import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.Object3D import Object3D

from ..lights.RectAreaLight_autogen import RectAreaLight

@register
class RectAreaLightHelper(Object3D):
    """RectAreaLightHelper

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/helpers/RectAreaLightHelper
    """

    def __init__(self, light=None, color="#ffffff", **kwargs):
        kwargs['light'] = light
        kwargs['color'] = color
        super(RectAreaLightHelper, self).__init__(**kwargs)

    _model_name = Unicode('RectAreaLightHelperModel').tag(sync=True)

    light = Instance(RectAreaLight, allow_none=True).tag(sync=True, **widget_serialization)

    color = Color("#ffffff", allow_none=True).tag(sync=True)

    type = Unicode("RectAreaLightHelper", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    RectAreaLightHelper.__signature__ = inspect.signature(RectAreaLightHelper.__init__)
