import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.Object3D import Object3D


@register
class ArrowHelper(Object3D):
    """ArrowHelper

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/helpers/ArrowHelper
    """

    def __init__(self, **kwargs):
        super(ArrowHelper, self).__init__(**kwargs)

    _model_name = Unicode('ArrowHelperModel').tag(sync=True)

    dir = Vector3(default_value=[1, 0, 0]).tag(sync=True)

    origin = Vector3(default_value=[0, 0, 0]).tag(sync=True)

    length = CFloat(1, allow_none=False).tag(sync=True)

    hex = CInt(0, allow_none=False).tag(sync=True)

    headLength = CFloat(None, allow_none=True).tag(sync=True)

    headWidth = CFloat(None, allow_none=True).tag(sync=True)

    type = Unicode("ArrowHelper", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    ArrowHelper.__signature__ = inspect.signature(ArrowHelper.__init__)
