import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.BaseBufferGeometry_autogen import BaseBufferGeometry


@register
class TorusBufferGeometry(BaseBufferGeometry):
    """TorusBufferGeometry

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/geometries/TorusGeometry
    """

    def __init__(self, radius=1, tube=0.4, radialSegments=8, tubularSegments=6, arc=6.283185307179586, **kwargs):
        kwargs['radius'] = radius
        kwargs['tube'] = tube
        kwargs['radialSegments'] = radialSegments
        kwargs['tubularSegments'] = tubularSegments
        kwargs['arc'] = arc
        super(TorusBufferGeometry, self).__init__(**kwargs)

    _model_name = Unicode('TorusBufferGeometryModel').tag(sync=True)

    radius = CFloat(1, allow_none=False).tag(sync=True)

    tube = CFloat(0.4, allow_none=False).tag(sync=True)

    radialSegments = CInt(8, allow_none=False).tag(sync=True)

    tubularSegments = CInt(6, allow_none=False).tag(sync=True)

    arc = CFloat(6.283185307179586, allow_none=False).tag(sync=True)

    type = Unicode("TorusBufferGeometry", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    TorusBufferGeometry.__signature__ = inspect.signature(TorusBufferGeometry.__init__)
