import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .Camera_autogen import Camera


@register
class PerspectiveCamera(Camera):
    """PerspectiveCamera

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/cameras/PerspectiveCamera
    """

    def __init__(self, fov=50, aspect=1, near=0.1, far=2000, **kwargs):
        kwargs['fov'] = fov
        kwargs['aspect'] = aspect
        kwargs['near'] = near
        kwargs['far'] = far
        super(PerspectiveCamera, self).__init__(**kwargs)

    _model_name = Unicode('PerspectiveCameraModel').tag(sync=True)

    fov = CFloat(50, allow_none=False).tag(sync=True)

    zoom = CFloat(1, allow_none=False).tag(sync=True)

    near = CFloat(0.1, allow_none=False).tag(sync=True)

    far = CFloat(2000, allow_none=False).tag(sync=True)

    focus = CFloat(10, allow_none=False).tag(sync=True)

    aspect = CFloat(1, allow_none=False).tag(sync=True)

    type = Unicode("PerspectiveCamera", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    PerspectiveCamera.__signature__ = inspect.signature(PerspectiveCamera.__init__)
