import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .Texture_autogen import Texture


class DataTexture3D(Texture):
    """DataTexture3D

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/textures/DataTexture3D
    """

    def __init__(self, data=None, format="RGBAFormat", type="UnsignedByteType", mapping="UVMapping", wrapS="ClampToEdgeWrapping", wrapT="ClampToEdgeWrapping", magFilter="NearestFilter", minFilter="NearestFilter", anisotropy=1, **kwargs):
        kwargs['data'] = data
        kwargs['format'] = format
        kwargs['type'] = type
        kwargs['mapping'] = mapping
        kwargs['wrapS'] = wrapS
        kwargs['wrapT'] = wrapT
        kwargs['magFilter'] = magFilter
        kwargs['minFilter'] = minFilter
        kwargs['anisotropy'] = anisotropy
        super(DataTexture3D, self).__init__(**kwargs)

    _model_name = Unicode('DataTexture3DModel').tag(sync=True)

    data = WebGLDataUnion().tag(sync=True)

    minFilter = Enum(Filters, "NearestFilter", allow_none=False).tag(sync=True)

    magFilter = Enum(Filters, "NearestFilter", allow_none=False).tag(sync=True)

    flipY = Bool(False, allow_none=False).tag(sync=True)

    generateMipmaps = Bool(False, allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    DataTexture3D.__signature__ = inspect.signature(DataTexture3D.__init__)
