import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget

from ..math.Plane_autogen import Plane

class Material(ThreeWidget):
    """Material

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/materials/Material
    """

    def __init__(self, **kwargs):
        super(Material, self).__init__(**kwargs)

    _model_name = Unicode('MaterialModel').tag(sync=True)

    alphaTest = CFloat(0, allow_none=False).tag(sync=True)

    blendDst = Enum(BlendFactors, "OneMinusSrcAlphaFactor", allow_none=False).tag(sync=True)

    blendDstAlpha = CFloat(0, allow_none=False).tag(sync=True)

    blending = Enum(BlendingMode, "NormalBlending", allow_none=False).tag(sync=True)

    blendSrc = Enum(BlendFactors, "SrcAlphaFactor", allow_none=False).tag(sync=True)

    blendSrcAlpha = CFloat(0, allow_none=False).tag(sync=True)

    blendEquation = Enum(Equations, "AddEquation", allow_none=False).tag(sync=True)

    blendEquationAlpha = CFloat(0, allow_none=False).tag(sync=True)

    clipIntersection = Bool(False, allow_none=False).tag(sync=True)

    clippingPlanes = Tuple().tag(sync=True, **widget_serialization)

    clipShadows = Bool(False, allow_none=False).tag(sync=True)

    colorWrite = Bool(True, allow_none=False).tag(sync=True)

    defines = Dict(default_value=None, allow_none=True).tag(sync=True)

    depthFunc = Enum(DepthMode, "LessEqualDepth", allow_none=False).tag(sync=True)

    depthTest = Bool(True, allow_none=False).tag(sync=True)

    depthWrite = Bool(True, allow_none=False).tag(sync=True)

    dithering = Bool(False, allow_none=False).tag(sync=True)

    flatShading = Bool(False, allow_none=False).tag(sync=True)

    fog = Bool(True, allow_none=False).tag(sync=True)

    lights = Bool(True, allow_none=False).tag(sync=True)

    name = Unicode("", allow_none=False).tag(sync=True)

    opacity = CFloat(1, allow_none=False).tag(sync=True)

    overdraw = CFloat(0, allow_none=False).tag(sync=True)

    polygonOffset = Bool(False, allow_none=False).tag(sync=True)

    polygonOffsetFactor = CFloat(0, allow_none=False).tag(sync=True)

    polygonOffsetUnits = CFloat(0, allow_none=False).tag(sync=True)

    precision = Unicode(None, allow_none=True).tag(sync=True)

    premultipliedAlpha = Bool(False, allow_none=False).tag(sync=True)

    shadowSide = Enum(Side, None, allow_none=True).tag(sync=True)

    side = Enum(Side, "FrontSide", allow_none=False).tag(sync=True)

    transparent = Bool(False, allow_none=False).tag(sync=True)

    type = Unicode("Material", allow_none=False).tag(sync=True)

    vertexColors = Enum(Colors, "NoColors", allow_none=False).tag(sync=True)

    visible = Bool(True, allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    Material.__signature__ = inspect.signature(Material.__init__)
