import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .Controls_autogen import Controls


class OrbitControls(Controls):
    """OrbitControls

    Autogenerated by generate-wrappers.js
    This class is a custom class for pythreejs, with no
    direct corresponding class in three.js.
    """

    def __init__(self, controlling=None, **kwargs):
        kwargs['controlling'] = controlling
        super(OrbitControls, self).__init__(**kwargs)

    _model_name = Unicode('OrbitControlsModel').tag(sync=True)

    autoRotate = Bool(False, allow_none=False).tag(sync=True)

    autoRotateSpeed = CFloat(2, allow_none=False).tag(sync=True)

    dampingFactor = CFloat(0.25, allow_none=False).tag(sync=True)

    enabled = Bool(True, allow_none=False).tag(sync=True)

    enableDamping = Bool(False, allow_none=False).tag(sync=True)

    enableKeys = Bool(True, allow_none=False).tag(sync=True)

    enablePan = Bool(True, allow_none=False).tag(sync=True)

    enableRotate = Bool(True, allow_none=False).tag(sync=True)

    enableZoom = Bool(True, allow_none=False).tag(sync=True)

    keyPanSpeed = CFloat(7, allow_none=False).tag(sync=True)

    maxAzimuthAngle = CFloat(float('inf'), allow_none=False).tag(sync=True)

    maxDistance = CFloat(float('inf'), allow_none=False).tag(sync=True)

    maxPolarAngle = CFloat(3.141592653589793, allow_none=False).tag(sync=True)

    maxZoom = CFloat(float('inf'), allow_none=False).tag(sync=True)

    minAzimuthAngle = CFloat(-float('inf'), allow_none=False).tag(sync=True)

    minDistance = CFloat(0, allow_none=False).tag(sync=True)

    minPolarAngle = CFloat(0, allow_none=False).tag(sync=True)

    minZoom = CFloat(0, allow_none=False).tag(sync=True)

    panSpeed = CFloat(1, allow_none=False).tag(sync=True)

    rotateSpeed = CFloat(1, allow_none=False).tag(sync=True)

    screenSpacePanning = Bool(False, allow_none=False).tag(sync=True)

    zoomSpeed = CFloat(1, allow_none=False).tag(sync=True)

    target = Vector3(default_value=[0, 0, 0]).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    OrbitControls.__signature__ = inspect.signature(OrbitControls.__init__)
