import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .MeshPhongMaterial_autogen import MeshPhongMaterial

from ..textures.Texture_autogen import Texture

@register
class MeshToonMaterial(MeshPhongMaterial):
    """MeshToonMaterial

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/materials/MeshToonMaterial
    """

    def __init__(self, **kwargs):
        super(MeshToonMaterial, self).__init__(**kwargs)

    _model_name = Unicode('MeshToonMaterialModel').tag(sync=True)

    gradientMap = Instance(Texture, allow_none=True).tag(sync=True, **widget_serialization)

    type = Unicode("MeshToonMaterial", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    MeshToonMaterial.__signature__ = inspect.signature(MeshToonMaterial.__init__)
