//
// base version of this file auto-generated by generate-class-config.js
// date: Wed Aug 31 2016 08:59:45 GMT-0700 (PDT)
//

'use strict';

var Types = require('./prop-types');

// NOTE: uuid properties are not generated, as they cannot be synced across
// several clients.

module.exports = {

    _defaults: require('./three-class-config-defaults'),

    AnimationAction: {
        relativePath: './animation/AnimationAction',
        properties: {
            mixer:              new Types.ThreeType('AnimationMixer'),
            clip:               new Types.ThreeType('AnimationClip'),
            localRoot:          new Types.ThreeType(),
            clampWhenFinished:  new Types.Bool(false),
            enabled:            new Types.Bool(true),
            loop:               new Types.Enum('LoopModes', 'LoopRepeat'),
            paused:             new Types.Bool(false),
            repititions:        new Types.Int(Infinity),
            time:               new Types.Float(0),
            timeScale:          new Types.Float(1),
            weigth:             new Types.Float(1),
            zeroSlopeAtEnd:     new Types.Bool(true),
            zeroSlopeAtStart:   new Types.Bool(true),
        },
        constructorArgs: ['mixer', 'clip', 'localRoot'],
    },
    AnimationClip: {
        relativePath: './animation/AnimationClip',
        properties: {
            name:           new Types.String(null, {nullable: true}),
            duration:       new Types.Float(-1.0),
            tracks:         new Types.ThreeTypeArray('KeyframeTrack'),
        },
        constructorArgs: ['name', 'duration', 'tracks'],
        propsDefinedByThree: ['duration'],
    },
    AnimationMixer: {
        relativePath: './animation/AnimationMixer',
        properties: {
            rootObject: new Types.ThreeType(),
            time:       new Types.Float(0),
            timeScale:  new Types.Float(1.0),
        },
        constructorArgs: ['rootObject', 'time', 'timeScale'],
    },
    AnimationObjectGroup: {
        relativePath: './animation/AnimationObjectGroup',
    },
    AnimationUtils: {
        relativePath: './animation/AnimationUtils',
    },
    KeyframeTrack: {
        relativePath: './animation/KeyframeTrack',
        properties: {
            name:           new Types.String(''),
            times:          new Types.ArrayBuffer(),
            values:         new Types.ArrayBuffer(),
            interpolation:  new Types.Enum('InterpolationModes', 'InterpolateLinear'),
        },
        constructorArgs: ['name', 'times', 'values', 'interpolation'],
    },
    PropertyBinding: {
        relativePath: './animation/PropertyBinding',
    },
    PropertyMixer: {
        relativePath: './animation/PropertyMixer',
    },
    Audio: {
        relativePath: './audio/Audio',
    },
    AudioAnalyser: {
        relativePath: './audio/AudioAnalyser',
    },
    AudioBuffer: {
        relativePath: './audio/AudioBuffer',
    },
    AudioListener: {
        relativePath: './audio/AudioListener',
    },
    PositionalAudio: {
        relativePath: './audio/PositionalAudio',
    },
    Camera: {
        relativePath: './cameras/Camera',
        superClass: 'Object3D',
        properties: {
            matrixWorldInverse: new Types.Matrix4(),
            projectionMatrix:   new Types.Matrix4(),
        },
        propsDefinedByThree: [ 'matrixWorldInverse', 'projectionMatrix' ],
    },
    CubeCamera: {
        relativePath: './cameras/CubeCamera',
        superClass: 'Object3D',
        properties: {
        }
    },
    OrthographicCamera: {
        relativePath: './cameras/OrthographicCamera',
        superClass: 'Camera',
        properties: {
            zoom:   new Types.Float(1.0),
            left:   new Types.Float(),
            right:  new Types.Float(),
            top:    new Types.Float(),
            bottom: new Types.Float(),
            near:   new Types.Float(0.1),
            far:    new Types.Float(2000),
        },
        constructorArgs: [ 'left', 'right', 'top', 'bottom', 'near', 'far' ],
    },
    PerspectiveCamera: {
        relativePath: './cameras/PerspectiveCamera',
        superClass: 'Camera',
        properties: {
            fov:        new Types.Float(50.0),
            zoom:       new Types.Float(1.0),
            near:       new Types.Float(0.1),
            far:        new Types.Float(2000),
            focus:      new Types.Float(10.0),
            aspect:     new Types.Float(1.0),
            // view:       new Types.Dict(),
            // filmGauge:  new Types.Float(35.0),
            // filmOffset: new Types.Float(0.0),
        },
        constructorArgs: [ 'fov', 'aspect', 'near', 'far' ],
    },
    ArrayCamera: {
        relativePath: './cameras/ArrayCamera',
        superClass: 'PerspectiveCamera',
        properties: {
        },
        constructorArgs: [ 'fov', 'aspect', 'near', 'far' ],
    },
    StereoCamera: {
        relativePath: './cameras/StereoCamera',
        properties: {
            aspect:     new Types.Float(1),
            eyeSep:     new Types.Float(0.064),
            cameraL:    new Types.ThreeType('PerspectiveCamera'),
            cameraR:    new Types.ThreeType('PerspectiveCamera'),
        },
    },
    CombinedCamera: {
        relativePath: './cameras/CombinedCamera',
        superClass: 'Camera',
        properties: {
            fov:        new Types.Float(50.0),
            zoom:       new Types.Float(1.0),
            near:       new Types.Float(0.1),
            far:        new Types.Float(2000),
            orthoNear:  new Types.Float(0.1),
            orthoFar:   new Types.Float(2000),

            width:      new Types.Float(),
            height:     new Types.Float(),

            mode:       new Types.Enum("['perspective', 'orthographic']", 'perspective'),
            impersonate:new Types.Bool(true),
            // view: new Types.ViewOffset()
        },
        constructorArgs: [ 'width', 'height', 'fov', 'near', 'far', 'orthoNear', 'orthoFar' ],
    },
    Controls: {
        relativePath: './controls/Controls',
        properties: {
            controlling: new Types.ThreeType('Object3D', {nullable: false}),
        },
    },
    OrbitControls: {
        relativePath: './controls/OrbitControls',
        superClass: 'Controls',
        properties: {
            autoRotate: new Types.Bool(false),

            autoRotateSpeed: new Types.Float(2.0), // 30 seconds per round when fps is 60

            dampingFactor: new Types.Float(0.25),

            enabled: new Types.Bool(true),

            enableDamping: new Types.Bool(false),
            enableKeys: new Types.Bool(true),
            enablePan: new Types.Bool(true),
            enableRotate: new Types.Bool(true),
            enableZoom: new Types.Bool(true),

            keyPanSpeed: new Types.Float(7.0), // pixels moved per arrow key push

            // keys: new Types.KeyDict(),

            maxAzimuthAngle: new Types.Float(Infinity), // radians
            maxDistance: new Types.Float(Infinity),
            maxPolarAngle: new Types.Float(Math.PI), // radians
            maxZoom: new Types.Float(Infinity),

            minAzimuthAngle: new Types.Float(-Infinity), // radians
            minDistance: new Types.Float(0),
            minPolarAngle: new Types.Float(0), // radians
            minZoom: new Types.Float(0),

            // mouseButtons: new Types.MouseButtonDict(),

            panSpeed: new Types.Float(1.0),

            rotateSpeed: new Types.Float(1.0),

            screenSpacePanning: new Types.Bool(false),

            zoomSpeed: new Types.Float(1.0),

            target: new Types.Vector3(0, 0, 0),
        },
        constructorArgs: ['controlling'],
    },
    TrackballControls: {
        relativePath: './controls/TrackballControls',
        superClass: 'Controls',
        properties: {
            enabled: new Types.Bool(true),

            minDistance: new Types.Float(0),
            maxDistance: new Types.Float(Infinity),

            rotateSpeed: new Types.Float(1.0),
            zoomSpeed: new Types.Float(1.2),
            panSpeed: new Types.Float(0.3),

            staticMoving: new Types.Bool(false),
            dynamicDampingFactor: new Types.Float(0.2),

            noRotate: new Types.Bool(false),
            noZoom: new Types.Bool(false),
            noPan: new Types.Bool(false),
            noRoll: new Types.Bool(false),

            target: new Types.Vector3(0, 0, 0),
        },
        constructorArgs: ['controlling'],
    },
    FlyControls: {
        relativePath: './controls/FlyControls',
        superClass: 'Controls',
        properties: {
            moveVector: new Types.Vector3(0, 0, 0),
            rotationVector: new Types.Vector3(0, 0, 0),
            movementSpeed: new Types.Float(1.0),
            rollSpeed: new Types.Float(0.05),
            syncRate: new Types.Float(1.0),
        },
        constructorArgs: ['controlling'],
    },
    Picker: {
        relativePath: './controls/Picker',
        superClass: 'Controls',
        properties: {
            event: new Types.String('click', {
                help: 'The DOM MouseEvent type to trigger the pick',
            }),
            all: new Types.Bool(false, {
                help: 'Wether to send info on all object intersections beneath the picked point, or only the first one. See ``picked``.',
            }),
            distance: new Types.Float(null, {
                nullable: true,
                help: 'The distance from the camera of the picked point (null if no object picked)',
            }),
            point: new Types.Vector3(0, 0, 0, {
                help: 'The coordinates of the picked point (all zero if no object picked)',
            }),
            face: new Types.Vector3(0, 0, 0, {
                help: 'The vertex indices of the picked face (all zero if no face picked)',
            }),
            faceNormal: new Types.Vector3(0, 0, 0, {
                help: 'The normal vector of the picked face (all zero if no face picked)',
            }),
            faceVertices: new Types.VectorArray({
                help: 'The three vertices that make up the picked face, as vectors (empty if no face picked)',
            }),
            faceIndex: new Types.Int(null, {
                nullable: true,
                help: 'The index of the face picked (null if no face picked)',
            }),
            modifiers: new Types.Array({
                help: 'The keyboard modifiers held at the pick event in the following order: [SHIFT, CTRL, ALT, META]',
            }),
            object: new Types.ThreeType('Object3D', {
                nullable: true,
                help: 'The picked object (null if no object picked)',
            }),
            picked: new Types.Array({
                help: 'The other fields on the picker will always be for the first object intersection. ' +
                      'If ``all`` is set true, this field will be an array containing the same information ' +
                      'for all intersections.',
            }),
            uv: new Types.Vector2(0, 0, {
                help: 'The UV coordinate picked (all zero if invalid pick)',
            }),
            indices: new Types.Array({
                help: 'The vertex indices of the picked face (empty if no face picked)',
            }),
        },
        propsDefinedByThree: [
            'distance', 'point', 'face', 'faceNormal', 'faceVertices',
            'faceIndex', 'object', 'picked', 'uv', 'indices'],
        constructorArgs: ['controlling'],
    },

    BufferAttribute: {
        relativePath: './core/BufferAttribute',
        properties: {
            array:       new Types.ArrayBuffer(),
            // count:       new Types.Int(0),   // inferred from array
            dynamic:     new Types.Bool(false),
            //itemSize:    new Types.Int(1),   // inferred from array
            needsUpdate: new Types.Bool(false),
            normalized:  new Types.Bool(false),
            version:     new Types.Int(-1),
        },
        constructorArgs: [ 'array', 'normalized' ],
        propsDefinedByThree: [ 'version', 'needsUpdate' ]
    },
    BaseBufferGeometry: {
        relativePath: './core/BaseBufferGeometry',
        properties: {
            name:       new Types.String(''),
            type:       new Types.String(''),
        },
        propsDefinedByThree: [ 'type' ]
    },
    Clock: {
        relativePath: './core/Clock',
    },
    DirectGeometry: {
        relativePath: './core/DirectGeometry',
    },
    EventDispatcher: {
        relativePath: './core/EventDispatcher',
    },
    BaseGeometry: {
        relativePath: './core/BaseGeometry',
        properties: {
            // TODO: id not supported as it conflicts with backbone's id
            // id: new Types.String(''),
            name: new Types.String(''),
            type: new Types.String(''),

            // By default BaseGeometry does not sync geometry arrays
            // Use the Geometry class to access those arrays
        },
        propsDefinedByThree: [ 'type' ]
    },
    Geometry: {
        relativePath: './core/Geometry',
        superClass: 'BaseGeometry',
        properties: {
            vertices:       new Types.VectorArray(),
            colors:         new Types.ColorArray(),
            faces:          new Types.FaceArray(),
            faceVertexUvs:  new Types.Array(),
            lineDistances:  new Types.Array(),
            morphTargets:   new Types.Array(),
            morphNormals:   new Types.Array(),
            skinWeights:    new Types.VectorArray(),
            skinIndices:    new Types.VectorArray(),
            _ref_geometry:  new Types.ThreeType('BaseGeometry'),
            _store_ref:     new Types.Bool(false),
        },
    },
    BufferGeometry: {
        relativePath: './core/BufferGeometry',
        superClass: 'BaseBufferGeometry',
        properties: {
            index:              new Types.ThreeType(['BufferAttribute', 'InterleavedBufferAttribute']),
            attributes:         new Types.ThreeTypeDict(['BufferAttribute', 'InterleavedBufferAttribute']),
            morphAttributes:    new Types.BufferMorphAttributes(),
            userData:           new Types.Dict(),
            MaxIndex:           new Types.Int(65535),
            // TODO: These likely require special types:
            //groups:             new Types.GeometryGroup(),
            //drawRange:          new Types.DrawRange(),
            _ref_geometry:      new Types.ThreeType(['BaseGeometry', 'BaseBufferGeometry']),
            _store_ref:         new Types.Bool(false),
        },
    },
    InstancedBufferAttribute: {
        relativePath: './core/InstancedBufferAttribute',
        superClass: 'BufferAttribute',
        properties: {
            meshPerAttribute: new Types.Int(1),
        },
        constructorArgs: ['array', 'meshPerAttribute'],
    },
    InstancedBufferGeometry: {
        relativePath: './core/InstancedBufferGeometry',
        superClass: 'BufferGeometry',
        properties: {
            maxInstancedCount: new Types.Int(null, {nullable: true}),
        },
    },
    InstancedInterleavedBuffer: {
        relativePath: './core/InstancedInterleavedBuffer',
        superClass: 'InterleavedBuffer',
        properties: {
            meshPerAttribute: new Types.Int(1),
        },
        constructorArgs: ['array', 'meshPerAttribute'],
    },
    InterleavedBuffer: {
        relativePath: './core/InterleavedBuffer',
        properties: {
            array:          new Types.ArrayBuffer(),
            dynamic:        new Types.Bool(false),
            // updateRange: new Types.UpdateRange(),
            version:        new Types.Int(0),
            needsUpdate:    new Types.Bool(false),
        },
        propsDefinedByThree: ['version', 'needsUpdate'],
        constructorArgs: ['array'],
    },
    InterleavedBufferAttribute: {
        relativePath: './core/InterleavedBufferAttribute',
        properties: {
            data:           new Types.ThreeType('InterleavedBuffer'),
            itemSize:       new Types.Int(0),
            offset:         new Types.Int(0),
            normalized:     new Types.Bool(false),
        },
        constructorArgs: ['data', 'itemSize', 'offset', 'normalized']
    },
    Layers: {
        relativePath: './core/Layers',
    },
    Object3D: {
        relativePath: './core/Object3D',
        properties: {
            // TODO: id not supported as it conflicts with backbone's id
            // id: new Types.String(''),
            name:                   new Types.String(''),
            type:                   new Types.String(''),
            //parent:                 new Types.ThreeType('this'),
            children:               new Types.ThreeTypeArray('this'),
            up:                     new Types.Vector3(0, 1, 0),
            position:               new Types.Vector3(),
            rotation:               new Types.Euler(),
            quaternion:             new Types.Vector4(0, 0, 0, 1),
            scale:                  new Types.Vector3(1, 1, 1),
            modelViewMatrix:        new Types.Matrix4(),
            normalMatrix:           new Types.Matrix3(),
            matrix:                 new Types.Matrix4(),
            matrixWorld:            new Types.Matrix4(),
            matrixAutoUpdate:       new Types.Bool(true),
            matrixWorldNeedsUpdate: new Types.Bool(false),
            visible:                new Types.Bool(true),
            castShadow:             new Types.Bool(false),
            receiveShadow:          new Types.Bool(false),
            frustumCulled:          new Types.Bool(true),
            renderOrder:            new Types.Int(0),
        },
        propsDefinedByThree: [ 'type', 'rotation', 'quaternion', 'matrixWorldNeedsUpdate' ]
    },
    Blackbox: {
        superClass: 'Object3D',
        relativePath: './objects/Blackbox'
    },
    Raycaster: {
        relativePath: './core/Raycaster',
        properties: {
            origin: new Types.Vector3(),
            direction: new Types.Vector3(),
            near: new Types.Float(0.0),
            far: new Types.Float(1000000.0),
            ray: new Types.ThreeType('Ray'),
            linePrecision: new Types.Float(1.0),
        },
        constructorArgs: [ 'origin', 'direction', 'near', 'far' ],
    },
    AmbientLight: {
        relativePath: './lights/AmbientLight',
        superClass: 'Light',
        constructorArgs: [ 'color', 'intensity' ],
    },
    DirectionalLight: {
        relativePath: './lights/DirectionalLight',
        superClass: 'Light',
        properties: {
            target:      new Types.InitializedThreeType('Object3D', {nullable: false}),
            shadow:      new Types.InitializedThreeType('LightShadow', {nullable: false}),
        },
        constructorArgs: [ 'color', 'intensity' ],
    },
    DirectionalLightShadow: {
        relativePath: './lights/DirectionalLightShadow',
        superClass: 'LightShadow',
    },
    HemisphereLight: {
        relativePath: './lights/HemisphereLight',
        superClass: 'Light',
        properties: {
            groundColor: new Types.Color('#000000'),
        },
        constructorArgs: [ 'color', 'groundColor', 'intensity' ],
    },
    Light: {
        relativePath: './lights/Light',
        superClass: 'Object3D',
        properties: {
            color:     new Types.Color('#ffffff'),
            intensity: new Types.Float(1.0),
        },
        constructorArgs: [ 'color', 'intensity' ],
    },
    LightShadow: {
        relativePath: './lights/LightShadow',
        properties: {
            camera:     new Types.InitializedThreeType('Camera', {nullable: false}),
            bias:       new Types.Float(0),
            mapSize:    new Types.Vector2(512, 512),
            radius:     new Types.Float(1)
        },
        constructorArgs: [ 'camera' ],
    },
    PointLight: {
        relativePath: './lights/PointLight',
        superClass: 'Light',
        properties: {
            power:    new Types.Float(4.0 * Math.PI),
            distance: new Types.Float(0.0),
            decay:    new Types.Float(1.0),
            shadow:   new Types.InitializedThreeType('LightShadow', {nullable: false}),
        },
        constructorArgs: [ 'color', 'intensity', 'distance', 'decay' ],
    },
    RectAreaLight: {
        relativePath: './lights/RectAreaLight',
        superClass: 'Light',
        properties: {
            width:      new Types.Float(10),
            height:     new Types.Float(10),
        },
        constructorArgs: [ 'color', 'intensity', 'width', 'height' ],
    },
    SpotLight: {
        relativePath: './lights/SpotLight',
        superClass: 'Light',
        properties: {
            target:   new Types.InitializedThreeType('Object3D', {nullable: false}),
            distance: new Types.Float(0.0),
            angle:    new Types.Float(Math.PI / 3.0),
            penumbra: new Types.Float(0.0),
            decay:    new Types.Float(1.0),
            shadow:   new Types.InitializedThreeType('LightShadow', {nullable: false}),
        },
        constructorArgs: [ 'color', 'intensity', 'distance', 'angle', 'penumbra', 'decay' ],
    },
    SpotLightShadow: {
        relativePath: './lights/SpotLightShadow',
        superClass: 'LightShadow',
    },
    AnimationLoader: {
        relativePath: './loaders/AnimationLoader',
    },
    AudioLoader: {
        relativePath: './loaders/AudioLoader',
    },
    BinaryTextureLoader: {
        relativePath: './loaders/BinaryTextureLoader',
    },
    BufferGeometryLoader: {
        relativePath: './loaders/BufferGeometryLoader',
    },
    Cache: {
        relativePath: './loaders/Cache',
    },
    CompressedTextureLoader: {
        relativePath: './loaders/CompressedTextureLoader',
    },
    CubeTextureLoader: {
        relativePath: './loaders/CubeTextureLoader',
    },
    DataTextureLoader: {
        relativePath: './loaders/DataTextureLoader',
    },
    FileLoader: {
        relativePath: './laoders/FileLoader',
    },
    FontLoader: {
        relativePath: './loaders/FontLoader',
    },
    ImageLoader: {
        relativePath: './loaders/ImageLoader',
    },
    ImageBitmapLoader: {
        relativePath: './loaders/ImageBitmapLoader',
    },
    JSONLoader: {
        relativePath: './loaders/JSONLoader',
    },
    Loader: {
        relativePath: './loaders/Loader',
    },
    LoadingManager: {
        relativePath: './loaders/LoadingManager',
    },
    MaterialLoader: {
        relativePath: './loaders/MaterialLoader',
    },
    ObjectLoader: {
        relativePath: './loaders/ObjectLoader',
    },
    TextureLoader: {
        relativePath: './loaders/TextureLoader',
    },
    XHRLoader: {
        relativePath: './loaders/XHRLoader',
    },
    // NOTE: the constructor arg, 'parameters' is special-cased in our wrapper generator
    //       it will be auto-detected, and properly generate the constructor dict arg
    //       containing all props of the model
    LineBasicMaterial: {
        relativePath: './materials/LineBasicMaterial',
        superClass: 'Material',
        properties: {
            color:        new Types.Color('#ffffff'),
            lights:       new Types.Bool(false),
            linewidth:    new Types.Float(1.0),
            linecap:      new Types.String('round'),
            linejoin:     new Types.String('round'),
        },
        constructorArgs: [ 'parameters' ],
    },
    LineDashedMaterial: {
        relativePath: './materials/LineDashedMaterial',
        superClass: 'Material',
        properties: {
            color:        new Types.Color('#ffffff'),
            lights:       new Types.Bool(false),
            linewidth:    new Types.Float(1.0),
            scale:        new Types.Float(1.0),
            dashSize:     new Types.Float(3.0),
            gapSize:      new Types.Float(1.0),
        },
        constructorArgs: [ 'parameters' ],
    },
    LineMaterial: {
        relativePath: './materials/LineMaterial',
        superClass: 'Material',
        properties: {
            color:        new Types.Color('#ffffff'),
            fog:          new Types.Bool(false),
            lights:       new Types.Bool(false),
            linewidth:    new Types.Float(1.0),
            dashScale:    new Types.Float(1.0),
            dashSize:     new Types.Float(1.0),
            gapSize:      new Types.Float(1.0),
        },
        constructorArgs: [ 'parameters' ],
    },
    Material: {
        relativePath: './materials/Material',
        properties: {
            alphaTest:              new Types.Float(0.0),
            blendDst:               new Types.Enum('BlendFactors', 'OneMinusSrcAlphaFactor'),
            blendDstAlpha:          new Types.Float(null),
            blending:               new Types.Enum('BlendingMode', 'NormalBlending'),
            blendSrc:               new Types.Enum('BlendFactors', 'SrcAlphaFactor'),
            blendSrcAlpha:          new Types.Float(null),
            blendEquation:          new Types.Enum('Equations', 'AddEquation'),
            blendEquationAlpha:     new Types.Float(null),
            clipIntersection:       new Types.Bool(false),
            clippingPlanes:         new Types.ThreeTypeArray('Plane'),
            clipShadows:            new Types.Bool(false),
            colorWrite:             new Types.Bool(true),
            //customDepthMaterial:    new Types.ForwardDeclaredThreeType('MeshDepthMaterial', 'pythreejs', {nullable: true}),
            //customDistanceMaterial: new Types.ForwardDeclaredThreeType('MeshDepthMaterial', 'pythreejs', {nullable: true}),
            defines:                new Types.Dict(null, {nullable: true}),
            depthFunc:              new Types.Enum('DepthMode', 'LessEqualDepth'),
            depthTest:              new Types.Bool(true),
            depthWrite:             new Types.Bool(true),
            dithering:              new Types.Bool(false),
            flatShading:            new Types.Bool(false),
            fog:                    new Types.Bool(true),
            lights:                 new Types.Bool(true),
            name:                   new Types.String(''),
            opacity:                new Types.Float(1.0),
            overdraw:               new Types.Float(0),
            polygonOffset:          new Types.Bool(false),
            polygonOffsetFactor:    new Types.Float(0),
            polygonOffsetUnits:     new Types.Float(0),
            precision:              new Types.String(null, {nullable: true}),
            premultipliedAlpha:     new Types.Bool(false),
            shadowSide:             new Types.Enum('Side', null, {nullable: true}),
            side:                   new Types.Enum('Side', 'FrontSide'),
            transparent:            new Types.Bool(false),
            type:                   new Types.String(''),
            vertexColors:           new Types.Enum('Colors', 'NoColors'),
            visible:                new Types.Bool(true),
        },
        propsDefinedByThree: [ 'type' ]
    },
    MeshBasicMaterial: {
        relativePath: './materials/MeshBasicMaterial',
        superClass: 'Material',
        properties: {
            alphaMap:           new Types.ThreeType('Texture'),
            aoMap:              new Types.ThreeType('Texture'),
            aoMapIntensity:     new Types.Float(1),
            color:              new Types.Color('#ffffff'),
            combine:            new Types.Enum('Operations', 'MultiplyOperation'),
            envMap:             new Types.ThreeType('CubeTexture'),
            lightMap:           new Types.ThreeType('Texture'),
            lightMapIntensity:  new Types.Float(1.0),
            lights:             new Types.Bool(false),
            map:                new Types.ThreeType('Texture'),
            morphTargets:       new Types.Bool(false),
            reflectivity:       new Types.Float(1),
            refractionRatio:    new Types.Float(0.98),
            skinning:           new Types.Bool(false),
            specularMap:        new Types.ThreeType('Texture'),
            wireframe:          new Types.Bool(false),
            wireframeLinewidth: new Types.Float(1),
            wireframeLinecap:   new Types.String('round'), // TODO: enum?
            wireframeLinejoin:  new Types.String('round'),
        },
        constructorArgs: [ 'parameters' ],
    },
    MeshDepthMaterial: {
        relativePath: './materials/MeshDepthMaterial',
        superClass: 'Material',
        properties: {
            alphaMap:           new Types.ThreeType('Texture'),
            displacementMap:    new Types.ThreeType('Texture'),
            displacementScale:  new Types.Float(1.0),
            displacementBias:   new Types.Float(0.0),
            fog:                new Types.Bool(false),
            lights:             new Types.Bool(false),
            map:                new Types.ThreeType('Texture'),
            morphTargets:       new Types.Bool(false),
            skinning:           new Types.Bool(false),
            wireframe:          new Types.Bool(false),
            wireframeLinewidth: new Types.Float(1.0),
        },
        constructorArgs: [ 'parameters' ],
    },
    MeshLambertMaterial: {
        relativePath: './materials/MeshLambertMaterial',
        superClass: 'Material',
        properties: {
            alphaMap:           new Types.ThreeType('Texture'),
            aoMap:              new Types.ThreeType('Texture'),
            aoMapIntensity:     new Types.Float(1.0),
            color:              new Types.Color('#ffffff'),
            combine:            new Types.Enum('Operations', 'MultiplyOperation'),
            emissive:           new Types.Color('#000000'),
            emissiveMap:        new Types.ThreeType('Texture'),
            emissiveIntensity:  new Types.Float(1.0),
            envMap:             new Types.ThreeType('CubeTexture'),
            lightMap:           new Types.ThreeType('Texture'),
            lightMapIntensity:  new Types.Float(1.0),
            map:                new Types.ThreeType('Texture'),
            morphNormals:       new Types.Bool(false),
            morphTargets:       new Types.Bool(false),
            reflectivity:       new Types.Float(1.0),
            refractionRatio:    new Types.Float(0.98),
            skinning:           new Types.Bool(false),
            specularMap:        new Types.ThreeType('Texture'),
            wireframe:          new Types.Bool(false),
            wireframeLinecap:   new Types.String('round'),
            wireframeLinejoin:  new Types.String('round'),
            wireframeLinewidth: new Types.Float(1.0),
        },
        constructorArgs: [ 'parameters' ],
    },
    MeshMatcapMaterial: {
        relativePath: './materials/MeshMatcapMaterial',
        superClass: 'Material',
        properties: {
            alphaMap:           new Types.ThreeType('Texture'),
            bumpMap:            new Types.ThreeType('Texture'),
            bumpScale:          new Types.Float(1.0),
            color:              new Types.Color('#ffffff'),
            displacementMap:    new Types.ThreeType('Texture'),
            displacementScale:  new Types.Float(1.0),
            displacementBias:   new Types.Float(0.0),
            lights:             new Types.Bool(false),
            map:                new Types.ThreeType('Texture'),
            matcap:             new Types.ThreeType('Texture'),
            morphNormals:       new Types.Bool(false),
            morphTargets:       new Types.Bool(false),
            normalMap:          new Types.ThreeType('Texture'),
            normalScale:        new Types.Vector2(1, 1),
            skinning:           new Types.Bool(false),
        },
        constructorArgs: [ 'parameters' ],
    },
    MeshNormalMaterial: {
        relativePath: './materials/MeshNormalMaterial',
        superClass: 'Material',
        properties: {
            fog:                new Types.Bool(false),
            lights:             new Types.Bool(false),
            morphTargets:       new Types.Bool(false),
            wireframe:          new Types.Bool(false),
            wireframeLinewidth: new Types.Float(1.0),
        },
        constructorArgs: [ 'parameters' ],
    },
    MeshPhongMaterial: {
        relativePath: './materials/MeshPhongMaterial',
        superClass: 'Material',
        properties: {
            alphaMap:           new Types.ThreeType('Texture'),
            aoMap:              new Types.ThreeType('Texture'),
            aoMapIntensity:     new Types.Float(1.0),
            bumpMap:            new Types.ThreeType('Texture'),
            bumpScale:          new Types.Float(1.0),
            color:              new Types.Color('#ffffff'),
            combine:            new Types.Enum('Operations', 'MultiplyOperation'),
            displacementMap:    new Types.ThreeType('Texture'),
            displacementScale:  new Types.Float(1.0),
            displacementBias:   new Types.Float(0.0),
            emissive:           new Types.Color('#000000'),
            emissiveMap:        new Types.ThreeType('Texture'),
            emissiveIntensity:  new Types.Float(1.0),
            envMap:             new Types.ThreeType('CubeTexture'),
            lightMap:           new Types.ThreeType('Texture'),
            lightMapIntensity:  new Types.Float(1.0),
            map:                new Types.ThreeType('Texture'),
            morphNormals:       new Types.Bool(false),
            morphTargets:       new Types.Bool(false),
            normalMap:          new Types.ThreeType('Texture'),
            normalScale:        new Types.Vector2(1, 1),
            reflectivity:       new Types.Float(1.0),
            refractionRatio:    new Types.Float(0.98),
            shininess:          new Types.Float(30.0),
            skinning:           new Types.Bool(false),
            specular:           new Types.Color('#111111'),
            specularMap:        new Types.ThreeType('Texture'),
            wireframe:          new Types.Bool(false),
            wireframeLinewidth: new Types.Float(1.0),
            wireframeLinecap:   new Types.String('round'),
            wireframeLinejoin:  new Types.String('round'),
        },
        constructorArgs: [ 'parameters' ],
    },
    MeshPhysicalMaterial: {
        relativePath: './materials/MeshPhysicalMaterial',
        superClass: 'MeshStandardMaterial',
        properties: {
            clearCoat:          new Types.Float(0.0),
            clearCoatRoughness: new Types.Float(0.0),
            defines:            new Types.Dict({ 'PHYSICAL': '' }, {nullable: true}),
            reflectivity:       new Types.Float(0.5),
        },
    },
    MeshStandardMaterial: {
        relativePath: './materials/MeshStandardMaterial',
        superClass: 'Material',
        properties: {
            alphaMap:           new Types.ThreeType('Texture'),
            aoMap:              new Types.ThreeType('Texture'),
            aoMapIntensity:     new Types.Float(1),
            bumpMap:            new Types.ThreeType('Texture'),
            bumpScale:          new Types.Float(1.0),
            color:              new Types.Color('#ffffff'),
            defines:            new Types.Dict({ 'STANDARD': '' }, {nullable: true}),
            displacementMap:    new Types.ThreeType('Texture'),
            displacementScale:  new Types.Float(1.0),
            displacementBias:   new Types.Float(0.0),
            emissive:           new Types.Color('#000000'),
            emissiveMap:        new Types.ThreeType('Texture'),
            emissiveIntensity:  new Types.Float(1.0),
            envMap:             new Types.ThreeType('CubeTexture'),
            envMapIntensity:    new Types.Float(1.0),
            lightMap:           new Types.ThreeType('Texture'),
            lightMapIntensity:  new Types.Float(1.0),
            map:                new Types.ThreeType('Texture'),
            metalness:          new Types.Float(0.5),
            metalnessMap:       new Types.ThreeType('Texture'),
            morphTargets:       new Types.Bool(false),
            morphNormals:       new Types.Bool(false),
            normalMap:          new Types.ThreeType('Texture'),
            normalScale:        new Types.Vector2(1, 1),
            refractionRatio:    new Types.Float(0.98),
            roughness:          new Types.Float(0.5),
            roughnessMap:       new Types.ThreeType('Texture'),
            skinning:           new Types.Bool(false),
            wireframe:          new Types.Bool(false),
            wireframeLinecap:   new Types.String('round'), // TODO: enum?
            wireframeLinejoin:  new Types.String('round'),
            wireframeLinewidth: new Types.Float(1),
        },
        constructorArgs: [ 'parameters' ],
    },
    MeshToonMaterial: {
        relativePath: './materials/MeshToonMaterial',
        superClass: 'MeshPhongMaterial',
        properties: {
            gradientMap:     new Types.ThreeType('Texture'),
        },
    },
    PointsMaterial: {
        relativePath: './materials/PointsMaterial',
        superClass: 'Material',
        properties: {
            color:           new Types.Color('#ffffff'),
            lights:          new Types.Bool(false),
            map:             new Types.ThreeType('Texture'),
            morphTargets:    new Types.Bool(false),
            size:            new Types.Float(1.0),
            sizeAttenuation: new Types.Bool(true),
        },
        constructorArgs: [ 'parameters' ],
    },
    RawShaderMaterial: {
        relativePath: './materials/RawShaderMaterial',
        superClass: 'ShaderMaterial',
        properties: {},
        constructorArgs: [ 'parameters' ],
    },
    ShaderMaterial: {
        relativePath: './materials/ShaderMaterial',
        superClass: 'Material',
        properties: {
            uniforms:           new Types.UniformDict(),
            clipping:           new Types.Bool(false),
            extensions:         new Types.Dict(),
            fog:                new Types.Bool(false),
            fragmentShader:     new Types.String(''),
            lights:             new Types.Bool(false),
            linewidth:          new Types.Float(1.0),
            morphNormals:       new Types.Bool(false),
            morphTargets:       new Types.Bool(false),
            flatShading:        new Types.Bool(false),
            skinning:           new Types.Bool(false),
            uniformsNeedUpdate: new Types.Bool(false),
            vertexShader:       new Types.String(''),
            wireframe:          new Types.Bool(false),
            wireframeLinewidth: new Types.Float(1.0),
        },
        constructorArgs: [ 'parameters' ],
        propsDefinedByThree: [ 'extensions' ],
    },
    ShadowMaterial: {
        relativePath: './materials/ShadowMaterial',
        superClass: 'ShaderMaterial',
        properties: {
            lights: new Types.Bool(true),
            transparent: new Types.Bool(true),
        },
    },
    SpriteMaterial: {
        relativePath: './materials/SpriteMaterial',
        superClass: 'Material',
        properties: {
            color:    new Types.Color('#ffffff'),
            fog:      new Types.Bool(false),
            lights:   new Types.Bool(false),
            map:      new Types.ThreeType('Texture'),
            rotation: new Types.Float(0.0),
            sizeAttenuation: new Types.Bool(true),
        },
        constructorArgs: [ 'parameters' ],
    },
    Box2: {
        relativePath: './math/Box2',
        properties: {
            min: new Types.Vector2(),
            max: new Types.Vector2(),
        },
        constructorArgs: [ 'min', 'max' ],
    },
    Box3: {
        relativePath: './math/Box3',
        properties: {
            min: new Types.Vector3(),
            max: new Types.Vector3(),
        },
        constructorArgs: [ 'min', 'max' ],

    },
    Cylindrical: {
        relativePath: './math/Cylindrical',
        properties: {
            radius: new Types.Float(1.0),
            theta:  new Types.Float(0.),
            y:      new Types.Float(0.),
        },
        constructorArgs: ['radius', 'theta', 'y'],
    },
    Frustum: {
        relativePath: './math/Frustum',
        properties: {
            p0: new Types.ThreeType('Plane'),
            p1: new Types.ThreeType('Plane'),
            p2: new Types.ThreeType('Plane'),
            p3: new Types.ThreeType('Plane'),
            p4: new Types.ThreeType('Plane'),
            p5: new Types.ThreeType('Plane'),
        },
        constructorArgs: [ 'p0', 'p1', 'p2', 'p3', 'p4', 'p5' ],
    },
    Interpolant: {
        relativePath: './math/Interpolant',
    },
    Line3: {
        relativePath: './math/Line3',
        properties: {
            start: new Types.Vector3(),
            end: new Types.Vector3(),
        },
        constructorArgs: [ 'start', 'end' ],
    },
    Math: {
        relativePath: './math/Math',
    },
    Plane: {
        relativePath: './math/Plane',
        properties: {
            normal: new Types.Vector3(),
            constant: new Types.Float(0.0),
        },
        constructorArgs: [ 'normal', 'constant' ],
    },
    Quaternion: {
        relativePath: './math/Quaternion',
        properties: {
            x: new Types.Float(0.0),
            y: new Types.Float(0.0),
            z: new Types.Float(0.0),
            w: new Types.Float(1.0),
        },
        constructorArgs: [ 'x', 'y', 'z', 'w' ],
    },
    Ray: {
        relativePath: './math/Ray',
        properties: {
            origin: new Types.Vector3(),
            direction: new Types.Vector3(),
        },
        constructorArgs: [ 'origin', 'direction' ],
    },
    Sphere: {
        relativePath: './math/Sphere',
        properties: {
            center: new Types.Vector3(),
            radius: new Types.Float(0.0),
        },
        constructorArgs: [ 'center', 'radius' ],
    },
    Spherical: {
        relativePath: './math/Spherical',
    },
    Spline: {
        relativePath: './math/Spline',
        properties: {
            points: new Types.ThreeTypeArray('Vector3'),
        },
        constructorArgs: [ 'points' ],
    },
    Triangle: {
        relativePath: './math/Triangle',
        properties: {
            a: new Types.Vector3(),
            b: new Types.Vector3(),
            c: new Types.Vector3(),
        },
        constructorArgs: [ 'a', 'b', 'c' ],
    },
    Bone: {
        relativePath: './objects/Bone',
        superClass: 'Object3D',
    },
    Group: {
        relativePath: './objects/Group',
        superClass: 'Object3D',
    },
    LOD: {
        relativePath: './objects/LOD',
    },
    Line: {
        relativePath: './objects/Line',
        superClass: 'Object3D',
        constructorArgs: [ 'geometry', 'material' ],
        properties: {
            material: new Types.ThreeType('Material'),
            geometry: new Types.ThreeType(['BaseGeometry', 'BaseBufferGeometry']),
        }
    },
    LineLoop: {
        relativePath: './objects/LineLoop',
        superClass: 'Line',
        constructorArgs: [ 'geometry', 'material' ],
    },
    LineSegments: {
        relativePath: './objects/LineSegments',
        superClass: 'Line',
        constructorArgs: [ 'geometry', 'material' ],
    },
    Mesh: {
        relativePath: './objects/Mesh',
        superClass: 'Object3D',
        constructorArgs: [ 'geometry', 'material' ],
        properties: {
            material: new Types.ThreeTypeArray('Material', {nullable: false, allow_single: true}),
            geometry: new Types.ThreeType(['BaseGeometry', 'BaseBufferGeometry'], {nullable: false}),
            drawMode: new Types.Enum('DrawModes', 'TrianglesDrawMode'),
            morphTargetInfluences: new Types.Array(),
        },
        propsDefinedByThree: ['morphTargetInfluences'],
    },
    Points: {
        relativePath: './objects/Points',
        superClass: 'Object3D',
        constructorArgs: [ 'geometry', 'material' ],
        properties: {
            material: new Types.ThreeType('Material', {nullable: false}),
            geometry: new Types.ThreeType(['BaseGeometry', 'BaseBufferGeometry'], {nullable: false}),
        },
    },
    Skeleton: {
        relativePath: './objects/Skeleton',
        properties: {
            bones: new Types.ThreeTypeArray('Bone'),
        },
        constructorArgs: ['bones'],
    },
    SkinnedMesh: {
        relativePath: './objects/SkinnedMesh',
        superClass: 'Mesh',
        properties: {
            bindMode:   new Types.String('attached'),
            bindMatrix: new Types.Matrix4(),
            skeleton:   new Types.ThreeType('Skeleton'),
        },
        constructorArgs: [ 'geometry', 'material' ],
    },
    Sprite: {
        relativePath: './objects/Sprite',
        superClass: 'Object3D',
        constructorArgs: [ 'material' ],
        properties: {
            material:   new Types.ThreeType('SpriteMaterial'),
            center:     new Types.Vector2(0.5, 0.5),
        },
        propsDefinedByThree: ['skeleton'],
    },
    CloneArray: {
        relativePath: './objects/CloneArray',
        superClass: 'Object3D',
        properties: {
            original: new Types.ThreeType('Object3D'),
            positions: new Types.VectorArray(),
            // TODO: Also scale and rotation arrays
            merge: new Types.Bool(false),
        },
        constructorArgs: [ 'original', 'positions', 'merge' ],
        // TODO: Add restriction: Source cannot use strip/fan draw modes
    },
    Line2: {
        relativePath: './objects/Line2',
        superClass: 'Mesh',
        properties: {
            material: new Types.InitializedThreeType('LineMaterial', {nullable: true}),
            geometry: new Types.InitializedThreeType('LineGeometry', {nullable: true}),
        },
        constructorArgs: [ 'geometry', 'material' ],
        propsDefinedByThree: [ 'geometry', 'material' ],
    },
    LineSegments2: {
        relativePath: './objects/LineSegments2',
        superClass: 'Mesh',
        properties: {
            material: new Types.InitializedThreeType('LineMaterial', {nullable: true}),
            geometry: new Types.InitializedThreeType('LineSegmentsGeometry', {nullable: true}),
        },
        constructorArgs: [ 'geometry', 'material' ],
        propsDefinedByThree: [ 'geometry', 'material' ],
    },
    WebGLRenderTarget: {
        relativePath: './renderers/WebGLRenderTarget',
    },
    WebGLRenderTargetCube: {
        relativePath: './renderers/WebGLRenderTargetCube',
    },
    WebGLRenderer: {
        relativePath: './renderers/WebGLRenderer',
        properties: {
            clippingPlanes:             new Types.ThreeTypeArray('Plane'),
            gammaFactor:                new Types.Float(2),
            gammaInput:                 new Types.Bool(false),
            gammaOutput:                new Types.Bool(false),
            localClippingEnabled:       new Types.Bool(false),
            physicallyCorrectLights:    new Types.Bool(false),
            // Note: shadow map has custom handling in `Renderable` base class
            shadowMap:                  new Types.ThreeType('WebGLShadowMap'),
            sortObjects:                new Types.Bool(false),
            toneMapping:                new Types.Enum('ToneMappings', 'LinearToneMapping'),
            toneMappingExposure:        new Types.Float(1.0),
            toneMappingWhitepoint:      new Types.Float(1.0),
        },
        propsDefinedByThree: ['shadowMap']
    },
    Fog: {
        relativePath: './scenes/Fog',
        properties: {
            name:   new Types.String(''),
            color:  new Types.Color('white'),
            near:   new Types.Float(1),
            far:    new Types.Float(1000)
        },
        constructorArgs: ['color', 'near', 'far'],
    },
    FogExp2: {
        relativePath: './scenes/FogExp2',
        properties: {
            name:   new Types.String(''),
            color:  new Types.Color('white'),
            density:   new Types.Float(0.00025),
        },
        constructorArgs: ['color', 'density'],
    },
    Scene: {
        relativePath: './scenes/Scene',
        superClass: 'Object3D',
        properties: {
            fog: new Types.ThreeType(['Fog', 'FogExp2']),
            overrideMaterial: new Types.ThreeType('Material'),
            autoUpdate: new Types.Bool(true),
            background: new Types.Color(null, {nullable: true}),
        },
    },
    Texture: {
        relativePath: './textures/Texture',
        properties: {
            // TODO: id not supported as it conflicts with backbone's id
            // id: new Types.String(''),
            name:             new Types.String(''),
            mapping:          new Types.Enum('MappingModes', 'UVMapping'),
            wrapS:            new Types.Enum('WrappingModes', 'ClampToEdgeWrapping'),
            wrapT:            new Types.Enum('WrappingModes', 'ClampToEdgeWrapping'),
            magFilter:        new Types.Enum('Filters', 'LinearFilter'),
            minFilter:        new Types.Enum('Filters', 'LinearMipMapLinearFilter'),
            format:           new Types.Enum('PixelFormats', 'RGBAFormat'),
            type:             new Types.Enum('DataTypes', 'UnsignedByteType'),
            anisotropy:       new Types.Float(1.0),
            repeat:           new Types.Vector2(1.0, 1.0),
            offset:           new Types.Vector2(0.0, 0.0),
            generateMipmaps:  new Types.Bool(true),
            premultiplyAlpha: new Types.Bool(false),
            flipY:            new Types.Bool(true),
            unpackAlignment:  new Types.Int(4), // from three docs: valid values: 1, 2, 4, 8 (see http://www.khronos.org/opengles/sdk/docs/man/xhtml/glPixelStorei.xml)
            encoding:         new Types.Enum('TextureEncodings', 'LinearEncoding'),
            version:          new Types.Int(0),
            rotation:         new Types.Float(0),
        },
        // As the image property is not exposed, we don't define constructorArgs.
        // The image property is hidden, as it does not have a good corresponding python type (yet)
        //constructorArgs: [ 'image', 'mapping', 'wrapS', 'wrapT', 'magFilter', 'minFilter', 'format', 'type', 'anisotropy' ],
        propsDefinedByThree: [ 'id', 'version' ],
    },
    CompressedTexture: {
        relativePath: './textures/CompressedTexture',
        superClass: 'Texture',
    },
    CubeTexture: {
        relativePath: './textures/CubeTexture',
        superClass: 'Texture',
        properties: {
            images: new Types.Array(),
        },
        constructorArgs: [ 'images', 'mapping', 'wrapS', 'wrapT', 'magFilter', 'minFilter', 'format', 'type', 'anisotropy' ],
    },
    DataTexture: {
        relativePath: './textures/DataTexture',
        superClass: 'Texture',
        properties: {
            // this.image = { data: data, width: width, height: height };
            data:            new Types.ArrayBuffer(),
            // width:           new Types.Int(0),   // inferred from data
            // height:          new Types.Int(0),   // inferred from data
            minFilter:       new Types.Enum('Filters', 'NearestFilter'), // override default
            magFilter:       new Types.Enum('Filters', 'NearestFilter'), // override default
            flipY:           new Types.Bool(false), // override default
            generateMipmaps: new Types.Bool(false),
        },
        constructorArgs: [ 'data', 'format', 'type', 'mapping', 'wrapS', 'wrapT', 'magFilter', 'minFilter', 'anisotropy' ],
    },
    DataTexture3D: {
        relativePath: './textures/DataTexture3D',
        superClass: 'Texture',
        properties: {
            // this.image = { data: data, width: width, height: height, depth: depth };
            data:            new Types.ArrayBuffer(),
            // width:           new Types.Int(0),   // inferred from data
            // height:          new Types.Int(0),   // inferred from data
            // depth:           new Types.Int(0),   // inferred from data
            minFilter:       new Types.Enum('Filters', 'NearestFilter'), // override default
            magFilter:       new Types.Enum('Filters', 'NearestFilter'), // override default
            flipY:           new Types.Bool(false), // override default
            generateMipmaps: new Types.Bool(false),
        },
        constructorArgs: [ 'data', 'format', 'type', 'mapping', 'wrapS', 'wrapT', 'magFilter', 'minFilter', 'anisotropy' ],
    },
    DepthTexture: {
        relativePath: './textures/DepthTexture',
        superClass: 'Texture',
        properties: {
            // this.image = { width: width, height: height };
            width:           new Types.Int(0),
            height:          new Types.Int(0),
            format:          new Types.Enum('DepthFormats', 'DepthFormat'), // narrowed type
            type:            new Types.Enum('DataTypes', 'UnsignedShortType'), // override default
            minFilter:       new Types.Enum('Filters', 'NearestFilter'), // override default
            magFilter:       new Types.Enum('Filters', 'NearestFilter'), // override default
            flipY:           new Types.Bool(false), // override default
            generateMipmaps: new Types.Bool(false),
        },
        constructorArgs: ['width', 'height', 'type', 'wrapS', 'wrapT', 'magFilter', 'minFilter', 'anisotropy', 'format']
    },
    ImageTexture: {
        relativePath: './textures/ImageTexture',
        superClass: 'Texture',
        properties: {
            imageUri: new Types.String(''),
        },
        constructorArgs: [ 'imageUri', 'mapping', 'wrapS', 'wrapT', 'magFilter', 'minFilter', 'format', 'type', 'anisotropy' ],
    },
    TextTexture: {
        relativePath: './textures/TextTexture',
        superClass: 'Texture',
        properties: {
            color: new Types.Color('white'),
            fontFace: new Types.String('Arial'),
            size: new Types.Int(12),
            string: new Types.String(''),
            squareTexture: new Types.Bool(true),
        },
        constructorArgs: ['string'],
    },
    VideoTexture: {
        relativePath: './textures/VideoTexture',
    },
    BooleanKeyframeTrack: {
        relativePath: './animation/tracks/BooleanKeyframeTrack',
        superClass: 'KeyframeTrack',
        constructorArgs: ['name', 'times', 'values', 'interpolation']
    },
    ColorKeyframeTrack: {
        relativePath: './animation/tracks/ColorKeyframeTrack',
        superClass: 'KeyframeTrack',
        constructorArgs: ['name', 'times', 'values', 'interpolation']
    },
    NumberKeyframeTrack: {
        relativePath: './animation/tracks/NumberKeyframeTrack',
        superClass: 'KeyframeTrack',
        constructorArgs: ['name', 'times', 'values', 'interpolation']
    },
    QuaternionKeyframeTrack: {
        relativePath: './animation/tracks/QuaternionKeyframeTrack',
        superClass: 'KeyframeTrack',
        constructorArgs: ['name', 'times', 'values', 'interpolation']
    },
    StringKeyframeTrack: {
        relativePath: './animation/tracks/StringKeyframeTrack',
        superClass: 'KeyframeTrack',
        constructorArgs: ['name', 'times', 'values', 'interpolation']
    },
    VectorKeyframeTrack: {
        relativePath: './animation/tracks/VectorKeyframeTrack',
        superClass: 'KeyframeTrack',
        constructorArgs: ['name', 'times', 'values', 'interpolation']
    },
    Curve: {
        relativePath: './extras/core/Curve',
    },
    CurvePath: {
        relativePath: './extras/core/CurvePath',
    },
    Font: {
        relativePath: './extras/core/Font',
    },
    Path: {
        relativePath: './extras/core/Path',
    },
    Shape: {
        relativePath: './extras/core/Shape',
    },
    ShapePath: {
        relativePath: './extras/core/ShapePath',
    },
    ArcCurve: {
        relativePath: './extras/curves/ArcCurve',
    },
    CatmullRomCurve3: {
        relativePath: './extras/curves/CatmullRomCurve3',
    },
    ClosedSplineCurve3: {
        relativePath: './extras/curves/ClosedSplineCurve3',
    },
    CubicBezierCurve: {
        relativePath: './extras/curves/CubicBezierCurve',
    },
    CubicBezierCurve3: {
        relativePath: './extras/curves/CubicBezierCurve3',
    },
    EllipseCurve: {
        relativePath: './extras/curves/EllipseCurve',
    },
    LineCurve: {
        relativePath: './extras/curves/LineCurve',
    },
    LineCurve3: {
        relativePath: './extras/curves/LineCurve3',
    },
    QuadraticBezierCurve: {
        relativePath: './extras/curves/QuadraticBezierCurve',
    },
    QuadraticBezierCurve3: {
        relativePath: './extras/curves/QuadraticBezierCurve3',
    },
    SplineCurve: {
        relativePath: './extras/curves/SplineCurve',
    },
    SplineCurve3: {
        relativePath: './extras/curves/SplineCurve3',
    },
    BoxBufferGeometry: {
        relativePath: './geometries/BoxGeometry',
        superClass: 'BaseBufferGeometry',
        constructorArgs: [ 'width', 'height', 'depth', 'widthSegments', 'heightSegments', 'depthSegments' ],
        properties: {
            width:          new Types.Float(1.0),
            height:         new Types.Float(1.0),
            depth:          new Types.Float(1.0),
            widthSegments:  new Types.Int(1),
            heightSegments: new Types.Int(1),
            depthSegments:  new Types.Int(1),
        },
    },
    BoxGeometry: {
        relativePath: './geometries/BoxGeometry',
        superClass: 'BaseGeometry',
        constructorArgs: [ 'width', 'height', 'depth', 'widthSegments', 'heightSegments', 'depthSegments' ],
        properties: {
            width:          new Types.Float(1.0),
            height:         new Types.Float(1.0),
            depth:          new Types.Float(1.0),
            widthSegments:  new Types.Int(1),
            heightSegments: new Types.Int(1),
            depthSegments:  new Types.Int(1),
        },
    },
    BoxLineGeometry: {
        relativePath: './geometries/BoxGeometry',
        superClass: 'BaseBufferGeometry',
        constructorArgs: [ 'width', 'height', 'depth', 'widthSegments', 'heightSegments', 'depthSegments' ],
        properties: {
            width:          new Types.Float(1.0),
            height:         new Types.Float(1.0),
            depth:          new Types.Float(1.0),
            widthSegments:  new Types.Int(1),
            heightSegments: new Types.Int(1),
            depthSegments:  new Types.Int(1),
        },
    },
    CircleBufferGeometry: {
        relativePath: './geometries/CircleGeometry',
        superClass: 'BaseBufferGeometry',
        constructorArgs: [ 'radius', 'segments', 'thetaStart', 'thetaLength' ],
        properties: {
            radius:      new Types.Float(1.0),
            segments:    new Types.Int(8, {minValue: 3}),
            thetaStart:  new Types.Float(0.0),
            thetaLength: new Types.Float(Math.PI * 2.0),
        },
    },
    CircleGeometry: {
        relativePath: './geometries/CircleGeometry',
        superClass: 'BaseGeometry',
        constructorArgs: [ 'radius', 'segments', 'thetaStart', 'thetaLength' ],
        properties: {
            radius:      new Types.Float(1.0),
            segments:    new Types.Int(8, {minValue: 3}),
            thetaStart:  new Types.Float(0.0),
            thetaLength: new Types.Float(Math.PI * 2.0),
        },
    },
    ConeGeometry: {
        relativePath: './geometries/ConeGeometry',
        superClass: 'BaseGeometry',
        constructorArgs: ['radius', 'height', 'radialSegments', 'heightSegments', 'openEnded', 'thetaStart', 'thetaLength'],
        properties: {
            radius:         new Types.Float(20.0),
            height:         new Types.Float(100.0),
            radialSegments: new Types.Int(8),
            heightSegments: new Types.Int(1),
            openEnded:      new Types.Bool(false),
            thetaStart:     new Types.Float(0.0),
            thetaLength:    new Types.Float(Math.PI * 2.0),
        },
    },
    CylinderBufferGeometry: {
        relativePath: './geometries/CylinderGeometry',
        superClass: 'BaseBufferGeometry',
        constructorArgs: [ 'radiusTop', 'radiusBottom', 'height', 'radiusSegments', 'heightSegments', 'openEnded', 'thetaStart', 'thetaLength' ],
        properties: {
            radiusTop:      new Types.Float(1.0),
            radiusBottom:   new Types.Float(1.0),
            height:         new Types.Float(1.0),
            radiusSegments: new Types.Int(8),
            heightSegments: new Types.Int(1),
            openEnded:      new Types.Bool(false),
            thetaStart:     new Types.Float(0.0),
            thetaLength:    new Types.Float(Math.PI * 2.0),
        },
    },
    CylinderGeometry: {
        relativePath: './geometries/CylinderGeometry',
        superClass: 'BaseGeometry',
        constructorArgs: [ 'radiusTop', 'radiusBottom', 'height', 'radiusSegments', 'heightSegments', 'openEnded', 'thetaStart', 'thetaLength' ],
        properties: {
            radiusTop:      new Types.Float(1.0),
            radiusBottom:   new Types.Float(1.0),
            height:         new Types.Float(1.0),
            radiusSegments: new Types.Int(8),
            heightSegments: new Types.Int(1),
            openEnded:      new Types.Bool(false),
            thetaStart:     new Types.Float(0.0),
            thetaLength:    new Types.Float(Math.PI * 2.0),
        },
    },
    DodecahedronGeometry: {
        relativePath: './geometries/DodecahedronGeometry',
        superClass: 'BaseGeometry',
        constructorArgs: [ 'radius', 'detail' ],
        properties: {
            radius: new Types.Float(1.0),
            detail: new Types.Int(0.0),
        },
    },
    // TODO:
    EdgesGeometry: {
        todo: true,
        relativePath: './geometries/EdgesGeometry',
        superClass: 'BaseGeometry',
    },
    // TODO:
    ExtrudeGeometry: {
        todo: true,
        relativePath: './geometries/ExtrudeGeometry',
        superClass: 'BaseGeometry',
    },
    IcosahedronGeometry: {
        relativePath: './geometries/IcosahedronGeometry',
        superClass: 'BaseGeometry',
        constructorArgs: [ 'radius', 'detail' ],
        properties: {
            radius: new Types.Float(1.0),
            detail: new Types.Int(0.0),
        },
    },
    LatheBufferGeometry: {
        relativePath: './geometries/LatheGeometry',
        superClass: 'BaseBufferGeometry',
        constructorArgs: [ 'points', 'segments', 'phiStart', 'phiLength' ],
        properties: {
            points:    new Types.VectorArray(),
            segments:  new Types.Int(12),
            phiStart:  new Types.Float(0.0),
            phiLength: new Types.Float(Math.PI * 2.0),
        },
    },
    LatheGeometry: {
        relativePath: './geometries/LatheGeometry',
        superClass: 'BaseGeometry',
        constructorArgs: [ 'points', 'segments', 'phiStart', 'phiLength' ],
        properties: {
            points:    new Types.VectorArray(),
            segments:  new Types.Int(12),
            phiStart:  new Types.Float(0.0),
            phiLength: new Types.Float(Math.PI * 2.0),
        },
    },
    LineGeometry: {
        relativePath: './geometries/LineGeometry',
        superClass: 'LineSegmentsGeometry',
        constructorArgs: [],
        properties: {
            positions: new Types.ArrayBuffer('float32', [null, 3]),
            colors:    new Types.ArrayBuffer('float32', [null, 3], {nullable: true}),
        },
    },
    LineSegmentsGeometry: {
        relativePath: './geometries/LineSegmentsGeometry',
        superClass: 'BaseBufferGeometry',
        constructorArgs: [],
        properties: {
            positions: new Types.ArrayBuffer('float32', [null, 2, 3]),
            colors:    new Types.ArrayBuffer('float32', [null, 2, 3], {nullable: true}),
        },
    },
    OctahedronGeometry: {
        relativePath: './geometries/OctahedronGeometry',
        superClass: 'BaseGeometry',
        constructorArgs: [ 'radius', 'detail' ],
        properties: {
            radius: new Types.Float(1.0),
            detail: new Types.Int(0.0),
        },
    },
    ParametricGeometry: {
        relativePath: './geometries/ParametricGeometry',
        superClass: 'BaseGeometry',
        constructorArgs: [ 'func', 'slices', 'stacks' ],
        properties: {
            func:   new Types.Function(function(u, v, vec) { }),
            slices: new Types.Int(3), // NOTE: default not specified in three.js
            stacks: new Types.Int(3), // NOTE: default not specified in three.js
        },
    },
    PlaneBufferGeometry: {
        relativePath: './geometries/PlaneGeometry',
        superClass: 'BaseBufferGeometry',
        constructorArgs: [ 'width', 'height', 'widthSegments', 'heightSegments' ],
        properties: {
            width:          new Types.Float(1.0),
            height:         new Types.Float(1.0),
            widthSegments:  new Types.Int(1),
            heightSegments: new Types.Int(1),
        },
    },
    PlaneGeometry: {
        relativePath: './geometries/PlaneGeometry',
        superClass: 'BaseGeometry',
        constructorArgs: [ 'width', 'height', 'widthSegments', 'heightSegments' ],
        properties: {
            width:          new Types.Float(1.0),
            height:         new Types.Float(1.0),
            widthSegments:  new Types.Int(1),
            heightSegments: new Types.Int(1),
        },
    },
    PolyhedronGeometry: {
        relativePath: './geometries/PolyhedronGeometry',
        superClass: 'BaseGeometry',
        constructorArgs: [ 'vertices', 'faces', 'radius', 'detail' ],
        properties: {
            vertices: new Types.Array(),
            indices:  new Types.Array(),
            radius:   new Types.Float(1.0),
            detail:   new Types.Float(0.0),
            faces:    new Types.Array(),
        },
    },
    RingBufferGeometry: {
        relativePath: './geometries/RingGeometry',
        superClass: 'BaseBufferGeometry',
        constructorArgs: [ 'innerRadius', 'outerRadius', 'thetaSegments', 'phiSegments', 'thetaStart', 'thetaLength' ],
        properties: {
            innerRadius:   new Types.Float(0.5),
            outerRadius:   new Types.Float(1.0),
            thetaSegments: new Types.Int(8, {minValue: 3}),
            phiSegments:   new Types.Int(8, {minValue: 1}),
            thetaStart:    new Types.Float(0),
            thetaLength:   new Types.Float(Math.PI * 2),
        },
    },
    RingGeometry: {
        relativePath: './geometries/RingGeometry',
        superClass: 'BaseGeometry',
        constructorArgs: [ 'innerRadius', 'outerRadius', 'thetaSegments', 'phiSegments', 'thetaStart', 'thetaLength' ],
        properties: {
            innerRadius:   new Types.Float(0.5),
            outerRadius:   new Types.Float(1.0),
            thetaSegments: new Types.Int(8, {minValue: 3}),
            phiSegments:   new Types.Int(8, {minValue: 1}),
            thetaStart:    new Types.Float(0),
            thetaLength:   new Types.Float(Math.PI * 2),
        },
    },
    // TODO: figure out options constructor args + UVGenerator
    ShapeGeometry: {
        relativePath: './geometries/ShapeGeometry',
        superClass: 'BaseGeometry',
        constructorArgs: [ 'shapes' ],
        properties: {
            shapes:        new Types.ThreeTypeArray('Shape'),
            curveSegments: new Types.Int(12), // NOTE: docs say this is unused
            material:      new Types.Int(0), // NOTE: no default specified
            // 'UVGenerator': // TODO: figure out this option
        }
    },
    SphereBufferGeometry: {
        relativePath: './geometries/SphereGeometry',
        superClass: 'BaseBufferGeometry',
        constructorArgs: [ 'radius', 'widthSegments', 'heightSegments', 'phiStart', 'phiLength', 'thetaStart', 'thetaLength' ],
        properties: {
            radius:         new Types.Float(1.0),
            widthSegments:  new Types.Int(8),
            heightSegments: new Types.Int(6),
            phiStart:       new Types.Float(0),
            phiLength:      new Types.Float(Math.PI * 2.0),
            thetaStart:     new Types.Float(0),
            thetaLength:    new Types.Float(Math.PI),
        },
    },
    SphereGeometry: {
        relativePath: './geometries/SphereGeometry',
        superClass: 'BaseGeometry',
        constructorArgs: [ 'radius', 'widthSegments', 'heightSegments', 'phiStart', 'phiLength', 'thetaStart', 'thetaLength' ],
        properties: {
            radius:         new Types.Float(1.0),
            widthSegments:  new Types.Int(8),
            heightSegments: new Types.Int(6),
            phiStart:       new Types.Float(0),
            phiLength:      new Types.Float(Math.PI * 2.0),
            thetaStart:     new Types.Float(0),
            thetaLength:    new Types.Float(Math.PI),
        },
    },
    TetrahedronGeometry: {
        relativePath: './geometries/TetrahedronGeometry',
        superClass: 'BaseGeometry',
        constructorArgs: [ 'radius', 'detail' ],
        properties: {
            radius: new Types.Float(1),
            detail: new Types.Int(0),
        },
    },
    // TODO:
    TextGeometry: {
        todo: true,
        relativePath: './geometries/TextGeometry',
        superClass: 'BaseGeometry',
    },
    TorusBufferGeometry: {
        relativePath: './geometries/TorusGeometry',
        superClass: 'BaseBufferGeometry',
        constructorArgs: [ 'radius', 'tube', 'radialSegments', 'tubularSegments', 'arc' ],
        properties: {
            radius:          new Types.Float(1.0),
            tube:            new Types.Float(0.4),
            radialSegments:  new Types.Int(8),
            tubularSegments: new Types.Int(6),
            arc:             new Types.Float(Math.PI * 2.0),
        },
    },
    TorusGeometry: {
        relativePath: './geometries/TorusGeometry',
        superClass: 'BaseGeometry',
        constructorArgs: [ 'radius', 'tube', 'radialSegments', 'tubularSegments', 'arc' ],
        properties: {
            radius:          new Types.Float(1.0),
            tube:            new Types.Float(0.4),
            radialSegments:  new Types.Int(8),
            tubularSegments: new Types.Int(6),
            arc:             new Types.Float(Math.PI * 2.0),
        },
    },
    TorusKnotBufferGeometry: {
        relativePath: './geometries/TorusKnotGeometry',
        superClass: 'BaseBufferGeometry',
        constructorArgs: [ 'radius', 'tube', 'tubularSegments', 'radialSegments', 'p', 'q' ],
        properties: {
            radius:          new Types.Float(1.0),
            tube:            new Types.Float(0.4),
            tubularSegments: new Types.Int(64),
            radialSegments:  new Types.Int(8),
            p:               new Types.Int(2),
            q:               new Types.Int(3),
        },
    },
    TorusKnotGeometry: {
        relativePath: './geometries/TorusKnotGeometry',
        superClass: 'BaseGeometry',
        constructorArgs: [ 'radius', 'tube', 'tubularSegments', 'radialSegments', 'p', 'q' ],
        properties: {
            radius:          new Types.Float(1),
            tube:            new Types.Float(0.4),
            tubularSegments: new Types.Int(64),
            radialSegments:  new Types.Int(8),
            p:               new Types.Int(2),
            q:               new Types.Int(3),
        },
    },
    TubeGeometry: {
        relativePath: './geometries/TubeGeometry',
        superClass: 'BaseGeometry',
        constructorArgs: [ 'path', 'segments', 'radius', 'radiusSegments', 'close' ],
        properties: {
            path:           new Types.ThreeType('Curve'),
            segments:       new Types.Int(64),
            radius:         new Types.Float(1.0),
            radiusSegments: new Types.Int(8),
            close:          new Types.Bool(false),
        },
    },
    WireframeGeometry: {
        relativePath: './geometries/WireframeGeometry',
        superClass: 'BaseGeometry',
        constructorArgs: [ 'geometry' ],
        properties: {
            geometry:       new Types.ThreeType(['BaseGeometry', 'BaseBufferGeometry']),
        },
    },
    ArrowHelper: {
        relativePath: './helpers/ArrowHelper',
        superClass: 'Object3D',
        properties: {
            dir: new Types.Vector3(1, 0, 0),
            origin: new Types.Vector3(0, 0, 0),
            length: new Types.Float(1.0),
            hex: new Types.Int(0),
            headLength: new Types.Float(null, {nullable: true}),
            headWidth: new Types.Float(null, {nullable: true}),
        },
    },
    AxesHelper: {
        relativePath: './helpers/AxesHelper',
        superClass: 'Object3D',  // Should really be LineSegments, but we don't want to sync geometry/material
        properties: {
            size:       new Types.Float(1.0),
        },
        constructorArgs: ['size'],
    },
    BoxHelper: {
        relativePath: './helpers/BoxHelper',
        superClass: 'Object3D',  // Should really be LineSegments, but we don't want to sync geometry/material
        properties: {
            object:      new Types.ThreeType('Object3D'),
            color:       new Types.Color(null, {nullable: true}),
        },
        constructorArgs: ['object', 'color'],
        propsDefinedByThree: ['matrixAutoUpdate']
    },
    Box3Helper: {
        superClass: 'Object3D',  // Should really be LineSegments, but we don't want to sync geometry/material
        properties: {
            box:      new Types.ThreeType('Box3'),
            color:    new Types.Color('yellow', {nullable: true}),
        },
        constructorArgs: ['box', 'color'],
    },
    CameraHelper: {
        relativePath: './helpers/CameraHelper',
        superClass: 'Object3D',  // Should really be LineSegments, but we don't want to sync geometry/material
        properties: {
            camera:         new Types.ThreeType('Camera'),
        },
        constructorArgs: ['camera'],
        propsDefinedByThree: ['matrixAutoUpdate']
    },
    DirectionalLightHelper: {
        relativePath: './helpers/DirectionalLightHelper',
        superClass: 'Object3D',
        properties: {
            light:      new Types.ThreeType('DirectionalLight'),
            size:       new Types.Float(1.0),
            color:      new Types.Color(null, {nullable: true}),
        },
        constructorArgs: ['light', 'size', 'color'],
        propsDefinedByThree: ['matrixAutoUpdate']
    },
    FaceNormalsHelper: {
        relativePath: './helpers/FaceNormalsHelper',
        superClass: 'Object3D',  // Should really be LineSegments, but we don't want to sync geometry/material
        properties: {
            object:         new Types.ThreeType('Object3D'),
            size:           new Types.Float(1.0),
            color:          new Types.Color('0xffff00'),
            linewidth:      new Types.Float(1.0),
        },
        constructorArgs: ['object', 'size', 'color', 'linewidth'],
        propsDefinedByThree: ['matrixAutoUpdate']
    },
    GridHelper: {
        relativePath: './helpers/GridHelper',
        superClass: 'Object3D',  // Should really be Line, but we don't want to sync geometry/material
        properties: {
            size:               new Types.Float(10),
            divisions:          new Types.Int(10),
            colorCenterLine:    new Types.Color('0x444444'),
            colorGrid:          new Types.Color('0x888888'),
        },
        constructorArgs: ['size', 'divisions', 'colorCenterLine', 'colorGrid'],
    },
    HemisphereLightHelper: {
        relativePath: './helpers/HemisphereLightHelper',
        superClass: 'Object3D',
        properties: {
            light:      new Types.ThreeType('HemisphereLight'),
            size:       new Types.Float(1.0),
            color:      new Types.Color(null, {nullable: true}),
        },
        constructorArgs: ['light', 'size', 'color'],
        propsDefinedByThree: ['matrixAutoUpdate']
    },
    PlaneHelper: {
        superClass: 'Object3D',  // Should really be LineSegments, but we don't want to sync geometry/material
        properties: {
            plane:    new Types.ThreeType('Plane'),
            size:     new Types.Float(1.0),
            color:    new Types.Color('yellow', {nullable: true}),
        },
        constructorArgs: ['plane', 'size', 'color'],
    },
    PointLightHelper: {
        relativePath: './helpers/PointLightHelper',
        superClass: 'Object3D',  // Should really be Mesh, but we don't want to sync geometry/material
        properties: {
            light:          new Types.ThreeType('PointLight'),
            sphereSize:     new Types.Float(1.0),
            color:          new Types.Color(null, {nullable: true}),
        },
        constructorArgs: ['light', 'sphereSize', 'color'],
        propsDefinedByThree: ['matrixAutoUpdate']
    },
    PolarGridHelper: {
        relativePath: './helpers/PolarGridHelper',
        superClass: 'Object3D',  // Should really be Line, but we don't want to sync geometry/material
        properties: {
            radius:     new Types.Int(10),
            radials:    new Types.Int(16),
            circles:    new Types.Int(8),
            divisions:  new Types.Int(64),
            color1:     new Types.Color('0x444444'),
            color2:     new Types.Color('0x888888'),
        },
        constructorArgs: ['radius', 'radials', 'circles', 'divisions', 'color1', 'color2'],
    },
    RectAreaLightHelper: {
        relativePath: './helpers/RectAreaLightHelper',
        superClass: 'Object3D',
        properties: {
            light:      new Types.ThreeType('RectAreaLight'),
            color:      new Types.Color(null, {nullable: true}),
        },
        constructorArgs: ['light', 'color'],
    },
    SkeletonHelper: {
        relativePath: './helpers/SkeletonHelper',
        superClass: 'Object3D',  // Should really be LineSegments, but we don't want to sync geometry/material
        properties: {
            root:         new Types.ThreeType('Object3D'),
        },
        constructorArgs: ['root'],
    },
    SpotLightHelper: {
        relativePath: './helpers/SpotLightHelper',
        superClass: 'Object3D',
        properties: {
            light:      new Types.ThreeType('SpotLight'),
            color:      new Types.Color(null, {nullable: true}),
        },
        constructorArgs: ['light', 'color'],
        propsDefinedByThree: ['matrixAutoUpdate']
    },
    VertexNormalsHelper: {
        relativePath: './helpers/VertexNormalsHelper',
        superClass: 'Object3D',  // Should really be Line, but we don't want to sync geometry/material
        properties: {
            object:         new Types.ThreeType('Object3D'),
            size:           new Types.Float(1.0),
            color:          new Types.Color('0xffff00'),
            linewidth:      new Types.Float(1.0),
        },
        constructorArgs: ['object', 'size', 'color', 'linewidth'],
        propsDefinedByThree: ['matrixAutoUpdate']
    },
    // TODO:
    ImmediateRenderObject: {
        todo: true,
        relativePath: './extras/objects/ImmediateRenderObject',
    },
    // TODO:
    CubicInterpolant: {
        todo: true,
        relativePath: './math/interpolants/CubicInterpolant',
    },
    // TODO:
    DiscreteInterpolant: {
        todo: true,
        relativePath: './math/interpolants/DiscreteInterpolant',
    },
    // TODO:
    LinearInterpolant: {
        todo: true,
        relativePath: './math/interpolants/LinearInterpolant',
    },
    // TODO:
    QuaternionLinearInterpolant: {
        todo: true,
        relativePath: './math/interpolants/QuaternionLinearInterpolant',
    },
    // TODO:
    WebGLBufferRenderer: {
        todo: true,
        relativePath: './renderers/webgl/WebGLBufferRenderer',
    },
    // TODO:
    WebGLCapabilities: {
        todo: true,
        relativePath: './renderers/webgl/WebGLCapabilities',
    },
    // TODO:
    WebGLExtensions: {
        todo: true,
        relativePath: './renderers/webgl/WebGLExtensions',
    },
    // TODO:
    WebGLGeometries: {
        todo: true,
        relativePath: './renderers/webgl/WebGLGeometries',
    },
    // TODO:
    WebGLIndexedBufferRenderer: {
        todo: true,
        relativePath: './renderers/webgl/WebGLIndexedBufferRenderer',
    },
    // TODO:
    WebGLLights: {
        todo: true,
        relativePath: './renderers/webgl/WebGLLights',
    },
    // TODO:
    WebGLObjects: {
        todo: true,
        relativePath: './renderers/webgl/WebGLObjects',
    },
    // TODO:
    WebGLProgram: {
        todo: true,
        relativePath: './renderers/webgl/WebGLProgram',
    },
    // TODO:
    WebGLPrograms: {
        todo: true,
        relativePath: './renderers/webgl/WebGLPrograms',
    },
    // TODO:
    WebGLProperties: {
        todo: true,
        relativePath: './renderers/webgl/WebGLProperties',
    },
    // TODO:
    WebGLShader: {
        todo: true,
        relativePath: './renderers/webgl/WebGLShader',
    },
    WebGLShadowMap: {
        relativePath: './renderers/webgl/WebGLShadowMap',
        properties: {
            enabled: new Types.Bool(false),
            type: new Types.Enum('ShadowTypes', 'PCFShadowMap'),
        }
    },
    // TODO:
    WebGLState: {
        todo: true,
        relativePath: './renderers/webgl/WebGLState',
    },
};
