import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from .Texture_autogen import Texture


class DataTexture(Texture):
    """DataTexture

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/textures/DataTexture
    """

    def __init__(self, data=None, format="RGBAFormat", type="UnsignedByteType", mapping="UVMapping", wrapS="ClampToEdgeWrapping", wrapT="ClampToEdgeWrapping", magFilter="NearestFilter", minFilter="NearestFilter", anisotropy=1, **kwargs):
        kwargs['data'] = data
        kwargs['format'] = format
        kwargs['type'] = type
        kwargs['mapping'] = mapping
        kwargs['wrapS'] = wrapS
        kwargs['wrapT'] = wrapT
        kwargs['magFilter'] = magFilter
        kwargs['minFilter'] = minFilter
        kwargs['anisotropy'] = anisotropy
        super(DataTexture, self).__init__(**kwargs)

    _model_name = Unicode('DataTextureModel').tag(sync=True)

    data = WebGLDataUnion().tag(sync=True)

    minFilter = Enum(Filters, "NearestFilter", allow_none=False).tag(sync=True)

    magFilter = Enum(Filters, "NearestFilter", allow_none=False).tag(sync=True)

    flipY = Bool(False, allow_none=False).tag(sync=True)

    generateMipmaps = Bool(False, allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    DataTexture.__signature__ = inspect.signature(DataTexture.__init__)
