import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from .BufferAttribute import BufferAttribute


@register
class InstancedBufferAttribute(BufferAttribute):
    """InstancedBufferAttribute

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/core/InstancedBufferAttribute
    """

    def __init__(self, array=None, meshPerAttribute=1, **kwargs):
        kwargs['array'] = array
        kwargs['meshPerAttribute'] = meshPerAttribute
        super(InstancedBufferAttribute, self).__init__(**kwargs)

    _model_name = Unicode('InstancedBufferAttributeModel').tag(sync=True)

    meshPerAttribute = CInt(1, allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    InstancedBufferAttribute.__signature__ = inspect.signature(InstancedBufferAttribute.__init__)
