import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from ..core.BaseGeometry_autogen import BaseGeometry


@register
class RingGeometry(BaseGeometry):
    """RingGeometry

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/geometries/RingGeometry
    """

    def __init__(self, innerRadius=0.5, outerRadius=1, thetaSegments=8, phiSegments=8, thetaStart=0, thetaLength=6.283185307179586, **kwargs):
        kwargs['innerRadius'] = innerRadius
        kwargs['outerRadius'] = outerRadius
        kwargs['thetaSegments'] = thetaSegments
        kwargs['phiSegments'] = phiSegments
        kwargs['thetaStart'] = thetaStart
        kwargs['thetaLength'] = thetaLength
        super(RingGeometry, self).__init__(**kwargs)

    _model_name = Unicode('RingGeometryModel').tag(sync=True)

    innerRadius = CFloat(0.5, allow_none=False).tag(sync=True)

    outerRadius = CFloat(1, allow_none=False).tag(sync=True)

    thetaSegments = CInt(8, allow_none=False, min=3).tag(sync=True)

    phiSegments = CInt(8, allow_none=False, min=1).tag(sync=True)

    thetaStart = CFloat(0, allow_none=False).tag(sync=True)

    thetaLength = CFloat(6.283185307179586, allow_none=False).tag(sync=True)

    type = Unicode("RingGeometry", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    RingGeometry.__signature__ = inspect.signature(RingGeometry.__init__)
