import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from .ShaderMaterial_autogen import ShaderMaterial


@register
class RawShaderMaterial(ShaderMaterial):
    """RawShaderMaterial

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/materials/RawShaderMaterial
    """

    _model_name = Unicode('RawShaderMaterialModel').tag(sync=True)

    type = Unicode("RawShaderMaterial", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    RawShaderMaterial.__signature__ = inspect.signature(RawShaderMaterial.__init__)
