import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from .Light_autogen import Light

from ..core.Object3D import Object3D
from .LightShadow_autogen import LightShadow

@register
class SpotLight(Light):
    """SpotLight

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/lights/SpotLight
    """

    def __init__(self, color="#ffffff", intensity=1, distance=0, angle=1.0471975511965976, penumbra=0, decay=1, **kwargs):
        kwargs['color'] = color
        kwargs['intensity'] = intensity
        kwargs['distance'] = distance
        kwargs['angle'] = angle
        kwargs['penumbra'] = penumbra
        kwargs['decay'] = decay
        super(SpotLight, self).__init__(**kwargs)

    _model_name = Unicode('SpotLightModel').tag(sync=True)

    target = Union([
        Instance(Uninitialized),
        Instance(Object3D),
        ], default_value=UninitializedSentinel, allow_none=False).tag(sync=True, **unitialized_serialization)

    distance = CFloat(0, allow_none=False).tag(sync=True)

    angle = CFloat(1.0471975511965976, allow_none=False).tag(sync=True)

    penumbra = CFloat(0, allow_none=False).tag(sync=True)

    decay = CFloat(1, allow_none=False).tag(sync=True)

    shadow = Union([
        Instance(Uninitialized),
        Instance(LightShadow),
        ], default_value=UninitializedSentinel, allow_none=False).tag(sync=True, **unitialized_serialization)

    type = Unicode("SpotLight", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    SpotLight.__signature__ = inspect.signature(SpotLight.__init__)
