import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from ..core.Object3D import Object3D

from ..lights.DirectionalLight_autogen import DirectionalLight

@register
class DirectionalLightHelper(Object3D):
    """DirectionalLightHelper

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/helpers/DirectionalLightHelper
    """

    def __init__(self, light=None, size=1, color="#ffffff", **kwargs):
        kwargs['light'] = light
        kwargs['size'] = size
        kwargs['color'] = color
        super(DirectionalLightHelper, self).__init__(**kwargs)

    _model_name = Unicode('DirectionalLightHelperModel').tag(sync=True)

    light = Instance(DirectionalLight, allow_none=True).tag(sync=True, **widget_serialization)

    size = CFloat(1, allow_none=False).tag(sync=True)

    color = Unicode("#ffffff", allow_none=True).tag(sync=True)

    type = Unicode("DirectionalLightHelper", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    DirectionalLightHelper.__signature__ = inspect.signature(DirectionalLightHelper.__init__)
