import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from ..core.BaseGeometry_autogen import BaseGeometry


@register
class LatheGeometry(BaseGeometry):
    """LatheGeometry

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/geometries/LatheGeometry
    """

    def __init__(self, points=[], segments=12, phiStart=0, phiLength=6.283185307179586, **kwargs):
        kwargs['points'] = points
        kwargs['segments'] = segments
        kwargs['phiStart'] = phiStart
        kwargs['phiLength'] = phiLength
        super(LatheGeometry, self).__init__(**kwargs)

    _model_name = Unicode('LatheGeometryModel').tag(sync=True)

    points = List(trait=List()).tag(sync=True)

    segments = CInt(12, allow_none=False).tag(sync=True)

    phiStart = CFloat(0, allow_none=False).tag(sync=True)

    phiLength = CFloat(6.283185307179586, allow_none=False).tag(sync=True)

    type = Unicode("LatheGeometry", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    LatheGeometry.__signature__ = inspect.signature(LatheGeometry.__init__)
