import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from ..core.BaseGeometry_autogen import BaseGeometry


@register
class ExtrudeGeometry(BaseGeometry):
    """ExtrudeGeometry

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/geometries/ExtrudeGeometry
    """

    def __init__(self, **kwargs):
        super(ExtrudeGeometry, self).__init__(**kwargs)

    _model_name = Unicode('ExtrudeGeometryModel').tag(sync=True)

    type = Unicode("ExtrudeGeometry", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    ExtrudeGeometry.__signature__ = inspect.signature(ExtrudeGeometry.__init__)
