import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from ..core.BaseGeometry_autogen import BaseGeometry


@register
class EdgesGeometry(BaseGeometry):
    """EdgesGeometry

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/geometries/EdgesGeometry
    """

    def __init__(self, **kwargs):
        super(EdgesGeometry, self).__init__(**kwargs)

    _model_name = Unicode('EdgesGeometryModel').tag(sync=True)

    type = Unicode("EdgesGeometry", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    EdgesGeometry.__signature__ = inspect.signature(EdgesGeometry.__init__)
