import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget


@register
class InterleavedBuffer(ThreeWidget):
    """InterleavedBuffer

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/core/InterleavedBuffer
    """

    def __init__(self, array=None, stride=0, **kwargs):
        kwargs['array'] = array
        kwargs['stride'] = stride
        super(InterleavedBuffer, self).__init__(**kwargs)

    _model_name = Unicode('InterleavedBufferModel').tag(sync=True)

    array = WebGLDataUnion().tag(sync=True)

    stride = CInt(0, allow_none=False).tag(sync=True)

    dynamic = Bool(False, allow_none=False).tag(sync=True)

    version = CInt(0, allow_none=False).tag(sync=True)

    needsUpdate = Bool(False, allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    InterleavedBuffer.__signature__ = inspect.signature(InterleavedBuffer.__init__)
