import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from ..._base.Three import ThreeWidget
from ...enums import *
from ...traits import *

from ..KeyframeTrack_autogen import KeyframeTrack


@register
class NumberKeyframeTrack(KeyframeTrack):
    """NumberKeyframeTrack

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/animation/tracks/NumberKeyframeTrack
    """

    def __init__(self, name='', times=None, values=None, interpolation="InterpolateLinear", **kwargs):
        kwargs['name'] = name
        kwargs['times'] = times
        kwargs['values'] = values
        kwargs['interpolation'] = interpolation
        super(NumberKeyframeTrack, self).__init__(**kwargs)

    _model_name = Unicode('NumberKeyframeTrackModel').tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    NumberKeyframeTrack.__signature__ = inspect.signature(NumberKeyframeTrack.__init__)
