import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget


@register
class Cylindrical(ThreeWidget):
    """Cylindrical

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/math/Cylindrical
    """

    def __init__(self, radius=1, theta=0, y=0, **kwargs):
        kwargs['radius'] = radius
        kwargs['theta'] = theta
        kwargs['y'] = y
        super(Cylindrical, self).__init__(**kwargs)

    _model_name = Unicode('CylindricalModel').tag(sync=True)

    radius = CFloat(1, allow_none=False).tag(sync=True)

    theta = CFloat(0, allow_none=False).tag(sync=True)

    y = CFloat(0, allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    Cylindrical.__signature__ = inspect.signature(Cylindrical.__init__)
