import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget


@register
class Texture(ThreeWidget):
    """Texture

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/textures/Texture
    """

    def __init__(self, **kwargs):
        super(Texture, self).__init__(**kwargs)

    _model_name = Unicode('TextureModel').tag(sync=True)

    name = Unicode('', allow_none=False).tag(sync=True)

    mapping = Enum(MappingModes, "UVMapping", allow_none=False).tag(sync=True)

    wrapS = Enum(WrappingModes, "ClampToEdgeWrapping", allow_none=False).tag(sync=True)

    wrapT = Enum(WrappingModes, "ClampToEdgeWrapping", allow_none=False).tag(sync=True)

    magFilter = Enum(Filters, "LinearFilter", allow_none=False).tag(sync=True)

    minFilter = Enum(Filters, "LinearMipMapLinearFilter", allow_none=False).tag(sync=True)

    format = Enum(PixelFormats, "RGBAFormat", allow_none=False).tag(sync=True)

    type = Enum(DataTypes, "UnsignedByteType", allow_none=False).tag(sync=True)

    anisotropy = CFloat(1, allow_none=False).tag(sync=True)

    repeat = Vector2(default_value=[1,1]).tag(sync=True)

    offset = Vector2(default_value=[0,0]).tag(sync=True)

    generateMipmaps = Bool(True, allow_none=False).tag(sync=True)

    premultiplyAlpha = Bool(False, allow_none=False).tag(sync=True)

    flipY = Bool(True, allow_none=False).tag(sync=True)

    unpackAlignment = CInt(4, allow_none=False).tag(sync=True)

    encoding = Enum(TextureEncodings, "LinearEncoding", allow_none=False).tag(sync=True)

    version = CInt(0, allow_none=False).tag(sync=True)

    rotation = CFloat(0, allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    Texture.__signature__ = inspect.signature(Texture.__init__)
