import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from .Controls_autogen import Controls


@register
class TrackballControls(Controls):
    """TrackballControls

    Autogenerated by generate-wrappers.js
    This class is a custom class for pythreejs, with no
    direct corresponding class in three.js.
    """

    def __init__(self, controlling=None, **kwargs):
        kwargs['controlling'] = controlling
        super(TrackballControls, self).__init__(**kwargs)

    _model_name = Unicode('TrackballControlsModel').tag(sync=True)

    enabled = Bool(True, allow_none=False).tag(sync=True)

    minDistance = CFloat(0, allow_none=False).tag(sync=True)

    maxDistance = CFloat(float('inf'), allow_none=False).tag(sync=True)

    rotateSpeed = CFloat(1, allow_none=False).tag(sync=True)

    zoomSpeed = CFloat(1.2, allow_none=False).tag(sync=True)

    panSpeed = CFloat(0.3, allow_none=False).tag(sync=True)

    staticMoving = Bool(False, allow_none=False).tag(sync=True)

    dynamicDampingFactor = CFloat(0.2, allow_none=False).tag(sync=True)

    noRotate = Bool(False, allow_none=False).tag(sync=True)

    noZoom = Bool(False, allow_none=False).tag(sync=True)

    noPan = Bool(False, allow_none=False).tag(sync=True)

    noRoll = Bool(False, allow_none=False).tag(sync=True)

    target = Vector3(default_value=[0,0,0]).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    TrackballControls.__signature__ = inspect.signature(TrackballControls.__init__)
