import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget

from .KeyframeTrack_autogen import KeyframeTrack

@register
class AnimationClip(ThreeWidget):
    """AnimationClip

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/animation/AnimationClip
    """

    def __init__(self, name=None, duration=-1, tracks=[], **kwargs):
        kwargs['name'] = name
        kwargs['duration'] = duration
        kwargs['tracks'] = tracks
        super(AnimationClip, self).__init__(**kwargs)

    _model_name = Unicode('AnimationClipModel').tag(sync=True)

    name = Unicode(None, allow_none=True).tag(sync=True)

    duration = CFloat(-1, allow_none=False).tag(sync=True)

    tracks = Tuple().tag(sync=True, **widget_serialization)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    AnimationClip.__signature__ = inspect.signature(AnimationClip.__init__)
