import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget

from .AnimationMixer_autogen import AnimationMixer
from .AnimationClip_autogen import AnimationClip
from .._base.Three import ThreeWidget

class AnimationAction(ThreeWidget):
    """AnimationAction

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/animation/AnimationAction
    """

    def __init__(self, mixer=None, clip=None, localRoot=None, **kwargs):
        kwargs['mixer'] = mixer
        kwargs['clip'] = clip
        kwargs['localRoot'] = localRoot
        super(AnimationAction, self).__init__(**kwargs)

    _model_name = Unicode('AnimationActionModel').tag(sync=True)

    mixer = Instance(AnimationMixer, allow_none=True).tag(sync=True, **widget_serialization)

    clip = Instance(AnimationClip, allow_none=True).tag(sync=True, **widget_serialization)

    localRoot = Instance(ThreeWidget, allow_none=True).tag(sync=True, **widget_serialization)

    clampWhenFinished = Bool(False, allow_none=False).tag(sync=True)

    enabled = Bool(True, allow_none=False).tag(sync=True)

    loop = Enum(LoopModes, "LoopRepeat", allow_none=False).tag(sync=True)

    paused = Bool(False, allow_none=False).tag(sync=True)

    repititions = CInt(float('inf'), allow_none=False).tag(sync=True)

    time = CFloat(0, allow_none=False).tag(sync=True)

    timeScale = CFloat(1, allow_none=False).tag(sync=True)

    weigth = CFloat(1, allow_none=False).tag(sync=True)

    zeroSlopeAtEnd = Bool(True, allow_none=False).tag(sync=True)

    zeroSlopeAtStart = Bool(True, allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    AnimationAction.__signature__ = inspect.signature(AnimationAction.__init__)
