import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget


@register
class Box2(ThreeWidget):
    """Box2

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/math/Box2
    """

    def __init__(self, min=[0,0], max=[0,0], **kwargs):
        kwargs['min'] = min
        kwargs['max'] = max
        super(Box2, self).__init__(**kwargs)

    _model_name = Unicode('Box2Model').tag(sync=True)

    min = Vector2(default_value=[0,0]).tag(sync=True)

    max = Vector2(default_value=[0,0]).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    Box2.__signature__ = inspect.signature(Box2.__init__)
