import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from ..core.Object3D import Object3D

from ..math.Box3_autogen import Box3

@register
class Box3Helper(Object3D):
    """Box3Helper

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/helpers/PlaneHelper
    """

    def __init__(self, box=None, color="yellow", **kwargs):
        kwargs['box'] = box
        kwargs['color'] = color
        super(Box3Helper, self).__init__(**kwargs)

    _model_name = Unicode('Box3HelperModel').tag(sync=True)

    box = Instance(Box3, allow_none=True).tag(sync=True, **widget_serialization)

    color = Unicode("yellow", allow_none=True).tag(sync=True)

    type = Unicode("Box3Helper", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    Box3Helper.__signature__ = inspect.signature(Box3Helper.__init__)
