import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from ..core.BaseGeometry_autogen import BaseGeometry


@register
class ConeGeometry(BaseGeometry):
    """ConeGeometry

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/geometries/ConeGeometry
    """

    def __init__(self, radius=20, height=100, radialSegments=8, heightSegments=1, openEnded=False, thetaStart=0, thetaLength=6.283185307179586, **kwargs):
        kwargs['radius'] = radius
        kwargs['height'] = height
        kwargs['radialSegments'] = radialSegments
        kwargs['heightSegments'] = heightSegments
        kwargs['openEnded'] = openEnded
        kwargs['thetaStart'] = thetaStart
        kwargs['thetaLength'] = thetaLength
        super(ConeGeometry, self).__init__(**kwargs)

    _model_name = Unicode('ConeGeometryModel').tag(sync=True)

    radius = CFloat(20, allow_none=False).tag(sync=True)

    height = CFloat(100, allow_none=False).tag(sync=True)

    radialSegments = CInt(8, allow_none=False).tag(sync=True)

    heightSegments = CInt(1, allow_none=False).tag(sync=True)

    openEnded = Bool(False, allow_none=False).tag(sync=True)

    thetaStart = CFloat(0, allow_none=False).tag(sync=True)

    thetaLength = CFloat(6.283185307179586, allow_none=False).tag(sync=True)

    type = Unicode("ConeGeometry", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    ConeGeometry.__signature__ = inspect.signature(ConeGeometry.__init__)
