import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from .Line_autogen import Line


@register
class LineLoop(Line):
    """LineLoop

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/objects/LineLoop
    """

    def __init__(self, geometry=None, material=None, **kwargs):
        kwargs['geometry'] = geometry
        kwargs['material'] = material
        super(LineLoop, self).__init__(**kwargs)

    _model_name = Unicode('LineLoopModel').tag(sync=True)

    type = Unicode("LineLoop", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    LineLoop.__signature__ = inspect.signature(LineLoop.__init__)
