import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from ..core.Object3D import Object3D


@register
class GridHelper(Object3D):
    """GridHelper

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/helpers/GridHelper
    """

    def __init__(self, size=10, divisions=10, colorCenterLine="0x444444", colorGrid="0x888888", **kwargs):
        kwargs['size'] = size
        kwargs['divisions'] = divisions
        kwargs['colorCenterLine'] = colorCenterLine
        kwargs['colorGrid'] = colorGrid
        super(GridHelper, self).__init__(**kwargs)

    _model_name = Unicode('GridHelperModel').tag(sync=True)

    size = CFloat(10, allow_none=False).tag(sync=True)

    divisions = CInt(10, allow_none=False).tag(sync=True)

    colorCenterLine = Unicode("0x444444", allow_none=False).tag(sync=True)

    colorGrid = Unicode("0x888888", allow_none=False).tag(sync=True)

    type = Unicode("GridHelper", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    GridHelper.__signature__ = inspect.signature(GridHelper.__init__)
