import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from ..core.BaseGeometry_autogen import BaseGeometry


@register
class ParametricGeometry(BaseGeometry):
    """ParametricGeometry

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/geometries/ParametricGeometry
    """

    def __init__(self, func, slices=3, stacks=3, **kwargs):
        kwargs['func'] = func
        kwargs['slices'] = slices
        kwargs['stacks'] = stacks
        super(ParametricGeometry, self).__init__(**kwargs)

    _model_name = Unicode('ParametricGeometryModel').tag(sync=True)

    func = Unicode('function(u,v) { return THREE.Vector3(); }').tag(sync=True)

    slices = CInt(3, allow_none=False).tag(sync=True)

    stacks = CInt(3, allow_none=False).tag(sync=True)

    type = Unicode("ParametricGeometry", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    ParametricGeometry.__signature__ = inspect.signature(ParametricGeometry.__init__)
