import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from .Controls_autogen import Controls


@register
class FlyControls(Controls):
    """FlyControls

    Autogenerated by generate-wrappers.js
    This class is a custom class for pythreejs, with no
    direct corresponding class in three.js.
    """

    def __init__(self, controlling=None, **kwargs):
        kwargs['controlling'] = controlling
        super(FlyControls, self).__init__(**kwargs)

    _model_name = Unicode('FlyControlsModel').tag(sync=True)

    moveVector = Vector3(default_value=[0,0,0]).tag(sync=True)

    rotationVector = Vector3(default_value=[0,0,0]).tag(sync=True)

    movementSpeed = CFloat(1, allow_none=False).tag(sync=True)

    rollSpeed = CFloat(0.05, allow_none=False).tag(sync=True)

    syncRate = CFloat(1, allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    FlyControls.__signature__ = inspect.signature(FlyControls.__init__)
