import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget


@register
class Triangle(ThreeWidget):
    """Triangle

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/math/Triangle
    """

    def __init__(self, a=[0,0,0], b=[0,0,0], c=[0,0,0], **kwargs):
        kwargs['a'] = a
        kwargs['b'] = b
        kwargs['c'] = c
        super(Triangle, self).__init__(**kwargs)

    _model_name = Unicode('TriangleModel').tag(sync=True)

    a = Vector3(default_value=[0,0,0]).tag(sync=True)

    b = Vector3(default_value=[0,0,0]).tag(sync=True)

    c = Vector3(default_value=[0,0,0]).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    Triangle.__signature__ = inspect.signature(Triangle.__init__)
