import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from .Material import Material


@register
class LineDashedMaterial(Material):
    """LineDashedMaterial

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/materials/LineDashedMaterial
    """

    _model_name = Unicode('LineDashedMaterialModel').tag(sync=True)

    color = Unicode("#ffffff", allow_none=False).tag(sync=True)

    lights = Bool(False, allow_none=False).tag(sync=True)

    linewidth = CFloat(1, allow_none=False).tag(sync=True)

    scale = CFloat(1, allow_none=False).tag(sync=True)

    dashSize = CFloat(3, allow_none=False).tag(sync=True)

    gapSize = CFloat(1, allow_none=False).tag(sync=True)

    type = Unicode("LineDashedMaterial", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    LineDashedMaterial.__signature__ = inspect.signature(LineDashedMaterial.__init__)
