import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from ..core.Object3D import Object3D

from ..lights.PointLight_autogen import PointLight

@register
class PointLightHelper(Object3D):
    """PointLightHelper

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/helpers/PointLightHelper
    """

    def __init__(self, light=None, sphereSize=1, color="#ffffff", **kwargs):
        kwargs['light'] = light
        kwargs['sphereSize'] = sphereSize
        kwargs['color'] = color
        super(PointLightHelper, self).__init__(**kwargs)

    _model_name = Unicode('PointLightHelperModel').tag(sync=True)

    light = Instance(PointLight, allow_none=True).tag(sync=True, **widget_serialization)

    sphereSize = CFloat(1, allow_none=False).tag(sync=True)

    color = Unicode("#ffffff", allow_none=True).tag(sync=True)

    type = Unicode("PointLightHelper", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    PointLightHelper.__signature__ = inspect.signature(PointLightHelper.__init__)
