import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from ..core.Object3D import Object3D


@register
class Light(Object3D):
    """Light

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/lights/Light
    """

    def __init__(self, color="#ffffff", intensity=1, **kwargs):
        kwargs['color'] = color
        kwargs['intensity'] = intensity
        super(Light, self).__init__(**kwargs)

    _model_name = Unicode('LightModel').tag(sync=True)

    color = Unicode("#ffffff", allow_none=False).tag(sync=True)

    intensity = CFloat(1, allow_none=False).tag(sync=True)

    type = Unicode("Light", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    Light.__signature__ = inspect.signature(Light.__init__)
