import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from ..core.BaseBufferGeometry_autogen import BaseBufferGeometry


@register
class TorusKnotBufferGeometry(BaseBufferGeometry):
    """TorusKnotBufferGeometry

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/geometries/TorusKnotGeometry
    """

    def __init__(self, radius=1, tube=0.4, tubularSegments=64, radialSegments=8, p=2, q=3, **kwargs):
        kwargs['radius'] = radius
        kwargs['tube'] = tube
        kwargs['tubularSegments'] = tubularSegments
        kwargs['radialSegments'] = radialSegments
        kwargs['p'] = p
        kwargs['q'] = q
        super(TorusKnotBufferGeometry, self).__init__(**kwargs)

    _model_name = Unicode('TorusKnotBufferGeometryModel').tag(sync=True)

    radius = CFloat(1, allow_none=False).tag(sync=True)

    tube = CFloat(0.4, allow_none=False).tag(sync=True)

    tubularSegments = CInt(64, allow_none=False).tag(sync=True)

    radialSegments = CInt(8, allow_none=False).tag(sync=True)

    p = CInt(2, allow_none=False).tag(sync=True)

    q = CInt(3, allow_none=False).tag(sync=True)

    type = Unicode("TorusKnotBufferGeometry", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    TorusKnotBufferGeometry.__signature__ = inspect.signature(TorusKnotBufferGeometry.__init__)
