import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from .PerspectiveCamera_autogen import PerspectiveCamera


@register
class ArrayCamera(PerspectiveCamera):
    """ArrayCamera

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/cameras/ArrayCamera
    """

    def __init__(self, fov=50, aspect=1, near=0.1, far=2000, **kwargs):
        kwargs['fov'] = fov
        kwargs['aspect'] = aspect
        kwargs['near'] = near
        kwargs['far'] = far
        super(ArrayCamera, self).__init__(**kwargs)

    _model_name = Unicode('ArrayCameraModel').tag(sync=True)

    type = Unicode("ArrayCamera", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    ArrayCamera.__signature__ = inspect.signature(ArrayCamera.__init__)
