import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from ..core.Object3D import Object3D


@register
class Bone(Object3D):
    """Bone

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/objects/Bone
    """

    def __init__(self, **kwargs):
        super(Bone, self).__init__(**kwargs)

    _model_name = Unicode('BoneModel').tag(sync=True)

    type = Unicode("Bone", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    Bone.__signature__ = inspect.signature(Bone.__init__)
