import six
from ipywidgets import Widget, DOMWidget, widget_serialization, Color, register
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
    )

from .._base.Three import ThreeWidget
from ..enums import *
from ..traits import *

from .BufferGeometry import BufferGeometry


@register
class InstancedBufferGeometry(BufferGeometry):
    """InstancedBufferGeometry

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/core/InstancedBufferGeometry
    """

    def __init__(self, **kwargs):
        super(InstancedBufferGeometry, self).__init__(**kwargs)

    _model_name = Unicode('InstancedBufferGeometryModel').tag(sync=True)

    maxInstancedCount = CInt(0, allow_none=False).tag(sync=True)

    type = Unicode("InstancedBufferGeometry", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    InstancedBufferGeometry.__signature__ = inspect.signature(InstancedBufferGeometry.__init__)
