#ifndef PYTHONIC_BUILTIN_ORD_HPP
#define PYTHONIC_BUILTIN_ORD_HPP

#include "pythonic/include/__builtin__/ord.hpp"

#include "pythonic/types/exceptions.hpp"
#include "pythonic/types/str.hpp"
#include "pythonic/utils/functor.hpp"

PYTHONIC_NS_BEGIN

namespace __builtin__
{

  long ord(types::str const &v)
  {
    if (v.size() != 1)
      throw types::TypeError(
          "ord() expected a character, but string of length " +
          std::to_string(v.size()) + " found");
    return (long)v.chars()[0];
  }
}
PYTHONIC_NS_END

#endif
