#ifndef PYTHONIC_INCLUDE_BUILTIN_SET_ISSUBSET_HPP
#define PYTHONIC_INCLUDE_BUILTIN_SET_ISSUBSET_HPP

#include "pythonic/include/types/set.hpp"
#include "pythonic/include/utils/functor.hpp"

PYTHONIC_NS_BEGIN

namespace __builtin__
{

  namespace set
  {

    template <class T, class U>
    bool issubset(types::set<T> const &set, U const &other);

    template <class U>
    bool issubset(types::empty_set const &set, U const &other);

    DEFINE_FUNCTOR(pythonic::__builtin__::set, issubset);
  }
}
PYTHONIC_NS_END
#endif
