# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
Law module, see official documentation at
https://www.opencascade.com/doc/occt-7.4.0/refman/html/package_law.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _Law
else:
    import _Law

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Law.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _Law.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _Law.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _Law.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _Law.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _Law.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _Law.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _Law.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _Law.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _Law.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _Law.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _Law.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _Law.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _Law.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _Law.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _Law.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _Law.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _Law:
_Law.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _Law.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.Adaptor3d
import OCC.Core.Geom
import OCC.Core.gp
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.TopAbs
import OCC.Core.Adaptor2d
import OCC.Core.Geom2d
import OCC.Core.math
import OCC.Core.Message

from enum import IntEnum
from OCC.Core.Exception import *




def Handle_Law_BSpline_Create() -> "opencascade::handle< Law_BSpline >":
    return _Law.Handle_Law_BSpline_Create()

def Handle_Law_BSpline_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Law_BSpline >":
    return _Law.Handle_Law_BSpline_DownCast(t)

def Handle_Law_BSpline_IsNull(t: "opencascade::handle< Law_BSpline > const &") -> "bool":
    return _Law.Handle_Law_BSpline_IsNull(t)

def Handle_Law_Function_Create() -> "opencascade::handle< Law_Function >":
    return _Law.Handle_Law_Function_Create()

def Handle_Law_Function_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Law_Function >":
    return _Law.Handle_Law_Function_DownCast(t)

def Handle_Law_Function_IsNull(t: "opencascade::handle< Law_Function > const &") -> "bool":
    return _Law.Handle_Law_Function_IsNull(t)

def Handle_Law_BSpFunc_Create() -> "opencascade::handle< Law_BSpFunc >":
    return _Law.Handle_Law_BSpFunc_Create()

def Handle_Law_BSpFunc_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Law_BSpFunc >":
    return _Law.Handle_Law_BSpFunc_DownCast(t)

def Handle_Law_BSpFunc_IsNull(t: "opencascade::handle< Law_BSpFunc > const &") -> "bool":
    return _Law.Handle_Law_BSpFunc_IsNull(t)

def Handle_Law_Composite_Create() -> "opencascade::handle< Law_Composite >":
    return _Law.Handle_Law_Composite_Create()

def Handle_Law_Composite_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Law_Composite >":
    return _Law.Handle_Law_Composite_DownCast(t)

def Handle_Law_Composite_IsNull(t: "opencascade::handle< Law_Composite > const &") -> "bool":
    return _Law.Handle_Law_Composite_IsNull(t)

def Handle_Law_Constant_Create() -> "opencascade::handle< Law_Constant >":
    return _Law.Handle_Law_Constant_Create()

def Handle_Law_Constant_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Law_Constant >":
    return _Law.Handle_Law_Constant_DownCast(t)

def Handle_Law_Constant_IsNull(t: "opencascade::handle< Law_Constant > const &") -> "bool":
    return _Law.Handle_Law_Constant_IsNull(t)

def Handle_Law_Linear_Create() -> "opencascade::handle< Law_Linear >":
    return _Law.Handle_Law_Linear_Create()

def Handle_Law_Linear_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Law_Linear >":
    return _Law.Handle_Law_Linear_DownCast(t)

def Handle_Law_Linear_IsNull(t: "opencascade::handle< Law_Linear > const &") -> "bool":
    return _Law.Handle_Law_Linear_IsNull(t)

def Handle_Law_Interpol_Create() -> "opencascade::handle< Law_Interpol >":
    return _Law.Handle_Law_Interpol_Create()

def Handle_Law_Interpol_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Law_Interpol >":
    return _Law.Handle_Law_Interpol_DownCast(t)

def Handle_Law_Interpol_IsNull(t: "opencascade::handle< Law_Interpol > const &") -> "bool":
    return _Law.Handle_Law_Interpol_IsNull(t)

def Handle_Law_S_Create() -> "opencascade::handle< Law_S >":
    return _Law.Handle_Law_S_Create()

def Handle_Law_S_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Law_S >":
    return _Law.Handle_Law_S_DownCast(t)

def Handle_Law_S_IsNull(t: "opencascade::handle< Law_S > const &") -> "bool":
    return _Law.Handle_Law_S_IsNull(t)
class Law_Laws(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self) -> "NCollection_List< opencascade::handle< Law_Function > >::iterator":
        return _Law.Law_Laws_begin(self)

    def end(self) -> "NCollection_List< opencascade::handle< Law_Function > >::iterator":
        return _Law.Law_Laws_end(self)

    def cbegin(self) -> "NCollection_List< opencascade::handle< Law_Function > >::const_iterator":
        return _Law.Law_Laws_cbegin(self)

    def cend(self) -> "NCollection_List< opencascade::handle< Law_Function > >::const_iterator":
        return _Law.Law_Laws_cend(self)

    def __init__(self, *args):
        _Law.Law_Laws_swiginit(self, _Law.new_Law_Laws(*args))

    def Size(self) -> "Standard_Integer":
        return _Law.Law_Laws_Size(self)

    def Assign(self, theOther: "Law_Laws") -> "NCollection_List< opencascade::handle< Law_Function > > &":
        return _Law.Law_Laws_Assign(self, theOther)

    def Set(self, theOther: "Law_Laws") -> "NCollection_List< opencascade::handle< Law_Function > > &":
        return _Law.Law_Laws_Set(self, theOther)

    def Clear(self, theAllocator: "opencascade::handle< NCollection_BaseAllocator > const &"=0) -> "void":
        return _Law.Law_Laws_Clear(self, theAllocator)

    def First(self) -> "opencascade::handle< Law_Function > const &":
        return _Law.Law_Laws_First(self)

    def Last(self) -> "opencascade::handle< Law_Function > const &":
        return _Law.Law_Laws_Last(self)

    def Append(self, *args) -> "void":
        return _Law.Law_Laws_Append(self, *args)

    def Prepend(self, *args) -> "void":
        return _Law.Law_Laws_Prepend(self, *args)

    def RemoveFirst(self) -> "void":
        return _Law.Law_Laws_RemoveFirst(self)

    def Remove(self, theIter: "Law_ListIteratorOfLaws") -> "void":
        return _Law.Law_Laws_Remove(self, theIter)

    def InsertBefore(self, *args) -> "void":
        return _Law.Law_Laws_InsertBefore(self, *args)

    def InsertAfter(self, *args) -> "void":
        return _Law.Law_Laws_InsertAfter(self, *args)

    def Reverse(self) -> "void":
        return _Law.Law_Laws_Reverse(self)
    __swig_destroy__ = _Law.delete_Law_Laws

    def __len__(self):
        return self.Size()


# Register Law_Laws in _Law:
_Law.Law_Laws_swigregister(Law_Laws)

class Law_ListIteratorOfLaws(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _Law.Law_ListIteratorOfLaws_swiginit(self, _Law.new_Law_ListIteratorOfLaws(*args))

    def More(self) -> "Standard_Boolean":
        return _Law.Law_ListIteratorOfLaws_More(self)

    def Next(self) -> "void":
        return _Law.Law_ListIteratorOfLaws_Next(self)

    def Value(self) -> "opencascade::handle< Law_Function > const &":
        return _Law.Law_ListIteratorOfLaws_Value(self)

    def ChangeValue(self) -> "opencascade::handle< Law_Function > &":
        return _Law.Law_ListIteratorOfLaws_ChangeValue(self)
    __swig_destroy__ = _Law.delete_Law_ListIteratorOfLaws

# Register Law_ListIteratorOfLaws in _Law:
_Law.Law_ListIteratorOfLaws_swigregister(Law_ListIteratorOfLaws)

class law(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def MixBnd(*args) -> "opencascade::handle< TColStd_HArray1OfReal >":
        r"""
        This algorithm searches the knot values corresponding to the splitting of a given b-spline law into several arcs with the same continuity. the continuity order is given at the construction time. builds a 1d bspline that is near from lin with null derivatives at the extremities.

        Parameters
        ----------
        Lin: Law_Linear

        Returns
        -------
        opencascade::handle<Law_BSpFunc>
        Builds the poles of the 1d bspline that is near from lin with null derivatives at the extremities.

        Parameters
        ----------
        Degree: int
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        Lin: Law_Linear

        Returns
        -------
        opencascade::handle<TColStd_HArray1OfReal>

        """
        return _Law.law_MixBnd(*args)

    @staticmethod
    def MixTgt(*args) -> "opencascade::handle< TColStd_HArray1OfReal >":
        r"""
        Builds the poles of the 1d bspline that is null on the rigth side of knots(index) (on the left if nulontheright is false) and that is like a t*(1-t)(1-t) curve on the left side of knots(index) (on the rigth if nulontheright is false). the result curve is c1 with a derivative equal to 1. at first parameter (-1 at last parameter if nulontheright is false). warning: mults(index) must greater or equal to degree-1.

        Parameters
        ----------
        Degree: int
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        NulOnTheRight: bool
        Index: int

        Returns
        -------
        opencascade::handle<TColStd_HArray1OfReal>

        """
        return _Law.law_MixTgt(*args)

    @staticmethod
    def Reparametrize(*args) -> "opencascade::handle< Law_BSpline >":
        r"""
        Computes a 1 d curve to reparametrize a curve. its an interpolation of nbpoints points calculated at quasi constant abscissa.

        Parameters
        ----------
        Curve: Adaptor3d_Curve
        First: float
        Last: float
        HasDF: bool
        HasDL: bool
        DFirst: float
        DLast: float
        Rev: bool
        NbPoints: int

        Returns
        -------
        opencascade::handle<Law_BSpline>

        """
        return _Law.law_Reparametrize(*args)

    @staticmethod
    def Scale(*args) -> "opencascade::handle< Law_BSpline >":
        r"""
        Computes a 1 d curve to scale a field of tangency. value is 1. for t = (first+last)/2 . if hasfirst value for t = first is vfirst (null derivative). if haslast value for t = last is vlast (null derivative). //! 1.  _ _/ \_ __/ \__ / vfirst ____/  vlast \____ first  last.

        Parameters
        ----------
        First: float
        Last: float
        HasF: bool
        HasL: bool
        VFirst: float
        VLast: float

        Returns
        -------
        opencascade::handle<Law_BSpline>

        """
        return _Law.law_Scale(*args)

    @staticmethod
    def ScaleCub(*args) -> "opencascade::handle< Law_BSpline >":
        r"""
        No available documentation.

        Parameters
        ----------
        First: float
        Last: float
        HasF: bool
        HasL: bool
        VFirst: float
        VLast: float

        Returns
        -------
        opencascade::handle<Law_BSpline>

        """
        return _Law.law_ScaleCub(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _Law.law_swiginit(self, _Law.new_law())
    __swig_destroy__ = _Law.delete_law

# Register law in _Law:
_Law.law_swigregister(law)

def law_MixBnd(*args) -> "opencascade::handle< TColStd_HArray1OfReal >":
    r"""
    This algorithm searches the knot values corresponding to the splitting of a given b-spline law into several arcs with the same continuity. the continuity order is given at the construction time. builds a 1d bspline that is near from lin with null derivatives at the extremities.

    Parameters
    ----------
    Lin: Law_Linear

    Returns
    -------
    opencascade::handle<Law_BSpFunc>
    Builds the poles of the 1d bspline that is near from lin with null derivatives at the extremities.

    Parameters
    ----------
    Degree: int
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    Lin: Law_Linear

    Returns
    -------
    opencascade::handle<TColStd_HArray1OfReal>

    """
    return _Law.law_MixBnd(*args)

def law_MixTgt(*args) -> "opencascade::handle< TColStd_HArray1OfReal >":
    r"""
    Builds the poles of the 1d bspline that is null on the rigth side of knots(index) (on the left if nulontheright is false) and that is like a t*(1-t)(1-t) curve on the left side of knots(index) (on the rigth if nulontheright is false). the result curve is c1 with a derivative equal to 1. at first parameter (-1 at last parameter if nulontheright is false). warning: mults(index) must greater or equal to degree-1.

    Parameters
    ----------
    Degree: int
    Knots: TColStd_Array1OfReal
    Mults: TColStd_Array1OfInteger
    NulOnTheRight: bool
    Index: int

    Returns
    -------
    opencascade::handle<TColStd_HArray1OfReal>

    """
    return _Law.law_MixTgt(*args)

def law_Reparametrize(*args) -> "opencascade::handle< Law_BSpline >":
    r"""
    Computes a 1 d curve to reparametrize a curve. its an interpolation of nbpoints points calculated at quasi constant abscissa.

    Parameters
    ----------
    Curve: Adaptor3d_Curve
    First: float
    Last: float
    HasDF: bool
    HasDL: bool
    DFirst: float
    DLast: float
    Rev: bool
    NbPoints: int

    Returns
    -------
    opencascade::handle<Law_BSpline>

    """
    return _Law.law_Reparametrize(*args)

def law_Scale(*args) -> "opencascade::handle< Law_BSpline >":
    r"""
    Computes a 1 d curve to scale a field of tangency. value is 1. for t = (first+last)/2 . if hasfirst value for t = first is vfirst (null derivative). if haslast value for t = last is vlast (null derivative). //! 1.  _ _/ \_ __/ \__ / vfirst ____/  vlast \____ first  last.

    Parameters
    ----------
    First: float
    Last: float
    HasF: bool
    HasL: bool
    VFirst: float
    VLast: float

    Returns
    -------
    opencascade::handle<Law_BSpline>

    """
    return _Law.law_Scale(*args)

def law_ScaleCub(*args) -> "opencascade::handle< Law_BSpline >":
    r"""
    No available documentation.

    Parameters
    ----------
    First: float
    Last: float
    HasF: bool
    HasL: bool
    VFirst: float
    VLast: float

    Returns
    -------
    opencascade::handle<Law_BSpline>

    """
    return _Law.law_ScaleCub(*args)

class Law_BSpline(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a non-rational b_spline curve on the basis <knots, multiplicities> of degree <degree>.

        Parameters
        ----------
        Poles: TColStd_Array1OfReal
        Knots: TColStd_Array1OfReal
        Multiplicities: TColStd_Array1OfInteger
        Degree: int
        Periodic: bool,optional
        	default value is Standard_False

        Returns
        -------
        None
        Creates a rational b_spline curve on the basis <knots, multiplicities> of degree <degree>.

        Parameters
        ----------
        Poles: TColStd_Array1OfReal
        Weights: TColStd_Array1OfReal
        Knots: TColStd_Array1OfReal
        Multiplicities: TColStd_Array1OfInteger
        Degree: int
        Periodic: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        _Law.Law_BSpline_swiginit(self, _Law.new_Law_BSpline(*args))

    def Continuity(self, *args) -> "GeomAbs_Shape":
        r"""
        Returns the global continuity of the curve : c0 : only geometric continuity, c1 : continuity of the first derivative all along the curve, c2 : continuity of the second derivative all along the curve, c3 : continuity of the third derivative all along the curve, cn : the order of continuity is infinite. for a b-spline curve of degree d if a knot ui has a multiplicity p the b-spline curve is only cd-p continuous at ui. so the global continuity of the curve can't be greater than cd-p where p is the maximum multiplicity of the interior knots. in the interior of a knot span the curve is infinitely continuously differentiable.

        Returns
        -------
        GeomAbs_Shape

        """
        return _Law.Law_BSpline_Continuity(self, *args)

    def Copy(self, *args) -> "opencascade::handle< Law_BSpline >":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Law_BSpline>

        """
        return _Law.Law_BSpline_Copy(self, *args)

    def D0(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        U: float

        Returns
        -------
        P: float

        """
        return _Law.Law_BSpline_D0(self, *args)

    def D1(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        U: float

        Returns
        -------
        P: float
        V1: float

        """
        return _Law.Law_BSpline_D1(self, *args)

    def D2(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        U: float

        Returns
        -------
        P: float
        V1: float
        V2: float

        """
        return _Law.Law_BSpline_D2(self, *args)

    def D3(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        U: float

        Returns
        -------
        P: float
        V1: float
        V2: float
        V3: float

        """
        return _Law.Law_BSpline_D3(self, *args)

    def DN(self, *args) -> "Standard_Real":
        r"""
        The following functions computes the point of parameter u and the derivatives at this point on the b-spline curve arc defined between the knot fromk1 and the knot tok2. u can be out of bounds [knot (fromk1), knot (tok2)] but for the computation we only use the definition of the curve between these two knots. this method is useful to compute local derivative, if the order of continuity of the whole curve is not greater enough. inside the parametric domain knot (fromk1), knot (tok2) the evaluations are the same as if we consider the whole definition of the curve. of course the evaluations are different outside this parametric domain.

        Parameters
        ----------
        U: float
        N: int

        Returns
        -------
        float

        """
        return _Law.Law_BSpline_DN(self, *args)

    def Degree(self, *args) -> "Standard_Integer":
        r"""
        Computation of value and derivatives.

        Returns
        -------
        int

        """
        return _Law.Law_BSpline_Degree(self, *args)

    def EndPoint(self, *args) -> "Standard_Real":
        r"""
        Returns the last point of the curve. warnings : the last point of the curve is different from the last pole of the curve if the multiplicity of the last knot is lower than degree.

        Returns
        -------
        float

        """
        return _Law.Law_BSpline_EndPoint(self, *args)

    def FirstParameter(self, *args) -> "Standard_Real":
        r"""
        Computes the parametric value of the start point of the curve. it is a knot value.

        Returns
        -------
        float

        """
        return _Law.Law_BSpline_FirstParameter(self, *args)

    def FirstUKnotIndex(self, *args) -> "Standard_Integer":
        r"""
        For a b-spline curve the first parameter (which gives the start point of the curve) is a knot value but if the multiplicity of the first knot index is lower than degree + 1 it is not the first knot of the curve. this method computes the index of the knot corresponding to the first parameter.

        Returns
        -------
        int

        """
        return _Law.Law_BSpline_FirstUKnotIndex(self, *args)

    def IncreaseDegree(self, *args) -> "void":
        r"""
        Increase the degree to <degree>. nothing is done if <degree> is lower or equal to the current degree.

        Parameters
        ----------
        Degree: int

        Returns
        -------
        None

        """
        return _Law.Law_BSpline_IncreaseDegree(self, *args)

    def IncreaseMultiplicity(self, *args) -> "void":
        r"""
        Increases the multiplicity of the knot <index> to <m>. //! if <m> is lower or equal to the current multiplicity nothing is done. if <m> is higher than the degree the degree is used. if <index> is not in [firstuknotindex, lastuknotindex].

        Parameters
        ----------
        Index: int
        M: int

        Returns
        -------
        None
        Increases the multiplicities of the knots in [i1,i2] to <m>. //! for each knot if <m> is lower or equal to the current multiplicity nothing is done. if <m> is higher than the degree the degree is used. if <i1,i2> are not in [firstuknotindex, lastuknotindex].

        Parameters
        ----------
        I1: int
        I2: int
        M: int

        Returns
        -------
        None

        """
        return _Law.Law_BSpline_IncreaseMultiplicity(self, *args)

    def IncrementMultiplicity(self, *args) -> "void":
        r"""
        Increment the multiplicities of the knots in [i1,i2] by <m>. //! if <m> is not positive nithing is done. //! for each knot the resulting multiplicity is limited to the degree. if <i1,i2> are not in [firstuknotindex, lastuknotindex].

        Parameters
        ----------
        I1: int
        I2: int
        M: int

        Returns
        -------
        None

        """
        return _Law.Law_BSpline_IncrementMultiplicity(self, *args)

    def InsertKnot(self, *args) -> "void":
        r"""
        Inserts a knot value in the sequence of knots. if <u> is an existing knot the multiplicity is increased by <m>. //! if u is not on the parameter range nothing is done. //! if the multiplicity is negative or null nothing is done. the new multiplicity is limited to the degree. //! the tolerance criterion for knots equality is the max of epsilon(u) and parametrictolerance.

        Parameters
        ----------
        U: float
        M: int,optional
        	default value is 1
        ParametricTolerance: float,optional
        	default value is 0.0
        Add: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        return _Law.Law_BSpline_InsertKnot(self, *args)

    def InsertKnots(self, *args) -> "void":
        r"""
        Inserts a set of knots values in the sequence of knots. //! for each u = knots(i), m = mults(i) //! if <u> is an existing knot the multiplicity is increased by <m> if <add> is true, increased to <m> if <add> is false. //! if u is not on the parameter range nothing is done. //! if the multiplicity is negative or null nothing is done. the new multiplicity is limited to the degree. //! the tolerance criterion for knots equality is the max of epsilon(u) and parametrictolerance.

        Parameters
        ----------
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        ParametricTolerance: float,optional
        	default value is 0.0
        Add: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        return _Law.Law_BSpline_InsertKnots(self, *args)

    def IsCN(self, *args) -> "Standard_Boolean":
        r"""
        Returns the continuity of the curve, the curve is at least c0. raised if n < 0.

        Parameters
        ----------
        N: int

        Returns
        -------
        bool

        """
        return _Law.Law_BSpline_IsCN(self, *args)

    def IsClosed(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the distance between the first point and the last point of the curve is lower or equal to resolution from package gp. warnings : the first and the last point can be different from the first pole and the last pole of the curve.

        Returns
        -------
        bool

        """
        return _Law.Law_BSpline_IsClosed(self, *args)

    def IsPeriodic(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the curve is periodic.

        Returns
        -------
        bool

        """
        return _Law.Law_BSpline_IsPeriodic(self, *args)

    def IsRational(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the weights are not identical. the tolerance criterion is epsilon of the class real.

        Returns
        -------
        bool

        """
        return _Law.Law_BSpline_IsRational(self, *args)

    def Knot(self, *args) -> "Standard_Real":
        r"""
        Returns the knot of range index. when there is a knot with a multiplicity greater than 1 the knot is not repeated. the method multiplicity can be used to get the multiplicity of the knot. raised if index < 1 or index > nbknots.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float

        """
        return _Law.Law_BSpline_Knot(self, *args)

    def KnotDistribution(self, *args) -> "GeomAbs_BSplKnotDistribution":
        r"""
        Returns nonuniform or uniform or quasiuniform or piecewisebezier. if all the knots differ by a positive constant from the preceding knot the bspline curve can be : - uniform if all the knots are of multiplicity 1, - quasiuniform if all the knots are of multiplicity 1 except for the first and last knot which are of multiplicity degree + 1, - piecewisebezier if the first and last knots have multiplicity degree + 1 and if interior knots have multiplicity degree a piecewise bezier with only two knots is a beziercurve. else the curve is non uniform. the tolerance criterion is epsilon from class real.

        Returns
        -------
        GeomAbs_BSplKnotDistribution

        """
        return _Law.Law_BSpline_KnotDistribution(self, *args)

    def KnotSequence(self, *args) -> "void":
        r"""
        Returns the knots sequence. in this sequence the knots with a multiplicity greater than 1 are repeated. example : k = {k1, k1, k1, k2, k3, k3, k4, k4, k4} //! raised if the length of k is not equal to nbpoles + degree + 1.

        Parameters
        ----------
        K: TColStd_Array1OfReal

        Returns
        -------
        None

        """
        return _Law.Law_BSpline_KnotSequence(self, *args)

    def Knots(self, *args) -> "void":
        r"""
        Returns the knot values of the b-spline curve; //! raised if the length of k is not equal to the number of knots.

        Parameters
        ----------
        K: TColStd_Array1OfReal

        Returns
        -------
        None

        """
        return _Law.Law_BSpline_Knots(self, *args)

    def LastParameter(self, *args) -> "Standard_Real":
        r"""
        Computes the parametric value of the end point of the curve. it is a knot value.

        Returns
        -------
        float

        """
        return _Law.Law_BSpline_LastParameter(self, *args)

    def LastUKnotIndex(self, *args) -> "Standard_Integer":
        r"""
        For a bspline curve the last parameter (which gives the end point of the curve) is a knot value but if the multiplicity of the last knot index is lower than degree + 1 it is not the last knot of the curve. this method computes the index of the knot corresponding to the last parameter.

        Returns
        -------
        int

        """
        return _Law.Law_BSpline_LastUKnotIndex(self, *args)

    def LocalD0(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        U: float
        FromK1: int
        ToK2: int

        Returns
        -------
        P: float

        """
        return _Law.Law_BSpline_LocalD0(self, *args)

    def LocalD1(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        U: float
        FromK1: int
        ToK2: int

        Returns
        -------
        P: float
        V1: float

        """
        return _Law.Law_BSpline_LocalD1(self, *args)

    def LocalD2(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        U: float
        FromK1: int
        ToK2: int

        Returns
        -------
        P: float
        V1: float
        V2: float

        """
        return _Law.Law_BSpline_LocalD2(self, *args)

    def LocalD3(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        U: float
        FromK1: int
        ToK2: int

        Returns
        -------
        P: float
        V1: float
        V2: float
        V3: float

        """
        return _Law.Law_BSpline_LocalD3(self, *args)

    def LocalDN(self, *args) -> "Standard_Real":
        r"""
        No available documentation.

        Parameters
        ----------
        U: float
        FromK1: int
        ToK2: int
        N: int

        Returns
        -------
        float

        """
        return _Law.Law_BSpline_LocalDN(self, *args)

    def LocalValue(self, *args) -> "Standard_Real":
        r"""
        No available documentation.

        Parameters
        ----------
        U: float
        FromK1: int
        ToK2: int

        Returns
        -------
        float

        """
        return _Law.Law_BSpline_LocalValue(self, *args)

    def LocateU(self, *args) -> "void":
        r"""
        Locates the parametric value u in the sequence of knots. if 'withknotrepetition' is true we consider the knot's representation with repetition of multiple knot value, otherwise we consider the knot's representation with no repetition of multiple knot values. knots (i1) <= u <= knots (i2) . if i1 = i2 u is a knot value (the tolerance criterion parametrictolerance is used). . if i1 < 1 => u < knots (1) - abs(parametrictolerance) . if i2 > nbknots => u > knots (nbknots) + abs(parametrictolerance).

        Parameters
        ----------
        U: float
        ParametricTolerance: float
        WithKnotRepetition: bool,optional
        	default value is Standard_False

        Returns
        -------
        I1: int
        I2: int

        """
        return _Law.Law_BSpline_LocateU(self, *args)

    @staticmethod
    def MaxDegree(*args) -> "Standard_Integer":
        r"""
        Returns the value of the maximum degree of the normalized b-spline basis functions in this package.

        Returns
        -------
        int

        """
        return _Law.Law_BSpline_MaxDegree(*args)

    def MovePointAndTangent(self, *args) -> "void":
        r"""
        Changes the value of the law at parameter u to newvalue. and makes its derivative at u be derivative. startingcondition = -1 means first can move endingcondition = -1 means last point can move startingcondition = 0 means the first point cannot move endingcondition = 0 means the last point cannot move startingcondition = 1 means the first point and tangent cannot move endingcondition = 1 means the last point and tangent cannot move and so forth errorstatus != 0 means that there are not enought degree of freedom with the constrain to deform the curve accordingly.

        Parameters
        ----------
        U: float
        NewValue: float
        Derivative: float
        Tolerance: float
        StartingCondition: int
        EndingCondition: int

        Returns
        -------
        ErrorStatus: int

        """
        return _Law.Law_BSpline_MovePointAndTangent(self, *args)

    def Multiplicities(self, *args) -> "void":
        r"""
        Returns the multiplicity of the knots of the curve. //! raised if the length of m is not equal to nbknots.

        Parameters
        ----------
        M: TColStd_Array1OfInteger

        Returns
        -------
        None

        """
        return _Law.Law_BSpline_Multiplicities(self, *args)

    def Multiplicity(self, *args) -> "Standard_Integer":
        r"""
        Returns the multiplicity of the knots of range index. raised if index < 1 or index > nbknots.

        Parameters
        ----------
        Index: int

        Returns
        -------
        int

        """
        return _Law.Law_BSpline_Multiplicity(self, *args)

    def NbKnots(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of knots. this method returns the number of knot without repetition of multiple knots.

        Returns
        -------
        int

        """
        return _Law.Law_BSpline_NbKnots(self, *args)

    def NbPoles(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of poles.

        Returns
        -------
        int

        """
        return _Law.Law_BSpline_NbPoles(self, *args)

    def PeriodicNormalization(self, *args) -> "void":
        r"""
        Returns the parameter normalized within the period if the curve is periodic : otherwise does not do anything.

        Parameters
        ----------

        Returns
        -------
        U: float

        """
        return _Law.Law_BSpline_PeriodicNormalization(self, *args)

    def Pole(self, *args) -> "Standard_Real":
        r"""
        Returns the pole of range index. raised if index < 1 or index > nbpoles.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float

        """
        return _Law.Law_BSpline_Pole(self, *args)

    def Poles(self, *args) -> "void":
        r"""
        Returns the poles of the b-spline curve; //! raised if the length of p is not equal to the number of poles.

        Parameters
        ----------
        P: TColStd_Array1OfReal

        Returns
        -------
        None

        """
        return _Law.Law_BSpline_Poles(self, *args)

    def RemoveKnot(self, *args) -> "Standard_Boolean":
        r"""
        Decrement the knots multiplicity to <m>. if m is 0 the knot is removed. the poles sequence is modified. //! as there are two ways to compute the new poles the average is computed if the distance is lower than the <tolerance>, else false is returned. //! a low tolerance is used to prevent the modification of the curve. //! a high tolerance is used to 'smooth' the curve. //! raised if index is not in the range [firstuknotindex, lastuknotindex] pole insertion and pole removing this operation is limited to the uniform or quasiuniform bsplinecurve. the knot values are modified . if the bspline is nonuniform or piecewise bezier an exception construction error is raised.

        Parameters
        ----------
        Index: int
        M: int
        Tolerance: float

        Returns
        -------
        bool

        """
        return _Law.Law_BSpline_RemoveKnot(self, *args)

    def Resolution(self, *args) -> "void":
        r"""
        Given tolerance3d returns utolerance such that if f(t) is the curve we have | t1 - t0| < utolerance ===> |f(t1) - f(t0)| < tolerance3d.

        Parameters
        ----------
        Tolerance3D: float

        Returns
        -------
        UTolerance: float

        """
        return _Law.Law_BSpline_Resolution(self, *args)

    def Reverse(self, *args) -> "void":
        r"""
        Changes the direction of parametrization of <self>. the knot sequence is modified, the firstparameter and the lastparameter are not modified. the startpoint of the initial curve becomes the endpoint of the reversed curve and the endpoint of the initial curve becomes the startpoint of the reversed curve.

        Returns
        -------
        None

        """
        return _Law.Law_BSpline_Reverse(self, *args)

    def ReversedParameter(self, *args) -> "Standard_Real":
        r"""
        Returns the parameter on the reversed curve for the point of parameter u on <self>. //! returns ufirst + ulast - u.

        Parameters
        ----------
        U: float

        Returns
        -------
        float

        """
        return _Law.Law_BSpline_ReversedParameter(self, *args)

    def Segment(self, *args) -> "void":
        r"""
        Segments the curve between u1 and u2. the control points are modified, the first and the last point are not the same. warnings : even if <self> is not closed it can become closed after the segmentation for example if u1 or u2 are out of the bounds of the curve <self> or if the curve makes loop. after the segmentation the length of a curve can be null. raises if u2 < u1.

        Parameters
        ----------
        U1: float
        U2: float

        Returns
        -------
        None

        """
        return _Law.Law_BSpline_Segment(self, *args)

    def SetKnot(self, *args) -> "void":
        r"""
        Changes the knot of range index. the multiplicity of the knot is not modified. raised if k >= knots(index+1) or k <= knots(index-1). raised if index < 1 || index > nbknots.

        Parameters
        ----------
        Index: int
        K: float

        Returns
        -------
        None
        Changes the knot of range index with its multiplicity. you can increase the multiplicity of a knot but it is not allowed to decrease the multiplicity of an existing knot. //! raised if k >= knots(index+1) or k <= knots(index-1). raised if m is greater than degree or lower than the previous multiplicity of knot of range index. raised if index < 1 || index > nbknots.

        Parameters
        ----------
        Index: int
        K: float
        M: int

        Returns
        -------
        None

        """
        return _Law.Law_BSpline_SetKnot(self, *args)

    def SetKnots(self, *args) -> "void":
        r"""
        Changes all the knots of the curve the multiplicity of the knots are not modified. //! raised if there is an index such that k (index+1) <= k (index). //! raised if k.lower() < 1 or k.upper() > nbknots.

        Parameters
        ----------
        K: TColStd_Array1OfReal

        Returns
        -------
        None

        """
        return _Law.Law_BSpline_SetKnots(self, *args)

    def SetNotPeriodic(self, *args) -> "void":
        r"""
        Makes a non periodic curve. if the curve was non periodic the curve is not modified.

        Returns
        -------
        None

        """
        return _Law.Law_BSpline_SetNotPeriodic(self, *args)

    def SetOrigin(self, *args) -> "void":
        r"""
        Set the origin of a periodic curve at knot(index) knotvector and poles are modified. raised if the curve is not periodic raised if index not in the range [firstuknotindex , lastuknotindex].

        Parameters
        ----------
        Index: int

        Returns
        -------
        None

        """
        return _Law.Law_BSpline_SetOrigin(self, *args)

    def SetPeriodic(self, *args) -> "void":
        r"""
        Makes a closed b-spline into a periodic curve. the curve is periodic if the knot sequence is periodic and if the curve is closed (the tolerance criterion is resolution from gp). the period t is equal to knot(lastuknotindex) - knot(firstuknotindex). a periodic b-spline can be uniform or not. raised if the curve is not closed.

        Returns
        -------
        None

        """
        return _Law.Law_BSpline_SetPeriodic(self, *args)

    def SetPole(self, *args) -> "void":
        r"""
        Substitutes the pole of range index with p. //! raised if index < 1 || index > nbpoles.

        Parameters
        ----------
        Index: int
        P: float

        Returns
        -------
        None
        Substitutes the pole and the weight of range index. if the curve <self> is not rational it can become rational if the curve was rational it can become non rational //! raised if index < 1 || index > nbpoles raised if weight <= 0.0.

        Parameters
        ----------
        Index: int
        P: float
        Weight: float

        Returns
        -------
        None

        """
        return _Law.Law_BSpline_SetPole(self, *args)

    def SetWeight(self, *args) -> "void":
        r"""
        Changes the weight for the pole of range index. if the curve was non rational it can become rational. if the curve was rational it can become non rational. //! raised if index < 1 || index > nbpoles raised if weight <= 0.0.

        Parameters
        ----------
        Index: int
        Weight: float

        Returns
        -------
        None

        """
        return _Law.Law_BSpline_SetWeight(self, *args)

    def StartPoint(self, *args) -> "Standard_Real":
        r"""
        Returns the start point of the curve. warnings : this point is different from the first pole of the curve if the multiplicity of the first knot is lower than degree.

        Returns
        -------
        float

        """
        return _Law.Law_BSpline_StartPoint(self, *args)

    def Value(self, *args) -> "Standard_Real":
        r"""
        No available documentation.

        Parameters
        ----------
        U: float

        Returns
        -------
        float

        """
        return _Law.Law_BSpline_Value(self, *args)

    def Weight(self, *args) -> "Standard_Real":
        r"""
        Returns the weight of the pole of range index . raised if index < 1 or index > nbpoles.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float

        """
        return _Law.Law_BSpline_Weight(self, *args)

    def Weights(self, *args) -> "void":
        r"""
        Returns the weights of the b-spline curve; //! raised if the length of w is not equal to nbpoles.

        Parameters
        ----------
        W: TColStd_Array1OfReal

        Returns
        -------
        None

        """
        return _Law.Law_BSpline_Weights(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Law_BSpline_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Law.delete_Law_BSpline

# Register Law_BSpline in _Law:
_Law.Law_BSpline_swigregister(Law_BSpline)

def Law_BSpline_MaxDegree(*args) -> "Standard_Integer":
    r"""
    Returns the value of the maximum degree of the normalized b-spline basis functions in this package.

    Returns
    -------
    int

    """
    return _Law.Law_BSpline_MaxDegree(*args)

class Law_BSplineKnotSplitting(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Locates the knot values which correspond to the segmentation of the curve into arcs with a continuity equal to continuityrange. //! raised if continuityrange is not greater or equal zero.

        Parameters
        ----------
        BasisLaw: Law_BSpline
        ContinuityRange: int

        Returns
        -------
        None

        """
        _Law.Law_BSplineKnotSplitting_swiginit(self, _Law.new_Law_BSplineKnotSplitting(*args))

    def NbSplits(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of knots corresponding to the splitting.

        Returns
        -------
        int

        """
        return _Law.Law_BSplineKnotSplitting_NbSplits(self, *args)

    def SplitValue(self, *args) -> "Standard_Integer":
        r"""
        Returns the index of the knot corresponding to the splitting of range index. //! raised if index < 1 or index > nbsplits.

        Parameters
        ----------
        Index: int

        Returns
        -------
        int

        """
        return _Law.Law_BSplineKnotSplitting_SplitValue(self, *args)

    def Splitting(self, *args) -> "void":
        r"""
        Returns the indexes of the bspline curve knots corresponding to the splitting. //! raised if the length of splitvalues is not equal to nbsplit.

        Parameters
        ----------
        SplitValues: TColStd_Array1OfInteger

        Returns
        -------
        None

        """
        return _Law.Law_BSplineKnotSplitting_Splitting(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Law.delete_Law_BSplineKnotSplitting

# Register Law_BSplineKnotSplitting in _Law:
_Law.Law_BSplineKnotSplitting_swigregister(Law_BSplineKnotSplitting)

class Law_Function(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Bounds(self, *args) -> "void":
        r"""
        Returns the parametric bounds of the function.

        Parameters
        ----------

        Returns
        -------
        PFirst: float
        PLast: float

        """
        return _Law.Law_Function_Bounds(self, *args)

    def Continuity(self, *args) -> "GeomAbs_Shape":
        r"""
        No available documentation.

        Returns
        -------
        GeomAbs_Shape

        """
        return _Law.Law_Function_Continuity(self, *args)

    def D1(self, *args) -> "void":
        r"""
        Returns the value f and the first derivative d of the function at the point of parameter x.

        Parameters
        ----------
        X: float

        Returns
        -------
        F: float
        D: float

        """
        return _Law.Law_Function_D1(self, *args)

    def D2(self, *args) -> "void":
        r"""
        Returns the value, first and seconde derivatives at parameter x.

        Parameters
        ----------
        X: float

        Returns
        -------
        F: float
        D: float
        D2: float

        """
        return _Law.Law_Function_D2(self, *args)

    def Intervals(self, *args) -> "void":
        r"""
        Stores in <t> the parameters bounding the intervals of continuity <s>. //! the array must provide enough room to accomodate for the parameters. i.e. t.length() > nbintervals().

        Parameters
        ----------
        T: TColStd_Array1OfReal
        S: GeomAbs_Shape

        Returns
        -------
        None

        """
        return _Law.Law_Function_Intervals(self, *args)

    def NbIntervals(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of intervals for continuity <s>. may be one if continuity(me) >= <s>.

        Parameters
        ----------
        S: GeomAbs_Shape

        Returns
        -------
        int

        """
        return _Law.Law_Function_NbIntervals(self, *args)

    def Trim(self, *args) -> "opencascade::handle< Law_Function >":
        r"""
        Returns a law equivalent of <self> between parameters <first> and <last>. <tol> is used to test for 3d points confusion. it is usfule to determines the derivatives in these values <first> and <last> if the law is not cn.

        Parameters
        ----------
        PFirst: float
        PLast: float
        Tol: float

        Returns
        -------
        opencascade::handle<Law_Function>

        """
        return _Law.Law_Function_Trim(self, *args)

    def Value(self, *args) -> "Standard_Real":
        r"""
        Returns the value of the function at the point of parameter x.

        Parameters
        ----------
        X: float

        Returns
        -------
        float

        """
        return _Law.Law_Function_Value(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Law_Function_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Law.delete_Law_Function

# Register Law_Function in _Law:
_Law.Law_Function_swigregister(Law_Function)

class Law_Interpolate(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Tolerance is to check if the points are not too close to one an other. it is also used to check if the tangent vector is not too small. there should be at least 2 points. if periodicflag is true then the curve will be periodic be periodic.

        Parameters
        ----------
        Points: TColStd_HArray1OfReal
        PeriodicFlag: bool
        Tolerance: float

        Returns
        -------
        None
        Tolerance is to check if the points are not too close to one an other. it is also used to check if the tangent vector is not too small. there should be at least 2 points. if periodicflag is true then the curve will be periodic be periodic.

        Parameters
        ----------
        Points: TColStd_HArray1OfReal
        Parameters: TColStd_HArray1OfReal
        PeriodicFlag: bool
        Tolerance: float

        Returns
        -------
        None

        """
        _Law.Law_Interpolate_swiginit(self, _Law.new_Law_Interpolate(*args))

    def Curve(self, *args) -> "opencascade::handle< Law_BSpline > const &":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Law_BSpline>

        """
        return _Law.Law_Interpolate_Curve(self, *args)

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _Law.Law_Interpolate_IsDone(self, *args)

    def Load(self, *args) -> "void":
        r"""
        Loads initial and final tangents if any.

        Parameters
        ----------
        InitialTangent: float
        FinalTangent: float

        Returns
        -------
        None
        Loads the tangents. we should have as many tangents as they are points in the array if tangentflags.value(i) is standard_true use the tangent tangents.value(i) otherwise the tangent is not constrained.

        Parameters
        ----------
        Tangents: TColStd_Array1OfReal
        TangentFlags: TColStd_HArray1OfBoolean

        Returns
        -------
        None

        """
        return _Law.Law_Interpolate_Load(self, *args)

    def Perform(self, *args) -> "void":
        r"""
        Makes the interpolation.

        Returns
        -------
        None

        """
        return _Law.Law_Interpolate_Perform(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def ClearTangents(self):
    	pass

    __swig_destroy__ = _Law.delete_Law_Interpolate

# Register Law_Interpolate in _Law:
_Law.Law_Interpolate_swigregister(Law_Interpolate)

class Law_BSpFunc(Law_Function):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        C: Law_BSpline
        First: float
        Last: float

        Returns
        -------
        None

        """
        _Law.Law_BSpFunc_swiginit(self, _Law.new_Law_BSpFunc(*args))

    def Curve(self, *args) -> "opencascade::handle< Law_BSpline >":
        r"""
        No available documentation.

        Returns
        -------
        opencascade::handle<Law_BSpline>

        """
        return _Law.Law_BSpFunc_Curve(self, *args)

    def SetCurve(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        C: Law_BSpline

        Returns
        -------
        None

        """
        return _Law.Law_BSpFunc_SetCurve(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Law_BSpFunc_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Law.delete_Law_BSpFunc

# Register Law_BSpFunc in _Law:
_Law.Law_BSpFunc_swigregister(Law_BSpFunc)

class Law_Composite(Law_Function):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Construct an empty law.

        Returns
        -------
        None
        Construct an empty, trimed law.

        Parameters
        ----------
        First: float
        Last: float
        Tol: float

        Returns
        -------
        None

        """
        _Law.Law_Composite_swiginit(self, _Law.new_Law_Composite(*args))

    def ChangeElementaryLaw(self, *args) -> "opencascade::handle< Law_Function > &":
        r"""
        Returns the elementary function of the composite used to compute at parameter w.

        Parameters
        ----------
        W: float

        Returns
        -------
        opencascade::handle<Law_Function>

        """
        return _Law.Law_Composite_ChangeElementaryLaw(self, *args)

    def ChangeLaws(self, *args) -> "Law_Laws &":
        r"""
        No available documentation.

        Returns
        -------
        Law_Laws

        """
        return _Law.Law_Composite_ChangeLaws(self, *args)

    def IsPeriodic(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _Law.Law_Composite_IsPeriodic(self, *args)

    def SetPeriodic(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _Law.Law_Composite_SetPeriodic(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Law_Composite_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Law.delete_Law_Composite

# Register Law_Composite in _Law:
_Law.Law_Composite_swigregister(Law_Composite)

class Law_Constant(Law_Function):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        _Law.Law_Constant_swiginit(self, _Law.new_Law_Constant(*args))

    def Set(self, *args) -> "void":
        r"""
        Set the radius and the range of the constant law.

        Parameters
        ----------
        Radius: float
        PFirst: float
        PLast: float

        Returns
        -------
        None

        """
        return _Law.Law_Constant_Set(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Law_Constant_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Law.delete_Law_Constant

# Register Law_Constant in _Law:
_Law.Law_Constant_swigregister(Law_Constant)

class Law_Linear(Law_Function):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs an empty linear evolution law.

        Returns
        -------
        None

        """
        _Law.Law_Linear_swiginit(self, _Law.new_Law_Linear(*args))

    def Set(self, *args) -> "void":
        r"""
        Defines this linear evolution law by assigning both: - the bounds pdeb and pfin of the parameter, and - the values valdeb and valfin of the function at these two parametric bounds.

        Parameters
        ----------
        Pdeb: float
        Valdeb: float
        Pfin: float
        Valfin: float

        Returns
        -------
        None

        """
        return _Law.Law_Linear_Set(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Law_Linear_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Law.delete_Law_Linear

# Register Law_Linear in _Law:
_Law.Law_Linear_swigregister(Law_Linear)

class Law_Interpol(Law_BSpFunc):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs an empty interpolative evolution law. the function set is used to define the law.

        Returns
        -------
        None

        """
        _Law.Law_Interpol_swiginit(self, _Law.new_Law_Interpol(*args))

    def Set(self, *args) -> "void":
        r"""
        Defines this evolution law by interpolating the set of 2d points parandrad. the y coordinate of a point of parandrad is the value of the function at the parameter point given by its x coordinate. if periodic is true, this function is assumed to be periodic. warning - the x coordinates of points in the table parandrad must be given in ascendant order. - if periodic is true, the first and last y coordinates of points in the table parandrad are assumed to be equal. in addition, with the second syntax, dd and df are also assumed to be equal. if this is not the case, set uses the first value(s) as last value(s).

        Parameters
        ----------
        ParAndRad: TColgp_Array1OfPnt2d
        Periodic: bool,optional
        	default value is Standard_False

        Returns
        -------
        None
        Defines this evolution law by interpolating the set of 2d points parandrad. the y coordinate of a point of parandrad is the value of the function at the parameter point given by its x coordinate. if periodic is true, this function is assumed to be periodic. in the second syntax, dd and df define the values of the first derivative of the function at its first and last points. warning - the x coordinates of points in the table parandrad must be given in ascendant order. - if periodic is true, the first and last y coordinates of points in the table parandrad are assumed to be equal. in addition, with the second syntax, dd and df are also assumed to be equal. if this is not the case, set uses the first value(s) as last value(s).

        Parameters
        ----------
        ParAndRad: TColgp_Array1OfPnt2d
        Dd: float
        Df: float
        Periodic: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        return _Law.Law_Interpol_Set(self, *args)

    def SetInRelative(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        ParAndRad: TColgp_Array1OfPnt2d
        Ud: float
        Uf: float
        Periodic: bool,optional
        	default value is Standard_False

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        ParAndRad: TColgp_Array1OfPnt2d
        Ud: float
        Uf: float
        Dd: float
        Df: float
        Periodic: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        return _Law.Law_Interpol_SetInRelative(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Law_Interpol_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Law.delete_Law_Interpol

# Register Law_Interpol in _Law:
_Law.Law_Interpol_swigregister(Law_Interpol)

class Law_S(Law_BSpFunc):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs an empty 's' evolution law.

        Returns
        -------
        None

        """
        _Law.Law_S_swiginit(self, _Law.new_Law_S(*args))

    def Set(self, *args) -> "void":
        r"""
        Defines this s evolution law by assigning both: - the bounds pdeb and pfin of the parameter, and - the values valdeb and valfin of the function at these two parametric bounds. the function is assumed to have the first derivatives equal to 0 at the two parameter points pdeb and pfin.

        Parameters
        ----------
        Pdeb: float
        Valdeb: float
        Pfin: float
        Valfin: float

        Returns
        -------
        None
        Defines this s evolution law by assigning - the bounds pdeb and pfin of the parameter, - the values valdeb and valfin of the function at these two parametric bounds, and - the values ddeb and dfin of the first derivative of the function at these two parametric bounds.

        Parameters
        ----------
        Pdeb: float
        Valdeb: float
        Ddeb: float
        Pfin: float
        Valfin: float
        Dfin: float

        Returns
        -------
        None

        """
        return _Law.Law_S_Set(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Law_S_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Law.delete_Law_S

# Register Law_S in _Law:
_Law.Law_S_swigregister(Law_S)





