from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TopoDS import *
from OCC.Core.HLRAlgo import *
from OCC.Core.TopAbs import *
from OCC.Core.BRepAdaptor import *
from OCC.Core.Geom import *
from OCC.Core.gp import *
from OCC.Core.GeomAbs import *
from OCC.Core.TColStd import *
from OCC.Core.TColgp import *
from OCC.Core.IntRes2d import *
from OCC.Core.Geom2d import *
from OCC.Core.TopTools import *
from OCC.Core.BRepTopAdaptor import *
from OCC.Core.IntCurveSurface import *
from OCC.Core.Bnd import *
from OCC.Core.HLRTopoBRep import *
from OCC.Core.math import *
from OCC.Core.IntCurve import *
from OCC.Core.Extrema import *
from OCC.Core.Adaptor3d import *
from OCC.Core.Intf import *
from OCC.Core.IntSurf import *


class HLRBRep_Array1OfEData:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> HLRBRep_EdgeData: ...
    def __setitem__(self, index: int, value: HLRBRep_EdgeData) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[HLRBRep_EdgeData]: ...
    def next(self) -> HLRBRep_EdgeData: ...
    __next__ = next
    def Init(self, theValue: HLRBRep_EdgeData) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> HLRBRep_EdgeData: ...
    def Last(self) -> HLRBRep_EdgeData: ...
    def Value(self, theIndex: int) -> HLRBRep_EdgeData: ...
    def SetValue(self, theIndex: int, theValue: HLRBRep_EdgeData) -> None: ...

class HLRBRep_Array1OfFData:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> HLRBRep_FaceData: ...
    def __setitem__(self, index: int, value: HLRBRep_FaceData) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[HLRBRep_FaceData]: ...
    def next(self) -> HLRBRep_FaceData: ...
    __next__ = next
    def Init(self, theValue: HLRBRep_FaceData) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> HLRBRep_FaceData: ...
    def Last(self) -> HLRBRep_FaceData: ...
    def Value(self, theIndex: int) -> HLRBRep_FaceData: ...
    def SetValue(self, theIndex: int, theValue: HLRBRep_FaceData) -> None: ...

class HLRBRep_ListOfBPnt2D:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> HLRBRep_BiPnt2D: ...
    def Last(self) -> HLRBRep_BiPnt2D: ...
    def Append(self, theItem: HLRBRep_BiPnt2D) -> HLRBRep_BiPnt2D: ...
    def Prepend(self, theItem: HLRBRep_BiPnt2D) -> HLRBRep_BiPnt2D: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> HLRBRep_BiPnt2D: ...
    def SetValue(self, theIndex: int, theValue: HLRBRep_BiPnt2D) -> None: ...

class HLRBRep_ListOfBPoint:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> HLRBRep_BiPoint: ...
    def Last(self) -> HLRBRep_BiPoint: ...
    def Append(self, theItem: HLRBRep_BiPoint) -> HLRBRep_BiPoint: ...
    def Prepend(self, theItem: HLRBRep_BiPoint) -> HLRBRep_BiPoint: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> HLRBRep_BiPoint: ...
    def SetValue(self, theIndex: int, theValue: HLRBRep_BiPoint) -> None: ...

class HLRBRep_SeqOfShapeBounds:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> HLRBRep_ShapeBounds: ...
    def Last(self) -> HLRBRep_ShapeBounds: ...
    def Length(self) -> int: ...
    def Append(self, theItem: HLRBRep_ShapeBounds) -> HLRBRep_ShapeBounds: ...
    def Prepend(self, theItem: HLRBRep_ShapeBounds) -> HLRBRep_ShapeBounds: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> HLRBRep_ShapeBounds: ...
    def SetValue(self, theIndex: int, theValue: HLRBRep_ShapeBounds) -> None: ...

class HLRBRep_TypeOfResultingEdge(IntEnum):
	HLRBRep_Undefined: int = ...
	HLRBRep_IsoLine: int = ...
	HLRBRep_OutLine: int = ...
	HLRBRep_Rg1Line: int = ...
	HLRBRep_RgNLine: int = ...
	HLRBRep_Sharp: int = ...
HLRBRep_Undefined = HLRBRep_TypeOfResultingEdge.HLRBRep_Undefined
HLRBRep_IsoLine = HLRBRep_TypeOfResultingEdge.HLRBRep_IsoLine
HLRBRep_OutLine = HLRBRep_TypeOfResultingEdge.HLRBRep_OutLine
HLRBRep_Rg1Line = HLRBRep_TypeOfResultingEdge.HLRBRep_Rg1Line
HLRBRep_RgNLine = HLRBRep_TypeOfResultingEdge.HLRBRep_RgNLine
HLRBRep_Sharp = HLRBRep_TypeOfResultingEdge.HLRBRep_Sharp

class hlrbrep:
	@staticmethod
	def MakeEdge(ec: HLRBRep_Curve, U1: float, U2: float) -> TopoDS_Edge: ...
	@staticmethod
	def MakeEdge3d(ec: HLRBRep_Curve, U1: float, U2: float) -> TopoDS_Edge: ...
	@staticmethod
	def PolyHLRAngleAndDeflection(InAngl: float) -> Tuple[float, float]: ...

class HLRBRep_AreaLimit(Standard_Transient):
	def __init__(self, V: HLRAlgo_Intersection, Boundary: bool, Interference: bool, StateBefore: TopAbs_State, StateAfter: TopAbs_State, EdgeBefore: TopAbs_State, EdgeAfter: TopAbs_State) -> None: ...
	def Clear(self) -> None: ...
	@overload
	def EdgeAfter(self, St: TopAbs_State) -> None: ...
	@overload
	def EdgeAfter(self) -> TopAbs_State: ...
	@overload
	def EdgeBefore(self, St: TopAbs_State) -> None: ...
	@overload
	def EdgeBefore(self) -> TopAbs_State: ...
	def IsBoundary(self) -> bool: ...
	def IsInterference(self) -> bool: ...
	@overload
	def Next(self, N: HLRBRep_AreaLimit) -> None: ...
	@overload
	def Next(self) -> HLRBRep_AreaLimit: ...
	@overload
	def Previous(self, P: HLRBRep_AreaLimit) -> None: ...
	@overload
	def Previous(self) -> HLRBRep_AreaLimit: ...
	@overload
	def StateAfter(self, St: TopAbs_State) -> None: ...
	@overload
	def StateAfter(self) -> TopAbs_State: ...
	@overload
	def StateBefore(self, St: TopAbs_State) -> None: ...
	@overload
	def StateBefore(self) -> TopAbs_State: ...
	def Vertex(self) -> HLRAlgo_Intersection: ...

class HLRBRep_BCurveTool:
	@staticmethod
	def BSpline(C: BRepAdaptor_Curve) -> Geom_BSplineCurve: ...
	@staticmethod
	def Bezier(C: BRepAdaptor_Curve) -> Geom_BezierCurve: ...
	@staticmethod
	def Circle(C: BRepAdaptor_Curve) -> gp_Circ: ...
	@staticmethod
	def Continuity(C: BRepAdaptor_Curve) -> GeomAbs_Shape: ...
	@staticmethod
	def D0(C: BRepAdaptor_Curve, U: float, P: gp_Pnt) -> None: ...
	@staticmethod
	def D1(C: BRepAdaptor_Curve, U: float, P: gp_Pnt, V: gp_Vec) -> None: ...
	@staticmethod
	def D2(C: BRepAdaptor_Curve, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec) -> None: ...
	@staticmethod
	def D3(C: BRepAdaptor_Curve, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec, V3: gp_Vec) -> None: ...
	@staticmethod
	def DN(C: BRepAdaptor_Curve, U: float, N: int) -> gp_Vec: ...
	@staticmethod
	def Degree(C: BRepAdaptor_Curve) -> int: ...
	@staticmethod
	def Ellipse(C: BRepAdaptor_Curve) -> gp_Elips: ...
	@staticmethod
	def FirstParameter(C: BRepAdaptor_Curve) -> float: ...
	@staticmethod
	def GetType(C: BRepAdaptor_Curve) -> GeomAbs_CurveType: ...
	@staticmethod
	def Hyperbola(C: BRepAdaptor_Curve) -> gp_Hypr: ...
	@staticmethod
	def Intervals(C: BRepAdaptor_Curve, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
	@staticmethod
	def IsClosed(C: BRepAdaptor_Curve) -> bool: ...
	@staticmethod
	def IsPeriodic(C: BRepAdaptor_Curve) -> bool: ...
	@staticmethod
	def IsRational(C: BRepAdaptor_Curve) -> bool: ...
	@staticmethod
	def LastParameter(C: BRepAdaptor_Curve) -> float: ...
	@staticmethod
	def Line(C: BRepAdaptor_Curve) -> gp_Lin: ...
	@staticmethod
	def NbIntervals(C: BRepAdaptor_Curve, S: GeomAbs_Shape) -> int: ...
	@staticmethod
	def NbKnots(C: BRepAdaptor_Curve) -> int: ...
	@staticmethod
	def NbPoles(C: BRepAdaptor_Curve) -> int: ...
	@staticmethod
	def NbSamples(C: BRepAdaptor_Curve, U0: float, U1: float) -> int: ...
	@staticmethod
	def Parabola(C: BRepAdaptor_Curve) -> gp_Parab: ...
	@staticmethod
	def Period(C: BRepAdaptor_Curve) -> float: ...
	@staticmethod
	def Poles(C: BRepAdaptor_Curve, T: TColgp_Array1OfPnt) -> None: ...
	@staticmethod
	def PolesAndWeights(C: BRepAdaptor_Curve, T: TColgp_Array1OfPnt, W: TColStd_Array1OfReal) -> None: ...
	@staticmethod
	def Resolution(C: BRepAdaptor_Curve, R3d: float) -> float: ...
	@staticmethod
	def Value(C: BRepAdaptor_Curve, U: float) -> gp_Pnt: ...

class HLRBRep_BiPnt2D:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, x1: float, y1: float, x2: float, y2: float, S: TopoDS_Shape, reg1: bool, regn: bool, outl: bool, intl: bool) -> None: ...
	@overload
	def __init__(self, thePoint1: gp_XY, thePoint2: gp_XY, S: TopoDS_Shape, reg1: bool, regn: bool, outl: bool, intl: bool) -> None: ...
	@overload
	def IntLine(self) -> bool: ...
	@overload
	def IntLine(self, B: bool) -> None: ...
	@overload
	def OutLine(self) -> bool: ...
	@overload
	def OutLine(self, B: bool) -> None: ...
	def P1(self) -> gp_Pnt2d: ...
	def P2(self) -> gp_Pnt2d: ...
	@overload
	def Rg1Line(self) -> bool: ...
	@overload
	def Rg1Line(self, B: bool) -> None: ...
	@overload
	def RgNLine(self) -> bool: ...
	@overload
	def RgNLine(self, B: bool) -> None: ...
	@overload
	def Shape(self) -> TopoDS_Shape: ...
	@overload
	def Shape(self, S: TopoDS_Shape) -> None: ...

class HLRBRep_BiPoint:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, x1: float, y1: float, z1: float, x2: float, y2: float, z2: float, S: TopoDS_Shape, reg1: bool, regn: bool, outl: bool, intl: bool) -> None: ...
	@overload
	def IntLine(self) -> bool: ...
	@overload
	def IntLine(self, B: bool) -> None: ...
	@overload
	def OutLine(self) -> bool: ...
	@overload
	def OutLine(self, B: bool) -> None: ...
	def P1(self) -> gp_Pnt: ...
	def P2(self) -> gp_Pnt: ...
	@overload
	def Rg1Line(self) -> bool: ...
	@overload
	def Rg1Line(self, B: bool) -> None: ...
	@overload
	def RgNLine(self) -> bool: ...
	@overload
	def RgNLine(self, B: bool) -> None: ...
	@overload
	def Shape(self) -> TopoDS_Shape: ...
	@overload
	def Shape(self, S: TopoDS_Shape) -> None: ...

class HLRBRep_CInter(IntRes2d_Intersection):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, C: None, TolConf: float, Tol: float) -> None: ...
	@overload
	def __init__(self, C: None, D: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def __init__(self, C1: None, C2: None, TolConf: float, Tol: float) -> None: ...
	@overload
	def __init__(self, C1: None, D1: IntRes2d_Domain, C2: None, TolConf: float, Tol: float) -> None: ...
	@overload
	def __init__(self, C1: None, C2: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def __init__(self, C1: None, D1: IntRes2d_Domain, C2: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	def ComputeDomain(self, C1: None, TolDomain: float) -> IntRes2d_Domain: ...
	def GetMinNbSamples(self) -> int: ...
	@overload
	def Perform(self, C1: None, D1: IntRes2d_Domain, C2: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def Perform(self, C1: None, C2: None, TolConf: float, Tol: float) -> None: ...
	@overload
	def Perform(self, C1: None, D1: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def Perform(self, C1: None, TolConf: float, Tol: float) -> None: ...
	@overload
	def Perform(self, C1: None, D1: IntRes2d_Domain, C2: None, TolConf: float, Tol: float) -> None: ...
	@overload
	def Perform(self, C1: None, C2: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	def SetMinNbSamples(self, theMinNbSamples: int) -> None: ...

class HLRBRep_CLProps:
	@overload
	def __init__(self, C: HLRBRep_Curve, N: int, Resolution: float) -> None: ...
	@overload
	def __init__(self, C: HLRBRep_Curve, U: float, N: int, Resolution: float) -> None: ...
	@overload
	def __init__(self, N: int, Resolution: float) -> None: ...
	def CentreOfCurvature(self, P: gp_Pnt2d) -> None: ...
	def Curvature(self) -> float: ...
	def D1(self) -> gp_Vec2d: ...
	def D2(self) -> gp_Vec2d: ...
	def D3(self) -> gp_Vec2d: ...
	def IsTangentDefined(self) -> bool: ...
	def Normal(self, N: gp_Dir2d) -> None: ...
	def SetCurve(self, C: HLRBRep_Curve) -> None: ...
	def SetParameter(self, U: float) -> None: ...
	def Tangent(self, D: gp_Dir2d) -> None: ...
	def Value(self) -> gp_Pnt2d: ...

class HLRBRep_CLPropsATool:
	@staticmethod
	def Continuity(A: HLRBRep_Curve) -> int: ...
	@staticmethod
	def D1(A: HLRBRep_Curve, U: float, P: gp_Pnt2d, V1: gp_Vec2d) -> None: ...
	@staticmethod
	def D2(A: HLRBRep_Curve, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d) -> None: ...
	@staticmethod
	def D3(A: HLRBRep_Curve, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d, V3: gp_Vec2d) -> None: ...
	@staticmethod
	def FirstParameter(A: HLRBRep_Curve) -> float: ...
	@staticmethod
	def LastParameter(A: HLRBRep_Curve) -> float: ...
	@staticmethod
	def Value(A: HLRBRep_Curve, U: float, P: gp_Pnt2d) -> None: ...

class HLRBRep_Curve:
	def __init__(self) -> None: ...
	def Circle(self) -> gp_Circ2d: ...
	def Continuity(self) -> GeomAbs_Shape: ...
	@overload
	def Curve(self) -> BRepAdaptor_Curve: ...
	@overload
	def Curve(self, E: TopoDS_Edge) -> None: ...
	@overload
	def D0(self, U: float, P: gp_Pnt) -> None: ...
	@overload
	def D0(self, U: float, P: gp_Pnt2d) -> None: ...
	@overload
	def D1(self, U: float, P: gp_Pnt, V: gp_Vec) -> None: ...
	@overload
	def D1(self, U: float, P: gp_Pnt2d, V: gp_Vec2d) -> None: ...
	def D2(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d) -> None: ...
	def D3(self, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d, V3: gp_Vec2d) -> None: ...
	def DN(self, U: float, N: int) -> gp_Vec2d: ...
	def Degree(self) -> int: ...
	def Ellipse(self) -> gp_Elips2d: ...
	def FirstParameter(self) -> float: ...
	def GetCurve(self) -> BRepAdaptor_Curve: ...
	def GetType(self) -> GeomAbs_CurveType: ...
	def Hyperbola(self) -> gp_Hypr2d: ...
	def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
	def IsClosed(self) -> bool: ...
	def IsPeriodic(self) -> bool: ...
	def IsRational(self) -> bool: ...
	def Knots(self, kn: TColStd_Array1OfReal) -> None: ...
	def LastParameter(self) -> float: ...
	def Line(self) -> gp_Lin2d: ...
	def Multiplicities(self, mu: TColStd_Array1OfInteger) -> None: ...
	def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
	def NbKnots(self) -> int: ...
	def NbPoles(self) -> int: ...
	def Parabola(self) -> gp_Parab2d: ...
	def Parameter2d(self, P3d: float) -> float: ...
	def Parameter3d(self, P2d: float) -> float: ...
	def Period(self) -> float: ...
	@overload
	def Poles(self, TP: TColgp_Array1OfPnt2d) -> None: ...
	@overload
	def Poles(self, aCurve: Geom_BSplineCurve, TP: TColgp_Array1OfPnt2d) -> None: ...
	@overload
	def PolesAndWeights(self, TP: TColgp_Array1OfPnt2d, TW: TColStd_Array1OfReal) -> None: ...
	@overload
	def PolesAndWeights(self, aCurve: Geom_BSplineCurve, TP: TColgp_Array1OfPnt2d, TW: TColStd_Array1OfReal) -> None: ...
	def Projector(self, Proj: HLRAlgo_Projector) -> None: ...
	def Resolution(self, R3d: float) -> float: ...
	def Tangent(self, AtStart: bool, P: gp_Pnt2d, D: gp_Dir2d) -> None: ...
	def Update(self, TotMin_list: List[float], TotMax_list: List[float]) -> float: ...
	def UpdateMinMax(self, TotMin_list: List[float], TotMax_list: List[float]) -> float: ...
	def Value(self, U: float) -> gp_Pnt2d: ...
	def Value3D(self, U: float) -> gp_Pnt: ...
	def Z(self, U: float) -> float: ...

class HLRBRep_CurveTool:
	@staticmethod
	def BSpline(C: None) -> Geom2d_BSplineCurve: ...
	@staticmethod
	def Bezier(C: None) -> Geom2d_BezierCurve: ...
	@staticmethod
	def Circle(C: None) -> gp_Circ2d: ...
	@staticmethod
	def Continuity(C: None) -> GeomAbs_Shape: ...
	@staticmethod
	def D0(C: None, U: float, P: gp_Pnt2d) -> None: ...
	@staticmethod
	def D1(C: None, U: float, P: gp_Pnt2d, V: gp_Vec2d) -> None: ...
	@staticmethod
	def D2(C: None, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d) -> None: ...
	@staticmethod
	def D3(C: None, U: float, P: gp_Pnt2d, V1: gp_Vec2d, V2: gp_Vec2d, V3: gp_Vec2d) -> None: ...
	@staticmethod
	def DN(C: None, U: float, N: int) -> gp_Vec2d: ...
	@staticmethod
	def Degree(C: None) -> int: ...
	@staticmethod
	def Ellipse(C: None) -> gp_Elips2d: ...
	@staticmethod
	def EpsX(C: None) -> float: ...
	@staticmethod
	def FirstParameter(C: None) -> float: ...
	@staticmethod
	def GetInterval(C: None, Index: int, Tab: TColStd_Array1OfReal) -> Tuple[float, float]: ...
	@staticmethod
	def GetType(C: None) -> GeomAbs_CurveType: ...
	@staticmethod
	def Hyperbola(C: None) -> gp_Hypr2d: ...
	@staticmethod
	def Intervals(C: None, T: TColStd_Array1OfReal) -> None: ...
	@staticmethod
	def IsClosed(C: None) -> bool: ...
	@staticmethod
	def IsPeriodic(C: None) -> bool: ...
	@staticmethod
	def LastParameter(C: None) -> float: ...
	@staticmethod
	def Line(C: None) -> gp_Lin2d: ...
	@staticmethod
	def NbIntervals(C: None) -> int: ...
	@overload
	@staticmethod
	def NbSamples(C: None, U0: float, U1: float) -> int: ...
	@overload
	@staticmethod
	def NbSamples(C: None) -> int: ...
	@staticmethod
	def Parabola(C: None) -> gp_Parab2d: ...
	@staticmethod
	def Period(C: None) -> float: ...
	@staticmethod
	def Resolution(C: None, R3d: float) -> float: ...
	@staticmethod
	def TheType(C: None) -> GeomAbs_CurveType: ...
	@staticmethod
	def Value(C: None, U: float) -> gp_Pnt2d: ...

class HLRBRep_Data(Standard_Transient):
	def __init__(self, NV: int, NE: int, NF: int) -> None: ...
	def AboveInterference(self) -> bool: ...
	def Classify(self, E: int, ED: HLRBRep_EdgeData, LevelFlag: bool, param: float) -> Tuple[TopAbs_State, int]: ...
	def Compare(self, E: int, ED: HLRBRep_EdgeData) -> TopAbs_State: ...
	def Destroy(self) -> None: ...
	def EDataArray(self) -> HLRBRep_Array1OfEData: ...
	def Edge(self) -> int: ...
	def EdgeMap(self) -> TopTools_IndexedMapOfShape: ...
	def EdgeOfTheHidingFace(self, E: int, ED: HLRBRep_EdgeData) -> bool: ...
	def EdgeState(self, p1: float, p2: float, stbef: TopAbs_State, staf: TopAbs_State) -> None: ...
	def FDataArray(self) -> HLRBRep_Array1OfFData: ...
	def FaceMap(self) -> TopTools_IndexedMapOfShape: ...
	def HidingStartLevel(self, E: int, ED: HLRBRep_EdgeData, IL: HLRAlgo_InterferenceList) -> int: ...
	def HidingTheFace(self) -> bool: ...
	def InitEdge(self, FI: int, MST: BRepTopAdaptor_MapOfShapeTool) -> None: ...
	def InitInterference(self) -> None: ...
	def Interference(self) -> HLRAlgo_Interference: ...
	def IsBadFace(self) -> bool: ...
	def LocalFEGeometry2D(self, FE: int, Param: float, Tg: gp_Dir2d, Nm: gp_Dir2d) -> float: ...
	def LocalLEGeometry2D(self, Param: float, Tg: gp_Dir2d, Nm: gp_Dir2d) -> float: ...
	def MoreEdge(self) -> bool: ...
	def MoreInterference(self) -> bool: ...
	def NbEdges(self) -> int: ...
	def NbFaces(self) -> int: ...
	def NbVertices(self) -> int: ...
	def NextEdge(self, skip: Optional[bool] = True) -> None: ...
	def NextInterference(self) -> None: ...
	def Projector(self) -> HLRAlgo_Projector: ...
	def RejectedInterference(self) -> bool: ...
	def SimplClassify(self, E: int, ED: HLRBRep_EdgeData, Nbp: int, p1: float, p2: float) -> TopAbs_State: ...
	def SimpleHidingFace(self) -> bool: ...
	@overload
	def Tolerance(self, tol: float) -> None: ...
	@overload
	def Tolerance(self) -> float: ...
	def Update(self, P: HLRAlgo_Projector) -> None: ...
	def Write(self, DS: HLRBRep_Data, dv: int, de: int, df: int) -> None: ...

class HLRBRep_EdgeBuilder:
	def __init__(self, VList: HLRBRep_VertexList) -> None: ...
	def AreaEdgeState(self) -> TopAbs_State: ...
	def AreaState(self) -> TopAbs_State: ...
	def Builds(self, ToBuild: TopAbs_State) -> None: ...
	def Current(self) -> HLRAlgo_Intersection: ...
	def Destroy(self) -> None: ...
	def HasArea(self) -> bool: ...
	def InitAreas(self) -> None: ...
	def IsBoundary(self) -> bool: ...
	def IsInterference(self) -> bool: ...
	def LeftLimit(self) -> HLRBRep_AreaLimit: ...
	def MoreEdges(self) -> bool: ...
	def MoreVertices(self) -> bool: ...
	def NextArea(self) -> None: ...
	def NextEdge(self) -> None: ...
	def NextVertex(self) -> None: ...
	def Orientation(self) -> TopAbs_Orientation: ...
	def PreviousArea(self) -> None: ...
	def RightLimit(self) -> HLRBRep_AreaLimit: ...

class HLRBRep_EdgeData:
	def __init__(self) -> None: ...
	@overload
	def AutoIntersectionDone(self) -> bool: ...
	@overload
	def AutoIntersectionDone(self, B: bool) -> None: ...
	def ChangeGeometry(self) -> HLRBRep_Curve: ...
	def Curve(self) -> HLRBRep_Curve: ...
	@overload
	def CutAtEnd(self) -> bool: ...
	@overload
	def CutAtEnd(self, B: bool) -> None: ...
	@overload
	def CutAtSta(self) -> bool: ...
	@overload
	def CutAtSta(self, B: bool) -> None: ...
	def Geometry(self) -> HLRBRep_Curve: ...
	@overload
	def HideCount(self) -> int: ...
	@overload
	def HideCount(self, I: int) -> None: ...
	def MinMax(self) -> False: ...
	@overload
	def OutLVEnd(self) -> bool: ...
	@overload
	def OutLVEnd(self, B: bool) -> None: ...
	@overload
	def OutLVSta(self) -> bool: ...
	@overload
	def OutLVSta(self, B: bool) -> None: ...
	@overload
	def Rg1Line(self) -> bool: ...
	@overload
	def Rg1Line(self, B: bool) -> None: ...
	@overload
	def RgNLine(self) -> bool: ...
	@overload
	def RgNLine(self, B: bool) -> None: ...
	@overload
	def Selected(self) -> bool: ...
	@overload
	def Selected(self, B: bool) -> None: ...
	def Set(self, Reg1: bool, RegN: bool, EG: TopoDS_Edge, V1: int, V2: int, Out1: bool, Out2: bool, Cut1: bool, Cut2: bool, Start: float, TolStart: float, End: float, TolEnd: float) -> None: ...
	@overload
	def Simple(self) -> bool: ...
	@overload
	def Simple(self, B: bool) -> None: ...
	def Status(self) -> HLRAlgo_EdgeStatus: ...
	def Tolerance(self) -> float: ...
	@overload
	def Used(self) -> bool: ...
	@overload
	def Used(self, B: bool) -> None: ...
	@overload
	def VEnd(self) -> int: ...
	@overload
	def VEnd(self, I: int) -> None: ...
	@overload
	def VSta(self) -> int: ...
	@overload
	def VSta(self, I: int) -> None: ...
	@overload
	def VerAtEnd(self) -> bool: ...
	@overload
	def VerAtEnd(self, B: bool) -> None: ...
	@overload
	def VerAtSta(self) -> bool: ...
	@overload
	def VerAtSta(self, B: bool) -> None: ...
	@overload
	def Vertical(self) -> bool: ...
	@overload
	def Vertical(self, B: bool) -> None: ...

class HLRBRep_EdgeFaceTool:
	@staticmethod
	def CurvatureValue(F: None, U: float, V: float, Tg: gp_Dir) -> float: ...
	@staticmethod
	def UVPoint(Par: float, E: None, F: None) -> Tuple[bool, float, float]: ...

class HLRBRep_EdgeIList:
	@staticmethod
	def AddInterference(IL: HLRAlgo_InterferenceList, I: HLRAlgo_Interference, T: HLRBRep_EdgeInterferenceTool) -> None: ...
	@staticmethod
	def ProcessComplex(IL: HLRAlgo_InterferenceList, T: HLRBRep_EdgeInterferenceTool) -> None: ...

class HLRBRep_EdgeInterferenceTool:
	def __init__(self, DS: HLRBRep_Data) -> None: ...
	def CurrentOrientation(self) -> TopAbs_Orientation: ...
	def CurrentParameter(self) -> float: ...
	def CurrentVertex(self) -> HLRAlgo_Intersection: ...
	def EdgeGeometry(self, Param: float, Tgt: gp_Dir, Nrm: gp_Dir) -> float: ...
	def InitVertices(self) -> None: ...
	def InterferenceBoundaryGeometry(self, I: HLRAlgo_Interference, Tang: gp_Dir, Norm: gp_Dir) -> float: ...
	def IsPeriodic(self) -> bool: ...
	def LoadEdge(self) -> None: ...
	def MoreVertices(self) -> bool: ...
	def NextVertex(self) -> None: ...
	def ParameterOfInterference(self, I: HLRAlgo_Interference) -> float: ...
	def SameInterferences(self, I1: HLRAlgo_Interference, I2: HLRAlgo_Interference) -> bool: ...
	def SameVertexAndInterference(self, I: HLRAlgo_Interference) -> bool: ...

class HLRBRep_ExactIntersectionPointOfTheIntPCurvePCurveOfCInter:
	def __init__(self, C1: None, C2: None, Tol: float) -> None: ...
	def AnErrorOccurred(self) -> bool: ...
	def NbRoots(self) -> int: ...
	@overload
	def Perform(self, Poly1: HLRBRep_ThePolygon2dOfTheIntPCurvePCurveOfCInter, Poly2: HLRBRep_ThePolygon2dOfTheIntPCurvePCurveOfCInter) -> Tuple[int, int, float, float]: ...
	@overload
	def Perform(self, Uo: float, Vo: float, UInf: float, VInf: float, USup: float, VSup: float) -> None: ...
	def Roots(self) -> Tuple[float, float]: ...

class HLRBRep_FaceData:
	def __init__(self) -> None: ...
	@overload
	def Back(self) -> bool: ...
	@overload
	def Back(self, B: bool) -> None: ...
	@overload
	def Closed(self) -> bool: ...
	@overload
	def Closed(self, B: bool) -> None: ...
	@overload
	def Cone(self) -> bool: ...
	@overload
	def Cone(self, B: bool) -> None: ...
	@overload
	def Cut(self) -> bool: ...
	@overload
	def Cut(self, B: bool) -> None: ...
	@overload
	def Cylinder(self) -> bool: ...
	@overload
	def Cylinder(self, B: bool) -> None: ...
	def Geometry(self) -> HLRBRep_Surface: ...
	@overload
	def Hiding(self) -> bool: ...
	@overload
	def Hiding(self, B: bool) -> None: ...
	@overload
	def Orientation(self) -> TopAbs_Orientation: ...
	@overload
	def Orientation(self, O: TopAbs_Orientation) -> None: ...
	@overload
	def Plane(self) -> bool: ...
	@overload
	def Plane(self, B: bool) -> None: ...
	@overload
	def Selected(self) -> bool: ...
	@overload
	def Selected(self, B: bool) -> None: ...
	def Set(self, FG: TopoDS_Face, Or: TopAbs_Orientation, Cl: bool, NW: int) -> None: ...
	def SetWEdge(self, WI: int, EWI: int, EI: int, Or: TopAbs_Orientation, OutL: bool, Inte: bool, Dble: bool, IsoL: bool) -> None: ...
	def SetWire(self, WI: int, NE: int) -> None: ...
	@overload
	def Side(self) -> bool: ...
	@overload
	def Side(self, B: bool) -> None: ...
	@overload
	def Simple(self) -> bool: ...
	@overload
	def Simple(self, B: bool) -> None: ...
	@overload
	def Size(self) -> float: ...
	@overload
	def Size(self, S: float) -> None: ...
	@overload
	def Sphere(self) -> bool: ...
	@overload
	def Sphere(self, B: bool) -> None: ...
	def Tolerance(self) -> float: ...
	@overload
	def Torus(self) -> bool: ...
	@overload
	def Torus(self, B: bool) -> None: ...
	def Wires(self) -> HLRAlgo_WiresBlock: ...
	@overload
	def WithOutL(self) -> bool: ...
	@overload
	def WithOutL(self, B: bool) -> None: ...

class HLRBRep_FaceIterator:
	def __init__(self) -> None: ...
	def BeginningOfWire(self) -> bool: ...
	def Double(self) -> bool: ...
	def Edge(self) -> int: ...
	def EndOfWire(self) -> bool: ...
	def InitEdge(self, fd: HLRBRep_FaceData) -> None: ...
	def Internal(self) -> bool: ...
	def IsoLine(self) -> bool: ...
	def MoreEdge(self) -> bool: ...
	def NextEdge(self) -> None: ...
	def Orientation(self) -> TopAbs_Orientation: ...
	def OutLine(self) -> bool: ...
	def SkipWire(self) -> None: ...
	def Wire(self) -> HLRAlgo_EdgesBlock: ...

class HLRBRep_HLRToShape:
	def __init__(self, A: HLRBRep_Algo) -> None: ...
	@overload
	def CompoundOfEdges(self, type: HLRBRep_TypeOfResultingEdge, visible: bool, In3d: bool) -> TopoDS_Shape: ...
	@overload
	def CompoundOfEdges(self, S: TopoDS_Shape, type: HLRBRep_TypeOfResultingEdge, visible: bool, In3d: bool) -> TopoDS_Shape: ...
	@overload
	def HCompound(self) -> TopoDS_Shape: ...
	@overload
	def HCompound(self, S: TopoDS_Shape) -> TopoDS_Shape: ...
	@overload
	def IsoLineHCompound(self) -> TopoDS_Shape: ...
	@overload
	def IsoLineHCompound(self, S: TopoDS_Shape) -> TopoDS_Shape: ...
	@overload
	def IsoLineVCompound(self) -> TopoDS_Shape: ...
	@overload
	def IsoLineVCompound(self, S: TopoDS_Shape) -> TopoDS_Shape: ...
	@overload
	def OutLineHCompound(self) -> TopoDS_Shape: ...
	@overload
	def OutLineHCompound(self, S: TopoDS_Shape) -> TopoDS_Shape: ...
	@overload
	def OutLineVCompound(self) -> TopoDS_Shape: ...
	@overload
	def OutLineVCompound(self, S: TopoDS_Shape) -> TopoDS_Shape: ...
	def OutLineVCompound3d(self) -> TopoDS_Shape: ...
	@overload
	def Rg1LineHCompound(self) -> TopoDS_Shape: ...
	@overload
	def Rg1LineHCompound(self, S: TopoDS_Shape) -> TopoDS_Shape: ...
	@overload
	def Rg1LineVCompound(self) -> TopoDS_Shape: ...
	@overload
	def Rg1LineVCompound(self, S: TopoDS_Shape) -> TopoDS_Shape: ...
	@overload
	def RgNLineHCompound(self) -> TopoDS_Shape: ...
	@overload
	def RgNLineHCompound(self, S: TopoDS_Shape) -> TopoDS_Shape: ...
	@overload
	def RgNLineVCompound(self) -> TopoDS_Shape: ...
	@overload
	def RgNLineVCompound(self, S: TopoDS_Shape) -> TopoDS_Shape: ...
	@overload
	def VCompound(self) -> TopoDS_Shape: ...
	@overload
	def VCompound(self, S: TopoDS_Shape) -> TopoDS_Shape: ...

class HLRBRep_Hider:
	def __init__(self, DS: HLRBRep_Data) -> None: ...
	def Hide(self, FI: int, MST: BRepTopAdaptor_MapOfShapeTool) -> None: ...
	def OwnHiding(self, FI: int) -> None: ...

class HLRBRep_IntConicCurveOfCInter(IntRes2d_Intersection):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, L: gp_Lin2d, D1: IntRes2d_Domain, PCurve: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def __init__(self, C: gp_Circ2d, D1: IntRes2d_Domain, PCurve: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def __init__(self, E: gp_Elips2d, D1: IntRes2d_Domain, PCurve: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def __init__(self, Prb: gp_Parab2d, D1: IntRes2d_Domain, PCurve: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def __init__(self, H: gp_Hypr2d, D1: IntRes2d_Domain, PCurve: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def Perform(self, L: gp_Lin2d, D1: IntRes2d_Domain, PCurve: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def Perform(self, C: gp_Circ2d, D1: IntRes2d_Domain, PCurve: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def Perform(self, E: gp_Elips2d, D1: IntRes2d_Domain, PCurve: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def Perform(self, Prb: gp_Parab2d, D1: IntRes2d_Domain, PCurve: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def Perform(self, H: gp_Hypr2d, D1: IntRes2d_Domain, PCurve: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...

class HLRBRep_InterCSurf(IntCurveSurface_Intersection):
	def __init__(self) -> None: ...
	@overload
	def Perform(self, Curve: gp_Lin, Surface: None) -> None: ...
	@overload
	def Perform(self, Curve: gp_Lin, Polygon: HLRBRep_ThePolygonOfInterCSurf, Surface: None) -> None: ...
	@overload
	def Perform(self, Curve: gp_Lin, ThePolygon: HLRBRep_ThePolygonOfInterCSurf, Surface: None, Polyhedron: HLRBRep_ThePolyhedronOfInterCSurf) -> None: ...
	@overload
	def Perform(self, Curve: gp_Lin, ThePolygon: HLRBRep_ThePolygonOfInterCSurf, Surface: None, Polyhedron: HLRBRep_ThePolyhedronOfInterCSurf, BndBSB: Bnd_BoundSortBox) -> None: ...
	@overload
	def Perform(self, Curve: gp_Lin, Surface: None, Polyhedron: HLRBRep_ThePolyhedronOfInterCSurf) -> None: ...

class HLRBRep_InternalAlgo(Standard_Transient):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, A: HLRBRep_InternalAlgo) -> None: ...
	def DataStructure(self) -> HLRBRep_Data: ...
	@overload
	def Debug(self, deb: bool) -> None: ...
	@overload
	def Debug(self) -> bool: ...
	@overload
	def Hide(self) -> None: ...
	@overload
	def Hide(self, I: int) -> None: ...
	@overload
	def Hide(self, I: int, J: int) -> None: ...
	@overload
	def HideAll(self) -> None: ...
	@overload
	def HideAll(self, I: int) -> None: ...
	def Index(self, S: HLRTopoBRep_OutLiner) -> int: ...
	def InitEdgeStatus(self) -> None: ...
	@overload
	def Load(self, S: HLRTopoBRep_OutLiner, SData: Standard_Transient, nbIso: Optional[int] = 0) -> None: ...
	@overload
	def Load(self, S: HLRTopoBRep_OutLiner, nbIso: Optional[int] = 0) -> None: ...
	def NbShapes(self) -> int: ...
	def PartialHide(self) -> None: ...
	@overload
	def Projector(self, P: HLRAlgo_Projector) -> None: ...
	@overload
	def Projector(self) -> HLRAlgo_Projector: ...
	def Remove(self, I: int) -> None: ...
	@overload
	def Select(self) -> None: ...
	@overload
	def Select(self, I: int) -> None: ...
	def SelectEdge(self, I: int) -> None: ...
	def SelectFace(self, I: int) -> None: ...
	def SeqOfShapeBounds(self) -> HLRBRep_SeqOfShapeBounds: ...
	def ShapeBounds(self, I: int) -> HLRBRep_ShapeBounds: ...
	def ShapeData(self, I: int, SData: Standard_Transient) -> None: ...
	@overload
	def ShowAll(self) -> None: ...
	@overload
	def ShowAll(self, I: int) -> None: ...
	def Update(self) -> None: ...

class HLRBRep_Intersector:
	def __init__(self) -> None: ...
	def CSPoint(self, N: int) -> IntCurveSurface_IntersectionPoint: ...
	def CSSegment(self, N: int) -> IntCurveSurface_IntersectionSegment: ...
	def Destroy(self) -> None: ...
	def IsDone(self) -> bool: ...
	def Load(self, A: None) -> None: ...
	def NbPoints(self) -> int: ...
	def NbSegments(self) -> int: ...
	@overload
	def Perform(self, A1: None, da1: float, db1: float) -> None: ...
	@overload
	def Perform(self, nA: int, A1: None, da1: float, db1: float, nB: int, A2: None, da2: float, db2: float, NoBound: bool) -> None: ...
	@overload
	def Perform(self, L: gp_Lin, P: float) -> None: ...
	def Point(self, N: int) -> IntRes2d_IntersectionPoint: ...
	def Segment(self, N: int) -> IntRes2d_IntersectionSegment: ...
	def SimulateOnePoint(self, A1: None, U: float, A2: None, V: float) -> None: ...

class HLRBRep_LineTool:
	@staticmethod
	def BSpline(C: gp_Lin) -> Geom_BSplineCurve: ...
	@staticmethod
	def Bezier(C: gp_Lin) -> Geom_BezierCurve: ...
	@staticmethod
	def Circle(C: gp_Lin) -> gp_Circ: ...
	@staticmethod
	def Continuity(C: gp_Lin) -> GeomAbs_Shape: ...
	@staticmethod
	def D0(C: gp_Lin, U: float, P: gp_Pnt) -> None: ...
	@staticmethod
	def D1(C: gp_Lin, U: float, P: gp_Pnt, V: gp_Vec) -> None: ...
	@staticmethod
	def D2(C: gp_Lin, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec) -> None: ...
	@staticmethod
	def D3(C: gp_Lin, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec, V3: gp_Vec) -> None: ...
	@staticmethod
	def DN(C: gp_Lin, U: float, N: int) -> gp_Vec: ...
	@staticmethod
	def Degree(C: gp_Lin) -> int: ...
	@staticmethod
	def Ellipse(C: gp_Lin) -> gp_Elips: ...
	@staticmethod
	def FirstParameter(C: gp_Lin) -> float: ...
	@staticmethod
	def GetType(C: gp_Lin) -> GeomAbs_CurveType: ...
	@staticmethod
	def Hyperbola(C: gp_Lin) -> gp_Hypr: ...
	@staticmethod
	def IntervalContinuity(C: gp_Lin) -> GeomAbs_Shape: ...
	@staticmethod
	def IntervalFirst(C: gp_Lin) -> float: ...
	@staticmethod
	def IntervalLast(C: gp_Lin) -> float: ...
	@staticmethod
	def Intervals(C: gp_Lin, T: TColStd_Array1OfReal, Sh: GeomAbs_Shape) -> None: ...
	@staticmethod
	def IsClosed(C: gp_Lin) -> bool: ...
	@staticmethod
	def IsPeriodic(C: gp_Lin) -> bool: ...
	@staticmethod
	def IsRational(C: gp_Lin) -> bool: ...
	@staticmethod
	def KnotsAndMultiplicities(C: gp_Lin, TK: TColStd_Array1OfReal, TM: TColStd_Array1OfInteger) -> None: ...
	@staticmethod
	def LastParameter(C: gp_Lin) -> float: ...
	@staticmethod
	def Line(C: gp_Lin) -> gp_Lin: ...
	@staticmethod
	def NbIntervals(C: gp_Lin, S: GeomAbs_Shape) -> int: ...
	@staticmethod
	def NbKnots(C: gp_Lin) -> int: ...
	@staticmethod
	def NbPoles(C: gp_Lin) -> int: ...
	@staticmethod
	def NbSamples(C: gp_Lin, U0: float, U1: float) -> int: ...
	@staticmethod
	def Parabola(C: gp_Lin) -> gp_Parab: ...
	@staticmethod
	def Period(C: gp_Lin) -> float: ...
	@staticmethod
	def Poles(C: gp_Lin, TP: TColgp_Array1OfPnt) -> None: ...
	@staticmethod
	def PolesAndWeights(C: gp_Lin, TP: TColgp_Array1OfPnt, TW: TColStd_Array1OfReal) -> None: ...
	@staticmethod
	def Resolution(C: gp_Lin, R3d: float) -> float: ...
	@staticmethod
	def SamplePars(C: gp_Lin, U0: float, U1: float, Defl: float, NbMin: int, Pars: TColStd_HArray1OfReal) -> None: ...
	@staticmethod
	def Value(C: gp_Lin, U: float) -> gp_Pnt: ...

class HLRBRep_MyImpParToolOfTheIntersectorOfTheIntConicCurveOfCInter(math_FunctionWithDerivative):
	def __init__(self, IT: IntCurve_IConicTool, PC: None) -> None: ...
	def Derivative(self, Param: float) -> Tuple[bool, float]: ...
	def Value(self, Param: float) -> Tuple[bool, float]: ...
	def Values(self, Param: float) -> Tuple[bool, float, float]: ...

class HLRBRep_PCLocFOfTheLocateExtPCOfTheProjPCurOfCInter(math_FunctionWithDerivative):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, P: gp_Pnt2d, C: None) -> None: ...
	def Derivative(self, U: float) -> Tuple[bool, float]: ...
	def GetStateNumber(self) -> int: ...
	def Initialize(self, C: None) -> None: ...
	def IsMin(self, N: int) -> bool: ...
	def NbExt(self) -> int: ...
	def Point(self, N: int) -> Extrema_POnCurv2d: ...
	def SearchOfTolerance(self) -> float: ...
	def SetPoint(self, P: gp_Pnt2d) -> None: ...
	def SquareDistance(self, N: int) -> float: ...
	def SubIntervalInitialize(self, theUfirst: float, theUlast: float) -> None: ...
	def Value(self, U: float) -> Tuple[bool, float]: ...
	def Values(self, U: float) -> Tuple[bool, float, float]: ...

class HLRBRep_PolyAlgo(Standard_Transient):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, A: HLRBRep_PolyAlgo) -> None: ...
	@overload
	def __init__(self, S: TopoDS_Shape) -> None: ...
	def Algo(self) -> HLRAlgo_PolyAlgo: ...
	@overload
	def Angle(self) -> float: ...
	@overload
	def Angle(self, Ang: float) -> None: ...
	@overload
	def Debug(self) -> bool: ...
	@overload
	def Debug(self, B: bool) -> None: ...
	def Hide(self, status: HLRAlgo_EdgeStatus, S: TopoDS_Shape) -> Tuple[False, bool, bool, bool, bool]: ...
	def Index(self, S: TopoDS_Shape) -> int: ...
	def InitHide(self) -> None: ...
	def InitShow(self) -> None: ...
	def Load(self, S: TopoDS_Shape) -> None: ...
	def MoreHide(self) -> bool: ...
	def MoreShow(self) -> bool: ...
	def NbShapes(self) -> int: ...
	def NextHide(self) -> None: ...
	def NextShow(self) -> None: ...
	def OutLinedShape(self, S: TopoDS_Shape) -> TopoDS_Shape: ...
	@overload
	def Projector(self) -> HLRAlgo_Projector: ...
	@overload
	def Projector(self, P: HLRAlgo_Projector) -> None: ...
	def Remove(self, I: int) -> None: ...
	def Shape(self, I: int) -> TopoDS_Shape: ...
	def Show(self, S: TopoDS_Shape) -> Tuple[False, bool, bool, bool, bool]: ...
	@overload
	def TolAngular(self) -> float: ...
	@overload
	def TolAngular(self, Tol: float) -> None: ...
	@overload
	def TolCoef(self) -> float: ...
	@overload
	def TolCoef(self, Tol: float) -> None: ...
	def Update(self) -> None: ...

class HLRBRep_PolyHLRToShape:
	def __init__(self) -> None: ...
	@overload
	def HCompound(self) -> TopoDS_Shape: ...
	@overload
	def HCompound(self, S: TopoDS_Shape) -> TopoDS_Shape: ...
	def Hide(self) -> None: ...
	@overload
	def OutLineHCompound(self) -> TopoDS_Shape: ...
	@overload
	def OutLineHCompound(self, S: TopoDS_Shape) -> TopoDS_Shape: ...
	@overload
	def OutLineVCompound(self) -> TopoDS_Shape: ...
	@overload
	def OutLineVCompound(self, S: TopoDS_Shape) -> TopoDS_Shape: ...
	@overload
	def Rg1LineHCompound(self) -> TopoDS_Shape: ...
	@overload
	def Rg1LineHCompound(self, S: TopoDS_Shape) -> TopoDS_Shape: ...
	@overload
	def Rg1LineVCompound(self) -> TopoDS_Shape: ...
	@overload
	def Rg1LineVCompound(self, S: TopoDS_Shape) -> TopoDS_Shape: ...
	@overload
	def RgNLineHCompound(self) -> TopoDS_Shape: ...
	@overload
	def RgNLineHCompound(self, S: TopoDS_Shape) -> TopoDS_Shape: ...
	@overload
	def RgNLineVCompound(self) -> TopoDS_Shape: ...
	@overload
	def RgNLineVCompound(self, S: TopoDS_Shape) -> TopoDS_Shape: ...
	def Show(self) -> None: ...
	def Update(self, A: HLRBRep_PolyAlgo) -> None: ...
	@overload
	def VCompound(self) -> TopoDS_Shape: ...
	@overload
	def VCompound(self, S: TopoDS_Shape) -> TopoDS_Shape: ...

class HLRBRep_SLProps:
	@overload
	def __init__(self, S: None, U: float, V: float, N: int, Resolution: float) -> None: ...
	@overload
	def __init__(self, S: None, N: int, Resolution: float) -> None: ...
	@overload
	def __init__(self, N: int, Resolution: float) -> None: ...
	def CurvatureDirections(self, MaxD: gp_Dir, MinD: gp_Dir) -> None: ...
	def D1U(self) -> gp_Vec: ...
	def D1V(self) -> gp_Vec: ...
	def D2U(self) -> gp_Vec: ...
	def D2V(self) -> gp_Vec: ...
	def DUV(self) -> gp_Vec: ...
	def GaussianCurvature(self) -> float: ...
	def IsCurvatureDefined(self) -> bool: ...
	def IsNormalDefined(self) -> bool: ...
	def IsTangentUDefined(self) -> bool: ...
	def IsTangentVDefined(self) -> bool: ...
	def IsUmbilic(self) -> bool: ...
	def MaxCurvature(self) -> float: ...
	def MeanCurvature(self) -> float: ...
	def MinCurvature(self) -> float: ...
	def Normal(self) -> gp_Dir: ...
	def SetParameters(self, U: float, V: float) -> None: ...
	def SetSurface(self, S: None) -> None: ...
	def TangentU(self, D: gp_Dir) -> None: ...
	def TangentV(self, D: gp_Dir) -> None: ...
	def Value(self) -> gp_Pnt: ...

class HLRBRep_SLPropsATool:
	@staticmethod
	def Bounds(A: None) -> Tuple[float, float, float, float]: ...
	@staticmethod
	def Continuity(A: None) -> int: ...
	@staticmethod
	def D1(A: None, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec) -> None: ...
	@staticmethod
	def D2(A: None, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, DUV: gp_Vec) -> None: ...
	@staticmethod
	def DN(A: None, U: float, V: float, Nu: int, Nv: int) -> gp_Vec: ...
	@staticmethod
	def Value(A: None, U: float, V: float, P: gp_Pnt) -> None: ...

class HLRBRep_ShapeBounds:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, S: HLRTopoBRep_OutLiner, SData: Standard_Transient, nbIso: int, V1: int, V2: int, E1: int, E2: int, F1: int, F2: int) -> None: ...
	@overload
	def __init__(self, S: HLRTopoBRep_OutLiner, nbIso: int, V1: int, V2: int, E1: int, E2: int, F1: int, F2: int) -> None: ...
	def Bounds(self) -> Tuple[int, int, int, int, int, int]: ...
	def MinMax(self) -> False: ...
	@overload
	def NbOfIso(self, nbIso: int) -> None: ...
	@overload
	def NbOfIso(self) -> int: ...
	@overload
	def Shape(self, S: HLRTopoBRep_OutLiner) -> None: ...
	@overload
	def Shape(self) -> HLRTopoBRep_OutLiner: ...
	@overload
	def ShapeData(self, SD: Standard_Transient) -> None: ...
	@overload
	def ShapeData(self) -> Standard_Transient: ...
	def Sizes(self) -> Tuple[int, int, int]: ...
	def Translate(self, NV: int, NE: int, NF: int) -> None: ...

class HLRBRep_ShapeToHLR:
	@staticmethod
	def Load(S: HLRTopoBRep_OutLiner, P: HLRAlgo_Projector, MST: BRepTopAdaptor_MapOfShapeTool, nbIso: Optional[int] = 0) -> HLRBRep_Data: ...

class HLRBRep_SurfaceTool:
	@staticmethod
	def AxeOfRevolution(S: None) -> gp_Ax1: ...
	@staticmethod
	def BSpline(S: None) -> Geom_BSplineSurface: ...
	@staticmethod
	def BasisCurve(S: None) -> Adaptor3d_HCurve: ...
	@staticmethod
	def BasisSurface(S: None) -> Adaptor3d_HSurface: ...
	@staticmethod
	def Bezier(S: None) -> Geom_BezierSurface: ...
	@staticmethod
	def Cone(S: None) -> gp_Cone: ...
	@staticmethod
	def Cylinder(S: None) -> gp_Cylinder: ...
	@staticmethod
	def D0(S: None, u: float, v: float, P: gp_Pnt) -> None: ...
	@staticmethod
	def D1(S: None, u: float, v: float, P: gp_Pnt, D1u: gp_Vec, D1v: gp_Vec) -> None: ...
	@staticmethod
	def D2(S: None, u: float, v: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec) -> None: ...
	@staticmethod
	def D3(S: None, u: float, v: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec, D3U: gp_Vec, D3V: gp_Vec, D3UUV: gp_Vec, D3UVV: gp_Vec) -> None: ...
	@staticmethod
	def DN(S: None, u: float, v: float, Nu: int, Nv: int) -> gp_Vec: ...
	@staticmethod
	def Direction(S: None) -> gp_Dir: ...
	@staticmethod
	def FirstUParameter(S: None) -> float: ...
	@staticmethod
	def FirstVParameter(S: None) -> float: ...
	@staticmethod
	def GetType(S: None) -> GeomAbs_SurfaceType: ...
	@staticmethod
	def IsUClosed(S: None) -> bool: ...
	@staticmethod
	def IsUPeriodic(S: None) -> bool: ...
	@staticmethod
	def IsVClosed(S: None) -> bool: ...
	@staticmethod
	def IsVPeriodic(S: None) -> bool: ...
	@staticmethod
	def LastUParameter(S: None) -> float: ...
	@staticmethod
	def LastVParameter(S: None) -> float: ...
	@overload
	@staticmethod
	def NbSamplesU(S: None) -> int: ...
	@overload
	@staticmethod
	def NbSamplesU(S: None, u1: float, u2: float) -> int: ...
	@overload
	@staticmethod
	def NbSamplesV(S: None) -> int: ...
	@overload
	@staticmethod
	def NbSamplesV(S: None, v1: float, v2: float) -> int: ...
	@staticmethod
	def NbUIntervals(S: None, Sh: GeomAbs_Shape) -> int: ...
	@staticmethod
	def NbVIntervals(S: None, Sh: GeomAbs_Shape) -> int: ...
	@staticmethod
	def OffsetValue(S: None) -> float: ...
	@staticmethod
	def Plane(S: None) -> gp_Pln: ...
	@staticmethod
	def Sphere(S: None) -> gp_Sphere: ...
	@staticmethod
	def Torus(S: None) -> gp_Torus: ...
	@staticmethod
	def UIntervals(S: None, T: TColStd_Array1OfReal, Sh: GeomAbs_Shape) -> None: ...
	@staticmethod
	def UPeriod(S: None) -> float: ...
	@staticmethod
	def UResolution(S: None, R3d: float) -> float: ...
	@staticmethod
	def UTrim(S: None, First: float, Last: float, Tol: float) -> Adaptor3d_HSurface: ...
	@staticmethod
	def VIntervals(S: None, T: TColStd_Array1OfReal, Sh: GeomAbs_Shape) -> None: ...
	@staticmethod
	def VPeriod(S: None) -> float: ...
	@staticmethod
	def VResolution(S: None, R3d: float) -> float: ...
	@staticmethod
	def VTrim(S: None, First: float, Last: float, Tol: float) -> Adaptor3d_HSurface: ...
	@staticmethod
	def Value(S: None, u: float, v: float) -> gp_Pnt: ...

class HLRBRep_TheCSFunctionOfInterCSurf(math_FunctionSetWithDerivatives):
	def __init__(self, S: None, C: gp_Lin) -> None: ...
	def AuxillarCurve(self) -> gp_Lin: ...
	def AuxillarSurface(self) -> None: ...
	def Derivatives(self, X: math_Vector, D: math_Matrix) -> bool: ...
	def NbEquations(self) -> int: ...
	def NbVariables(self) -> int: ...
	def Point(self) -> gp_Pnt: ...
	def Root(self) -> float: ...
	def Value(self, X: math_Vector, F: math_Vector) -> bool: ...
	def Values(self, X: math_Vector, F: math_Vector, D: math_Matrix) -> bool: ...

class HLRBRep_TheDistBetweenPCurvesOfTheIntPCurvePCurveOfCInter(math_FunctionSetWithDerivatives):
	def __init__(self, curve1: None, curve2: None) -> None: ...
	def Derivatives(self, X: math_Vector, D: math_Matrix) -> bool: ...
	def NbEquations(self) -> int: ...
	def NbVariables(self) -> int: ...
	def Value(self, X: math_Vector, F: math_Vector) -> bool: ...
	def Values(self, X: math_Vector, F: math_Vector, D: math_Matrix) -> bool: ...

class HLRBRep_TheExactInterCSurf:
	@overload
	def __init__(self, U: float, V: float, W: float, F: HLRBRep_TheCSFunctionOfInterCSurf, TolTangency: float, MarginCoef: Optional[float] = 0.0) -> None: ...
	@overload
	def __init__(self, F: HLRBRep_TheCSFunctionOfInterCSurf, TolTangency: float) -> None: ...
	def Function(self) -> HLRBRep_TheCSFunctionOfInterCSurf: ...
	def IsDone(self) -> bool: ...
	def IsEmpty(self) -> bool: ...
	def ParameterOnCurve(self) -> float: ...
	def ParameterOnSurface(self) -> Tuple[float, float]: ...
	def Perform(self, U: float, V: float, W: float, Rsnld: math_FunctionSetRoot, u0: float, v0: float, u1: float, v1: float, w0: float, w1: float) -> None: ...
	def Point(self) -> gp_Pnt: ...

class HLRBRep_TheIntConicCurveOfCInter(IntRes2d_Intersection):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, L: gp_Lin2d, D1: IntRes2d_Domain, PCurve: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def __init__(self, C: gp_Circ2d, D1: IntRes2d_Domain, PCurve: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def __init__(self, E: gp_Elips2d, D1: IntRes2d_Domain, PCurve: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def __init__(self, Prb: gp_Parab2d, D1: IntRes2d_Domain, PCurve: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def __init__(self, H: gp_Hypr2d, D1: IntRes2d_Domain, PCurve: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def Perform(self, L: gp_Lin2d, D1: IntRes2d_Domain, PCurve: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def Perform(self, C: gp_Circ2d, D1: IntRes2d_Domain, PCurve: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def Perform(self, E: gp_Elips2d, D1: IntRes2d_Domain, PCurve: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def Perform(self, Prb: gp_Parab2d, D1: IntRes2d_Domain, PCurve: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def Perform(self, H: gp_Hypr2d, D1: IntRes2d_Domain, PCurve: None, D2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...

class HLRBRep_TheIntPCurvePCurveOfCInter(IntRes2d_Intersection):
	def __init__(self) -> None: ...
	def GetMinNbSamples(self) -> int: ...
	@overload
	def Perform(self, Curve1: None, Domain1: IntRes2d_Domain, Curve2: None, Domain2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	@overload
	def Perform(self, Curve1: None, Domain1: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	def SetMinNbSamples(self, theMinNbSamples: int) -> None: ...

class HLRBRep_TheInterferenceOfInterCSurf(Intf_Interference):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, thePolyg: HLRBRep_ThePolygonOfInterCSurf, thePolyh: HLRBRep_ThePolyhedronOfInterCSurf) -> None: ...
	@overload
	def __init__(self, theLin: gp_Lin, thePolyh: HLRBRep_ThePolyhedronOfInterCSurf) -> None: ...
	@overload
	def __init__(self, theLins: Intf_Array1OfLin, thePolyh: HLRBRep_ThePolyhedronOfInterCSurf) -> None: ...
	@overload
	def __init__(self, thePolyg: HLRBRep_ThePolygonOfInterCSurf, thePolyh: HLRBRep_ThePolyhedronOfInterCSurf, theBoundSB: Bnd_BoundSortBox) -> None: ...
	@overload
	def __init__(self, theLin: gp_Lin, thePolyh: HLRBRep_ThePolyhedronOfInterCSurf, theBoundSB: Bnd_BoundSortBox) -> None: ...
	@overload
	def __init__(self, theLins: Intf_Array1OfLin, thePolyh: HLRBRep_ThePolyhedronOfInterCSurf, theBoundSB: Bnd_BoundSortBox) -> None: ...
	@overload
	def Interference(self, thePolyg: HLRBRep_ThePolygonOfInterCSurf, thePolyh: HLRBRep_ThePolyhedronOfInterCSurf, theBoundSB: Bnd_BoundSortBox) -> None: ...
	@overload
	def Interference(self, thePolyg: HLRBRep_ThePolygonOfInterCSurf, thePolyh: HLRBRep_ThePolyhedronOfInterCSurf) -> None: ...
	@overload
	def Perform(self, thePolyg: HLRBRep_ThePolygonOfInterCSurf, thePolyh: HLRBRep_ThePolyhedronOfInterCSurf) -> None: ...
	@overload
	def Perform(self, theLin: gp_Lin, thePolyh: HLRBRep_ThePolyhedronOfInterCSurf) -> None: ...
	@overload
	def Perform(self, theLins: Intf_Array1OfLin, thePolyh: HLRBRep_ThePolyhedronOfInterCSurf) -> None: ...
	@overload
	def Perform(self, thePolyg: HLRBRep_ThePolygonOfInterCSurf, thePolyh: HLRBRep_ThePolyhedronOfInterCSurf, theBoundSB: Bnd_BoundSortBox) -> None: ...
	@overload
	def Perform(self, theLin: gp_Lin, thePolyh: HLRBRep_ThePolyhedronOfInterCSurf, theBoundSB: Bnd_BoundSortBox) -> None: ...
	@overload
	def Perform(self, theLins: Intf_Array1OfLin, thePolyh: HLRBRep_ThePolyhedronOfInterCSurf, theBoundSB: Bnd_BoundSortBox) -> None: ...

class HLRBRep_TheIntersectorOfTheIntConicCurveOfCInter(IntRes2d_Intersection):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, ITool: IntCurve_IConicTool, Dom1: IntRes2d_Domain, PCurve: None, Dom2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...
	def And_Domaine_Objet1_Intersections(self, TheImpTool: IntCurve_IConicTool, TheParCurve: None, TheImpCurveDomain: IntRes2d_Domain, TheParCurveDomain: IntRes2d_Domain, Inter2_And_Domain2: TColStd_Array1OfReal, Inter1: TColStd_Array1OfReal, Resultat1: TColStd_Array1OfReal, Resultat2: TColStd_Array1OfReal, EpsNul: float) -> int: ...
	def FindU(self, parameter: float, point: gp_Pnt2d, TheParCurev: None, TheImpTool: IntCurve_IConicTool) -> float: ...
	def FindV(self, parameter: float, point: gp_Pnt2d, TheImpTool: IntCurve_IConicTool, ParCurve: None, TheParCurveDomain: IntRes2d_Domain, V0: float, V1: float, Tolerance: float) -> float: ...
	def Perform(self, ITool: IntCurve_IConicTool, Dom1: IntRes2d_Domain, PCurve: None, Dom2: IntRes2d_Domain, TolConf: float, Tol: float) -> None: ...

class HLRBRep_TheLocateExtPCOfTheProjPCurOfCInter:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, P: gp_Pnt2d, C: None, U0: float, TolU: float) -> None: ...
	@overload
	def __init__(self, P: gp_Pnt2d, C: None, U0: float, Umin: float, Usup: float, TolU: float) -> None: ...
	def Initialize(self, C: None, Umin: float, Usup: float, TolU: float) -> None: ...
	def IsDone(self) -> bool: ...
	def IsMin(self) -> bool: ...
	def Perform(self, P: gp_Pnt2d, U0: float) -> None: ...
	def Point(self) -> Extrema_POnCurv2d: ...
	def SquareDistance(self) -> float: ...

class HLRBRep_ThePolygon2dOfTheIntPCurvePCurveOfCInter(Intf_Polygon2d):
	def __init__(self, Curve: None, NbPnt: int, Domain: IntRes2d_Domain, Tol: float) -> None: ...
	def ApproxParamOnCurve(self, Index: int, ParamOnLine: float) -> float: ...
	def AutoIntersectionIsPossible(self) -> bool: ...
	def CalculRegion(self, x: float, y: float, x1: float, x2: float, y1: float, y2: float) -> int: ...
	@overload
	def Closed(self, clos: bool) -> None: ...
	@overload
	def Closed(self) -> bool: ...
	def ComputeWithBox(self, Curve: None, OtherBox: Bnd_Box2d) -> None: ...
	def DeflectionOverEstimation(self) -> float: ...
	def Dump(self) -> None: ...
	def InfParameter(self) -> float: ...
	def NbSegments(self) -> int: ...
	def Segment(self, theIndex: int, theBegin: gp_Pnt2d, theEnd: gp_Pnt2d) -> None: ...
	def SetDeflectionOverEstimation(self, x: float) -> None: ...
	def SupParameter(self) -> float: ...

class HLRBRep_ThePolygonOfInterCSurf:
	@overload
	def __init__(self, Curve: gp_Lin, NbPnt: int) -> None: ...
	@overload
	def __init__(self, Curve: gp_Lin, U1: float, U2: float, NbPnt: int) -> None: ...
	@overload
	def __init__(self, Curve: gp_Lin, Upars: TColStd_Array1OfReal) -> None: ...
	def ApproxParamOnCurve(self, Index: int, ParamOnLine: float) -> float: ...
	def BeginOfSeg(self, Index: int) -> gp_Pnt: ...
	def Bounding(self) -> Bnd_Box: ...
	@overload
	def Closed(self, clos: bool) -> None: ...
	@overload
	def Closed(self) -> bool: ...
	def DeflectionOverEstimation(self) -> float: ...
	def Dump(self) -> None: ...
	def EndOfSeg(self, Index: int) -> gp_Pnt: ...
	def InfParameter(self) -> float: ...
	def NbSegments(self) -> int: ...
	def SetDeflectionOverEstimation(self, x: float) -> None: ...
	def SupParameter(self) -> float: ...

class HLRBRep_ThePolygonToolOfInterCSurf:
	@staticmethod
	def BeginOfSeg(thePolygon: HLRBRep_ThePolygonOfInterCSurf, Index: int) -> gp_Pnt: ...
	@staticmethod
	def Bounding(thePolygon: HLRBRep_ThePolygonOfInterCSurf) -> Bnd_Box: ...
	@staticmethod
	def Closed(thePolygon: HLRBRep_ThePolygonOfInterCSurf) -> bool: ...
	@staticmethod
	def DeflectionOverEstimation(thePolygon: HLRBRep_ThePolygonOfInterCSurf) -> float: ...
	@staticmethod
	def Dump(thePolygon: HLRBRep_ThePolygonOfInterCSurf) -> None: ...
	@staticmethod
	def EndOfSeg(thePolygon: HLRBRep_ThePolygonOfInterCSurf, Index: int) -> gp_Pnt: ...
	@staticmethod
	def NbSegments(thePolygon: HLRBRep_ThePolygonOfInterCSurf) -> int: ...

class HLRBRep_ThePolyhedronToolOfInterCSurf:
	@staticmethod
	def Bounding(thePolyh: HLRBRep_ThePolyhedronOfInterCSurf) -> Bnd_Box: ...
	@staticmethod
	def ComponentsBounding(thePolyh: HLRBRep_ThePolyhedronOfInterCSurf) -> Bnd_HArray1OfBox: ...
	@staticmethod
	def DeflectionOverEstimation(thePolyh: HLRBRep_ThePolyhedronOfInterCSurf) -> float: ...
	@staticmethod
	def Dump(thePolyh: HLRBRep_ThePolyhedronOfInterCSurf) -> None: ...
	@staticmethod
	def GetBorderDeflection(thePolyh: HLRBRep_ThePolyhedronOfInterCSurf) -> float: ...
	@staticmethod
	def IsOnBound(thePolyh: HLRBRep_ThePolyhedronOfInterCSurf, Index1: int, Index2: int) -> bool: ...
	@staticmethod
	def NbTriangles(thePolyh: HLRBRep_ThePolyhedronOfInterCSurf) -> int: ...
	@staticmethod
	def Point(thePolyh: HLRBRep_ThePolyhedronOfInterCSurf, Index: int) -> gp_Pnt: ...
	@staticmethod
	def TriConnex(thePolyh: HLRBRep_ThePolyhedronOfInterCSurf, Triang: int, Pivot: int, Pedge: int) -> Tuple[int, int, int]: ...
	@staticmethod
	def Triangle(thePolyh: HLRBRep_ThePolyhedronOfInterCSurf, Index: int) -> Tuple[int, int, int]: ...

class HLRBRep_TheProjPCurOfCInter:
	@overload
	@staticmethod
	def FindParameter(C: None, Pnt: gp_Pnt2d, Tol: float) -> float: ...
	@overload
	@staticmethod
	def FindParameter(C: None, Pnt: gp_Pnt2d, LowParameter: float, HighParameter: float, Tol: float) -> float: ...

class HLRBRep_TheQuadCurvExactInterCSurf:
	def __init__(self, S: None, C: gp_Lin) -> None: ...
	def Intervals(self, Index: int) -> Tuple[float, float]: ...
	def IsDone(self) -> bool: ...
	def NbIntervals(self) -> int: ...
	def NbRoots(self) -> int: ...
	def Root(self, Index: int) -> float: ...

class HLRBRep_TheQuadCurvFuncOfTheQuadCurvExactInterCSurf(math_FunctionWithDerivative):
	def __init__(self, Q: IntSurf_Quadric, C: gp_Lin) -> None: ...
	def Derivative(self, Param: float) -> Tuple[bool, float]: ...
	def Value(self, Param: float) -> Tuple[bool, float]: ...
	def Values(self, Param: float) -> Tuple[bool, float, float]: ...

class HLRBRep_VertexList:
	def __init__(self, T: HLRBRep_EdgeInterferenceTool, I: HLRAlgo_ListIteratorOfInterferenceList) -> None: ...
	def BoundaryTransition(self) -> TopAbs_Orientation: ...
	def Current(self) -> HLRAlgo_Intersection: ...
	def IsBoundary(self) -> bool: ...
	def IsInterference(self) -> bool: ...
	def IsPeriodic(self) -> bool: ...
	def More(self) -> bool: ...
	def Next(self) -> None: ...
	def Orientation(self) -> TopAbs_Orientation: ...
	def Transition(self) -> TopAbs_Orientation: ...

class HLRBRep_Algo(HLRBRep_InternalAlgo):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, A: HLRBRep_Algo) -> None: ...
	@overload
	def Add(self, S: TopoDS_Shape, SData: Standard_Transient, nbIso: Optional[int] = 0) -> None: ...
	@overload
	def Add(self, S: TopoDS_Shape, nbIso: Optional[int] = 0) -> None: ...
	def Index(self, S: TopoDS_Shape) -> int: ...
	def OutLinedShapeNullify(self) -> None: ...

#classnotwrapped
class HLRBRep_ThePolyhedronOfInterCSurf: ...

#classnotwrapped
class HLRBRep_BSurfaceTool: ...

#classnotwrapped
class HLRBRep_Surface: ...

#classnotwrapped
class HLRBRep_TheCurveLocatorOfTheProjPCurOfCInter: ...

# harray1 classes
# harray2 classes
# hsequence classes

hlrbrep_MakeEdge = hlrbrep.MakeEdge
hlrbrep_MakeEdge3d = hlrbrep.MakeEdge3d
hlrbrep_PolyHLRAngleAndDeflection = hlrbrep.PolyHLRAngleAndDeflection
HLRBRep_BCurveTool_BSpline = HLRBRep_BCurveTool.BSpline
HLRBRep_BCurveTool_Bezier = HLRBRep_BCurveTool.Bezier
HLRBRep_BCurveTool_Circle = HLRBRep_BCurveTool.Circle
HLRBRep_BCurveTool_Continuity = HLRBRep_BCurveTool.Continuity
HLRBRep_BCurveTool_D0 = HLRBRep_BCurveTool.D0
HLRBRep_BCurveTool_D1 = HLRBRep_BCurveTool.D1
HLRBRep_BCurveTool_D2 = HLRBRep_BCurveTool.D2
HLRBRep_BCurveTool_D3 = HLRBRep_BCurveTool.D3
HLRBRep_BCurveTool_DN = HLRBRep_BCurveTool.DN
HLRBRep_BCurveTool_Degree = HLRBRep_BCurveTool.Degree
HLRBRep_BCurveTool_Ellipse = HLRBRep_BCurveTool.Ellipse
HLRBRep_BCurveTool_FirstParameter = HLRBRep_BCurveTool.FirstParameter
HLRBRep_BCurveTool_GetType = HLRBRep_BCurveTool.GetType
HLRBRep_BCurveTool_Hyperbola = HLRBRep_BCurveTool.Hyperbola
HLRBRep_BCurveTool_Intervals = HLRBRep_BCurveTool.Intervals
HLRBRep_BCurveTool_IsClosed = HLRBRep_BCurveTool.IsClosed
HLRBRep_BCurveTool_IsPeriodic = HLRBRep_BCurveTool.IsPeriodic
HLRBRep_BCurveTool_IsRational = HLRBRep_BCurveTool.IsRational
HLRBRep_BCurveTool_LastParameter = HLRBRep_BCurveTool.LastParameter
HLRBRep_BCurveTool_Line = HLRBRep_BCurveTool.Line
HLRBRep_BCurveTool_NbIntervals = HLRBRep_BCurveTool.NbIntervals
HLRBRep_BCurveTool_NbKnots = HLRBRep_BCurveTool.NbKnots
HLRBRep_BCurveTool_NbPoles = HLRBRep_BCurveTool.NbPoles
HLRBRep_BCurveTool_NbSamples = HLRBRep_BCurveTool.NbSamples
HLRBRep_BCurveTool_Parabola = HLRBRep_BCurveTool.Parabola
HLRBRep_BCurveTool_Period = HLRBRep_BCurveTool.Period
HLRBRep_BCurveTool_Poles = HLRBRep_BCurveTool.Poles
HLRBRep_BCurveTool_PolesAndWeights = HLRBRep_BCurveTool.PolesAndWeights
HLRBRep_BCurveTool_Resolution = HLRBRep_BCurveTool.Resolution
HLRBRep_BCurveTool_Value = HLRBRep_BCurveTool.Value
HLRBRep_CLPropsATool_Continuity = HLRBRep_CLPropsATool.Continuity
HLRBRep_CLPropsATool_D1 = HLRBRep_CLPropsATool.D1
HLRBRep_CLPropsATool_D2 = HLRBRep_CLPropsATool.D2
HLRBRep_CLPropsATool_D3 = HLRBRep_CLPropsATool.D3
HLRBRep_CLPropsATool_FirstParameter = HLRBRep_CLPropsATool.FirstParameter
HLRBRep_CLPropsATool_LastParameter = HLRBRep_CLPropsATool.LastParameter
HLRBRep_CLPropsATool_Value = HLRBRep_CLPropsATool.Value
HLRBRep_CurveTool_BSpline = HLRBRep_CurveTool.BSpline
HLRBRep_CurveTool_Bezier = HLRBRep_CurveTool.Bezier
HLRBRep_CurveTool_Circle = HLRBRep_CurveTool.Circle
HLRBRep_CurveTool_Continuity = HLRBRep_CurveTool.Continuity
HLRBRep_CurveTool_D0 = HLRBRep_CurveTool.D0
HLRBRep_CurveTool_D1 = HLRBRep_CurveTool.D1
HLRBRep_CurveTool_D2 = HLRBRep_CurveTool.D2
HLRBRep_CurveTool_D3 = HLRBRep_CurveTool.D3
HLRBRep_CurveTool_DN = HLRBRep_CurveTool.DN
HLRBRep_CurveTool_Degree = HLRBRep_CurveTool.Degree
HLRBRep_CurveTool_Ellipse = HLRBRep_CurveTool.Ellipse
HLRBRep_CurveTool_EpsX = HLRBRep_CurveTool.EpsX
HLRBRep_CurveTool_FirstParameter = HLRBRep_CurveTool.FirstParameter
HLRBRep_CurveTool_GetInterval = HLRBRep_CurveTool.GetInterval
HLRBRep_CurveTool_GetType = HLRBRep_CurveTool.GetType
HLRBRep_CurveTool_Hyperbola = HLRBRep_CurveTool.Hyperbola
HLRBRep_CurveTool_Intervals = HLRBRep_CurveTool.Intervals
HLRBRep_CurveTool_IsClosed = HLRBRep_CurveTool.IsClosed
HLRBRep_CurveTool_IsPeriodic = HLRBRep_CurveTool.IsPeriodic
HLRBRep_CurveTool_LastParameter = HLRBRep_CurveTool.LastParameter
HLRBRep_CurveTool_Line = HLRBRep_CurveTool.Line
HLRBRep_CurveTool_NbIntervals = HLRBRep_CurveTool.NbIntervals
HLRBRep_CurveTool_NbSamples = HLRBRep_CurveTool.NbSamples
HLRBRep_CurveTool_NbSamples = HLRBRep_CurveTool.NbSamples
HLRBRep_CurveTool_Parabola = HLRBRep_CurveTool.Parabola
HLRBRep_CurveTool_Period = HLRBRep_CurveTool.Period
HLRBRep_CurveTool_Resolution = HLRBRep_CurveTool.Resolution
HLRBRep_CurveTool_TheType = HLRBRep_CurveTool.TheType
HLRBRep_CurveTool_Value = HLRBRep_CurveTool.Value
HLRBRep_EdgeFaceTool_CurvatureValue = HLRBRep_EdgeFaceTool.CurvatureValue
HLRBRep_EdgeFaceTool_UVPoint = HLRBRep_EdgeFaceTool.UVPoint
HLRBRep_EdgeIList_AddInterference = HLRBRep_EdgeIList.AddInterference
HLRBRep_EdgeIList_ProcessComplex = HLRBRep_EdgeIList.ProcessComplex
HLRBRep_LineTool_BSpline = HLRBRep_LineTool.BSpline
HLRBRep_LineTool_Bezier = HLRBRep_LineTool.Bezier
HLRBRep_LineTool_Circle = HLRBRep_LineTool.Circle
HLRBRep_LineTool_Continuity = HLRBRep_LineTool.Continuity
HLRBRep_LineTool_D0 = HLRBRep_LineTool.D0
HLRBRep_LineTool_D1 = HLRBRep_LineTool.D1
HLRBRep_LineTool_D2 = HLRBRep_LineTool.D2
HLRBRep_LineTool_D3 = HLRBRep_LineTool.D3
HLRBRep_LineTool_DN = HLRBRep_LineTool.DN
HLRBRep_LineTool_Degree = HLRBRep_LineTool.Degree
HLRBRep_LineTool_Ellipse = HLRBRep_LineTool.Ellipse
HLRBRep_LineTool_FirstParameter = HLRBRep_LineTool.FirstParameter
HLRBRep_LineTool_GetType = HLRBRep_LineTool.GetType
HLRBRep_LineTool_Hyperbola = HLRBRep_LineTool.Hyperbola
HLRBRep_LineTool_IntervalContinuity = HLRBRep_LineTool.IntervalContinuity
HLRBRep_LineTool_IntervalFirst = HLRBRep_LineTool.IntervalFirst
HLRBRep_LineTool_IntervalLast = HLRBRep_LineTool.IntervalLast
HLRBRep_LineTool_Intervals = HLRBRep_LineTool.Intervals
HLRBRep_LineTool_IsClosed = HLRBRep_LineTool.IsClosed
HLRBRep_LineTool_IsPeriodic = HLRBRep_LineTool.IsPeriodic
HLRBRep_LineTool_IsRational = HLRBRep_LineTool.IsRational
HLRBRep_LineTool_KnotsAndMultiplicities = HLRBRep_LineTool.KnotsAndMultiplicities
HLRBRep_LineTool_LastParameter = HLRBRep_LineTool.LastParameter
HLRBRep_LineTool_Line = HLRBRep_LineTool.Line
HLRBRep_LineTool_NbIntervals = HLRBRep_LineTool.NbIntervals
HLRBRep_LineTool_NbKnots = HLRBRep_LineTool.NbKnots
HLRBRep_LineTool_NbPoles = HLRBRep_LineTool.NbPoles
HLRBRep_LineTool_NbSamples = HLRBRep_LineTool.NbSamples
HLRBRep_LineTool_Parabola = HLRBRep_LineTool.Parabola
HLRBRep_LineTool_Period = HLRBRep_LineTool.Period
HLRBRep_LineTool_Poles = HLRBRep_LineTool.Poles
HLRBRep_LineTool_PolesAndWeights = HLRBRep_LineTool.PolesAndWeights
HLRBRep_LineTool_Resolution = HLRBRep_LineTool.Resolution
HLRBRep_LineTool_SamplePars = HLRBRep_LineTool.SamplePars
HLRBRep_LineTool_Value = HLRBRep_LineTool.Value
HLRBRep_SLPropsATool_Bounds = HLRBRep_SLPropsATool.Bounds
HLRBRep_SLPropsATool_Continuity = HLRBRep_SLPropsATool.Continuity
HLRBRep_SLPropsATool_D1 = HLRBRep_SLPropsATool.D1
HLRBRep_SLPropsATool_D2 = HLRBRep_SLPropsATool.D2
HLRBRep_SLPropsATool_DN = HLRBRep_SLPropsATool.DN
HLRBRep_SLPropsATool_Value = HLRBRep_SLPropsATool.Value
HLRBRep_ShapeToHLR_Load = HLRBRep_ShapeToHLR.Load
HLRBRep_SurfaceTool_AxeOfRevolution = HLRBRep_SurfaceTool.AxeOfRevolution
HLRBRep_SurfaceTool_BSpline = HLRBRep_SurfaceTool.BSpline
HLRBRep_SurfaceTool_BasisCurve = HLRBRep_SurfaceTool.BasisCurve
HLRBRep_SurfaceTool_BasisSurface = HLRBRep_SurfaceTool.BasisSurface
HLRBRep_SurfaceTool_Bezier = HLRBRep_SurfaceTool.Bezier
HLRBRep_SurfaceTool_Cone = HLRBRep_SurfaceTool.Cone
HLRBRep_SurfaceTool_Cylinder = HLRBRep_SurfaceTool.Cylinder
HLRBRep_SurfaceTool_D0 = HLRBRep_SurfaceTool.D0
HLRBRep_SurfaceTool_D1 = HLRBRep_SurfaceTool.D1
HLRBRep_SurfaceTool_D2 = HLRBRep_SurfaceTool.D2
HLRBRep_SurfaceTool_D3 = HLRBRep_SurfaceTool.D3
HLRBRep_SurfaceTool_DN = HLRBRep_SurfaceTool.DN
HLRBRep_SurfaceTool_Direction = HLRBRep_SurfaceTool.Direction
HLRBRep_SurfaceTool_FirstUParameter = HLRBRep_SurfaceTool.FirstUParameter
HLRBRep_SurfaceTool_FirstVParameter = HLRBRep_SurfaceTool.FirstVParameter
HLRBRep_SurfaceTool_GetType = HLRBRep_SurfaceTool.GetType
HLRBRep_SurfaceTool_IsUClosed = HLRBRep_SurfaceTool.IsUClosed
HLRBRep_SurfaceTool_IsUPeriodic = HLRBRep_SurfaceTool.IsUPeriodic
HLRBRep_SurfaceTool_IsVClosed = HLRBRep_SurfaceTool.IsVClosed
HLRBRep_SurfaceTool_IsVPeriodic = HLRBRep_SurfaceTool.IsVPeriodic
HLRBRep_SurfaceTool_LastUParameter = HLRBRep_SurfaceTool.LastUParameter
HLRBRep_SurfaceTool_LastVParameter = HLRBRep_SurfaceTool.LastVParameter
HLRBRep_SurfaceTool_NbSamplesU = HLRBRep_SurfaceTool.NbSamplesU
HLRBRep_SurfaceTool_NbSamplesU = HLRBRep_SurfaceTool.NbSamplesU
HLRBRep_SurfaceTool_NbSamplesV = HLRBRep_SurfaceTool.NbSamplesV
HLRBRep_SurfaceTool_NbSamplesV = HLRBRep_SurfaceTool.NbSamplesV
HLRBRep_SurfaceTool_NbUIntervals = HLRBRep_SurfaceTool.NbUIntervals
HLRBRep_SurfaceTool_NbVIntervals = HLRBRep_SurfaceTool.NbVIntervals
HLRBRep_SurfaceTool_OffsetValue = HLRBRep_SurfaceTool.OffsetValue
HLRBRep_SurfaceTool_Plane = HLRBRep_SurfaceTool.Plane
HLRBRep_SurfaceTool_Sphere = HLRBRep_SurfaceTool.Sphere
HLRBRep_SurfaceTool_Torus = HLRBRep_SurfaceTool.Torus
HLRBRep_SurfaceTool_UIntervals = HLRBRep_SurfaceTool.UIntervals
HLRBRep_SurfaceTool_UPeriod = HLRBRep_SurfaceTool.UPeriod
HLRBRep_SurfaceTool_UResolution = HLRBRep_SurfaceTool.UResolution
HLRBRep_SurfaceTool_UTrim = HLRBRep_SurfaceTool.UTrim
HLRBRep_SurfaceTool_VIntervals = HLRBRep_SurfaceTool.VIntervals
HLRBRep_SurfaceTool_VPeriod = HLRBRep_SurfaceTool.VPeriod
HLRBRep_SurfaceTool_VResolution = HLRBRep_SurfaceTool.VResolution
HLRBRep_SurfaceTool_VTrim = HLRBRep_SurfaceTool.VTrim
HLRBRep_SurfaceTool_Value = HLRBRep_SurfaceTool.Value
HLRBRep_ThePolygonToolOfInterCSurf_BeginOfSeg = HLRBRep_ThePolygonToolOfInterCSurf.BeginOfSeg
HLRBRep_ThePolygonToolOfInterCSurf_Bounding = HLRBRep_ThePolygonToolOfInterCSurf.Bounding
HLRBRep_ThePolygonToolOfInterCSurf_Closed = HLRBRep_ThePolygonToolOfInterCSurf.Closed
HLRBRep_ThePolygonToolOfInterCSurf_DeflectionOverEstimation = HLRBRep_ThePolygonToolOfInterCSurf.DeflectionOverEstimation
HLRBRep_ThePolygonToolOfInterCSurf_Dump = HLRBRep_ThePolygonToolOfInterCSurf.Dump
HLRBRep_ThePolygonToolOfInterCSurf_EndOfSeg = HLRBRep_ThePolygonToolOfInterCSurf.EndOfSeg
HLRBRep_ThePolygonToolOfInterCSurf_NbSegments = HLRBRep_ThePolygonToolOfInterCSurf.NbSegments
HLRBRep_ThePolyhedronToolOfInterCSurf_Bounding = HLRBRep_ThePolyhedronToolOfInterCSurf.Bounding
HLRBRep_ThePolyhedronToolOfInterCSurf_ComponentsBounding = HLRBRep_ThePolyhedronToolOfInterCSurf.ComponentsBounding
HLRBRep_ThePolyhedronToolOfInterCSurf_DeflectionOverEstimation = HLRBRep_ThePolyhedronToolOfInterCSurf.DeflectionOverEstimation
HLRBRep_ThePolyhedronToolOfInterCSurf_Dump = HLRBRep_ThePolyhedronToolOfInterCSurf.Dump
HLRBRep_ThePolyhedronToolOfInterCSurf_GetBorderDeflection = HLRBRep_ThePolyhedronToolOfInterCSurf.GetBorderDeflection
HLRBRep_ThePolyhedronToolOfInterCSurf_IsOnBound = HLRBRep_ThePolyhedronToolOfInterCSurf.IsOnBound
HLRBRep_ThePolyhedronToolOfInterCSurf_NbTriangles = HLRBRep_ThePolyhedronToolOfInterCSurf.NbTriangles
HLRBRep_ThePolyhedronToolOfInterCSurf_Point = HLRBRep_ThePolyhedronToolOfInterCSurf.Point
HLRBRep_ThePolyhedronToolOfInterCSurf_TriConnex = HLRBRep_ThePolyhedronToolOfInterCSurf.TriConnex
HLRBRep_ThePolyhedronToolOfInterCSurf_Triangle = HLRBRep_ThePolyhedronToolOfInterCSurf.Triangle
HLRBRep_TheProjPCurOfCInter_FindParameter = HLRBRep_TheProjPCurOfCInter.FindParameter
HLRBRep_TheProjPCurOfCInter_FindParameter = HLRBRep_TheProjPCurOfCInter.FindParameter
