# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
BinTools module, see official documentation at
https://www.opencascade.com/doc/occt-7.4.0/refman/html/package_bintools.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _BinTools
else:
    import _BinTools

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _BinTools.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _BinTools.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _BinTools.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _BinTools.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _BinTools.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _BinTools.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _BinTools.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _BinTools.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _BinTools.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _BinTools.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _BinTools.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _BinTools.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _BinTools.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _BinTools.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _BinTools.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _BinTools.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _BinTools.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _BinTools:
_BinTools.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _BinTools.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TopoDS
import OCC.Core.Message
import OCC.Core.TCollection
import OCC.Core.TColStd
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.gp
import OCC.Core.Geom2d
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.Geom

from enum import IntEnum
from OCC.Core.Exception import *



class bintools(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Read(*args) -> "Standard_Boolean":
        r"""
        Reads a shape from <thefile> and returns it in <theshape>.

        Parameters
        ----------
        theShape: TopoDS_Shape
        theFile: char *

        Returns
        -------
        bool

        """
        return _BinTools.bintools_Read(*args)

    @staticmethod
    def Write(*args) -> "Standard_Boolean":
        r"""
        Writes <theshape> in <thefile>.

        Parameters
        ----------
        theShape: TopoDS_Shape
        theFile: char *

        Returns
        -------
        bool

        """
        return _BinTools.bintools_Write(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _BinTools.bintools_swiginit(self, _BinTools.new_bintools())
    __swig_destroy__ = _BinTools.delete_bintools

# Register bintools in _BinTools:
_BinTools.bintools_swigregister(bintools)

def bintools_Read(*args) -> "Standard_Boolean":
    r"""
    Reads a shape from <thefile> and returns it in <theshape>.

    Parameters
    ----------
    theShape: TopoDS_Shape
    theFile: char *

    Returns
    -------
    bool

    """
    return _BinTools.bintools_Read(*args)

def bintools_Write(*args) -> "Standard_Boolean":
    r"""
    Writes <theshape> in <thefile>.

    Parameters
    ----------
    theShape: TopoDS_Shape
    theFile: char *

    Returns
    -------
    bool

    """
    return _BinTools.bintools_Write(*args)

class BinTools_Curve2dSet(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Returns an empty set of curves.

        Returns
        -------
        None

        """
        _BinTools.BinTools_Curve2dSet_swiginit(self, _BinTools.new_BinTools_Curve2dSet(*args))

    def Add(self, *args) -> "Standard_Integer":
        r"""
        Incorporate a new curve in the set and returns its index.

        Parameters
        ----------
        C: Geom2d_Curve

        Returns
        -------
        int

        """
        return _BinTools.BinTools_Curve2dSet_Add(self, *args)

    def Clear(self, *args) -> "void":
        r"""
        Clears the content of the set.

        Returns
        -------
        None

        """
        return _BinTools.BinTools_Curve2dSet_Clear(self, *args)

    def Curve2d(self, *args) -> "opencascade::handle< Geom2d_Curve >":
        r"""
        Returns the curve of index <i>.

        Parameters
        ----------
        I: int

        Returns
        -------
        opencascade::handle<Geom2d_Curve>

        """
        return _BinTools.BinTools_Curve2dSet_Curve2d(self, *args)

    def Index(self, *args) -> "Standard_Integer":
        r"""
        Returns the index of <l>.

        Parameters
        ----------
        C: Geom2d_Curve

        Returns
        -------
        int

        """
        return _BinTools.BinTools_Curve2dSet_Index(self, *args)

    def ReadFromString(self, src: "std::string") -> "void":
        r"""ReadFromString(BinTools_Curve2dSet self, std::string src)"""
        return _BinTools.BinTools_Curve2dSet_ReadFromString(self, src)

    def WriteToString(self) -> "std::string":
        r"""WriteToString(BinTools_Curve2dSet self) -> std::string"""
        return _BinTools.BinTools_Curve2dSet_WriteToString(self)

    __repr__ = _dumps_object

    @methodnotwrapped
    def Dump(self):
    	pass

    __swig_destroy__ = _BinTools.delete_BinTools_Curve2dSet

# Register BinTools_Curve2dSet in _BinTools:
_BinTools.BinTools_Curve2dSet_swigregister(BinTools_Curve2dSet)

class BinTools_CurveSet(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Returns an empty set of curves.

        Returns
        -------
        None

        """
        _BinTools.BinTools_CurveSet_swiginit(self, _BinTools.new_BinTools_CurveSet(*args))

    def Add(self, *args) -> "Standard_Integer":
        r"""
        Incorporate a new curve in the set and returns its index.

        Parameters
        ----------
        C: Geom_Curve

        Returns
        -------
        int

        """
        return _BinTools.BinTools_CurveSet_Add(self, *args)

    def Clear(self, *args) -> "void":
        r"""
        Clears the content of the set.

        Returns
        -------
        None

        """
        return _BinTools.BinTools_CurveSet_Clear(self, *args)

    def Curve(self, *args) -> "opencascade::handle< Geom_Curve >":
        r"""
        Returns the curve of index <i>.

        Parameters
        ----------
        I: int

        Returns
        -------
        opencascade::handle<Geom_Curve>

        """
        return _BinTools.BinTools_CurveSet_Curve(self, *args)

    def Index(self, *args) -> "Standard_Integer":
        r"""
        Returns the index of <l>.

        Parameters
        ----------
        C: Geom_Curve

        Returns
        -------
        int

        """
        return _BinTools.BinTools_CurveSet_Index(self, *args)

    def ReadFromString(self, src: "std::string") -> "void":
        r"""ReadFromString(BinTools_CurveSet self, std::string src)"""
        return _BinTools.BinTools_CurveSet_ReadFromString(self, src)

    def WriteToString(self) -> "std::string":
        r"""WriteToString(BinTools_CurveSet self) -> std::string"""
        return _BinTools.BinTools_CurveSet_WriteToString(self)

    __repr__ = _dumps_object

    __swig_destroy__ = _BinTools.delete_BinTools_CurveSet

# Register BinTools_CurveSet in _BinTools:
_BinTools.BinTools_CurveSet_swigregister(BinTools_CurveSet)

class BinTools_LocationSet(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Returns an empty set of locations.

        Returns
        -------
        None

        """
        _BinTools.BinTools_LocationSet_swiginit(self, _BinTools.new_BinTools_LocationSet(*args))

    def Add(self, *args) -> "Standard_Integer":
        r"""
        Incorporate a new location in the set and returns its index.

        Parameters
        ----------
        L: TopLoc_Location

        Returns
        -------
        int

        """
        return _BinTools.BinTools_LocationSet_Add(self, *args)

    def Clear(self, *args) -> "void":
        r"""
        Clears the content of the set.

        Returns
        -------
        None

        """
        return _BinTools.BinTools_LocationSet_Clear(self, *args)

    def Index(self, *args) -> "Standard_Integer":
        r"""
        Returns the index of <l>.

        Parameters
        ----------
        L: TopLoc_Location

        Returns
        -------
        int

        """
        return _BinTools.BinTools_LocationSet_Index(self, *args)

    def Location(self, *args) -> "TopLoc_Location const &":
        r"""
        Returns the location of index <i>.

        Parameters
        ----------
        I: int

        Returns
        -------
        TopLoc_Location

        """
        return _BinTools.BinTools_LocationSet_Location(self, *args)

    def NbLocations(self, *args) -> "Standard_Integer":
        r"""
        Returns number of locations.

        Returns
        -------
        int

        """
        return _BinTools.BinTools_LocationSet_NbLocations(self, *args)

    def ReadFromString(self, src: "std::string") -> "void":
        r"""ReadFromString(BinTools_LocationSet self, std::string src)"""
        return _BinTools.BinTools_LocationSet_ReadFromString(self, src)

    def WriteToString(self) -> "std::string":
        r"""WriteToString(BinTools_LocationSet self) -> std::string"""
        return _BinTools.BinTools_LocationSet_WriteToString(self)

    __repr__ = _dumps_object

    __swig_destroy__ = _BinTools.delete_BinTools_LocationSet

# Register BinTools_LocationSet in _BinTools:
_BinTools.BinTools_LocationSet_swigregister(BinTools_LocationSet)

class BinTools_ShapeSet(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Builds an empty shapeset. parameter <iswithtriangles> is added for xml persistence.

        Parameters
        ----------
        isWithTriangles: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        _BinTools.BinTools_ShapeSet_swiginit(self, _BinTools.new_BinTools_ShapeSet(*args))

    def Add(self, *args) -> "Standard_Integer":
        r"""
        Stores <s> and its sub-shape. returns the index of <s>. the method addgeometry is called on each sub-shape.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        int

        """
        return _BinTools.BinTools_ShapeSet_Add(self, *args)

    def AddGeometry(self, *args) -> "void":
        r"""
        Stores the goemetry of <s>.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        None

        """
        return _BinTools.BinTools_ShapeSet_AddGeometry(self, *args)

    def AddShapes(self, *args) -> "void":
        r"""
        Inserts the shape <s2> in the shape <s1>.

        Parameters
        ----------
        S1: TopoDS_Shape
        S2: TopoDS_Shape

        Returns
        -------
        None

        """
        return _BinTools.BinTools_ShapeSet_AddShapes(self, *args)

    def ChangeLocations(self, *args) -> "BinTools_LocationSet &":
        r"""
        No available documentation.

        Returns
        -------
        BinTools_LocationSet

        """
        return _BinTools.BinTools_ShapeSet_ChangeLocations(self, *args)

    def Clear(self, *args) -> "void":
        r"""
        Clears the content of the set.

        Returns
        -------
        None

        """
        return _BinTools.BinTools_ShapeSet_Clear(self, *args)

    def FormatNb(self, *args) -> "Standard_Integer":
        r"""
        Two formats available for the moment: first: does not write curveonsurface uv points into the file on reading calls check() method. second: stores curveonsurface uv points. on reading format is recognized from version string.

        Returns
        -------
        int

        """
        return _BinTools.BinTools_ShapeSet_FormatNb(self, *args)

    def Index(self, *args) -> "Standard_Integer":
        r"""
        Returns the index of <s>.

        Parameters
        ----------
        S: TopoDS_Shape

        Returns
        -------
        int

        """
        return _BinTools.BinTools_ShapeSet_Index(self, *args)

    def IsWithTriangles(self, *args) -> "Standard_Boolean":
        r"""
        Return true if shape should be stored with triangles.

        Returns
        -------
        bool

        """
        return _BinTools.BinTools_ShapeSet_IsWithTriangles(self, *args)

    def Locations(self, *args) -> "BinTools_LocationSet const &":
        r"""
        No available documentation.

        Returns
        -------
        BinTools_LocationSet

        """
        return _BinTools.BinTools_ShapeSet_Locations(self, *args)

    def NbShapes(self, *args) -> "Standard_Integer":
        r"""
        Returns number of shapes read from file.

        Returns
        -------
        int

        """
        return _BinTools.BinTools_ShapeSet_NbShapes(self, *args)

    def ReadFromString(self, src: "std::string") -> "void":
        r"""ReadFromString(BinTools_ShapeSet self, std::string src)"""
        return _BinTools.BinTools_ShapeSet_ReadFromString(self, src)

    def ReadGeometryFromString(self, src: "std::string") -> "void":
        r"""ReadGeometryFromString(BinTools_ShapeSet self, std::string src)"""
        return _BinTools.BinTools_ShapeSet_ReadGeometryFromString(self, src)

    def ReadPolygon3DFromString(self, src: "std::string") -> "void":
        r"""ReadPolygon3DFromString(BinTools_ShapeSet self, std::string src)"""
        return _BinTools.BinTools_ShapeSet_ReadPolygon3DFromString(self, src)

    def ReadPolygonOnTriangulationFromString(self, src: "std::string") -> "void":
        r"""ReadPolygonOnTriangulationFromString(BinTools_ShapeSet self, std::string src)"""
        return _BinTools.BinTools_ShapeSet_ReadPolygonOnTriangulationFromString(self, src)

    def ReadTriangulationFromString(self, src: "std::string") -> "void":
        r"""ReadTriangulationFromString(BinTools_ShapeSet self, std::string src)"""
        return _BinTools.BinTools_ShapeSet_ReadTriangulationFromString(self, src)

    def SetFormatNb(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        theFormatNb: int

        Returns
        -------
        None

        """
        return _BinTools.BinTools_ShapeSet_SetFormatNb(self, *args)

    def SetWithTriangles(self, *args) -> "void":
        r"""
        Define if shape will be stored with triangles. ignored (always written) if face defines only triangulation (no surface).

        Parameters
        ----------
        isWithTriangles: bool

        Returns
        -------
        None

        """
        return _BinTools.BinTools_ShapeSet_SetWithTriangles(self, *args)

    def Shape(self, *args) -> "TopoDS_Shape const":
        r"""
        Returns the sub-shape of index <i>.

        Parameters
        ----------
        I: int

        Returns
        -------
        TopoDS_Shape

        """
        return _BinTools.BinTools_ShapeSet_Shape(self, *args)

    def WriteToString(self) -> "std::string":
        r"""WriteToString(BinTools_ShapeSet self) -> std::string"""
        return _BinTools.BinTools_ShapeSet_WriteToString(self)

    def WriteGeometryToString(self) -> "std::string":
        r"""WriteGeometryToString(BinTools_ShapeSet self) -> std::string"""
        return _BinTools.BinTools_ShapeSet_WriteGeometryToString(self)

    def WritePolygon3DToString(self) -> "std::string":
        r"""WritePolygon3DToString(BinTools_ShapeSet self) -> std::string"""
        return _BinTools.BinTools_ShapeSet_WritePolygon3DToString(self)

    def WritePolygonOnTriangulationToString(self) -> "std::string":
        r"""WritePolygonOnTriangulationToString(BinTools_ShapeSet self) -> std::string"""
        return _BinTools.BinTools_ShapeSet_WritePolygonOnTriangulationToString(self)

    def WriteTriangulationToString(self) -> "std::string":
        r"""WriteTriangulationToString(BinTools_ShapeSet self) -> std::string"""
        return _BinTools.BinTools_ShapeSet_WriteTriangulationToString(self)

    __repr__ = _dumps_object

    __swig_destroy__ = _BinTools.delete_BinTools_ShapeSet

# Register BinTools_ShapeSet in _BinTools:
_BinTools.BinTools_ShapeSet_swigregister(BinTools_ShapeSet)

class BinTools_SurfaceSet(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Returns an empty set of surfaces.

        Returns
        -------
        None

        """
        _BinTools.BinTools_SurfaceSet_swiginit(self, _BinTools.new_BinTools_SurfaceSet(*args))

    def Add(self, *args) -> "Standard_Integer":
        r"""
        Incorporate a new surface in the set and returns its index.

        Parameters
        ----------
        S: Geom_Surface

        Returns
        -------
        int

        """
        return _BinTools.BinTools_SurfaceSet_Add(self, *args)

    def Clear(self, *args) -> "void":
        r"""
        Clears the content of the set.

        Returns
        -------
        None

        """
        return _BinTools.BinTools_SurfaceSet_Clear(self, *args)

    def Index(self, *args) -> "Standard_Integer":
        r"""
        Returns the index of <l>.

        Parameters
        ----------
        S: Geom_Surface

        Returns
        -------
        int

        """
        return _BinTools.BinTools_SurfaceSet_Index(self, *args)

    def ReadFromString(self, src: "std::string") -> "void":
        r"""ReadFromString(BinTools_SurfaceSet self, std::string src)"""
        return _BinTools.BinTools_SurfaceSet_ReadFromString(self, src)

    def Surface(self, *args) -> "opencascade::handle< Geom_Surface >":
        r"""
        Returns the surface of index <i>.

        Parameters
        ----------
        I: int

        Returns
        -------
        opencascade::handle<Geom_Surface>

        """
        return _BinTools.BinTools_SurfaceSet_Surface(self, *args)

    def WriteToString(self) -> "std::string":
        r"""WriteToString(BinTools_SurfaceSet self) -> std::string"""
        return _BinTools.BinTools_SurfaceSet_WriteToString(self)

    __repr__ = _dumps_object

    __swig_destroy__ = _BinTools.delete_BinTools_SurfaceSet

# Register BinTools_SurfaceSet in _BinTools:
_BinTools.BinTools_SurfaceSet_swigregister(BinTools_SurfaceSet)





