# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
gp module, see official documentation at
https://www.opencascade.com/doc/occt-7.4.0/refman/html/package_gp.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _gp
else:
    import _gp

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gp.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _gp.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _gp.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _gp.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _gp.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _gp.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _gp.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _gp.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _gp.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _gp.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _gp.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _gp.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _gp.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _gp.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _gp.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _gp.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _gp.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _gp:
_gp.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _gp.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TColStd
import OCC.Core.TCollection

from enum import IntEnum
from OCC.Core.Exception import *

gp_Identity = _gp.gp_Identity
gp_Rotation = _gp.gp_Rotation
gp_Translation = _gp.gp_Translation
gp_PntMirror = _gp.gp_PntMirror
gp_Ax1Mirror = _gp.gp_Ax1Mirror
gp_Ax2Mirror = _gp.gp_Ax2Mirror
gp_Scale = _gp.gp_Scale
gp_CompoundTrsf = _gp.gp_CompoundTrsf
gp_Other = _gp.gp_Other
gp_EulerAngles = _gp.gp_EulerAngles
gp_YawPitchRoll = _gp.gp_YawPitchRoll
gp_Extrinsic_XYZ = _gp.gp_Extrinsic_XYZ
gp_Extrinsic_XZY = _gp.gp_Extrinsic_XZY
gp_Extrinsic_YZX = _gp.gp_Extrinsic_YZX
gp_Extrinsic_YXZ = _gp.gp_Extrinsic_YXZ
gp_Extrinsic_ZXY = _gp.gp_Extrinsic_ZXY
gp_Extrinsic_ZYX = _gp.gp_Extrinsic_ZYX
gp_Intrinsic_XYZ = _gp.gp_Intrinsic_XYZ
gp_Intrinsic_XZY = _gp.gp_Intrinsic_XZY
gp_Intrinsic_YZX = _gp.gp_Intrinsic_YZX
gp_Intrinsic_YXZ = _gp.gp_Intrinsic_YXZ
gp_Intrinsic_ZXY = _gp.gp_Intrinsic_ZXY
gp_Intrinsic_ZYX = _gp.gp_Intrinsic_ZYX
gp_Extrinsic_XYX = _gp.gp_Extrinsic_XYX
gp_Extrinsic_XZX = _gp.gp_Extrinsic_XZX
gp_Extrinsic_YZY = _gp.gp_Extrinsic_YZY
gp_Extrinsic_YXY = _gp.gp_Extrinsic_YXY
gp_Extrinsic_ZYZ = _gp.gp_Extrinsic_ZYZ
gp_Extrinsic_ZXZ = _gp.gp_Extrinsic_ZXZ
gp_Intrinsic_XYX = _gp.gp_Intrinsic_XYX
gp_Intrinsic_XZX = _gp.gp_Intrinsic_XZX
gp_Intrinsic_YZY = _gp.gp_Intrinsic_YZY
gp_Intrinsic_YXY = _gp.gp_Intrinsic_YXY
gp_Intrinsic_ZXZ = _gp.gp_Intrinsic_ZXZ
gp_Intrinsic_ZYZ = _gp.gp_Intrinsic_ZYZ


class gp_TrsfForm(IntEnum):
	gp_Identity = 0
	gp_Rotation = 1
	gp_Translation = 2
	gp_PntMirror = 3
	gp_Ax1Mirror = 4
	gp_Ax2Mirror = 5
	gp_Scale = 6
	gp_CompoundTrsf = 7
	gp_Other = 8
gp_Identity = gp_TrsfForm.gp_Identity
gp_Rotation = gp_TrsfForm.gp_Rotation
gp_Translation = gp_TrsfForm.gp_Translation
gp_PntMirror = gp_TrsfForm.gp_PntMirror
gp_Ax1Mirror = gp_TrsfForm.gp_Ax1Mirror
gp_Ax2Mirror = gp_TrsfForm.gp_Ax2Mirror
gp_Scale = gp_TrsfForm.gp_Scale
gp_CompoundTrsf = gp_TrsfForm.gp_CompoundTrsf
gp_Other = gp_TrsfForm.gp_Other

class gp_EulerSequence(IntEnum):
	gp_EulerAngles = 0
	gp_YawPitchRoll = 1
	gp_Extrinsic_XYZ = 2
	gp_Extrinsic_XZY = 3
	gp_Extrinsic_YZX = 4
	gp_Extrinsic_YXZ = 5
	gp_Extrinsic_ZXY = 6
	gp_Extrinsic_ZYX = 7
	gp_Intrinsic_XYZ = 8
	gp_Intrinsic_XZY = 9
	gp_Intrinsic_YZX = 10
	gp_Intrinsic_YXZ = 11
	gp_Intrinsic_ZXY = 12
	gp_Intrinsic_ZYX = 13
	gp_Extrinsic_XYX = 14
	gp_Extrinsic_XZX = 15
	gp_Extrinsic_YZY = 16
	gp_Extrinsic_YXY = 17
	gp_Extrinsic_ZYZ = 18
	gp_Extrinsic_ZXZ = 19
	gp_Intrinsic_XYX = 20
	gp_Intrinsic_XZX = 21
	gp_Intrinsic_YZY = 22
	gp_Intrinsic_YXY = 23
	gp_Intrinsic_ZXZ = 24
	gp_Intrinsic_ZYZ = 25
gp_EulerAngles = gp_EulerSequence.gp_EulerAngles
gp_YawPitchRoll = gp_EulerSequence.gp_YawPitchRoll
gp_Extrinsic_XYZ = gp_EulerSequence.gp_Extrinsic_XYZ
gp_Extrinsic_XZY = gp_EulerSequence.gp_Extrinsic_XZY
gp_Extrinsic_YZX = gp_EulerSequence.gp_Extrinsic_YZX
gp_Extrinsic_YXZ = gp_EulerSequence.gp_Extrinsic_YXZ
gp_Extrinsic_ZXY = gp_EulerSequence.gp_Extrinsic_ZXY
gp_Extrinsic_ZYX = gp_EulerSequence.gp_Extrinsic_ZYX
gp_Intrinsic_XYZ = gp_EulerSequence.gp_Intrinsic_XYZ
gp_Intrinsic_XZY = gp_EulerSequence.gp_Intrinsic_XZY
gp_Intrinsic_YZX = gp_EulerSequence.gp_Intrinsic_YZX
gp_Intrinsic_YXZ = gp_EulerSequence.gp_Intrinsic_YXZ
gp_Intrinsic_ZXY = gp_EulerSequence.gp_Intrinsic_ZXY
gp_Intrinsic_ZYX = gp_EulerSequence.gp_Intrinsic_ZYX
gp_Extrinsic_XYX = gp_EulerSequence.gp_Extrinsic_XYX
gp_Extrinsic_XZX = gp_EulerSequence.gp_Extrinsic_XZX
gp_Extrinsic_YZY = gp_EulerSequence.gp_Extrinsic_YZY
gp_Extrinsic_YXY = gp_EulerSequence.gp_Extrinsic_YXY
gp_Extrinsic_ZYZ = gp_EulerSequence.gp_Extrinsic_ZYZ
gp_Extrinsic_ZXZ = gp_EulerSequence.gp_Extrinsic_ZXZ
gp_Intrinsic_XYX = gp_EulerSequence.gp_Intrinsic_XYX
gp_Intrinsic_XZX = gp_EulerSequence.gp_Intrinsic_XZX
gp_Intrinsic_YZY = gp_EulerSequence.gp_Intrinsic_YZY
gp_Intrinsic_YXY = gp_EulerSequence.gp_Intrinsic_YXY
gp_Intrinsic_ZXZ = gp_EulerSequence.gp_Intrinsic_ZXZ
gp_Intrinsic_ZYZ = gp_EulerSequence.gp_Intrinsic_ZYZ

class gp(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def DX(*args) -> "gp_Dir const":
        r"""
        Returns a unit vector with the combination (1,0,0).

        Returns
        -------
        gp_Dir

        """
        return _gp.gp_DX(*args)

    @staticmethod
    def DX2d(*args) -> "gp_Dir2d const":
        r"""
        Returns a unit vector with the combinations (1,0).

        Returns
        -------
        gp_Dir2d

        """
        return _gp.gp_DX2d(*args)

    @staticmethod
    def DY(*args) -> "gp_Dir const":
        r"""
        Returns a unit vector with the combination (0,1,0).

        Returns
        -------
        gp_Dir

        """
        return _gp.gp_DY(*args)

    @staticmethod
    def DY2d(*args) -> "gp_Dir2d const":
        r"""
        Returns a unit vector with the combinations (0,1).

        Returns
        -------
        gp_Dir2d

        """
        return _gp.gp_DY2d(*args)

    @staticmethod
    def DZ(*args) -> "gp_Dir const":
        r"""
        Returns a unit vector with the combination (0,0,1).

        Returns
        -------
        gp_Dir

        """
        return _gp.gp_DZ(*args)

    @staticmethod
    def OX(*args) -> "gp_Ax1 const":
        r"""
        Identifies an axis where its origin is origin and its unit vector coordinates x = 1.0, y = z = 0.0.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_OX(*args)

    @staticmethod
    def OX2d(*args) -> "gp_Ax2d const":
        r"""
        Identifies an axis where its origin is origin2d and its unit vector coordinates are: x = 1.0, y = 0.0.

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_OX2d(*args)

    @staticmethod
    def OY(*args) -> "gp_Ax1 const":
        r"""
        Identifies an axis where its origin is origin and its unit vector coordinates y = 1.0, x = z = 0.0.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_OY(*args)

    @staticmethod
    def OY2d(*args) -> "gp_Ax2d const":
        r"""
        Identifies an axis where its origin is origin2d and its unit vector coordinates are y = 1.0, x = 0.0.

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_OY2d(*args)

    @staticmethod
    def OZ(*args) -> "gp_Ax1 const":
        r"""
        Identifies an axis where its origin is origin and its unit vector coordinates z = 1.0, y = x = 0.0.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_OZ(*args)

    @staticmethod
    def Origin(*args) -> "gp_Pnt const":
        r"""
        Identifies a cartesian point with coordinates x = y = z = 0.0.0.

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Origin(*args)

    @staticmethod
    def Origin2d(*args) -> "gp_Pnt2d const":
        r"""
        Identifies a cartesian point with coordinates x = y = 0.0.

        Returns
        -------
        gp_Pnt2d

        """
        return _gp.gp_Origin2d(*args)

    @staticmethod
    def Resolution(*args) -> "Standard_Real":
        r"""
        Method of package gp //! in geometric computations, defines the tolerance criterion used to determine when two numbers can be considered equal. many class functions use this tolerance criterion, for example, to avoid division by zero in geometric computations. in the documentation, tolerance criterion is always referred to as gp::resolution().

        Returns
        -------
        float

        """
        return _gp.gp_Resolution(*args)

    @staticmethod
    def XOY(*args) -> "gp_Ax2 const":
        r"""
        Identifies a coordinate system where its origin is origin, and its 'main direction' and 'x direction' coordinates z = 1.0, x = y =0.0 and x direction coordinates x = 1.0, y = z = 0.0.

        Returns
        -------
        gp_Ax2

        """
        return _gp.gp_XOY(*args)

    @staticmethod
    def YOZ(*args) -> "gp_Ax2 const":
        r"""
        Identifies a coordinate system where its origin is origin, and its 'main direction' and 'x direction' coordinates x = 1.0, z = y =0.0 and x direction coordinates y = 1.0, x = z = 0.0 in 2d space.

        Returns
        -------
        gp_Ax2

        """
        return _gp.gp_YOZ(*args)

    @staticmethod
    def ZOX(*args) -> "gp_Ax2 const":
        r"""
        Identifies a coordinate system where its origin is origin, and its 'main direction' and 'x direction' coordinates y = 1.0, x = z =0.0 and x direction coordinates z = 1.0, x = y = 0.0.

        Returns
        -------
        gp_Ax2

        """
        return _gp.gp_ZOX(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _gp.gp_swiginit(self, _gp.new_gp())
    __swig_destroy__ = _gp.delete_gp

# Register gp in _gp:
_gp.gp_swigregister(gp)

def gp_DX(*args) -> "gp_Dir const":
    r"""
    Returns a unit vector with the combination (1,0,0).

    Returns
    -------
    gp_Dir

    """
    return _gp.gp_DX(*args)

def gp_DX2d(*args) -> "gp_Dir2d const":
    r"""
    Returns a unit vector with the combinations (1,0).

    Returns
    -------
    gp_Dir2d

    """
    return _gp.gp_DX2d(*args)

def gp_DY(*args) -> "gp_Dir const":
    r"""
    Returns a unit vector with the combination (0,1,0).

    Returns
    -------
    gp_Dir

    """
    return _gp.gp_DY(*args)

def gp_DY2d(*args) -> "gp_Dir2d const":
    r"""
    Returns a unit vector with the combinations (0,1).

    Returns
    -------
    gp_Dir2d

    """
    return _gp.gp_DY2d(*args)

def gp_DZ(*args) -> "gp_Dir const":
    r"""
    Returns a unit vector with the combination (0,0,1).

    Returns
    -------
    gp_Dir

    """
    return _gp.gp_DZ(*args)

def gp_OX(*args) -> "gp_Ax1 const":
    r"""
    Identifies an axis where its origin is origin and its unit vector coordinates x = 1.0, y = z = 0.0.

    Returns
    -------
    gp_Ax1

    """
    return _gp.gp_OX(*args)

def gp_OX2d(*args) -> "gp_Ax2d const":
    r"""
    Identifies an axis where its origin is origin2d and its unit vector coordinates are: x = 1.0, y = 0.0.

    Returns
    -------
    gp_Ax2d

    """
    return _gp.gp_OX2d(*args)

def gp_OY(*args) -> "gp_Ax1 const":
    r"""
    Identifies an axis where its origin is origin and its unit vector coordinates y = 1.0, x = z = 0.0.

    Returns
    -------
    gp_Ax1

    """
    return _gp.gp_OY(*args)

def gp_OY2d(*args) -> "gp_Ax2d const":
    r"""
    Identifies an axis where its origin is origin2d and its unit vector coordinates are y = 1.0, x = 0.0.

    Returns
    -------
    gp_Ax2d

    """
    return _gp.gp_OY2d(*args)

def gp_OZ(*args) -> "gp_Ax1 const":
    r"""
    Identifies an axis where its origin is origin and its unit vector coordinates z = 1.0, y = x = 0.0.

    Returns
    -------
    gp_Ax1

    """
    return _gp.gp_OZ(*args)

def gp_Origin(*args) -> "gp_Pnt const":
    r"""
    Identifies a cartesian point with coordinates x = y = z = 0.0.0.

    Returns
    -------
    gp_Pnt

    """
    return _gp.gp_Origin(*args)

def gp_Origin2d(*args) -> "gp_Pnt2d const":
    r"""
    Identifies a cartesian point with coordinates x = y = 0.0.

    Returns
    -------
    gp_Pnt2d

    """
    return _gp.gp_Origin2d(*args)

def gp_Resolution(*args) -> "Standard_Real":
    r"""
    Method of package gp //! in geometric computations, defines the tolerance criterion used to determine when two numbers can be considered equal. many class functions use this tolerance criterion, for example, to avoid division by zero in geometric computations. in the documentation, tolerance criterion is always referred to as gp::resolution().

    Returns
    -------
    float

    """
    return _gp.gp_Resolution(*args)

def gp_XOY(*args) -> "gp_Ax2 const":
    r"""
    Identifies a coordinate system where its origin is origin, and its 'main direction' and 'x direction' coordinates z = 1.0, x = y =0.0 and x direction coordinates x = 1.0, y = z = 0.0.

    Returns
    -------
    gp_Ax2

    """
    return _gp.gp_XOY(*args)

def gp_YOZ(*args) -> "gp_Ax2 const":
    r"""
    Identifies a coordinate system where its origin is origin, and its 'main direction' and 'x direction' coordinates x = 1.0, z = y =0.0 and x direction coordinates y = 1.0, x = z = 0.0 in 2d space.

    Returns
    -------
    gp_Ax2

    """
    return _gp.gp_YOZ(*args)

def gp_ZOX(*args) -> "gp_Ax2 const":
    r"""
    Identifies a coordinate system where its origin is origin, and its 'main direction' and 'x direction' coordinates y = 1.0, x = z =0.0 and x direction coordinates z = 1.0, x = y = 0.0.

    Returns
    -------
    gp_Ax2

    """
    return _gp.gp_ZOX(*args)

class gp_Ax1(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an axis object representing z axis of the reference co-ordinate system.

        Returns
        -------
        None
        P is the location point and v is the direction of <self>.

        Parameters
        ----------
        P: gp_Pnt
        V: gp_Dir

        Returns
        -------
        None

        """
        _gp.gp_Ax1_swiginit(self, _gp.new_gp_Ax1(*args))

    def Angle(self, *args) -> "Standard_Real":
        r"""
        Computes the angular value, in radians, between <self>.direction() and <other>.direction(). returns the angle between 0 and 2*pi radians.

        Parameters
        ----------
        Other: gp_Ax1

        Returns
        -------
        float

        """
        return _gp.gp_Ax1_Angle(self, *args)

    def Direction(self, *args) -> "gp_Dir const":
        r"""
        Returns the direction of <self>.

        Returns
        -------
        gp_Dir

        """
        return _gp.gp_Ax1_Direction(self, *args)

    def IsCoaxial(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if : . the angle between <self> and <other> is lower or equal to <angulartolerance> and . the distance between <self>.location() and <other> is lower or equal to <lineartolerance> and . the distance between <other>.location() and <self> is lower or equal to lineartolerance.

        Parameters
        ----------
        Other: gp_Ax1
        AngularTolerance: float
        LinearTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Ax1_IsCoaxial(self, *args)

    def IsNormal(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the direction of the <self> and <other> are normal to each other. that is, if the angle between the two axes is equal to pi/2. note: the tolerance criterion is given by angulartolerance..

        Parameters
        ----------
        Other: gp_Ax1
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Ax1_IsNormal(self, *args)

    def IsOpposite(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the direction of <self> and <other> are parallel with opposite orientation. that is, if the angle between the two axes is equal to pi. note: the tolerance criterion is given by angulartolerance.

        Parameters
        ----------
        Other: gp_Ax1
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Ax1_IsOpposite(self, *args)

    def IsParallel(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the direction of <self> and <other> are parallel with same orientation or opposite orientation. that is, if the angle between the two axes is equal to 0 or pi. note: the tolerance criterion is given by angulartolerance.

        Parameters
        ----------
        Other: gp_Ax1
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Ax1_IsParallel(self, *args)

    def Location(self, *args) -> "gp_Pnt const":
        r"""
        Returns the location point of <self>.

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Ax1_Location(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        Performs the symmetrical transformation of an axis placement with respect to the point p which is the center of the symmetry and assigns the result to this axis.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None
        Performs the symmetrical transformation of an axis placement with respect to an axis placement which is the axis of the symmetry and assigns the result to this axis.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None
        Performs the symmetrical transformation of an axis placement with respect to a plane. the axis placement <a2> locates the plane of the symmetry : (location, xdirection, ydirection) and assigns the result to this axis.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        None

        """
        return _gp.gp_Ax1_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Ax1":
        r"""
        Performs the symmetrical transformation of an axis placement with respect to the point p which is the center of the symmetry and creates a new axis.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        gp_Ax1
        Performs the symmetrical transformation of an axis placement with respect to an axis placement which is the axis of the symmetry and creates a new axis.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        gp_Ax1
        Performs the symmetrical transformation of an axis placement with respect to a plane. the axis placement <a2> locates the plane of the symmetry : (location, xdirection, ydirection) and creates a new axis.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Ax1_Mirrored(self, *args)

    def Reverse(self, *args) -> "void":
        r"""
        Reverses the unit vector of this axis. and assigns the result to this axis.

        Returns
        -------
        None

        """
        return _gp.gp_Ax1_Reverse(self, *args)

    def Reversed(self, *args) -> "gp_Ax1":
        r"""
        Reverses the unit vector of this axis and creates a new one.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Ax1_Reversed(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        Rotates this axis at an angle ang (in radians) about the axis a1 and assigns the result to this axis.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Ax1_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Ax1":
        r"""
        Rotates this axis at an angle ang (in radians) about the axis a1 and creates a new one.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Ax1_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        Applies a scaling transformation to this axis with: - scale factor s, and - center p and assigns the result to this axis.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Ax1_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Ax1":
        r"""
        Applies a scaling transformation to this axis with: - scale factor s, and - center p and creates a new axis.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Ax1_Scaled(self, *args)

    def SetDirection(self, *args) -> "void":
        r"""
        Assigns v as the 'direction' of this axis.

        Parameters
        ----------
        V: gp_Dir

        Returns
        -------
        None

        """
        return _gp.gp_Ax1_SetDirection(self, *args)

    def SetLocation(self, *args) -> "void":
        r"""
        Assigns p as the origin of this axis.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Ax1_SetLocation(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        Applies the transformation t to this axis. and assigns the result to this axis.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        None

        """
        return _gp.gp_Ax1_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Ax1":
        r"""
        Applies the transformation t to this axis and creates a new one. //! translates an axis plaxement in the direction of the vector <v>. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Ax1_Transformed(self, *args)

    def Translate(self, *args) -> "void":
        r"""
        Translates this axis by the vector v, and assigns the result to this axis.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        None
        Translates this axis by: the vector (p1, p2) defined from point p1 to point p2. and assigns the result to this axis.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Ax1_Translate(self, *args)

    def Translated(self, *args) -> "gp_Ax1":
        r"""
        Translates this axis by the vector v, and creates a new one.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        gp_Ax1
        Translates this axis by: the vector (p1, p2) defined from point p1 to point p2. and creates a new one.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Ax1_Translated(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Ax1

# Register gp_Ax1 in _gp:
_gp.gp_Ax1_swigregister(gp_Ax1)

class gp_Ax2(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an object corresponding to the reference coordinate system (oxyz).

        Returns
        -------
        None
        Creates an axis placement with an origin p such that: - n is the direction, and - the 'x direction' is normal to n, in the plane defined by the vectors (n, vx): 'x direction' = (n ^ vx) ^ n, exception: raises constructionerror if n and vx are parallel (same or opposite orientation).

        Parameters
        ----------
        P: gp_Pnt
        N: gp_Dir
        Vx: gp_Dir

        Returns
        -------
        None
        Creates - a coordinate system with an origin p, where v gives the 'main direction' (here, 'x direction' and 'y direction' are defined automatically).

        Parameters
        ----------
        P: gp_Pnt
        V: gp_Dir

        Returns
        -------
        None

        """
        _gp.gp_Ax2_swiginit(self, _gp.new_gp_Ax2(*args))

    def Angle(self, *args) -> "Standard_Real":
        r"""
        Computes the angular value, in radians, between the main direction of <self> and the main direction of <other>. returns the angle between 0 and pi in radians.

        Parameters
        ----------
        Other: gp_Ax2

        Returns
        -------
        float

        """
        return _gp.gp_Ax2_Angle(self, *args)

    def Axis(self, *args) -> "gp_Ax1 const":
        r"""
        Returns the main axis of <self>. it is the 'location' point and the main 'direction'.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Ax2_Axis(self, *args)

    def Direction(self, *args) -> "gp_Dir const":
        r"""
        Returns the main direction of <self>.

        Returns
        -------
        gp_Dir

        """
        return _gp.gp_Ax2_Direction(self, *args)

    def IsCoplanar(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_Ax2
        LinearTolerance: float
        AngularTolerance: float

        Returns
        -------
        bool
        Returns true if . the distance between <self> and the 'location' point of a1 is lower of equal to lineartolerance and . the main direction of <self> and the direction of a1 are normal. note: the tolerance criterion for angular equality is given by angulartolerance.

        Parameters
        ----------
        A1: gp_Ax1
        LinearTolerance: float
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Ax2_IsCoplanar(self, *args)

    def Location(self, *args) -> "gp_Pnt const":
        r"""
        Returns the 'location' point (origin) of <self>.

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Ax2_Location(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        Performs a symmetrical transformation of this coordinate system with respect to: - the point p, and assigns the result to this coordinate system. warning this transformation is always performed on the origin. in case of a reflection with respect to a point: - the main direction of the coordinate system is not changed, and - the 'x direction' and the 'y direction' are simply reversed in case of a reflection with respect to an axis or a plane: - the transformation is applied to the 'x direction' and the 'y direction', then - the 'main direction' is recomputed as the cross product 'x direction' ^ 'y direction'. this maintains the right-handed property of the coordinate system.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None
        Performs a symmetrical transformation of this coordinate system with respect to: - the axis a1, and assigns the result to this coordinate systeme. warning this transformation is always performed on the origin. in case of a reflection with respect to a point: - the main direction of the coordinate system is not changed, and - the 'x direction' and the 'y direction' are simply reversed in case of a reflection with respect to an axis or a plane: - the transformation is applied to the 'x direction' and the 'y direction', then - the 'main direction' is recomputed as the cross product 'x direction' ^ 'y direction'. this maintains the right-handed property of the coordinate system.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None
        Performs a symmetrical transformation of this coordinate system with respect to: - the plane defined by the origin, 'x direction' and 'y direction' of coordinate system a2 and assigns the result to this coordinate systeme. warning this transformation is always performed on the origin. in case of a reflection with respect to a point: - the main direction of the coordinate system is not changed, and - the 'x direction' and the 'y direction' are simply reversed in case of a reflection with respect to an axis or a plane: - the transformation is applied to the 'x direction' and the 'y direction', then - the 'main direction' is recomputed as the cross product 'x direction' ^ 'y direction'. this maintains the right-handed property of the coordinate system.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        None

        """
        return _gp.gp_Ax2_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Ax2":
        r"""
        Performs a symmetrical transformation of this coordinate system with respect to: - the point p, and creates a new one. warning this transformation is always performed on the origin. in case of a reflection with respect to a point: - the main direction of the coordinate system is not changed, and - the 'x direction' and the 'y direction' are simply reversed in case of a reflection with respect to an axis or a plane: - the transformation is applied to the 'x direction' and the 'y direction', then - the 'main direction' is recomputed as the cross product 'x direction' ^ 'y direction'. this maintains the right-handed property of the coordinate system.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        gp_Ax2
        Performs a symmetrical transformation of this coordinate system with respect to: - the axis a1, and creates a new one. warning this transformation is always performed on the origin. in case of a reflection with respect to a point: - the main direction of the coordinate system is not changed, and - the 'x direction' and the 'y direction' are simply reversed in case of a reflection with respect to an axis or a plane: - the transformation is applied to the 'x direction' and the 'y direction', then - the 'main direction' is recomputed as the cross product 'x direction' ^ 'y direction'. this maintains the right-handed property of the coordinate system.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        gp_Ax2
        Performs a symmetrical transformation of this coordinate system with respect to: - the plane defined by the origin, 'x direction' and 'y direction' of coordinate system a2 and creates a new one. warning this transformation is always performed on the origin. in case of a reflection with respect to a point: - the main direction of the coordinate system is not changed, and - the 'x direction' and the 'y direction' are simply reversed in case of a reflection with respect to an axis or a plane: - the transformation is applied to the 'x direction' and the 'y direction', then - the 'main direction' is recomputed as the cross product 'x direction' ^ 'y direction'. this maintains the right-handed property of the coordinate system.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        gp_Ax2

        """
        return _gp.gp_Ax2_Mirrored(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Ax2_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Ax2":
        r"""
        Rotates an axis placement. <a1> is the axis of the rotation . ang is the angular value of the rotation in radians.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        gp_Ax2

        """
        return _gp.gp_Ax2_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Ax2_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Ax2":
        r"""
        Applies a scaling transformation on the axis placement. the 'location' point of the axisplacement is modified. warnings : if the scale <s> is negative : . the main direction of the axis placement is not changed. . the 'xdirection' and the 'ydirection' are reversed. so the axis placement stay right handed.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        gp_Ax2

        """
        return _gp.gp_Ax2_Scaled(self, *args)

    def SetAxis(self, *args) -> "void":
        r"""
        Assigns the origin and 'main direction' of the axis a1 to this coordinate system, then recomputes its 'x direction' and 'y direction'. note: the new 'x direction' is computed as follows: new 'x direction' = v1 ^(previous 'x direction' ^ v) where v is the 'direction' of a1. exceptions standard_constructionerror if a1 is parallel to the 'x direction' of this coordinate system.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None

        """
        return _gp.gp_Ax2_SetAxis(self, *args)

    def SetDirection(self, *args) -> "void":
        r"""
        Changes the 'main direction' of this coordinate system, then recomputes its 'x direction' and 'y direction'. note: the new 'x direction' is computed as follows: new 'x direction' = v ^ (previous 'x direction' ^ v) exceptions standard_constructionerror if v is parallel to the 'x direction' of this coordinate system.

        Parameters
        ----------
        V: gp_Dir

        Returns
        -------
        None

        """
        return _gp.gp_Ax2_SetDirection(self, *args)

    def SetLocation(self, *args) -> "void":
        r"""
        Changes the 'location' point (origin) of <self>.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Ax2_SetLocation(self, *args)

    def SetXDirection(self, *args) -> "void":
        r"""
        Changes the 'xdirection' of <self>. the main direction 'direction' is not modified, the 'ydirection' is modified. if <vx> is not normal to the main direction then <xdirection> is computed as follows xdirection = direction ^ (vx ^ direction). exceptions standard_constructionerror if vx or vy is parallel to the 'main direction' of this coordinate system.

        Parameters
        ----------
        Vx: gp_Dir

        Returns
        -------
        None

        """
        return _gp.gp_Ax2_SetXDirection(self, *args)

    def SetYDirection(self, *args) -> "void":
        r"""
        Changes the 'ydirection' of <self>. the main direction is not modified but the 'xdirection' is changed. if <vy> is not normal to the main direction then 'ydirection' is computed as follows ydirection = direction ^ (<vy> ^ direction). exceptions standard_constructionerror if vx or vy is parallel to the 'main direction' of this coordinate system.

        Parameters
        ----------
        Vy: gp_Dir

        Returns
        -------
        None

        """
        return _gp.gp_Ax2_SetYDirection(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        None

        """
        return _gp.gp_Ax2_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Ax2":
        r"""
        Transforms an axis placement with a trsf. the 'location' point, the 'xdirection' and the 'ydirection' are transformed with t. the resulting main 'direction' of <self> is the cross product between the 'xdirection' and the 'ydirection' after transformation.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        gp_Ax2

        """
        return _gp.gp_Ax2_Transformed(self, *args)

    def Translate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Ax2_Translate(self, *args)

    def Translated(self, *args) -> "gp_Ax2":
        r"""
        Translates an axis plaxement in the direction of the vector <v>. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        gp_Ax2
        Translates an axis placement from the point <p1> to the point <p2>.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        gp_Ax2

        """
        return _gp.gp_Ax2_Translated(self, *args)

    def XDirection(self, *args) -> "gp_Dir const":
        r"""
        Returns the 'xdirection' of <self>.

        Returns
        -------
        gp_Dir

        """
        return _gp.gp_Ax2_XDirection(self, *args)

    def YDirection(self, *args) -> "gp_Dir const":
        r"""
        Returns the 'ydirection' of <self>.

        Returns
        -------
        gp_Dir

        """
        return _gp.gp_Ax2_YDirection(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Ax2

# Register gp_Ax2 in _gp:
_gp.gp_Ax2_swigregister(gp_Ax2)

class gp_Ax22d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an object representing the reference co-ordinate system (oxy).

        Returns
        -------
        None
        Creates a coordinate system with origin p and where: - vx is the 'x direction', and - the 'y direction' is orthogonal to vx and oriented so that the cross products vx^'y direction' and vx^vy have the same sign. raises constructionerror if vx and vy are parallel (same or opposite orientation).

        Parameters
        ----------
        P: gp_Pnt2d
        Vx: gp_Dir2d
        Vy: gp_Dir2d

        Returns
        -------
        None
        Creates - a coordinate system with origin p and 'x direction' v, which is: - right-handed if sense is true (default value), or - left-handed if sense is false.

        Parameters
        ----------
        P: gp_Pnt2d
        V: gp_Dir2d
        Sense: bool,optional
        	default value is Standard_True

        Returns
        -------
        None
        Creates - a coordinate system where its origin is the origin of a and its 'x direction' is the unit vector of a, which is: - right-handed if sense is true (default value), or - left-handed if sense is false.

        Parameters
        ----------
        A: gp_Ax2d
        Sense: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        _gp.gp_Ax22d_swiginit(self, _gp.new_gp_Ax22d(*args))

    def Location(self, *args) -> "gp_Pnt2d const":
        r"""
        Returns the 'location' point (origin) of <self>.

        Returns
        -------
        gp_Pnt2d

        """
        return _gp.gp_Ax22d_Location(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        None

        """
        return _gp.gp_Ax22d_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Ax22d":
        r"""
        Performs the symmetrical transformation of an axis placement with respect to the point p which is the center of the symmetry. warnings : the main direction of the axis placement is not changed. the 'xdirection' and the 'ydirection' are reversed. so the axis placement stay right handed.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        gp_Ax22d
        Performs the symmetrical transformation of an axis placement with respect to an axis placement which is the axis of the symmetry. the transformation is performed on the 'location' point, on the 'xdirection' and 'ydirection'. the resulting main 'direction' is the cross product between the 'xdirection' and the 'ydirection' after transformation.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        gp_Ax22d

        """
        return _gp.gp_Ax22d_Mirrored(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Ax22d_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Ax22d":
        r"""
        Rotates an axis placement. <a1> is the axis of the rotation . ang is the angular value of the rotation in radians.

        Parameters
        ----------
        P: gp_Pnt2d
        Ang: float

        Returns
        -------
        gp_Ax22d

        """
        return _gp.gp_Ax22d_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Ax22d_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Ax22d":
        r"""
        Applies a scaling transformation on the axis placement. the 'location' point of the axisplacement is modified. warnings : if the scale <s> is negative : . the main direction of the axis placement is not changed. . the 'xdirection' and the 'ydirection' are reversed. so the axis placement stay right handed.

        Parameters
        ----------
        P: gp_Pnt2d
        S: float

        Returns
        -------
        gp_Ax22d

        """
        return _gp.gp_Ax22d_Scaled(self, *args)

    def SetAxis(self, *args) -> "void":
        r"""
        Assigns the origin and the two unit vectors of the coordinate system a1 to this coordinate system.

        Parameters
        ----------
        A1: gp_Ax22d

        Returns
        -------
        None

        """
        return _gp.gp_Ax22d_SetAxis(self, *args)

    def SetLocation(self, *args) -> "void":
        r"""
        Changes the 'location' point (origin) of <self>.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        None

        """
        return _gp.gp_Ax22d_SetLocation(self, *args)

    def SetXAxis(self, *args) -> "void":
        r"""
        Changes the xaxis and yaxis ('location' point and 'direction') of <self>. the 'ydirection' is recomputed in the same sense as before.

        Parameters
        ----------
        A1: gp_Ax2d

        Returns
        -------
        None

        """
        return _gp.gp_Ax22d_SetXAxis(self, *args)

    def SetXDirection(self, *args) -> "void":
        r"""
        Assigns vx to the 'x direction' of this coordinate system. the other unit vector of this coordinate system is recomputed, normal to vx , without modifying the orientation (right-handed or left-handed) of this coordinate system.

        Parameters
        ----------
        Vx: gp_Dir2d

        Returns
        -------
        None

        """
        return _gp.gp_Ax22d_SetXDirection(self, *args)

    def SetYAxis(self, *args) -> "void":
        r"""
        Changes the xaxis and yaxis ('location' point and 'direction') of <self>. the 'xdirection' is recomputed in the same sense as before.

        Parameters
        ----------
        A1: gp_Ax2d

        Returns
        -------
        None

        """
        return _gp.gp_Ax22d_SetYAxis(self, *args)

    def SetYDirection(self, *args) -> "void":
        r"""
        Assignsr vy to the 'y direction' of this coordinate system. the other unit vector of this coordinate system is recomputed, normal to vy, without modifying the orientation (right-handed or left-handed) of this coordinate system.

        Parameters
        ----------
        Vy: gp_Dir2d

        Returns
        -------
        None

        """
        return _gp.gp_Ax22d_SetYDirection(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        None

        """
        return _gp.gp_Ax22d_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Ax22d":
        r"""
        Transforms an axis placement with a trsf. the 'location' point, the 'xdirection' and the 'ydirection' are transformed with t. the resulting main 'direction' of <self> is the cross product between the 'xdirection' and the 'ydirection' after transformation.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        gp_Ax22d

        """
        return _gp.gp_Ax22d_Transformed(self, *args)

    def Translate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Vec2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        None

        """
        return _gp.gp_Ax22d_Translate(self, *args)

    def Translated(self, *args) -> "gp_Ax22d":
        r"""
        Translates an axis plaxement in the direction of the vector <v>. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        V: gp_Vec2d

        Returns
        -------
        gp_Ax22d
        Translates an axis placement from the point <p1> to the point <p2>.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        gp_Ax22d

        """
        return _gp.gp_Ax22d_Translated(self, *args)

    def XAxis(self, *args) -> "gp_Ax2d":
        r"""
        Returns an axis, for which - the origin is that of this coordinate system, and - the unit vector is either the 'x direction' of this coordinate system. note: the result is the 'x axis' of this coordinate system.

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Ax22d_XAxis(self, *args)

    def XDirection(self, *args) -> "gp_Dir2d const":
        r"""
        Returns the 'xdirection' of <self>.

        Returns
        -------
        gp_Dir2d

        """
        return _gp.gp_Ax22d_XDirection(self, *args)

    def YAxis(self, *args) -> "gp_Ax2d":
        r"""
        Returns an axis, for which - the origin is that of this coordinate system, and - the unit vector is either the 'y direction' of this coordinate system. note: the result is the 'y axis' of this coordinate system.

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Ax22d_YAxis(self, *args)

    def YDirection(self, *args) -> "gp_Dir2d const":
        r"""
        Returns the 'ydirection' of <self>.

        Returns
        -------
        gp_Dir2d

        """
        return _gp.gp_Ax22d_YDirection(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Ax22d

# Register gp_Ax22d in _gp:
_gp.gp_Ax22d_swigregister(gp_Ax22d)

class gp_Ax2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an axis object representing x axis of the reference co-ordinate system.

        Returns
        -------
        None
        Creates an ax2d. <p> is the 'location' point of the axis placement and v is the 'direction' of the axis placement.

        Parameters
        ----------
        P: gp_Pnt2d
        V: gp_Dir2d

        Returns
        -------
        None

        """
        _gp.gp_Ax2d_swiginit(self, _gp.new_gp_Ax2d(*args))

    def Angle(self, *args) -> "Standard_Real":
        r"""
        Computes the angle, in radians, between this axis and the axis other. the value of the angle is between -pi and pi.

        Parameters
        ----------
        Other: gp_Ax2d

        Returns
        -------
        float

        """
        return _gp.gp_Ax2d_Angle(self, *args)

    def Direction(self, *args) -> "gp_Dir2d const":
        r"""
        Returns the direction of <self>.

        Returns
        -------
        gp_Dir2d

        """
        return _gp.gp_Ax2d_Direction(self, *args)

    def IsCoaxial(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if : . the angle between <self> and <other> is lower or equal to <angulartolerance> and . the distance between <self>.location() and <other> is lower or equal to <lineartolerance> and . the distance between <other>.location() and <self> is lower or equal to lineartolerance.

        Parameters
        ----------
        Other: gp_Ax2d
        AngularTolerance: float
        LinearTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Ax2d_IsCoaxial(self, *args)

    def IsNormal(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if this axis and the axis other are normal to each other. that is, if the angle between the two axes is equal to pi/2 or -pi/2. note: the tolerance criterion is given by angulartolerance.

        Parameters
        ----------
        Other: gp_Ax2d
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Ax2d_IsNormal(self, *args)

    def IsOpposite(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if this axis and the axis other are parallel, and have opposite orientations. that is, if the angle between the two axes is equal to pi or -pi. note: the tolerance criterion is given by angulartolerance.

        Parameters
        ----------
        Other: gp_Ax2d
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Ax2d_IsOpposite(self, *args)

    def IsParallel(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if this axis and the axis other are parallel, and have either the same or opposite orientations. that is, if the angle between the two axes is equal to 0, pi or -pi. note: the tolerance criterion is given by angulartolerance.

        Parameters
        ----------
        Other: gp_Ax2d
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Ax2d_IsParallel(self, *args)

    def Location(self, *args) -> "gp_Pnt2d const":
        r"""
        Returns the origin of <self>.

        Returns
        -------
        gp_Pnt2d

        """
        return _gp.gp_Ax2d_Location(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        None

        """
        return _gp.gp_Ax2d_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Ax2d":
        r"""
        Performs the symmetrical transformation of an axis placement with respect to the point p which is the center of the symmetry.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        gp_Ax2d
        Performs the symmetrical transformation of an axis placement with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Ax2d_Mirrored(self, *args)

    def Reverse(self, *args) -> "void":
        r"""
        Reverses the direction of <self> and assigns the result to this axis.

        Returns
        -------
        None

        """
        return _gp.gp_Ax2d_Reverse(self, *args)

    def Reversed(self, *args) -> "gp_Ax2d":
        r"""
        Computes a new axis placement with a direction opposite to the direction of <self>.

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Ax2d_Reversed(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Ax2d_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Ax2d":
        r"""
        Rotates an axis placement. <p> is the center of the rotation . ang is the angular value of the rotation in radians.

        Parameters
        ----------
        P: gp_Pnt2d
        Ang: float

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Ax2d_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Ax2d_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Ax2d":
        r"""
        Applies a scaling transformation on the axis placement. the 'location' point of the axisplacement is modified. the 'direction' is reversed if the scale is negative.

        Parameters
        ----------
        P: gp_Pnt2d
        S: float

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Ax2d_Scaled(self, *args)

    def SetDirection(self, *args) -> "void":
        r"""
        Changes the direction of <self>.

        Parameters
        ----------
        V: gp_Dir2d

        Returns
        -------
        None

        """
        return _gp.gp_Ax2d_SetDirection(self, *args)

    def SetLocation(self, *args) -> "void":
        r"""
        Changes the 'location' point (origin) of <self>.

        Parameters
        ----------
        Locat: gp_Pnt2d

        Returns
        -------
        None

        """
        return _gp.gp_Ax2d_SetLocation(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        None

        """
        return _gp.gp_Ax2d_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Ax2d":
        r"""
        Transforms an axis placement with a trsf.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Ax2d_Transformed(self, *args)

    def Translate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Vec2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        None

        """
        return _gp.gp_Ax2d_Translate(self, *args)

    def Translated(self, *args) -> "gp_Ax2d":
        r"""
        Translates an axis placement in the direction of the vector <v>. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        V: gp_Vec2d

        Returns
        -------
        gp_Ax2d
        Translates an axis placement from the point <p1> to the point <p2>.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Ax2d_Translated(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Ax2d

# Register gp_Ax2d in _gp:
_gp.gp_Ax2d_swigregister(gp_Ax2d)

class gp_Ax3(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an object corresponding to the reference coordinate system (oxyz).

        Returns
        -------
        None
        Creates a coordinate system from a right-handed coordinate system.

        Parameters
        ----------
        A: gp_Ax2

        Returns
        -------
        None
        Creates a right handed axis placement with the 'location' point p and two directions, n gives the 'direction' and vx gives the 'xdirection'. raises constructionerror if n and vx are parallel (same or opposite orientation).

        Parameters
        ----------
        P: gp_Pnt
        N: gp_Dir
        Vx: gp_Dir

        Returns
        -------
        None
        Creates an axis placement with the 'location' point <p> and the normal direction <v>.

        Parameters
        ----------
        P: gp_Pnt
        V: gp_Dir

        Returns
        -------
        None

        """
        _gp.gp_Ax3_swiginit(self, _gp.new_gp_Ax3(*args))

    def Angle(self, *args) -> "Standard_Real":
        r"""
        Computes the angular value between the main direction of <self> and the main direction of <other>. returns the angle between 0 and pi in radians.

        Parameters
        ----------
        Other: gp_Ax3

        Returns
        -------
        float

        """
        return _gp.gp_Ax3_Angle(self, *args)

    def Ax2(self, *args) -> "gp_Ax2":
        r"""
        Computes a right-handed coordinate system with the same 'x direction' and 'y direction' as those of this coordinate system, then recomputes the 'main direction'. if this coordinate system is right-handed, the result returned is the same coordinate system. if this coordinate system is left-handed, the result is reversed.

        Returns
        -------
        gp_Ax2

        """
        return _gp.gp_Ax3_Ax2(self, *args)

    def Axis(self, *args) -> "gp_Ax1 const":
        r"""
        Returns the main axis of <self>. it is the 'location' point and the main 'direction'.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Ax3_Axis(self, *args)

    def Direct(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the coordinate system is right-handed. i.e. xdirection().crossed(ydirection()).dot(direction()) > 0.

        Returns
        -------
        bool

        """
        return _gp.gp_Ax3_Direct(self, *args)

    def Direction(self, *args) -> "gp_Dir const":
        r"""
        Returns the main direction of <self>.

        Returns
        -------
        gp_Dir

        """
        return _gp.gp_Ax3_Direction(self, *args)

    def IsCoplanar(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if . the distance between the 'location' point of <self> and <other> is lower or equal to lineartolerance and . the distance between the 'location' point of <other> and <self> is lower or equal to lineartolerance and . the main direction of <self> and the main direction of <other> are parallel (same or opposite orientation).

        Parameters
        ----------
        Other: gp_Ax3
        LinearTolerance: float
        AngularTolerance: float

        Returns
        -------
        bool
        Returns true if . the distance between <self> and the 'location' point of a1 is lower of equal to lineartolerance and . the distance between a1 and the 'location' point of <self> is lower or equal to lineartolerance and . the main direction of <self> and the direction of a1 are normal.

        Parameters
        ----------
        A1: gp_Ax1
        LinearTolerance: float
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Ax3_IsCoplanar(self, *args)

    def Location(self, *args) -> "gp_Pnt const":
        r"""
        Returns the 'location' point (origin) of <self>.

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Ax3_Location(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        None

        """
        return _gp.gp_Ax3_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Ax3":
        r"""
        Performs the symmetrical transformation of an axis placement with respect to the point p which is the center of the symmetry. warnings : the main direction of the axis placement is not changed. the 'xdirection' and the 'ydirection' are reversed. so the axis placement stay right handed.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        gp_Ax3
        Performs the symmetrical transformation of an axis placement with respect to an axis placement which is the axis of the symmetry. the transformation is performed on the 'location' point, on the 'xdirection' and 'ydirection'. the resulting main 'direction' is the cross product between the 'xdirection' and the 'ydirection' after transformation.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        gp_Ax3
        Performs the symmetrical transformation of an axis placement with respect to a plane. the axis placement <a2> locates the plane of the symmetry : (location, xdirection, ydirection). the transformation is performed on the 'location' point, on the 'xdirection' and 'ydirection'. the resulting main 'direction' is the cross product between the 'xdirection' and the 'ydirection' after transformation.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        gp_Ax3

        """
        return _gp.gp_Ax3_Mirrored(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Ax3_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Ax3":
        r"""
        Rotates an axis placement. <a1> is the axis of the rotation . ang is the angular value of the rotation in radians.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        gp_Ax3

        """
        return _gp.gp_Ax3_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Ax3_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Ax3":
        r"""
        Applies a scaling transformation on the axis placement. the 'location' point of the axisplacement is modified. warnings : if the scale <s> is negative : . the main direction of the axis placement is not changed. . the 'xdirection' and the 'ydirection' are reversed. so the axis placement stay right handed.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        gp_Ax3

        """
        return _gp.gp_Ax3_Scaled(self, *args)

    def SetAxis(self, *args) -> "void":
        r"""
        Assigns the origin and 'main direction' of the axis a1 to this coordinate system, then recomputes its 'x direction' and 'y direction'. note: - the new 'x direction' is computed as follows: new 'x direction' = v1 ^(previous 'x direction' ^ v) where v is the 'direction' of a1. - the orientation of this coordinate system (right-handed or left-handed) is not modified. raises constructionerror if the 'direction' of <a1> and the 'xdirection' of <self> are parallel (same or opposite orientation) because it is impossible to calculate the new 'xdirection' and the new 'ydirection'.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None

        """
        return _gp.gp_Ax3_SetAxis(self, *args)

    def SetDirection(self, *args) -> "void":
        r"""
        Changes the main direction of this coordinate system, then recomputes its 'x direction' and 'y direction'. note: - the new 'x direction' is computed as follows: new 'x direction' = v ^ (previous 'x direction' ^ v). - the orientation of this coordinate system (left- or right-handed) is not modified. raises constructionerror if <v< and the previous 'xdirection' are parallel because it is impossible to calculate the new 'xdirection' and the new 'ydirection'.

        Parameters
        ----------
        V: gp_Dir

        Returns
        -------
        None

        """
        return _gp.gp_Ax3_SetDirection(self, *args)

    def SetLocation(self, *args) -> "void":
        r"""
        Changes the 'location' point (origin) of <self>.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Ax3_SetLocation(self, *args)

    def SetXDirection(self, *args) -> "void":
        r"""
        Changes the 'xdirection' of <self>. the main direction 'direction' is not modified, the 'ydirection' is modified. if <vx> is not normal to the main direction then <xdirection> is computed as follows xdirection = direction ^ (vx ^ direction). raises constructionerror if <vx> is parallel (same or opposite orientation) to the main direction of <self>.

        Parameters
        ----------
        Vx: gp_Dir

        Returns
        -------
        None

        """
        return _gp.gp_Ax3_SetXDirection(self, *args)

    def SetYDirection(self, *args) -> "void":
        r"""
        Changes the 'ydirection' of <self>. the main direction is not modified but the 'xdirection' is changed. if <vy> is not normal to the main direction then 'ydirection' is computed as follows ydirection = direction ^ (<vy> ^ direction). raises constructionerror if <vy> is parallel to the main direction of <self>.

        Parameters
        ----------
        Vy: gp_Dir

        Returns
        -------
        None

        """
        return _gp.gp_Ax3_SetYDirection(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        None

        """
        return _gp.gp_Ax3_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Ax3":
        r"""
        Transforms an axis placement with a trsf. the 'location' point, the 'xdirection' and the 'ydirection' are transformed with t. the resulting main 'direction' of <self> is the cross product between the 'xdirection' and the 'ydirection' after transformation.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        gp_Ax3

        """
        return _gp.gp_Ax3_Transformed(self, *args)

    def Translate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Ax3_Translate(self, *args)

    def Translated(self, *args) -> "gp_Ax3":
        r"""
        Translates an axis plaxement in the direction of the vector <v>. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        gp_Ax3
        Translates an axis placement from the point <p1> to the point <p2>.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        gp_Ax3

        """
        return _gp.gp_Ax3_Translated(self, *args)

    def XDirection(self, *args) -> "gp_Dir const":
        r"""
        Returns the 'xdirection' of <self>.

        Returns
        -------
        gp_Dir

        """
        return _gp.gp_Ax3_XDirection(self, *args)

    def XReverse(self, *args) -> "void":
        r"""
        Reverses the x direction of <self>.

        Returns
        -------
        None

        """
        return _gp.gp_Ax3_XReverse(self, *args)

    def YDirection(self, *args) -> "gp_Dir const":
        r"""
        Returns the 'ydirection' of <self>.

        Returns
        -------
        gp_Dir

        """
        return _gp.gp_Ax3_YDirection(self, *args)

    def YReverse(self, *args) -> "void":
        r"""
        Reverses the y direction of <self>.

        Returns
        -------
        None

        """
        return _gp.gp_Ax3_YReverse(self, *args)

    def ZReverse(self, *args) -> "void":
        r"""
        Reverses the z direction of <self>.

        Returns
        -------
        None

        """
        return _gp.gp_Ax3_ZReverse(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Ax3

# Register gp_Ax3 in _gp:
_gp.gp_Ax3_swigregister(gp_Ax3)

class gp_Circ(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an indefinite circle.

        Returns
        -------
        None
        A2 locates the circle and gives its orientation in 3d space. warnings : it is not forbidden to create a circle with radius = 0.0 raises constructionerror if radius < 0.0.

        Parameters
        ----------
        A2: gp_Ax2
        Radius: float

        Returns
        -------
        None

        """
        _gp.gp_Circ_swiginit(self, _gp.new_gp_Circ(*args))

    def Area(self, *args) -> "Standard_Real":
        r"""
        Computes the area of the circle.

        Returns
        -------
        float

        """
        return _gp.gp_Circ_Area(self, *args)

    def Axis(self, *args) -> "gp_Ax1 const":
        r"""
        Returns the main axis of the circle. it is the axis perpendicular to the plane of the circle, passing through the 'location' point (center) of the circle.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Circ_Axis(self, *args)

    def Contains(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the point p is on the circumference. the distance between <self> and <p> must be lower or equal to lineartolerance.

        Parameters
        ----------
        P: gp_Pnt
        LinearTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Circ_Contains(self, *args)

    def Distance(self, *args) -> "Standard_Real":
        r"""
        Computes the minimum of distance between the point p and any point on the circumference of the circle.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        float

        """
        return _gp.gp_Circ_Distance(self, *args)

    def Length(self, *args) -> "Standard_Real":
        r"""
        Computes the circumference of the circle.

        Returns
        -------
        float

        """
        return _gp.gp_Circ_Length(self, *args)

    def Location(self, *args) -> "gp_Pnt const":
        r"""
        Returns the center of the circle. it is the 'location' point of the local coordinate system of the circle.

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Circ_Location(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        None

        """
        return _gp.gp_Circ_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Circ":
        r"""
        Performs the symmetrical transformation of a circle with respect to the point p which is the center of the symmetry.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        gp_Circ
        Performs the symmetrical transformation of a circle with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        gp_Circ
        Performs the symmetrical transformation of a circle with respect to a plane. the axis placement a2 locates the plane of the of the symmetry : (location, xdirection, ydirection).

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        gp_Circ

        """
        return _gp.gp_Circ_Mirrored(self, *args)

    def Position(self, *args) -> "gp_Ax2 const":
        r"""
        Returns the position of the circle. it is the local coordinate system of the circle.

        Returns
        -------
        gp_Ax2

        """
        return _gp.gp_Circ_Position(self, *args)

    def Radius(self, *args) -> "Standard_Real":
        r"""
        Returns the radius of this circle.

        Returns
        -------
        float

        """
        return _gp.gp_Circ_Radius(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Circ_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Circ":
        r"""
        Rotates a circle. a1 is the axis of the rotation. ang is the angular value of the rotation in radians.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        gp_Circ

        """
        return _gp.gp_Circ_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Circ_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Circ":
        r"""
        Scales a circle. s is the scaling value. warnings : if s is negative the radius stay positive but the 'xaxis' and the 'yaxis' are reversed as for an ellipse.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        gp_Circ

        """
        return _gp.gp_Circ_Scaled(self, *args)

    def SetAxis(self, *args) -> "void":
        r"""
        Changes the main axis of the circle. it is the axis perpendicular to the plane of the circle. raises constructionerror if the direction of a1 is parallel to the 'xaxis' of the circle.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None

        """
        return _gp.gp_Circ_SetAxis(self, *args)

    def SetLocation(self, *args) -> "void":
        r"""
        Changes the 'location' point (center) of the circle.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Circ_SetLocation(self, *args)

    def SetPosition(self, *args) -> "void":
        r"""
        Changes the position of the circle.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        None

        """
        return _gp.gp_Circ_SetPosition(self, *args)

    def SetRadius(self, *args) -> "void":
        r"""
        Modifies the radius of this circle. warning. this class does not prevent the creation of a circle where radius is null. exceptions standard_constructionerror if radius is negative.

        Parameters
        ----------
        Radius: float

        Returns
        -------
        None

        """
        return _gp.gp_Circ_SetRadius(self, *args)

    def SquareDistance(self, *args) -> "Standard_Real":
        r"""
        Computes the square distance between <self> and the point p.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        float

        """
        return _gp.gp_Circ_SquareDistance(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        None

        """
        return _gp.gp_Circ_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Circ":
        r"""
        Transforms a circle with the transformation t from class trsf.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        gp_Circ

        """
        return _gp.gp_Circ_Transformed(self, *args)

    def Translate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Circ_Translate(self, *args)

    def Translated(self, *args) -> "gp_Circ":
        r"""
        Translates a circle in the direction of the vector v. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        gp_Circ
        Translates a circle from the point p1 to the point p2.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        gp_Circ

        """
        return _gp.gp_Circ_Translated(self, *args)

    def XAxis(self, *args) -> "gp_Ax1":
        r"""
        Returns the 'xaxis' of the circle. this axis is perpendicular to the axis of the conic. this axis and the 'yaxis' define the plane of the conic.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Circ_XAxis(self, *args)

    def YAxis(self, *args) -> "gp_Ax1":
        r"""
        Returns the 'yaxis' of the circle. this axis and the 'xaxis' define the plane of the conic. the 'yaxis' is perpendicular to the 'xaxis'.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Circ_YAxis(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Circ

# Register gp_Circ in _gp:
_gp.gp_Circ_swigregister(gp_Circ)

class gp_Circ2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an indefinite circle.

        Returns
        -------
        None
        The location point of xaxis is the center of the circle. warnings : it is not forbidden to create a circle with radius = 0.0 raises constructionerror if radius < 0.0. raised if radius < 0.0.

        Parameters
        ----------
        XAxis: gp_Ax2d
        Radius: float
        Sense: bool,optional
        	default value is Standard_True

        Returns
        -------
        None
        Axis defines the xaxis and yaxis of the circle which defines the origin and the sense of parametrization. the location point of axis is the center of the circle. warnings : it is not forbidden to create a circle with radius = 0.0 raises constructionerror if radius < 0.0. raised if radius < 0.0.

        Parameters
        ----------
        Axis: gp_Ax22d
        Radius: float

        Returns
        -------
        None

        """
        _gp.gp_Circ2d_swiginit(self, _gp.new_gp_Circ2d(*args))

    def Area(self, *args) -> "Standard_Real":
        r"""
        Computes the area of the circle.

        Returns
        -------
        float

        """
        return _gp.gp_Circ2d_Area(self, *args)

    def Axis(self, *args) -> "gp_Ax22d const":
        r"""
        Returns the position of the circle.

        Returns
        -------
        gp_Ax22d

        """
        return _gp.gp_Circ2d_Axis(self, *args)

    def Coefficients(self, *args) -> "void":
        r"""
        Returns the normalized coefficients from the implicit equation of the circle : a * (x**2) + b * (y**2) + 2*c*(x*y) + 2*d*x + 2*e*y + f = 0.0.

        Parameters
        ----------

        Returns
        -------
        A: float
        B: float
        C: float
        D: float
        E: float
        F: float

        """
        return _gp.gp_Circ2d_Coefficients(self, *args)

    def Contains(self, *args) -> "Standard_Boolean":
        r"""
        Does <self> contain p ? returns true if the distance between p and any point on the circumference of the circle is lower of equal to <lineartolerance>.

        Parameters
        ----------
        P: gp_Pnt2d
        LinearTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Circ2d_Contains(self, *args)

    def Distance(self, *args) -> "Standard_Real":
        r"""
        Computes the minimum of distance between the point p and any point on the circumference of the circle.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        float

        """
        return _gp.gp_Circ2d_Distance(self, *args)

    def IsDirect(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the local coordinate system is direct and false in the other case.

        Returns
        -------
        bool

        """
        return _gp.gp_Circ2d_IsDirect(self, *args)

    def Length(self, *args) -> "Standard_Real":
        r"""
        Computes the circumference of the circle.

        Returns
        -------
        float

        """
        return _gp.gp_Circ2d_Length(self, *args)

    def Location(self, *args) -> "gp_Pnt2d const":
        r"""
        Returns the location point (center) of the circle.

        Returns
        -------
        gp_Pnt2d

        """
        return _gp.gp_Circ2d_Location(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        None

        """
        return _gp.gp_Circ2d_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Circ2d":
        r"""
        Performs the symmetrical transformation of a circle with respect to the point p which is the center of the symmetry.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        gp_Circ2d
        Performs the symmetrical transformation of a circle with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        gp_Circ2d

        """
        return _gp.gp_Circ2d_Mirrored(self, *args)

    def Position(self, *args) -> "gp_Ax22d const":
        r"""
        Returns the position of the circle. idem axis(me).

        Returns
        -------
        gp_Ax22d

        """
        return _gp.gp_Circ2d_Position(self, *args)

    def Radius(self, *args) -> "Standard_Real":
        r"""
        Returns the radius value of the circle.

        Returns
        -------
        float

        """
        return _gp.gp_Circ2d_Radius(self, *args)

    def Reverse(self, *args) -> "void":
        r"""
        Reverses the orientation of the local coordinate system of this circle (the 'y direction' is reversed) and therefore changes the implicit orientation of this circle. reverse assigns the result to this circle,.

        Returns
        -------
        None

        """
        return _gp.gp_Circ2d_Reverse(self, *args)

    def Reversed(self, *args) -> "gp_Circ2d":
        r"""
        Reverses the orientation of the local coordinate system of this circle (the 'y direction' is reversed) and therefore changes the implicit orientation of this circle. reversed creates a new circle.

        Returns
        -------
        gp_Circ2d

        """
        return _gp.gp_Circ2d_Reversed(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Circ2d_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Circ2d":
        r"""
        Rotates a circle. p is the center of the rotation. ang is the angular value of the rotation in radians.

        Parameters
        ----------
        P: gp_Pnt2d
        Ang: float

        Returns
        -------
        gp_Circ2d

        """
        return _gp.gp_Circ2d_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Circ2d_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Circ2d":
        r"""
        Scales a circle. s is the scaling value. warnings : if s is negative the radius stay positive but the 'xaxis' and the 'yaxis' are reversed as for an ellipse.

        Parameters
        ----------
        P: gp_Pnt2d
        S: float

        Returns
        -------
        gp_Circ2d

        """
        return _gp.gp_Circ2d_Scaled(self, *args)

    def SetAxis(self, *args) -> "void":
        r"""
        Changes the x axis of the circle.

        Parameters
        ----------
        A: gp_Ax22d

        Returns
        -------
        None

        """
        return _gp.gp_Circ2d_SetAxis(self, *args)

    def SetLocation(self, *args) -> "void":
        r"""
        Changes the location point (center) of the circle.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        None

        """
        return _gp.gp_Circ2d_SetLocation(self, *args)

    def SetRadius(self, *args) -> "void":
        r"""
        Modifies the radius of this circle. this class does not prevent the creation of a circle where radius is null. exceptions standard_constructionerror if radius is negative.

        Parameters
        ----------
        Radius: float

        Returns
        -------
        None

        """
        return _gp.gp_Circ2d_SetRadius(self, *args)

    def SetXAxis(self, *args) -> "void":
        r"""
        Changes the x axis of the circle.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        None

        """
        return _gp.gp_Circ2d_SetXAxis(self, *args)

    def SetYAxis(self, *args) -> "void":
        r"""
        Changes the y axis of the circle.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        None

        """
        return _gp.gp_Circ2d_SetYAxis(self, *args)

    def SquareDistance(self, *args) -> "Standard_Real":
        r"""
        Computes the square distance between <self> and the point p.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        float

        """
        return _gp.gp_Circ2d_SquareDistance(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        None

        """
        return _gp.gp_Circ2d_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Circ2d":
        r"""
        Transforms a circle with the transformation t from class trsf2d.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        gp_Circ2d

        """
        return _gp.gp_Circ2d_Transformed(self, *args)

    def Translate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Vec2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        None

        """
        return _gp.gp_Circ2d_Translate(self, *args)

    def Translated(self, *args) -> "gp_Circ2d":
        r"""
        Translates a circle in the direction of the vector v. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        V: gp_Vec2d

        Returns
        -------
        gp_Circ2d
        Translates a circle from the point p1 to the point p2.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        gp_Circ2d

        """
        return _gp.gp_Circ2d_Translated(self, *args)

    def XAxis(self, *args) -> "gp_Ax2d":
        r"""
        Returns the x axis of the circle.

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Circ2d_XAxis(self, *args)

    def YAxis(self, *args) -> "gp_Ax2d":
        r"""
        Returns the y axis of the circle. reverses the direction of the circle.

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Circ2d_YAxis(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Circ2d

# Register gp_Circ2d in _gp:
_gp.gp_Circ2d_swigregister(gp_Circ2d)

class gp_Cone(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an indefinite cone.

        Returns
        -------
        None
        Creates an infinite conical surface. a3 locates the cone in the space and defines the reference plane of the surface. ang is the conical surface semi-angle. its absolute value is in range ]0, pi/2[. radius is the radius of the circle in the reference plane of the cone. raises constructionerror * if radius is lower than 0.0 * abs(ang) < resolution from gp or abs(ang) >= (pi/2) - resolution.

        Parameters
        ----------
        A3: gp_Ax3
        Ang: float
        Radius: float

        Returns
        -------
        None

        """
        _gp.gp_Cone_swiginit(self, _gp.new_gp_Cone(*args))

    def Apex(self, *args) -> "gp_Pnt":
        r"""
        Computes the cone's top. the apex of the cone is on the negative side of the symmetry axis of the cone.

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Cone_Apex(self, *args)

    def Axis(self, *args) -> "gp_Ax1 const":
        r"""
        Returns the symmetry axis of the cone.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Cone_Axis(self, *args)

    def Coefficients(self, *args) -> "void":
        r"""
        Computes the coefficients of the implicit equation of the quadric in the absolute cartesian coordinates system : a1.x**2 + a2.y**2 + a3.z**2 + 2.(b1.x.y + b2.x.z + b3.y.z) + 2.(c1.x + c2.y + c3.z) + d = 0.0.

        Parameters
        ----------

        Returns
        -------
        A1: float
        A2: float
        A3: float
        B1: float
        B2: float
        B3: float
        C1: float
        C2: float
        C3: float
        D: float

        """
        return _gp.gp_Cone_Coefficients(self, *args)

    def Direct(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the local coordinate system of this cone is right-handed.

        Returns
        -------
        bool

        """
        return _gp.gp_Cone_Direct(self, *args)

    def Location(self, *args) -> "gp_Pnt const":
        r"""
        Returns the 'location' point of the cone.

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Cone_Location(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        None

        """
        return _gp.gp_Cone_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Cone":
        r"""
        Performs the symmetrical transformation of a cone with respect to the point p which is the center of the symmetry.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        gp_Cone
        Performs the symmetrical transformation of a cone with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        gp_Cone
        Performs the symmetrical transformation of a cone with respect to a plane. the axis placement a2 locates the plane of the of the symmetry : (location, xdirection, ydirection).

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        gp_Cone

        """
        return _gp.gp_Cone_Mirrored(self, *args)

    def Position(self, *args) -> "gp_Ax3 const":
        r"""
        Returns the local coordinates system of the cone.

        Returns
        -------
        gp_Ax3

        """
        return _gp.gp_Cone_Position(self, *args)

    def RefRadius(self, *args) -> "Standard_Real":
        r"""
        Returns the radius of the cone in the reference plane.

        Returns
        -------
        float

        """
        return _gp.gp_Cone_RefRadius(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Cone_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Cone":
        r"""
        Rotates a cone. a1 is the axis of the rotation. ang is the angular value of the rotation in radians.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        gp_Cone

        """
        return _gp.gp_Cone_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Cone_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Cone":
        r"""
        Scales a cone. s is the scaling value. the absolute value of s is used to scale the cone.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        gp_Cone

        """
        return _gp.gp_Cone_Scaled(self, *args)

    def SemiAngle(self, *args) -> "Standard_Real":
        r"""
        Returns the half-angle at the apex of this cone. attention! semi-angle can be negative.

        Returns
        -------
        float

        """
        return _gp.gp_Cone_SemiAngle(self, *args)

    def SetAxis(self, *args) -> "void":
        r"""
        Changes the symmetry axis of the cone. raises constructionerror the direction of a1 is parallel to the 'xdirection' of the coordinate system of the cone.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None

        """
        return _gp.gp_Cone_SetAxis(self, *args)

    def SetLocation(self, *args) -> "void":
        r"""
        Changes the location of the cone.

        Parameters
        ----------
        Loc: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Cone_SetLocation(self, *args)

    def SetPosition(self, *args) -> "void":
        r"""
        Changes the local coordinate system of the cone. this coordinate system defines the reference plane of the cone.

        Parameters
        ----------
        A3: gp_Ax3

        Returns
        -------
        None

        """
        return _gp.gp_Cone_SetPosition(self, *args)

    def SetRadius(self, *args) -> "void":
        r"""
        Changes the radius of the cone in the reference plane of the cone. raised if r < 0.0.

        Parameters
        ----------
        R: float

        Returns
        -------
        None

        """
        return _gp.gp_Cone_SetRadius(self, *args)

    def SetSemiAngle(self, *args) -> "void":
        r"""
        Changes the semi-angle of the cone. semi-angle can be negative. its absolute value abs(ang) is in range ]0,pi/2[. raises constructionerror if abs(ang) < resolution from gp or abs(ang) >= pi/2 - resolution.

        Parameters
        ----------
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Cone_SetSemiAngle(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        None

        """
        return _gp.gp_Cone_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Cone":
        r"""
        Transforms a cone with the transformation t from class trsf.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        gp_Cone

        """
        return _gp.gp_Cone_Transformed(self, *args)

    def Translate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Cone_Translate(self, *args)

    def Translated(self, *args) -> "gp_Cone":
        r"""
        Translates a cone in the direction of the vector v. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        gp_Cone
        Translates a cone from the point p1 to the point p2.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        gp_Cone

        """
        return _gp.gp_Cone_Translated(self, *args)

    def UReverse(self, *args) -> "void":
        r"""
        Reverses the u parametrization of the cone reversing the yaxis.

        Returns
        -------
        None

        """
        return _gp.gp_Cone_UReverse(self, *args)

    def VReverse(self, *args) -> "void":
        r"""
        Reverses the v parametrization of the cone reversing the zaxis.

        Returns
        -------
        None

        """
        return _gp.gp_Cone_VReverse(self, *args)

    def XAxis(self, *args) -> "gp_Ax1":
        r"""
        Returns the xaxis of the reference plane.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Cone_XAxis(self, *args)

    def YAxis(self, *args) -> "gp_Ax1":
        r"""
        Returns the yaxis of the reference plane.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Cone_YAxis(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Cone

# Register gp_Cone in _gp:
_gp.gp_Cone_swigregister(gp_Cone)

class gp_Cylinder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a indefinite cylinder.

        Returns
        -------
        None
        Creates a cylinder of radius radius, whose axis is the 'main axis' of a3. a3 is the local coordinate system of the cylinder. raises constructionerrord if r < 0.0.

        Parameters
        ----------
        A3: gp_Ax3
        Radius: float

        Returns
        -------
        None

        """
        _gp.gp_Cylinder_swiginit(self, _gp.new_gp_Cylinder(*args))

    def Axis(self, *args) -> "gp_Ax1 const":
        r"""
        Returns the symmetry axis of the cylinder.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Cylinder_Axis(self, *args)

    def Coefficients(self, *args) -> "void":
        r"""
        Computes the coefficients of the implicit equation of the quadric in the absolute cartesian coordinate system : a1.x**2 + a2.y**2 + a3.z**2 + 2.(b1.x.y + b2.x.z + b3.y.z) + 2.(c1.x + c2.y + c3.z) + d = 0.0.

        Parameters
        ----------

        Returns
        -------
        A1: float
        A2: float
        A3: float
        B1: float
        B2: float
        B3: float
        C1: float
        C2: float
        C3: float
        D: float

        """
        return _gp.gp_Cylinder_Coefficients(self, *args)

    def Direct(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the local coordinate system of this cylinder is right-handed.

        Returns
        -------
        bool

        """
        return _gp.gp_Cylinder_Direct(self, *args)

    def Location(self, *args) -> "gp_Pnt const":
        r"""
        Returns the 'location' point of the cylinder.

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Cylinder_Location(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        None

        """
        return _gp.gp_Cylinder_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Cylinder":
        r"""
        Performs the symmetrical transformation of a cylinder with respect to the point p which is the center of the symmetry.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        gp_Cylinder
        Performs the symmetrical transformation of a cylinder with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        gp_Cylinder
        Performs the symmetrical transformation of a cylinder with respect to a plane. the axis placement a2 locates the plane of the of the symmetry : (location, xdirection, ydirection).

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        gp_Cylinder

        """
        return _gp.gp_Cylinder_Mirrored(self, *args)

    def Position(self, *args) -> "gp_Ax3 const":
        r"""
        Returns the local coordinate system of the cylinder.

        Returns
        -------
        gp_Ax3

        """
        return _gp.gp_Cylinder_Position(self, *args)

    def Radius(self, *args) -> "Standard_Real":
        r"""
        Returns the radius of the cylinder.

        Returns
        -------
        float

        """
        return _gp.gp_Cylinder_Radius(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Cylinder_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Cylinder":
        r"""
        Rotates a cylinder. a1 is the axis of the rotation. ang is the angular value of the rotation in radians.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        gp_Cylinder

        """
        return _gp.gp_Cylinder_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Cylinder_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Cylinder":
        r"""
        Scales a cylinder. s is the scaling value. the absolute value of s is used to scale the cylinder.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        gp_Cylinder

        """
        return _gp.gp_Cylinder_Scaled(self, *args)

    def SetAxis(self, *args) -> "void":
        r"""
        Changes the symmetry axis of the cylinder. raises constructionerror if the direction of a1 is parallel to the 'xdirection' of the coordinate system of the cylinder.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None

        """
        return _gp.gp_Cylinder_SetAxis(self, *args)

    def SetLocation(self, *args) -> "void":
        r"""
        Changes the location of the surface.

        Parameters
        ----------
        Loc: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Cylinder_SetLocation(self, *args)

    def SetPosition(self, *args) -> "void":
        r"""
        Change the local coordinate system of the surface.

        Parameters
        ----------
        A3: gp_Ax3

        Returns
        -------
        None

        """
        return _gp.gp_Cylinder_SetPosition(self, *args)

    def SetRadius(self, *args) -> "void":
        r"""
        Modifies the radius of this cylinder. exceptions standard_constructionerror if r is negative.

        Parameters
        ----------
        R: float

        Returns
        -------
        None

        """
        return _gp.gp_Cylinder_SetRadius(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        None

        """
        return _gp.gp_Cylinder_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Cylinder":
        r"""
        Transforms a cylinder with the transformation t from class trsf.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        gp_Cylinder

        """
        return _gp.gp_Cylinder_Transformed(self, *args)

    def Translate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Cylinder_Translate(self, *args)

    def Translated(self, *args) -> "gp_Cylinder":
        r"""
        Translates a cylinder in the direction of the vector v. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        gp_Cylinder
        Translates a cylinder from the point p1 to the point p2.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        gp_Cylinder

        """
        return _gp.gp_Cylinder_Translated(self, *args)

    def UReverse(self, *args) -> "void":
        r"""
        Reverses the u parametrization of the cylinder reversing the yaxis.

        Returns
        -------
        None

        """
        return _gp.gp_Cylinder_UReverse(self, *args)

    def VReverse(self, *args) -> "void":
        r"""
        Reverses the v parametrization of the plane reversing the axis.

        Returns
        -------
        None

        """
        return _gp.gp_Cylinder_VReverse(self, *args)

    def XAxis(self, *args) -> "gp_Ax1":
        r"""
        Returns the axis x of the cylinder.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Cylinder_XAxis(self, *args)

    def YAxis(self, *args) -> "gp_Ax1":
        r"""
        Returns the axis y of the cylinder.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Cylinder_YAxis(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Cylinder

# Register gp_Cylinder in _gp:
_gp.gp_Cylinder_swigregister(gp_Cylinder)

class gp_Dir(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a direction corresponding to x axis.

        Returns
        -------
        None
        Normalizes the vector v and creates a direction. raises constructionerror if v.magnitude() <= resolution.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        None
        Creates a direction from a triplet of coordinates. raises constructionerror if coord.modulus() <= resolution from gp.

        Parameters
        ----------
        Coord: gp_XYZ

        Returns
        -------
        None
        Creates a direction with its 3 cartesian coordinates. raises constructionerror if sqrt(xv*xv + yv*yv + zv*zv) <= resolution modification of the direction's coordinates if sqrt (x*x + y*y + z*z) <= resolution from gp where x, y ,z are the new coordinates it is not possible to construct the direction and the method raises the exception constructionerror.

        Parameters
        ----------
        Xv: float
        Yv: float
        Zv: float

        Returns
        -------
        None

        """
        _gp.gp_Dir_swiginit(self, _gp.new_gp_Dir(*args))

    def Angle(self, *args) -> "Standard_Real":
        r"""
        Computes the angular value in radians between <self> and <other>. this value is always positive in 3d space. returns the angle in the range [0, pi].

        Parameters
        ----------
        Other: gp_Dir

        Returns
        -------
        float

        """
        return _gp.gp_Dir_Angle(self, *args)

    def AngleWithRef(self, *args) -> "Standard_Real":
        r"""
        Computes the angular value between <self> and <other>. <vref> is the direction of reference normal to <self> and <other> and its orientation gives the positive sense of rotation. if the cross product <self> ^ <other> has the same orientation as <vref> the angular value is positive else negative. returns the angular value in the range -pi and pi (in radians). raises domainerror if <self> and <other> are not parallel this exception is raised when <vref> is in the same plane as <self> and <other> the tolerance criterion is resolution from package gp.

        Parameters
        ----------
        Other: gp_Dir
        VRef: gp_Dir

        Returns
        -------
        float

        """
        return _gp.gp_Dir_AngleWithRef(self, *args)

    def Coord(self, *args) -> "void":
        r"""
        Returns the coordinate of range index : index = 1 => x is returned index = 2 => y is returned index = 3 => z is returned exceptions standard_outofrange if index is not 1, 2, or 3.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float
        Returns for the unit vector its three coordinates xv, yv, and zv.

        Parameters
        ----------

        Returns
        -------
        Xv: float
        Yv: float
        Zv: float

        """
        return _gp.gp_Dir_Coord(self, *args)

    def Cross(self, *args) -> "void":
        r"""
        Computes the cross product between two directions raises the exception constructionerror if the two directions are parallel because the computed vector cannot be normalized to create a direction.

        Parameters
        ----------
        Right: gp_Dir

        Returns
        -------
        None

        """
        return _gp.gp_Dir_Cross(self, *args)

    def CrossCross(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V1: gp_Dir
        V2: gp_Dir

        Returns
        -------
        None

        """
        return _gp.gp_Dir_CrossCross(self, *args)

    def CrossCrossed(self, *args) -> "gp_Dir":
        r"""
        Computes the double vector product this ^ (v1 ^ v2). - crosscrossed creates a new unit vector. exceptions standard_constructionerror if: - v1 and v2 are parallel, or - this unit vector and (v1 ^ v2) are parallel. this is because, in these conditions, the computed vector is null and cannot be normalized.

        Parameters
        ----------
        V1: gp_Dir
        V2: gp_Dir

        Returns
        -------
        gp_Dir

        """
        return _gp.gp_Dir_CrossCrossed(self, *args)

    def Crossed(self, *args) -> "gp_Dir":
        r"""
        Computes the triple vector product. <self> ^ (v1 ^ v2) raises the exception constructionerror if v1 and v2 are parallel or <self> and (v1^v2) are parallel because the computed vector can't be normalized to create a direction.

        Parameters
        ----------
        Right: gp_Dir

        Returns
        -------
        gp_Dir

        """
        return _gp.gp_Dir_Crossed(self, *args)

    def Dot(self, *args) -> "Standard_Real":
        r"""
        Computes the scalar product.

        Parameters
        ----------
        Other: gp_Dir

        Returns
        -------
        float

        """
        return _gp.gp_Dir_Dot(self, *args)

    def DotCross(self, *args) -> "Standard_Real":
        r"""
        Computes the triple scalar product <self> * (v1 ^ v2). warnings : the computed vector v1' = v1 ^ v2 is not normalized to create a unitary vector. so this method never raises an exception even if v1 and v2 are parallel.

        Parameters
        ----------
        V1: gp_Dir
        V2: gp_Dir

        Returns
        -------
        float

        """
        return _gp.gp_Dir_DotCross(self, *args)

    def IsEqual(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the angle between the two directions is lower or equal to angulartolerance.

        Parameters
        ----------
        Other: gp_Dir
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Dir_IsEqual(self, *args)

    def IsNormal(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the angle between this unit vector and the unit vector other is equal to pi/2 (normal).

        Parameters
        ----------
        Other: gp_Dir
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Dir_IsNormal(self, *args)

    def IsOpposite(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the angle between this unit vector and the unit vector other is equal to pi (opposite).

        Parameters
        ----------
        Other: gp_Dir
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Dir_IsOpposite(self, *args)

    def IsParallel(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the angle between this unit vector and the unit vector other is equal to 0 or to pi. note: the tolerance criterion is given by angulartolerance.

        Parameters
        ----------
        Other: gp_Dir
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Dir_IsParallel(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Dir

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        None

        """
        return _gp.gp_Dir_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Dir":
        r"""
        Performs the symmetrical transformation of a direction with respect to the direction v which is the center of the symmetry.

        Parameters
        ----------
        V: gp_Dir

        Returns
        -------
        gp_Dir
        Performs the symmetrical transformation of a direction with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        gp_Dir
        Performs the symmetrical transformation of a direction with respect to a plane. the axis placement a2 locates the plane of the symmetry : (location, xdirection, ydirection).

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        gp_Dir

        """
        return _gp.gp_Dir_Mirrored(self, *args)

    def Reverse(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _gp.gp_Dir_Reverse(self, *args)

    def Reversed(self, *args) -> "gp_Dir":
        r"""
        Reverses the orientation of a direction geometric transformations performs the symmetrical transformation of a direction with respect to the direction v which is the center of the symmetry.].

        Returns
        -------
        gp_Dir

        """
        return _gp.gp_Dir_Reversed(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Dir_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Dir":
        r"""
        Rotates a direction. a1 is the axis of the rotation. ang is the angular value of the rotation in radians.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        gp_Dir

        """
        return _gp.gp_Dir_Rotated(self, *args)

    def SetCoord(self, *args) -> "void":
        r"""
        For this unit vector, assigns the value xi to: - the x coordinate if index is 1, or - the y coordinate if index is 2, or - the z coordinate if index is 3, and then normalizes it. warning remember that all the coordinates of a unit vector are implicitly modified when any single one is changed directly. exceptions standard_outofrange if index is not 1, 2, or 3. standard_constructionerror if either of the following is less than or equal to gp::resolution(): - sqrt(xv*xv + yv*yv + zv*zv), or - the modulus of the number triple formed by the new value xi and the two other coordinates of this vector that were not directly modified.

        Parameters
        ----------
        Index: int
        Xi: float

        Returns
        -------
        None
        For this unit vector, assigns the values xv, yv and zv to its three coordinates. remember that all the coordinates of a unit vector are implicitly modified when any single one is changed directly.

        Parameters
        ----------
        Xv: float
        Yv: float
        Zv: float

        Returns
        -------
        None

        """
        return _gp.gp_Dir_SetCoord(self, *args)

    def SetX(self, *args) -> "void":
        r"""
        Assigns the given value to the x coordinate of this unit vector.

        Parameters
        ----------
        X: float

        Returns
        -------
        None

        """
        return _gp.gp_Dir_SetX(self, *args)

    def SetXYZ(self, *args) -> "void":
        r"""
        Assigns the three coordinates of coord to this unit vector.

        Parameters
        ----------
        Coord: gp_XYZ

        Returns
        -------
        None

        """
        return _gp.gp_Dir_SetXYZ(self, *args)

    def SetY(self, *args) -> "void":
        r"""
        Assigns the given value to the y coordinate of this unit vector.

        Parameters
        ----------
        Y: float

        Returns
        -------
        None

        """
        return _gp.gp_Dir_SetY(self, *args)

    def SetZ(self, *args) -> "void":
        r"""
        Assigns the given value to the z coordinate of this unit vector.

        Parameters
        ----------
        Z: float

        Returns
        -------
        None

        """
        return _gp.gp_Dir_SetZ(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        None

        """
        return _gp.gp_Dir_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Dir":
        r"""
        Transforms a direction with a 'trsf' from gp. warnings : if the scale factor of the 'trsf' t is negative then the direction <self> is reversed.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        gp_Dir

        """
        return _gp.gp_Dir_Transformed(self, *args)

    def X(self, *args) -> "Standard_Real":
        r"""
        Returns the x coordinate for a unit vector.

        Returns
        -------
        float

        """
        return _gp.gp_Dir_X(self, *args)

    def XYZ(self, *args) -> "gp_XYZ const":
        r"""
        For this unit vector, returns its three coordinates as a number triplea.

        Returns
        -------
        gp_XYZ

        """
        return _gp.gp_Dir_XYZ(self, *args)

    def Y(self, *args) -> "Standard_Real":
        r"""
        Returns the y coordinate for a unit vector.

        Returns
        -------
        float

        """
        return _gp.gp_Dir_Y(self, *args)

    def Z(self, *args) -> "Standard_Real":
        r"""
        Returns the z coordinate for a unit vector.

        Returns
        -------
        float

        """
        return _gp.gp_Dir_Z(self, *args)

    def __mul__(self, *args) -> "Standard_Real":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_Dir

        Returns
        -------
        float

        """
        return _gp.gp_Dir___mul__(self, *args)

    def __neg__(self, *args) -> "gp_Dir":
        r"""
        No available documentation.

        Returns
        -------
        gp_Dir

        """
        return _gp.gp_Dir___neg__(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Dir

# Register gp_Dir in _gp:
_gp.gp_Dir_swigregister(gp_Dir)

class gp_Dir2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a direction corresponding to x axis.

        Returns
        -------
        None
        Normalizes the vector v and creates a direction. raises constructionerror if v.magnitude() <= resolution from gp.

        Parameters
        ----------
        V: gp_Vec2d

        Returns
        -------
        None
        Creates a direction from a doublet of coordinates. raises constructionerror if coord.modulus() <= resolution from gp.

        Parameters
        ----------
        Coord: gp_XY

        Returns
        -------
        None
        Creates a direction with its 2 cartesian coordinates. raises constructionerror if sqrt(xv*xv + yv*yv) <= resolution from gp.

        Parameters
        ----------
        Xv: float
        Yv: float

        Returns
        -------
        None

        """
        _gp.gp_Dir2d_swiginit(self, _gp.new_gp_Dir2d(*args))

    def Angle(self, *args) -> "Standard_Real":
        r"""
        Computes the angular value in radians between <self> and <other>. returns the angle in the range [-pi, pi].

        Parameters
        ----------
        Other: gp_Dir2d

        Returns
        -------
        float

        """
        return _gp.gp_Dir2d_Angle(self, *args)

    def Coord(self, *args) -> "void":
        r"""
        For this unit vector returns the coordinate of range index : index = 1 => x is returned index = 2 => y is returned raises outofrange if index != {1, 2}.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float
        For this unit vector returns its two coordinates xv and yv. raises outofrange if index != {1, 2}.

        Parameters
        ----------

        Returns
        -------
        Xv: float
        Yv: float

        """
        return _gp.gp_Dir2d_Coord(self, *args)

    def Crossed(self, *args) -> "Standard_Real":
        r"""
        Computes the cross product between two directions.

        Parameters
        ----------
        Right: gp_Dir2d

        Returns
        -------
        float

        """
        return _gp.gp_Dir2d_Crossed(self, *args)

    def Dot(self, *args) -> "Standard_Real":
        r"""
        Computes the scalar product.

        Parameters
        ----------
        Other: gp_Dir2d

        Returns
        -------
        float

        """
        return _gp.gp_Dir2d_Dot(self, *args)

    def IsEqual(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the two vectors have the same direction i.e. the angle between this unit vector and the unit vector other is less than or equal to angulartolerance.

        Parameters
        ----------
        Other: gp_Dir2d
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Dir2d_IsEqual(self, *args)

    def IsNormal(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the angle between this unit vector and the unit vector other is equal to pi/2 or -pi/2 (normal) i.e. abs(abs(<self>.angle(other)) - pi/2.) <= angulartolerance.

        Parameters
        ----------
        Other: gp_Dir2d
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Dir2d_IsNormal(self, *args)

    def IsOpposite(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the angle between this unit vector and the unit vector other is equal to pi or -pi (opposite). i.e. pi - abs(<self>.angle(other)) <= angulartolerance.

        Parameters
        ----------
        Other: gp_Dir2d
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Dir2d_IsOpposite(self, *args)

    def IsParallel(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if if the angle between this unit vector and unit vector other is equal to 0, pi or -pi. i.e. abs(angle(<self>, other)) <= angulartolerance or pi - abs(angle(<self>, other)) <= angulartolerance.

        Parameters
        ----------
        Other: gp_Dir2d
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Dir2d_IsParallel(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Dir2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        None

        """
        return _gp.gp_Dir2d_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Dir2d":
        r"""
        Performs the symmetrical transformation of a direction with respect to the direction v which is the center of the symmetry.

        Parameters
        ----------
        V: gp_Dir2d

        Returns
        -------
        gp_Dir2d
        Performs the symmetrical transformation of a direction with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        gp_Dir2d

        """
        return _gp.gp_Dir2d_Mirrored(self, *args)

    def Reverse(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _gp.gp_Dir2d_Reverse(self, *args)

    def Reversed(self, *args) -> "gp_Dir2d":
        r"""
        Reverses the orientation of a direction.

        Returns
        -------
        gp_Dir2d

        """
        return _gp.gp_Dir2d_Reversed(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Dir2d_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Dir2d":
        r"""
        Rotates a direction. ang is the angular value of the rotation in radians.

        Parameters
        ----------
        Ang: float

        Returns
        -------
        gp_Dir2d

        """
        return _gp.gp_Dir2d_Rotated(self, *args)

    def SetCoord(self, *args) -> "void":
        r"""
        For this unit vector, assigns: the value xi to: - the x coordinate if index is 1, or - the y coordinate if index is 2, and then normalizes it. warning remember that all the coordinates of a unit vector are implicitly modified when any single one is changed directly. exceptions standard_outofrange if index is not 1 or 2. standard_constructionerror if either of the following is less than or equal to gp::resolution(): - sqrt(xv*xv + yv*yv), or - the modulus of the number pair formed by the new value xi and the other coordinate of this vector that was not directly modified. raises outofrange if index != {1, 2}.

        Parameters
        ----------
        Index: int
        Xi: float

        Returns
        -------
        None
        For this unit vector, assigns: - the values xv and yv to its two coordinates, warning remember that all the coordinates of a unit vector are implicitly modified when any single one is changed directly. exceptions standard_outofrange if index is not 1 or 2. standard_constructionerror if either of the following is less than or equal to gp::resolution(): - sqrt(xv*xv + yv*yv), or - the modulus of the number pair formed by the new value xi and the other coordinate of this vector that was not directly modified. raises outofrange if index != {1, 2}.

        Parameters
        ----------
        Xv: float
        Yv: float

        Returns
        -------
        None

        """
        return _gp.gp_Dir2d_SetCoord(self, *args)

    def SetX(self, *args) -> "void":
        r"""
        Assigns the given value to the x coordinate of this unit vector, and then normalizes it. warning remember that all the coordinates of a unit vector are implicitly modified when any single one is changed directly. exceptions standard_constructionerror if either of the following is less than or equal to gp::resolution(): - the modulus of coord, or - the modulus of the number pair formed from the new x or y coordinate and the other coordinate of this vector that was not directly modified.

        Parameters
        ----------
        X: float

        Returns
        -------
        None

        """
        return _gp.gp_Dir2d_SetX(self, *args)

    def SetXY(self, *args) -> "void":
        r"""
        Assigns: - the two coordinates of coord to this unit vector, and then normalizes it. warning remember that all the coordinates of a unit vector are implicitly modified when any single one is changed directly. exceptions standard_constructionerror if either of the following is less than or equal to gp::resolution(): - the modulus of coord, or - the modulus of the number pair formed from the new x or y coordinate and the other coordinate of this vector that was not directly modified.

        Parameters
        ----------
        Coord: gp_XY

        Returns
        -------
        None

        """
        return _gp.gp_Dir2d_SetXY(self, *args)

    def SetY(self, *args) -> "void":
        r"""
        Assigns the given value to the y coordinate of this unit vector, and then normalizes it. warning remember that all the coordinates of a unit vector are implicitly modified when any single one is changed directly. exceptions standard_constructionerror if either of the following is less than or equal to gp::resolution(): - the modulus of coord, or - the modulus of the number pair formed from the new x or y coordinate and the other coordinate of this vector that was not directly modified.

        Parameters
        ----------
        Y: float

        Returns
        -------
        None

        """
        return _gp.gp_Dir2d_SetY(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        None

        """
        return _gp.gp_Dir2d_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Dir2d":
        r"""
        Transforms a direction with the 'trsf' t. warnings : if the scale factor of the 'trsf' t is negative then the direction <self> is reversed.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        gp_Dir2d

        """
        return _gp.gp_Dir2d_Transformed(self, *args)

    def X(self, *args) -> "Standard_Real":
        r"""
        For this unit vector, returns its x coordinate.

        Returns
        -------
        float

        """
        return _gp.gp_Dir2d_X(self, *args)

    def XY(self, *args) -> "gp_XY const":
        r"""
        For this unit vector, returns its two coordinates as a number pair. comparison between directions the precision value is an input data.

        Returns
        -------
        gp_XY

        """
        return _gp.gp_Dir2d_XY(self, *args)

    def Y(self, *args) -> "Standard_Real":
        r"""
        For this unit vector, returns its y coordinate.

        Returns
        -------
        float

        """
        return _gp.gp_Dir2d_Y(self, *args)

    def __mul__(self, *args) -> "Standard_Real":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_Dir2d

        Returns
        -------
        float

        """
        return _gp.gp_Dir2d___mul__(self, *args)

    def __neg__(self, *args) -> "gp_Dir2d":
        r"""
        No available documentation.

        Returns
        -------
        gp_Dir2d

        """
        return _gp.gp_Dir2d___neg__(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Dir2d

# Register gp_Dir2d in _gp:
_gp.gp_Dir2d_swigregister(gp_Dir2d)

class gp_Elips(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an indefinite ellipse.

        Returns
        -------
        None
        The major radius of the ellipse is on the 'xaxis' and the minor radius is on the 'yaxis' of the ellipse. the 'xaxis' is defined with the 'xdirection' of a2 and the 'yaxis' is defined with the 'ydirection' of a2. warnings : it is not forbidden to create an ellipse with majorradius = minorradius. raises constructionerror if majorradius < minorradius or minorradius < 0.

        Parameters
        ----------
        A2: gp_Ax2
        MajorRadius: float
        MinorRadius: float

        Returns
        -------
        None

        """
        _gp.gp_Elips_swiginit(self, _gp.new_gp_Elips(*args))

    def Area(self, *args) -> "Standard_Real":
        r"""
        Computes the area of the ellipse.

        Returns
        -------
        float

        """
        return _gp.gp_Elips_Area(self, *args)

    def Axis(self, *args) -> "gp_Ax1 const":
        r"""
        Computes the axis normal to the plane of the ellipse.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Elips_Axis(self, *args)

    def Directrix1(self, *args) -> "gp_Ax1":
        r"""
        Computes the first or second directrix of this ellipse. these are the lines, in the plane of the ellipse, normal to the major axis, at a distance equal to majorradius/e from the center of the ellipse, where e is the eccentricity of the ellipse. the first directrix (directrix1) is on the positive side of the major axis. the second directrix (directrix2) is on the negative side. the directrix is returned as an axis (gp_ax1 object), the origin of which is situated on the 'x axis' of the local coordinate system of this ellipse. exceptions standard_constructionerror if the eccentricity is null (the ellipse has degenerated into a circle).

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Elips_Directrix1(self, *args)

    def Directrix2(self, *args) -> "gp_Ax1":
        r"""
        This line is obtained by the symmetrical transformation of 'directrix1' with respect to the 'yaxis' of the ellipse. exceptions standard_constructionerror if the eccentricity is null (the ellipse has degenerated into a circle).

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Elips_Directrix2(self, *args)

    def Eccentricity(self, *args) -> "Standard_Real":
        r"""
        Returns the eccentricity of the ellipse between 0.0 and 1.0 if f is the distance between the center of the ellipse and the focus1 then the eccentricity e = f / majorradius. raises constructionerror if majorradius = 0.0.

        Returns
        -------
        float

        """
        return _gp.gp_Elips_Eccentricity(self, *args)

    def Focal(self, *args) -> "Standard_Real":
        r"""
        Computes the focal distance. it is the distance between the two focus focus1 and focus2 of the ellipse.

        Returns
        -------
        float

        """
        return _gp.gp_Elips_Focal(self, *args)

    def Focus1(self, *args) -> "gp_Pnt":
        r"""
        Returns the first focus of the ellipse. this focus is on the positive side of the 'xaxis' of the ellipse.

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Elips_Focus1(self, *args)

    def Focus2(self, *args) -> "gp_Pnt":
        r"""
        Returns the second focus of the ellipse. this focus is on the negative side of the 'xaxis' of the ellipse.

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Elips_Focus2(self, *args)

    def Location(self, *args) -> "gp_Pnt const":
        r"""
        Returns the center of the ellipse. it is the 'location' point of the coordinate system of the ellipse.

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Elips_Location(self, *args)

    def MajorRadius(self, *args) -> "Standard_Real":
        r"""
        Returns the major radius of the ellipse.

        Returns
        -------
        float

        """
        return _gp.gp_Elips_MajorRadius(self, *args)

    def MinorRadius(self, *args) -> "Standard_Real":
        r"""
        Returns the minor radius of the ellipse.

        Returns
        -------
        float

        """
        return _gp.gp_Elips_MinorRadius(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        None

        """
        return _gp.gp_Elips_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Elips":
        r"""
        Performs the symmetrical transformation of an ellipse with respect to the point p which is the center of the symmetry.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        gp_Elips
        Performs the symmetrical transformation of an ellipse with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        gp_Elips
        Performs the symmetrical transformation of an ellipse with respect to a plane. the axis placement a2 locates the plane of the symmetry (location, xdirection, ydirection).

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        gp_Elips

        """
        return _gp.gp_Elips_Mirrored(self, *args)

    def Parameter(self, *args) -> "Standard_Real":
        r"""
        Returns p = (1 - e * e) * majorradius where e is the eccentricity of the ellipse. returns 0 if majorradius = 0.

        Returns
        -------
        float

        """
        return _gp.gp_Elips_Parameter(self, *args)

    def Position(self, *args) -> "gp_Ax2 const":
        r"""
        Returns the coordinate system of the ellipse.

        Returns
        -------
        gp_Ax2

        """
        return _gp.gp_Elips_Position(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Elips_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Elips":
        r"""
        Rotates an ellipse. a1 is the axis of the rotation. ang is the angular value of the rotation in radians.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        gp_Elips

        """
        return _gp.gp_Elips_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Elips_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Elips":
        r"""
        Scales an ellipse. s is the scaling value.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        gp_Elips

        """
        return _gp.gp_Elips_Scaled(self, *args)

    def SetAxis(self, *args) -> "void":
        r"""
        Changes the axis normal to the plane of the ellipse. it modifies the definition of this plane. the 'xaxis' and the 'yaxis' are recomputed. the local coordinate system is redefined so that: - its origin and 'main direction' become those of the axis a1 (the 'x direction' and 'y direction' are then recomputed in the same way as for any gp_ax2), or raises constructionerror if the direction of a1 is parallel to the direction of the 'xaxis' of the ellipse.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None

        """
        return _gp.gp_Elips_SetAxis(self, *args)

    def SetLocation(self, *args) -> "void":
        r"""
        Modifies this ellipse, by redefining its local coordinate so that its origin becomes p.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Elips_SetLocation(self, *args)

    def SetMajorRadius(self, *args) -> "void":
        r"""
        The major radius of the ellipse is on the 'xaxis' (major axis) of the ellipse. raises constructionerror if majorradius < minorradius.

        Parameters
        ----------
        MajorRadius: float

        Returns
        -------
        None

        """
        return _gp.gp_Elips_SetMajorRadius(self, *args)

    def SetMinorRadius(self, *args) -> "void":
        r"""
        The minor radius of the ellipse is on the 'yaxis' (minor axis) of the ellipse. raises constructionerror if minorradius > majorradius or minorradius < 0.

        Parameters
        ----------
        MinorRadius: float

        Returns
        -------
        None

        """
        return _gp.gp_Elips_SetMinorRadius(self, *args)

    def SetPosition(self, *args) -> "void":
        r"""
        Modifies this ellipse, by redefining its local coordinate so that it becomes a2e.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        None

        """
        return _gp.gp_Elips_SetPosition(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        None

        """
        return _gp.gp_Elips_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Elips":
        r"""
        Transforms an ellipse with the transformation t from class trsf.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        gp_Elips

        """
        return _gp.gp_Elips_Transformed(self, *args)

    def Translate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Elips_Translate(self, *args)

    def Translated(self, *args) -> "gp_Elips":
        r"""
        Translates an ellipse in the direction of the vector v. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        gp_Elips
        Translates an ellipse from the point p1 to the point p2.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        gp_Elips

        """
        return _gp.gp_Elips_Translated(self, *args)

    def XAxis(self, *args) -> "gp_Ax1":
        r"""
        Returns the 'xaxis' of the ellipse whose origin is the center of this ellipse. it is the major axis of the ellipse.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Elips_XAxis(self, *args)

    def YAxis(self, *args) -> "gp_Ax1":
        r"""
        Returns the 'yaxis' of the ellipse whose unit vector is the 'x direction' or the 'y direction' of the local coordinate system of this ellipse. this is the minor axis of the ellipse.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Elips_YAxis(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Elips

# Register gp_Elips in _gp:
_gp.gp_Elips_swigregister(gp_Elips)

class gp_Elips2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an indefinite ellipse.

        Returns
        -------
        None
        Creates an ellipse with the major axis, the major and the minor radius. the location of the majoraxis is the center of the ellipse. the sense of parametrization is given by sense. warnings : it is possible to create an ellipse with majorradius = minorradius. raises constructionerror if majorradius < minorradius or minorradius < 0.0.

        Parameters
        ----------
        MajorAxis: gp_Ax2d
        MajorRadius: float
        MinorRadius: float
        Sense: bool,optional
        	default value is Standard_True

        Returns
        -------
        None
        Creates an ellipse with radii majorradius and minorradius, positioned in the plane by coordinate system a where: - the origin of a is the center of the ellipse, - the 'x direction' of a defines the major axis of the ellipse, that is, the major radius majorradius is measured along this axis, and - the 'y direction' of a defines the minor axis of the ellipse, that is, the minor radius minorradius is measured along this axis, and - the orientation (direct or indirect sense) of a gives the orientation of the ellipse. warnings : it is possible to create an ellipse with majorradius = minorradius. raises constructionerror if majorradius < minorradius or minorradius < 0.0.

        Parameters
        ----------
        A: gp_Ax22d
        MajorRadius: float
        MinorRadius: float

        Returns
        -------
        None

        """
        _gp.gp_Elips2d_swiginit(self, _gp.new_gp_Elips2d(*args))

    def Area(self, *args) -> "Standard_Real":
        r"""
        Computes the area of the ellipse.

        Returns
        -------
        float

        """
        return _gp.gp_Elips2d_Area(self, *args)

    def Axis(self, *args) -> "gp_Ax22d const":
        r"""
        Returns the major axis of the ellipse.

        Returns
        -------
        gp_Ax22d

        """
        return _gp.gp_Elips2d_Axis(self, *args)

    def Coefficients(self, *args) -> "void":
        r"""
        Returns the coefficients of the implicit equation of the ellipse. a * (x**2) + b * (y**2) + 2*c*(x*y) + 2*d*x + 2*e*y + f = 0.

        Parameters
        ----------

        Returns
        -------
        A: float
        B: float
        C: float
        D: float
        E: float
        F: float

        """
        return _gp.gp_Elips2d_Coefficients(self, *args)

    def Directrix1(self, *args) -> "gp_Ax2d":
        r"""
        This directrix is the line normal to the xaxis of the ellipse in the local plane (z = 0) at a distance d = majorradius / e from the center of the ellipse, where e is the eccentricity of the ellipse. this line is parallel to the 'yaxis'. the intersection point between directrix1 and the 'xaxis' is the location point of the directrix1. this point is on the positive side of the 'xaxis'. //! raised if eccentricity = 0.0. (the ellipse degenerates into a circle).

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Elips2d_Directrix1(self, *args)

    def Directrix2(self, *args) -> "gp_Ax2d":
        r"""
        This line is obtained by the symmetrical transformation of 'directrix1' with respect to the minor axis of the ellipse. //! raised if eccentricity = 0.0. (the ellipse degenerates into a circle).

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Elips2d_Directrix2(self, *args)

    def Eccentricity(self, *args) -> "Standard_Real":
        r"""
        Returns the eccentricity of the ellipse between 0.0 and 1.0 if f is the distance between the center of the ellipse and the focus1 then the eccentricity e = f / majorradius. returns 0 if majorradius = 0.

        Returns
        -------
        float

        """
        return _gp.gp_Elips2d_Eccentricity(self, *args)

    def Focal(self, *args) -> "Standard_Real":
        r"""
        Returns the distance between the center of the ellipse and focus1 or focus2.

        Returns
        -------
        float

        """
        return _gp.gp_Elips2d_Focal(self, *args)

    def Focus1(self, *args) -> "gp_Pnt2d":
        r"""
        Returns the first focus of the ellipse. this focus is on the positive side of the major axis of the ellipse.

        Returns
        -------
        gp_Pnt2d

        """
        return _gp.gp_Elips2d_Focus1(self, *args)

    def Focus2(self, *args) -> "gp_Pnt2d":
        r"""
        Returns the second focus of the ellipse. this focus is on the negative side of the major axis of the ellipse.

        Returns
        -------
        gp_Pnt2d

        """
        return _gp.gp_Elips2d_Focus2(self, *args)

    def IsDirect(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the local coordinate system is direct and false in the other case.

        Returns
        -------
        bool

        """
        return _gp.gp_Elips2d_IsDirect(self, *args)

    def Location(self, *args) -> "gp_Pnt2d const":
        r"""
        Returns the center of the ellipse.

        Returns
        -------
        gp_Pnt2d

        """
        return _gp.gp_Elips2d_Location(self, *args)

    def MajorRadius(self, *args) -> "Standard_Real":
        r"""
        Returns the major radius of the ellipse.

        Returns
        -------
        float

        """
        return _gp.gp_Elips2d_MajorRadius(self, *args)

    def MinorRadius(self, *args) -> "Standard_Real":
        r"""
        Returns the minor radius of the ellipse.

        Returns
        -------
        float

        """
        return _gp.gp_Elips2d_MinorRadius(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        None

        """
        return _gp.gp_Elips2d_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Elips2d":
        r"""
        Performs the symmetrical transformation of a ellipse with respect to the point p which is the center of the symmetry.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        gp_Elips2d
        Performs the symmetrical transformation of a ellipse with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        gp_Elips2d

        """
        return _gp.gp_Elips2d_Mirrored(self, *args)

    def Parameter(self, *args) -> "Standard_Real":
        r"""
        Returns p = (1 - e * e) * majorradius where e is the eccentricity of the ellipse. returns 0 if majorradius = 0.

        Returns
        -------
        float

        """
        return _gp.gp_Elips2d_Parameter(self, *args)

    def Reverse(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _gp.gp_Elips2d_Reverse(self, *args)

    def Reversed(self, *args) -> "gp_Elips2d":
        r"""
        No available documentation.

        Returns
        -------
        gp_Elips2d

        """
        return _gp.gp_Elips2d_Reversed(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Elips2d_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Elips2d":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d
        Ang: float

        Returns
        -------
        gp_Elips2d

        """
        return _gp.gp_Elips2d_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Elips2d_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Elips2d":
        r"""
        Scales a ellipse. s is the scaling value.

        Parameters
        ----------
        P: gp_Pnt2d
        S: float

        Returns
        -------
        gp_Elips2d

        """
        return _gp.gp_Elips2d_Scaled(self, *args)

    def SetAxis(self, *args) -> "void":
        r"""
        Modifies this ellipse, by redefining its local coordinate system so that it becomes a.

        Parameters
        ----------
        A: gp_Ax22d

        Returns
        -------
        None

        """
        return _gp.gp_Elips2d_SetAxis(self, *args)

    def SetLocation(self, *args) -> "void":
        r"""
        Modifies this ellipse, by redefining its local coordinate system so that - its origin becomes p.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        None

        """
        return _gp.gp_Elips2d_SetLocation(self, *args)

    def SetMajorRadius(self, *args) -> "void":
        r"""
        Changes the value of the major radius. raises constructionerror if majorradius < minorradius.

        Parameters
        ----------
        MajorRadius: float

        Returns
        -------
        None

        """
        return _gp.gp_Elips2d_SetMajorRadius(self, *args)

    def SetMinorRadius(self, *args) -> "void":
        r"""
        Changes the value of the minor radius. raises constructionerror if majorradius < minorradius or minorradius < 0.0.

        Parameters
        ----------
        MinorRadius: float

        Returns
        -------
        None

        """
        return _gp.gp_Elips2d_SetMinorRadius(self, *args)

    def SetXAxis(self, *args) -> "void":
        r"""
        Modifies this ellipse, by redefining its local coordinate system so that its origin and its 'x direction' become those of the axis a. the 'y direction' is then recomputed. the orientation of the local coordinate system is not modified.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        None

        """
        return _gp.gp_Elips2d_SetXAxis(self, *args)

    def SetYAxis(self, *args) -> "void":
        r"""
        Modifies this ellipse, by redefining its local coordinate system so that its origin and its 'y direction' become those of the axis a. the 'x direction' is then recomputed. the orientation of the local coordinate system is not modified.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        None

        """
        return _gp.gp_Elips2d_SetYAxis(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        None

        """
        return _gp.gp_Elips2d_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Elips2d":
        r"""
        Transforms an ellipse with the transformation t from class trsf2d.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        gp_Elips2d

        """
        return _gp.gp_Elips2d_Transformed(self, *args)

    def Translate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Vec2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        None

        """
        return _gp.gp_Elips2d_Translate(self, *args)

    def Translated(self, *args) -> "gp_Elips2d":
        r"""
        Translates a ellipse in the direction of the vector v. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        V: gp_Vec2d

        Returns
        -------
        gp_Elips2d
        Translates a ellipse from the point p1 to the point p2.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        gp_Elips2d

        """
        return _gp.gp_Elips2d_Translated(self, *args)

    def XAxis(self, *args) -> "gp_Ax2d":
        r"""
        Returns the major axis of the ellipse.

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Elips2d_XAxis(self, *args)

    def YAxis(self, *args) -> "gp_Ax2d":
        r"""
        Returns the minor axis of the ellipse. reverses the direction of the circle.

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Elips2d_YAxis(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Elips2d

# Register gp_Elips2d in _gp:
_gp.gp_Elips2d_swigregister(gp_Elips2d)

class gp_GTrsf(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Returns the identity transformation.

        Returns
        -------
        None
        Converts the gp_trsf transformation t into a general transformation, i.e. returns a gtrsf with the same matrix of coefficients as the trsf t.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        None
        Creates a transformation based on the matrix m and the vector v where m defines the vectorial part of the transformation, and v the translation part, or.

        Parameters
        ----------
        M: gp_Mat
        V: gp_XYZ

        Returns
        -------
        None

        """
        _gp.gp_GTrsf_swiginit(self, _gp.new_gp_GTrsf(*args))

    def Form(self, *args) -> "gp_TrsfForm":
        r"""
        Returns the nature of the transformation. it can be an identity transformation, a rotation, a translation, a mirror transformation (relative to a point, an axis or a plane), a scaling transformation, a compound transformation or some other type of transformation.

        Returns
        -------
        gp_TrsfForm

        """
        return _gp.gp_GTrsf_Form(self, *args)

    def Invert(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _gp.gp_GTrsf_Invert(self, *args)

    def Inverted(self, *args) -> "gp_GTrsf":
        r"""
        Computes the reverse transformation. raises an exception if the matrix of the transformation is not inversible.

        Returns
        -------
        gp_GTrsf

        """
        return _gp.gp_GTrsf_Inverted(self, *args)

    def IsNegative(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the determinant of the vectorial part of this transformation is negative.

        Returns
        -------
        bool

        """
        return _gp.gp_GTrsf_IsNegative(self, *args)

    def IsSingular(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if this transformation is singular (and therefore, cannot be inverted). note: the gauss lu decomposition is used to invert the transformation matrix. consequently, the transformation is considered as singular if the largest pivot found is less than or equal to gp::resolution(). warning if this transformation is singular, it cannot be inverted.

        Returns
        -------
        bool

        """
        return _gp.gp_GTrsf_IsSingular(self, *args)

    def Multiplied(self, *args) -> "gp_GTrsf":
        r"""
        Computes the transformation composed from t and <self>. in a c++ implementation you can also write tcomposed = <self> * t. example : gtrsf t1, t2, tcomp; ............... //composition : tcomp = t2.multiplied(t1); // or (tcomp = t2 * t1) // transformation of a point xyz p(10.,3.,4.); xyz p1(p); tcomp.transforms(p1); //using tcomp xyz p2(p); t1.transforms(p2); //using t1 then t2 t2.transforms(p2); // p1 = p2 !!!.

        Parameters
        ----------
        T: gp_GTrsf

        Returns
        -------
        gp_GTrsf

        """
        return _gp.gp_GTrsf_Multiplied(self, *args)

    def Multiply(self, *args) -> "void":
        r"""
        Computes the transformation composed with <self> and t. <self> = <self> * t.

        Parameters
        ----------
        T: gp_GTrsf

        Returns
        -------
        None

        """
        return _gp.gp_GTrsf_Multiply(self, *args)

    def Power(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        N: int

        Returns
        -------
        None

        """
        return _gp.gp_GTrsf_Power(self, *args)

    def Powered(self, *args) -> "gp_GTrsf":
        r"""
        Computes: - the product of this transformation multiplied by itself n times, if n is positive, or - the product of the inverse of this transformation multiplied by itself |n| times, if n is negative. if n equals zero, the result is equal to the identity transformation. i.e.: <self> * <self> * .......* <self>, n time. if n =0 <self> = identity if n < 0 <self> = <self>.inverse() *...........* <self>.inverse(). //! raises an exception if n < 0 and if the matrix of the transformation not inversible.

        Parameters
        ----------
        N: int

        Returns
        -------
        gp_GTrsf

        """
        return _gp.gp_GTrsf_Powered(self, *args)

    def PreMultiply(self, *args) -> "void":
        r"""
        Computes the product of the transformation t and this transformation and assigns the result to this transformation. this = t * this.

        Parameters
        ----------
        T: gp_GTrsf

        Returns
        -------
        None

        """
        return _gp.gp_GTrsf_PreMultiply(self, *args)

    def SetAffinity(self, *args) -> "void":
        r"""
        Changes this transformation into an affinity of ratio ratio with respect to the axis a1. note: an affinity is a point-by-point transformation that transforms any point p into a point p' such that if h is the orthogonal projection of p on the axis a1 or the plane a2, the vectors hp and hp' satisfy: hp' = ratio * hp.

        Parameters
        ----------
        A1: gp_Ax1
        Ratio: float

        Returns
        -------
        None
        Changes this transformation into an affinity of ratio ratio with respect to the plane defined by the origin, the 'x direction' and the 'y direction' of coordinate system a2. note: an affinity is a point-by-point transformation that transforms any point p into a point p' such that if h is the orthogonal projection of p on the axis a1 or the plane a2, the vectors hp and hp' satisfy: hp' = ratio * hp.

        Parameters
        ----------
        A2: gp_Ax2
        Ratio: float

        Returns
        -------
        None

        """
        return _gp.gp_GTrsf_SetAffinity(self, *args)

    def SetForm(self, *args) -> "void":
        r"""
        Verify and set the shape of the gtrsf other or compoundtrsf ex : mygtrsf.setvalue(row1,col1,val1); mygtrsf.setvalue(row2,col2,val2); ... mygtrsf.setform();.

        Returns
        -------
        None

        """
        return _gp.gp_GTrsf_SetForm(self, *args)

    def SetTranslationPart(self, *args) -> "void":
        r"""
        Replaces the translation part of this transformation by the coordinates of the number triple coord.

        Parameters
        ----------
        Coord: gp_XYZ

        Returns
        -------
        None

        """
        return _gp.gp_GTrsf_SetTranslationPart(self, *args)

    def SetTrsf(self, *args) -> "void":
        r"""
        Assigns the vectorial and translation parts of t to this transformation.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        None

        """
        return _gp.gp_GTrsf_SetTrsf(self, *args)

    def SetValue(self, *args) -> "void":
        r"""
        Replaces the coefficient (row, col) of the matrix representing this transformation by value. raises outofrange if row < 1 or row > 3 or col < 1 or col > 4.

        Parameters
        ----------
        Row: int
        Col: int
        Value: float

        Returns
        -------
        None

        """
        return _gp.gp_GTrsf_SetValue(self, *args)

    def SetVectorialPart(self, *args) -> "void":
        r"""
        Replaces the vectorial part of this transformation by matrix.

        Parameters
        ----------
        Matrix: gp_Mat

        Returns
        -------
        None

        """
        return _gp.gp_GTrsf_SetVectorialPart(self, *args)

    def Transforms(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Coord: gp_XYZ

        Returns
        -------
        None
        Transforms a triplet xyz with a gtrsf.

        Parameters
        ----------

        Returns
        -------
        X: float
        Y: float
        Z: float

        """
        return _gp.gp_GTrsf_Transforms(self, *args)

    def TranslationPart(self, *args) -> "gp_XYZ const":
        r"""
        Returns the translation part of the gtrsf.

        Returns
        -------
        gp_XYZ

        """
        return _gp.gp_GTrsf_TranslationPart(self, *args)

    def Trsf(self, *args) -> "gp_Trsf":
        r"""
        No available documentation.

        Returns
        -------
        gp_Trsf

        """
        return _gp.gp_GTrsf_Trsf(self, *args)

    def Value(self, *args) -> "Standard_Real":
        r"""
        Returns the coefficients of the global matrix of transformation. raises outofrange if row < 1 or row > 3 or col < 1 or col > 4.

        Parameters
        ----------
        Row: int
        Col: int

        Returns
        -------
        float

        """
        return _gp.gp_GTrsf_Value(self, *args)

    def VectorialPart(self, *args) -> "gp_Mat const":
        r"""
        Computes the vectorial part of the gtrsf. the returned matrix is a 3*3 matrix.

        Returns
        -------
        gp_Mat

        """
        return _gp.gp_GTrsf_VectorialPart(self, *args)

    def __mul__(self, *args) -> "gp_GTrsf":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_GTrsf

        Returns
        -------
        gp_GTrsf

        """
        return _gp.gp_GTrsf___mul__(self, *args)

    def __imul_wrapper__(self, other: "gp_GTrsf") -> "void":
        return _gp.gp_GTrsf___imul_wrapper__(self, other)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_GTrsf

# Register gp_GTrsf in _gp:
_gp.gp_GTrsf_swigregister(gp_GTrsf)

class gp_GTrsf2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Returns identity transformation.

        Returns
        -------
        None
        Converts the gp_trsf2d transformation t into a general transformation.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        None
        Creates a transformation based on the matrix m and the vector v where m defines the vectorial part of the transformation, and v the translation part.

        Parameters
        ----------
        M: gp_Mat2d
        V: gp_XY

        Returns
        -------
        None

        """
        _gp.gp_GTrsf2d_swiginit(self, _gp.new_gp_GTrsf2d(*args))

    def Form(self, *args) -> "gp_TrsfForm":
        r"""
        Returns the nature of the transformation. it can be an identity transformation, a rotation, a translation, a mirror transformation (relative to a point or axis), a scaling transformation, a compound transformation or some other type of transformation.

        Returns
        -------
        gp_TrsfForm

        """
        return _gp.gp_GTrsf2d_Form(self, *args)

    def Invert(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _gp.gp_GTrsf2d_Invert(self, *args)

    def Inverted(self, *args) -> "gp_GTrsf2d":
        r"""
        Computes the reverse transformation. raised an exception if the matrix of the transformation is not inversible.

        Returns
        -------
        gp_GTrsf2d

        """
        return _gp.gp_GTrsf2d_Inverted(self, *args)

    def IsNegative(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the determinant of the vectorial part of this transformation is negative.

        Returns
        -------
        bool

        """
        return _gp.gp_GTrsf2d_IsNegative(self, *args)

    def IsSingular(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if this transformation is singular (and therefore, cannot be inverted). note: the gauss lu decomposition is used to invert the transformation matrix. consequently, the transformation is considered as singular if the largest pivot found is less than or equal to gp::resolution(). warning if this transformation is singular, it cannot be inverted.

        Returns
        -------
        bool

        """
        return _gp.gp_GTrsf2d_IsSingular(self, *args)

    def Multiplied(self, *args) -> "gp_GTrsf2d":
        r"""
        Computes the transformation composed with t and <self>. in a c++ implementation you can also write tcomposed = <self> * t. example : gtrsf2d t1, t2, tcomp; ............... //composition : tcomp = t2.multiplied(t1); // or (tcomp = t2 * t1) // transformation of a point xy p(10.,3.); xy p1(p); tcomp.transforms(p1); //using tcomp xy p2(p); t1.transforms(p2); //using t1 then t2 t2.transforms(p2); // p1 = p2 !!!.

        Parameters
        ----------
        T: gp_GTrsf2d

        Returns
        -------
        gp_GTrsf2d

        """
        return _gp.gp_GTrsf2d_Multiplied(self, *args)

    def Multiply(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_GTrsf2d

        Returns
        -------
        None

        """
        return _gp.gp_GTrsf2d_Multiply(self, *args)

    def Power(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        N: int

        Returns
        -------
        None

        """
        return _gp.gp_GTrsf2d_Power(self, *args)

    def Powered(self, *args) -> "gp_GTrsf2d":
        r"""
        Computes the following composition of transformations <self> * <self> * .......* <self>, n time. if n = 0 <self> = identity if n < 0 <self> = <self>.inverse() *...........* <self>.inverse(). //! raises an exception if n < 0 and if the matrix of the transformation is not inversible.

        Parameters
        ----------
        N: int

        Returns
        -------
        gp_GTrsf2d

        """
        return _gp.gp_GTrsf2d_Powered(self, *args)

    def PreMultiply(self, *args) -> "void":
        r"""
        Computes the product of the transformation t and this transformation, and assigns the result to this transformation: this = t * this.

        Parameters
        ----------
        T: gp_GTrsf2d

        Returns
        -------
        None

        """
        return _gp.gp_GTrsf2d_PreMultiply(self, *args)

    def SetAffinity(self, *args) -> "void":
        r"""
        Changes this transformation into an affinity of ratio ratio with respect to the axis a. note: an affinity is a point-by-point transformation that transforms any point p into a point p' such that if h is the orthogonal projection of p on the axis a, the vectors hp and hp' satisfy: hp' = ratio * hp.

        Parameters
        ----------
        A: gp_Ax2d
        Ratio: float

        Returns
        -------
        None

        """
        return _gp.gp_GTrsf2d_SetAffinity(self, *args)

    def SetTranslationPart(self, *args) -> "void":
        r"""
        Replacesthe translation part of this transformation by the coordinates of the number pair coord.

        Parameters
        ----------
        Coord: gp_XY

        Returns
        -------
        None

        """
        return _gp.gp_GTrsf2d_SetTranslationPart(self, *args)

    def SetTrsf2d(self, *args) -> "void":
        r"""
        Assigns the vectorial and translation parts of t to this transformation.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        None

        """
        return _gp.gp_GTrsf2d_SetTrsf2d(self, *args)

    def SetValue(self, *args) -> "void":
        r"""
        Replaces the coefficient (row, col) of the matrix representing this transformation by value, raises outofrange if row < 1 or row > 2 or col < 1 or col > 3.

        Parameters
        ----------
        Row: int
        Col: int
        Value: float

        Returns
        -------
        None

        """
        return _gp.gp_GTrsf2d_SetValue(self, *args)

    def SetVectorialPart(self, *args) -> "void":
        r"""
        Replaces the vectorial part of this transformation by matrix.

        Parameters
        ----------
        Matrix: gp_Mat2d

        Returns
        -------
        None

        """
        return _gp.gp_GTrsf2d_SetVectorialPart(self, *args)

    def Transformed(self, *args) -> "gp_XY":
        r"""
        No available documentation.

        Parameters
        ----------
        Coord: gp_XY

        Returns
        -------
        gp_XY

        """
        return _gp.gp_GTrsf2d_Transformed(self, *args)

    def Transforms(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Coord: gp_XY

        Returns
        -------
        None
        Applies this transformation to the coordinates: - of the number pair coord, or - x and y. //! note: - transforms modifies x, y, or the coordinate pair coord, while - transformed creates a new coordinate pair.

        Parameters
        ----------

        Returns
        -------
        X: float
        Y: float

        """
        return _gp.gp_GTrsf2d_Transforms(self, *args)

    def TranslationPart(self, *args) -> "gp_XY const":
        r"""
        Returns the translation part of the gtrsf2d.

        Returns
        -------
        gp_XY

        """
        return _gp.gp_GTrsf2d_TranslationPart(self, *args)

    def Trsf2d(self, *args) -> "gp_Trsf2d":
        r"""
        Converts this transformation into a gp_trsf2d transformation. exceptions standard_constructionerror if this transformation cannot be converted, i.e. if its form is gp_other.

        Returns
        -------
        gp_Trsf2d

        """
        return _gp.gp_GTrsf2d_Trsf2d(self, *args)

    def Value(self, *args) -> "Standard_Real":
        r"""
        Returns the coefficients of the global matrix of transformation. raised outofrange if row < 1 or row > 2 or col < 1 or col > 3.

        Parameters
        ----------
        Row: int
        Col: int

        Returns
        -------
        float

        """
        return _gp.gp_GTrsf2d_Value(self, *args)

    def VectorialPart(self, *args) -> "gp_Mat2d const":
        r"""
        Computes the vectorial part of the gtrsf2d. the returned matrix is a 2*2 matrix.

        Returns
        -------
        gp_Mat2d

        """
        return _gp.gp_GTrsf2d_VectorialPart(self, *args)

    def __mul__(self, *args) -> "gp_GTrsf2d":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_GTrsf2d

        Returns
        -------
        gp_GTrsf2d

        """
        return _gp.gp_GTrsf2d___mul__(self, *args)

    def __imul_wrapper__(self, other: "gp_GTrsf2d") -> "void":
        return _gp.gp_GTrsf2d___imul_wrapper__(self, other)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_GTrsf2d

# Register gp_GTrsf2d in _gp:
_gp.gp_GTrsf2d_swigregister(gp_GTrsf2d)

class gp_Hypr(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates of an indefinite hyperbola.

        Returns
        -------
        None
        Creates a hyperbola with radii majorradius and minorradius, positioned in the space by the coordinate system a2 such that: - the origin of a2 is the center of the hyperbola, - the 'x direction' of a2 defines the major axis of the hyperbola, that is, the major radius majorradius is measured along this axis, and - the 'y direction' of a2 defines the minor axis of the hyperbola, that is, the minor radius minorradius is measured along this axis. note: this class does not prevent the creation of a hyperbola where: - majoraxis is equal to minoraxis, or - majoraxis is less than minoraxis. exceptions standard_constructionerror if majoraxis or minoraxis is negative. raises constructionerror if majorradius < 0.0 or minorradius < 0.0 raised if majorradius < 0.0 or minorradius < 0.0.

        Parameters
        ----------
        A2: gp_Ax2
        MajorRadius: float
        MinorRadius: float

        Returns
        -------
        None

        """
        _gp.gp_Hypr_swiginit(self, _gp.new_gp_Hypr(*args))

    def Asymptote1(self, *args) -> "gp_Ax1":
        r"""
        In the local coordinate system of the hyperbola the equation of the hyperbola is (x*x)/(a*a) - (y*y)/(b*b) = 1.0 and the equation of the first asymptote is y = (b/a)*x where a is the major radius and b is the minor radius. raises constructionerror if majorradius = 0.0.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Hypr_Asymptote1(self, *args)

    def Asymptote2(self, *args) -> "gp_Ax1":
        r"""
        In the local coordinate system of the hyperbola the equation of the hyperbola is (x*x)/(a*a) - (y*y)/(b*b) = 1.0 and the equation of the first asymptote is y = -(b/a)*x. where a is the major radius and b is the minor radius. raises constructionerror if majorradius = 0.0.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Hypr_Asymptote2(self, *args)

    def Axis(self, *args) -> "gp_Ax1 const":
        r"""
        Returns the axis passing through the center, and normal to the plane of this hyperbola.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Hypr_Axis(self, *args)

    def ConjugateBranch1(self, *args) -> "gp_Hypr":
        r"""
        Computes the branch of hyperbola which is on the positive side of the 'yaxis' of <self>.

        Returns
        -------
        gp_Hypr

        """
        return _gp.gp_Hypr_ConjugateBranch1(self, *args)

    def ConjugateBranch2(self, *args) -> "gp_Hypr":
        r"""
        Computes the branch of hyperbola which is on the negative side of the 'yaxis' of <self>.

        Returns
        -------
        gp_Hypr

        """
        return _gp.gp_Hypr_ConjugateBranch2(self, *args)

    def Directrix1(self, *args) -> "gp_Ax1":
        r"""
        This directrix is the line normal to the xaxis of the hyperbola in the local plane (z = 0) at a distance d = majorradius / e from the center of the hyperbola, where e is the eccentricity of the hyperbola. this line is parallel to the 'yaxis'. the intersection point between the directrix1 and the 'xaxis' is the 'location' point of the directrix1. this point is on the positive side of the 'xaxis'.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Hypr_Directrix1(self, *args)

    def Directrix2(self, *args) -> "gp_Ax1":
        r"""
        This line is obtained by the symmetrical transformation of 'directrix1' with respect to the 'yaxis' of the hyperbola.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Hypr_Directrix2(self, *args)

    def Eccentricity(self, *args) -> "Standard_Real":
        r"""
        Returns the excentricity of the hyperbola (e > 1). if f is the distance between the location of the hyperbola and the focus1 then the eccentricity e = f / majorradius. raises domainerror if majorradius = 0.0.

        Returns
        -------
        float

        """
        return _gp.gp_Hypr_Eccentricity(self, *args)

    def Focal(self, *args) -> "Standard_Real":
        r"""
        Computes the focal distance. it is the distance between the the two focus of the hyperbola.

        Returns
        -------
        float

        """
        return _gp.gp_Hypr_Focal(self, *args)

    def Focus1(self, *args) -> "gp_Pnt":
        r"""
        Returns the first focus of the hyperbola. this focus is on the positive side of the 'xaxis' of the hyperbola.

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Hypr_Focus1(self, *args)

    def Focus2(self, *args) -> "gp_Pnt":
        r"""
        Returns the second focus of the hyperbola. this focus is on the negative side of the 'xaxis' of the hyperbola.

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Hypr_Focus2(self, *args)

    def Location(self, *args) -> "gp_Pnt const":
        r"""
        Returns the location point of the hyperbola. it is the intersection point between the 'xaxis' and the 'yaxis'.

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Hypr_Location(self, *args)

    def MajorRadius(self, *args) -> "Standard_Real":
        r"""
        Returns the major radius of the hyperbola. it is the radius on the 'xaxis' of the hyperbola.

        Returns
        -------
        float

        """
        return _gp.gp_Hypr_MajorRadius(self, *args)

    def MinorRadius(self, *args) -> "Standard_Real":
        r"""
        Returns the minor radius of the hyperbola. it is the radius on the 'yaxis' of the hyperbola.

        Returns
        -------
        float

        """
        return _gp.gp_Hypr_MinorRadius(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        None

        """
        return _gp.gp_Hypr_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Hypr":
        r"""
        Performs the symmetrical transformation of an hyperbola with respect to the point p which is the center of the symmetry.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        gp_Hypr
        Performs the symmetrical transformation of an hyperbola with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        gp_Hypr
        Performs the symmetrical transformation of an hyperbola with respect to a plane. the axis placement a2 locates the plane of the symmetry (location, xdirection, ydirection).

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        gp_Hypr

        """
        return _gp.gp_Hypr_Mirrored(self, *args)

    def OtherBranch(self, *args) -> "gp_Hypr":
        r"""
        Returns the branch of hyperbola obtained by doing the symmetrical transformation of <self> with respect to the 'yaxis' of <self>.

        Returns
        -------
        gp_Hypr

        """
        return _gp.gp_Hypr_OtherBranch(self, *args)

    def Parameter(self, *args) -> "Standard_Real":
        r"""
        Returns p = (e * e - 1) * majorradius where e is the eccentricity of the hyperbola. raises domainerror if majorradius = 0.0.

        Returns
        -------
        float

        """
        return _gp.gp_Hypr_Parameter(self, *args)

    def Position(self, *args) -> "gp_Ax2 const":
        r"""
        Returns the coordinate system of the hyperbola.

        Returns
        -------
        gp_Ax2

        """
        return _gp.gp_Hypr_Position(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Hypr_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Hypr":
        r"""
        Rotates an hyperbola. a1 is the axis of the rotation. ang is the angular value of the rotation in radians.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        gp_Hypr

        """
        return _gp.gp_Hypr_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Hypr_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Hypr":
        r"""
        Scales an hyperbola. s is the scaling value.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        gp_Hypr

        """
        return _gp.gp_Hypr_Scaled(self, *args)

    def SetAxis(self, *args) -> "void":
        r"""
        Modifies this hyperbola, by redefining its local coordinate system so that: - its origin and 'main direction' become those of the axis a1 (the 'x direction' and 'y direction' are then recomputed in the same way as for any gp_ax2). raises constructionerror if the direction of a1 is parallel to the direction of the 'xaxis' of the hyperbola.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None

        """
        return _gp.gp_Hypr_SetAxis(self, *args)

    def SetLocation(self, *args) -> "void":
        r"""
        Modifies this hyperbola, by redefining its local coordinate system so that its origin becomes p.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Hypr_SetLocation(self, *args)

    def SetMajorRadius(self, *args) -> "void":
        r"""
        Modifies the major radius of this hyperbola. exceptions standard_constructionerror if majorradius is negative.

        Parameters
        ----------
        MajorRadius: float

        Returns
        -------
        None

        """
        return _gp.gp_Hypr_SetMajorRadius(self, *args)

    def SetMinorRadius(self, *args) -> "void":
        r"""
        Modifies the minor radius of this hyperbola. exceptions standard_constructionerror if minorradius is negative.

        Parameters
        ----------
        MinorRadius: float

        Returns
        -------
        None

        """
        return _gp.gp_Hypr_SetMinorRadius(self, *args)

    def SetPosition(self, *args) -> "void":
        r"""
        Modifies this hyperbola, by redefining its local coordinate system so that it becomes a2.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        None

        """
        return _gp.gp_Hypr_SetPosition(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        None

        """
        return _gp.gp_Hypr_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Hypr":
        r"""
        Transforms an hyperbola with the transformation t from class trsf.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        gp_Hypr

        """
        return _gp.gp_Hypr_Transformed(self, *args)

    def Translate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Hypr_Translate(self, *args)

    def Translated(self, *args) -> "gp_Hypr":
        r"""
        Translates an hyperbola in the direction of the vector v. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        gp_Hypr
        Translates an hyperbola from the point p1 to the point p2.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        gp_Hypr

        """
        return _gp.gp_Hypr_Translated(self, *args)

    def XAxis(self, *args) -> "gp_Ax1":
        r"""
        Computes an axis, whose - the origin is the center of this hyperbola, and - the unit vector is the 'x direction' of the local coordinate system of this hyperbola. these axes are, the major axis (the 'x axis') and of this hyperboreturns the 'xaxis' of the hyperbola.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Hypr_XAxis(self, *args)

    def YAxis(self, *args) -> "gp_Ax1":
        r"""
        Computes an axis, whose - the origin is the center of this hyperbola, and - the unit vector is the 'y direction' of the local coordinate system of this hyperbola. these axes are the minor axis (the 'y axis') of this hyperbola.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Hypr_YAxis(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Hypr

# Register gp_Hypr in _gp:
_gp.gp_Hypr_swigregister(gp_Hypr)

class gp_Hypr2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates of an indefinite hyperbola.

        Returns
        -------
        None
        Creates a hyperbola with radii majorradius and minorradius, centered on the origin of majoraxis and where the unit vector of majoraxis is the 'x direction' of the local coordinate system of the hyperbola. this coordinate system is direct if sense is true (the default value), and indirect if sense is false. warnings : it is yet possible to create an hyperbola with majorradius <= minorradius. raises constructionerror if majorradius < 0.0 or minorradius < 0.0.

        Parameters
        ----------
        MajorAxis: gp_Ax2d
        MajorRadius: float
        MinorRadius: float
        Sense: bool,optional
        	default value is Standard_True

        Returns
        -------
        None
        A hyperbola with radii majorradius and minorradius, positioned in the plane by coordinate system a where: - the origin of a is the center of the hyperbola, - the 'x direction' of a defines the major axis of the hyperbola, that is, the major radius majorradius is measured along this axis, and - the 'y direction' of a defines the minor axis of the hyperbola, that is, the minor radius minorradius is measured along this axis, and - the orientation (direct or indirect sense) of a gives the implicit orientation of the hyperbola. warnings : it is yet possible to create an hyperbola with majorradius <= minorradius. raises constructionerror if majorradius < 0.0 or minorradius < 0.0.

        Parameters
        ----------
        A: gp_Ax22d
        MajorRadius: float
        MinorRadius: float

        Returns
        -------
        None

        """
        _gp.gp_Hypr2d_swiginit(self, _gp.new_gp_Hypr2d(*args))

    def Asymptote1(self, *args) -> "gp_Ax2d":
        r"""
        In the local coordinate system of the hyperbola the equation of the hyperbola is (x*x)/(a*a) - (y*y)/(b*b) = 1.0 and the equation of the first asymptote is y = (b/a)*x where a is the major radius of the hyperbola and b the minor radius of the hyperbola. raises constructionerror if majorradius = 0.0.

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Hypr2d_Asymptote1(self, *args)

    def Asymptote2(self, *args) -> "gp_Ax2d":
        r"""
        In the local coordinate system of the hyperbola the equation of the hyperbola is (x*x)/(a*a) - (y*y)/(b*b) = 1.0 and the equation of the first asymptote is y = -(b/a)*x where a is the major radius of the hyperbola and b the minor radius of the hyperbola. raises constructionerror if majorradius = 0.0.

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Hypr2d_Asymptote2(self, *args)

    def Axis(self, *args) -> "gp_Ax22d const":
        r"""
        Returns the axisplacement of the hyperbola.

        Returns
        -------
        gp_Ax22d

        """
        return _gp.gp_Hypr2d_Axis(self, *args)

    def Coefficients(self, *args) -> "void":
        r"""
        Computes the coefficients of the implicit equation of the hyperbola : a * (x**2) + b * (y**2) + 2*c*(x*y) + 2*d*x + 2*e*y + f = 0.

        Parameters
        ----------

        Returns
        -------
        A: float
        B: float
        C: float
        D: float
        E: float
        F: float

        """
        return _gp.gp_Hypr2d_Coefficients(self, *args)

    def ConjugateBranch1(self, *args) -> "gp_Hypr2d":
        r"""
        Computes the branch of hyperbola which is on the positive side of the 'yaxis' of <self>.

        Returns
        -------
        gp_Hypr2d

        """
        return _gp.gp_Hypr2d_ConjugateBranch1(self, *args)

    def ConjugateBranch2(self, *args) -> "gp_Hypr2d":
        r"""
        Computes the branch of hyperbola which is on the negative side of the 'yaxis' of <self>.

        Returns
        -------
        gp_Hypr2d

        """
        return _gp.gp_Hypr2d_ConjugateBranch2(self, *args)

    def Directrix1(self, *args) -> "gp_Ax2d":
        r"""
        Computes the directrix which is the line normal to the xaxis of the hyperbola in the local plane (z = 0) at a distance d = majorradius / e from the center of the hyperbola, where e is the eccentricity of the hyperbola. this line is parallel to the 'yaxis'. the intersection point between the 'directrix1' and the 'xaxis' is the 'location' point of the 'directrix1'. this point is on the positive side of the 'xaxis'.

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Hypr2d_Directrix1(self, *args)

    def Directrix2(self, *args) -> "gp_Ax2d":
        r"""
        This line is obtained by the symmetrical transformation of 'directrix1' with respect to the 'yaxis' of the hyperbola.

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Hypr2d_Directrix2(self, *args)

    def Eccentricity(self, *args) -> "Standard_Real":
        r"""
        Returns the excentricity of the hyperbola (e > 1). if f is the distance between the location of the hyperbola and the focus1 then the eccentricity e = f / majorradius. raises domainerror if majorradius = 0.0.

        Returns
        -------
        float

        """
        return _gp.gp_Hypr2d_Eccentricity(self, *args)

    def Focal(self, *args) -> "Standard_Real":
        r"""
        Computes the focal distance. it is the distance between the 'location' of the hyperbola and 'focus1' or 'focus2'.

        Returns
        -------
        float

        """
        return _gp.gp_Hypr2d_Focal(self, *args)

    def Focus1(self, *args) -> "gp_Pnt2d":
        r"""
        Returns the first focus of the hyperbola. this focus is on the positive side of the 'xaxis' of the hyperbola.

        Returns
        -------
        gp_Pnt2d

        """
        return _gp.gp_Hypr2d_Focus1(self, *args)

    def Focus2(self, *args) -> "gp_Pnt2d":
        r"""
        Returns the second focus of the hyperbola. this focus is on the negative side of the 'xaxis' of the hyperbola.

        Returns
        -------
        gp_Pnt2d

        """
        return _gp.gp_Hypr2d_Focus2(self, *args)

    def IsDirect(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the local coordinate system is direct and false in the other case.

        Returns
        -------
        bool

        """
        return _gp.gp_Hypr2d_IsDirect(self, *args)

    def Location(self, *args) -> "gp_Pnt2d const":
        r"""
        Returns the location point of the hyperbola. it is the intersection point between the 'xaxis' and the 'yaxis'.

        Returns
        -------
        gp_Pnt2d

        """
        return _gp.gp_Hypr2d_Location(self, *args)

    def MajorRadius(self, *args) -> "Standard_Real":
        r"""
        Returns the major radius of the hyperbola (it is the radius corresponding to the 'xaxis' of the hyperbola).

        Returns
        -------
        float

        """
        return _gp.gp_Hypr2d_MajorRadius(self, *args)

    def MinorRadius(self, *args) -> "Standard_Real":
        r"""
        Returns the minor radius of the hyperbola (it is the radius corresponding to the 'yaxis' of the hyperbola).

        Returns
        -------
        float

        """
        return _gp.gp_Hypr2d_MinorRadius(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        None

        """
        return _gp.gp_Hypr2d_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Hypr2d":
        r"""
        Performs the symmetrical transformation of an hyperbola with respect to the point p which is the center of the symmetry.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        gp_Hypr2d
        Performs the symmetrical transformation of an hyperbola with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        gp_Hypr2d

        """
        return _gp.gp_Hypr2d_Mirrored(self, *args)

    def OtherBranch(self, *args) -> "gp_Hypr2d":
        r"""
        Returns the branch of hyperbola obtained by doing the symmetrical transformation of <self> with respect to the 'yaxis' of <self>.

        Returns
        -------
        gp_Hypr2d

        """
        return _gp.gp_Hypr2d_OtherBranch(self, *args)

    def Parameter(self, *args) -> "Standard_Real":
        r"""
        Returns p = (e * e - 1) * majorradius where e is the eccentricity of the hyperbola. raises domainerror if majorradius = 0.0.

        Returns
        -------
        float

        """
        return _gp.gp_Hypr2d_Parameter(self, *args)

    def Reverse(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _gp.gp_Hypr2d_Reverse(self, *args)

    def Reversed(self, *args) -> "gp_Hypr2d":
        r"""
        Reverses the orientation of the local coordinate system of this hyperbola (the 'y axis' is reversed). therefore, the implicit orientation of this hyperbola is reversed. note: - reverse assigns the result to this hyperbola, while - reversed creates a new one.

        Returns
        -------
        gp_Hypr2d

        """
        return _gp.gp_Hypr2d_Reversed(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Hypr2d_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Hypr2d":
        r"""
        Rotates an hyperbola. p is the center of the rotation. ang is the angular value of the rotation in radians.

        Parameters
        ----------
        P: gp_Pnt2d
        Ang: float

        Returns
        -------
        gp_Hypr2d

        """
        return _gp.gp_Hypr2d_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Hypr2d_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Hypr2d":
        r"""
        Scales an hyperbola. <s> is the scaling value. if <s> is positive only the location point is modified. but if <s> is negative the 'xaxis' is reversed and the 'yaxis' too.

        Parameters
        ----------
        P: gp_Pnt2d
        S: float

        Returns
        -------
        gp_Hypr2d

        """
        return _gp.gp_Hypr2d_Scaled(self, *args)

    def SetAxis(self, *args) -> "void":
        r"""
        Modifies this hyperbola, by redefining its local coordinate system so that it becomes a.

        Parameters
        ----------
        A: gp_Ax22d

        Returns
        -------
        None

        """
        return _gp.gp_Hypr2d_SetAxis(self, *args)

    def SetLocation(self, *args) -> "void":
        r"""
        Modifies this hyperbola, by redefining its local coordinate system so that its origin becomes p.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        None

        """
        return _gp.gp_Hypr2d_SetLocation(self, *args)

    def SetMajorRadius(self, *args) -> "void":
        r"""
        Modifies the major or minor radius of this hyperbola. exceptions standard_constructionerror if majorradius or minorradius is negative.

        Parameters
        ----------
        MajorRadius: float

        Returns
        -------
        None

        """
        return _gp.gp_Hypr2d_SetMajorRadius(self, *args)

    def SetMinorRadius(self, *args) -> "void":
        r"""
        Modifies the major or minor radius of this hyperbola. exceptions standard_constructionerror if majorradius or minorradius is negative.

        Parameters
        ----------
        MinorRadius: float

        Returns
        -------
        None

        """
        return _gp.gp_Hypr2d_SetMinorRadius(self, *args)

    def SetXAxis(self, *args) -> "void":
        r"""
        Changes the major axis of the hyperbola. the minor axis is recomputed and the location of the hyperbola too.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        None

        """
        return _gp.gp_Hypr2d_SetXAxis(self, *args)

    def SetYAxis(self, *args) -> "void":
        r"""
        Changes the minor axis of the hyperbola.the minor axis is recomputed and the location of the hyperbola too.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        None

        """
        return _gp.gp_Hypr2d_SetYAxis(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        None

        """
        return _gp.gp_Hypr2d_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Hypr2d":
        r"""
        Transforms an hyperbola with the transformation t from class trsf2d.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        gp_Hypr2d

        """
        return _gp.gp_Hypr2d_Transformed(self, *args)

    def Translate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Vec2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        None

        """
        return _gp.gp_Hypr2d_Translate(self, *args)

    def Translated(self, *args) -> "gp_Hypr2d":
        r"""
        Translates an hyperbola in the direction of the vector v. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        V: gp_Vec2d

        Returns
        -------
        gp_Hypr2d
        Translates an hyperbola from the point p1 to the point p2.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        gp_Hypr2d

        """
        return _gp.gp_Hypr2d_Translated(self, *args)

    def XAxis(self, *args) -> "gp_Ax2d":
        r"""
        Computes an axis whose - the origin is the center of this hyperbola, and - the unit vector is the 'x direction' or 'y direction' respectively of the local coordinate system of this hyperbola returns the major axis of the hyperbola.

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Hypr2d_XAxis(self, *args)

    def YAxis(self, *args) -> "gp_Ax2d":
        r"""
        Computes an axis whose - the origin is the center of this hyperbola, and - the unit vector is the 'x direction' or 'y direction' respectively of the local coordinate system of this hyperbola returns the minor axis of the hyperbola.

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Hypr2d_YAxis(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Hypr2d

# Register gp_Hypr2d in _gp:
_gp.gp_Hypr2d_swigregister(gp_Hypr2d)

class gp_Lin(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a line corresponding to z axis of the reference coordinate system.

        Returns
        -------
        None
        Creates a line defined by axis a1.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None
        Creates a line passing through point p and parallel to vector v (p and v are, respectively, the origin and the unit vector of the positioning axis of the line).

        Parameters
        ----------
        P: gp_Pnt
        V: gp_Dir

        Returns
        -------
        None

        """
        _gp.gp_Lin_swiginit(self, _gp.new_gp_Lin(*args))

    def Angle(self, *args) -> "Standard_Real":
        r"""
        Computes the angle between two lines in radians.

        Parameters
        ----------
        Other: gp_Lin

        Returns
        -------
        float

        """
        return _gp.gp_Lin_Angle(self, *args)

    def Contains(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if this line contains the point p, that is, if the distance between point p and this line is less than or equal to lineartolerance..

        Parameters
        ----------
        P: gp_Pnt
        LinearTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Lin_Contains(self, *args)

    def Direction(self, *args) -> "gp_Dir const":
        r"""
        Returns the direction of the line.

        Returns
        -------
        gp_Dir

        """
        return _gp.gp_Lin_Direction(self, *args)

    def Distance(self, *args) -> "Standard_Real":
        r"""
        Computes the distance between <self> and the point p.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        float
        Computes the distance between two lines.

        Parameters
        ----------
        Other: gp_Lin

        Returns
        -------
        float

        """
        return _gp.gp_Lin_Distance(self, *args)

    def Location(self, *args) -> "gp_Pnt const":
        r"""
        Returns the location point (origin) of the line.

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Lin_Location(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        None

        """
        return _gp.gp_Lin_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Lin":
        r"""
        Performs the symmetrical transformation of a line with respect to the point p which is the center of the symmetry.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        gp_Lin
        Performs the symmetrical transformation of a line with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        gp_Lin
        Performs the symmetrical transformation of a line with respect to a plane. the axis placement <a2> locates the plane of the symmetry : (location, xdirection, ydirection).

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        gp_Lin

        """
        return _gp.gp_Lin_Mirrored(self, *args)

    def Normal(self, *args) -> "gp_Lin":
        r"""
        Computes the line normal to the direction of <self>, passing through the point p. raises constructionerror if the distance between <self> and the point p is lower or equal to resolution from gp because there is an infinity of solutions in 3d space.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        gp_Lin

        """
        return _gp.gp_Lin_Normal(self, *args)

    def Position(self, *args) -> "gp_Ax1 const":
        r"""
        Returns the axis placement one axis whith the same location and direction as <self>.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Lin_Position(self, *args)

    def Reverse(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _gp.gp_Lin_Reverse(self, *args)

    def Reversed(self, *args) -> "gp_Lin":
        r"""
        Reverses the direction of the line. note: - reverse assigns the result to this line, while - reversed creates a new one.

        Returns
        -------
        gp_Lin

        """
        return _gp.gp_Lin_Reversed(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Lin_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Lin":
        r"""
        Rotates a line. a1 is the axis of the rotation. ang is the angular value of the rotation in radians.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        gp_Lin

        """
        return _gp.gp_Lin_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Lin_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Lin":
        r"""
        Scales a line. s is the scaling value. the 'location' point (origin) of the line is modified. the 'direction' is reversed if the scale is negative.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        gp_Lin

        """
        return _gp.gp_Lin_Scaled(self, *args)

    def SetDirection(self, *args) -> "void":
        r"""
        Changes the direction of the line.

        Parameters
        ----------
        V: gp_Dir

        Returns
        -------
        None

        """
        return _gp.gp_Lin_SetDirection(self, *args)

    def SetLocation(self, *args) -> "void":
        r"""
        Changes the location point (origin) of the line.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Lin_SetLocation(self, *args)

    def SetPosition(self, *args) -> "void":
        r"""
        Complete redefinition of the line. the 'location' point of <a1> is the origin of the line. the 'direction' of <a1> is the direction of the line.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None

        """
        return _gp.gp_Lin_SetPosition(self, *args)

    def SquareDistance(self, *args) -> "Standard_Real":
        r"""
        Computes the square distance between <self> and the point p.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        float
        Computes the square distance between two lines.

        Parameters
        ----------
        Other: gp_Lin

        Returns
        -------
        float

        """
        return _gp.gp_Lin_SquareDistance(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        None

        """
        return _gp.gp_Lin_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Lin":
        r"""
        Transforms a line with the transformation t from class trsf.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        gp_Lin

        """
        return _gp.gp_Lin_Transformed(self, *args)

    def Translate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Lin_Translate(self, *args)

    def Translated(self, *args) -> "gp_Lin":
        r"""
        Translates a line in the direction of the vector v. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        gp_Lin
        Translates a line from the point p1 to the point p2.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        gp_Lin

        """
        return _gp.gp_Lin_Translated(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Lin

# Register gp_Lin in _gp:
_gp.gp_Lin_swigregister(gp_Lin)

class gp_Lin2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a line corresponding to x axis of the reference coordinate system.

        Returns
        -------
        None
        Creates a line located with a.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        None
        <p> is the location point (origin) of the line and <v> is the direction of the line.

        Parameters
        ----------
        P: gp_Pnt2d
        V: gp_Dir2d

        Returns
        -------
        None
        Creates the line from the equation a*x + b*y + c = 0.0 raises constructionerror if sqrt(a*a + b*b) <= resolution from gp. raised if sqrt(a*a + b*b) <= resolution from gp.

        Parameters
        ----------
        A: float
        B: float
        C: float

        Returns
        -------
        None

        """
        _gp.gp_Lin2d_swiginit(self, _gp.new_gp_Lin2d(*args))

    def Angle(self, *args) -> "Standard_Real":
        r"""
        Computes the angle between two lines in radians.

        Parameters
        ----------
        Other: gp_Lin2d

        Returns
        -------
        float

        """
        return _gp.gp_Lin2d_Angle(self, *args)

    def Coefficients(self, *args) -> "void":
        r"""
        Returns the normalized coefficients of the line : a * x + b * y + c = 0.

        Parameters
        ----------

        Returns
        -------
        A: float
        B: float
        C: float

        """
        return _gp.gp_Lin2d_Coefficients(self, *args)

    def Contains(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if this line contains the point p, that is, if the distance between point p and this line is less than or equal to lineartolerance.

        Parameters
        ----------
        P: gp_Pnt2d
        LinearTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Lin2d_Contains(self, *args)

    def Direction(self, *args) -> "gp_Dir2d const":
        r"""
        Returns the direction of the line.

        Returns
        -------
        gp_Dir2d

        """
        return _gp.gp_Lin2d_Direction(self, *args)

    def Distance(self, *args) -> "Standard_Real":
        r"""
        Computes the distance between <self> and the point <p>.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        float
        Computes the distance between two lines.

        Parameters
        ----------
        Other: gp_Lin2d

        Returns
        -------
        float

        """
        return _gp.gp_Lin2d_Distance(self, *args)

    def Location(self, *args) -> "gp_Pnt2d const":
        r"""
        Returns the location point (origin) of the line.

        Returns
        -------
        gp_Pnt2d

        """
        return _gp.gp_Lin2d_Location(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        None

        """
        return _gp.gp_Lin2d_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Lin2d":
        r"""
        Performs the symmetrical transformation of a line with respect to the point <p> which is the center of the symmetry.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        gp_Lin2d
        Performs the symmetrical transformation of a line with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        gp_Lin2d

        """
        return _gp.gp_Lin2d_Mirrored(self, *args)

    def Normal(self, *args) -> "gp_Lin2d":
        r"""
        Computes the line normal to the direction of <self>, passing through the point <p>.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        gp_Lin2d

        """
        return _gp.gp_Lin2d_Normal(self, *args)

    def Position(self, *args) -> "gp_Ax2d const":
        r"""
        Returns the axis placement one axis whith the same location and direction as <self>.

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Lin2d_Position(self, *args)

    def Reverse(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _gp.gp_Lin2d_Reverse(self, *args)

    def Reversed(self, *args) -> "gp_Lin2d":
        r"""
        Reverses the positioning axis of this line. note: - reverse assigns the result to this line, while - reversed creates a new one.

        Returns
        -------
        gp_Lin2d

        """
        return _gp.gp_Lin2d_Reversed(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Lin2d_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Lin2d":
        r"""
        Rotates a line. p is the center of the rotation. ang is the angular value of the rotation in radians.

        Parameters
        ----------
        P: gp_Pnt2d
        Ang: float

        Returns
        -------
        gp_Lin2d

        """
        return _gp.gp_Lin2d_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Lin2d_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Lin2d":
        r"""
        Scales a line. s is the scaling value. only the origin of the line is modified.

        Parameters
        ----------
        P: gp_Pnt2d
        S: float

        Returns
        -------
        gp_Lin2d

        """
        return _gp.gp_Lin2d_Scaled(self, *args)

    def SetDirection(self, *args) -> "void":
        r"""
        Changes the direction of the line.

        Parameters
        ----------
        V: gp_Dir2d

        Returns
        -------
        None

        """
        return _gp.gp_Lin2d_SetDirection(self, *args)

    def SetLocation(self, *args) -> "void":
        r"""
        Changes the origin of the line.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        None

        """
        return _gp.gp_Lin2d_SetLocation(self, *args)

    def SetPosition(self, *args) -> "void":
        r"""
        Complete redefinition of the line. the 'location' point of <a> is the origin of the line. the 'direction' of <a> is the direction of the line.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        None

        """
        return _gp.gp_Lin2d_SetPosition(self, *args)

    def SquareDistance(self, *args) -> "Standard_Real":
        r"""
        Computes the square distance between <self> and the point <p>.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        float
        Computes the square distance between two lines.

        Parameters
        ----------
        Other: gp_Lin2d

        Returns
        -------
        float

        """
        return _gp.gp_Lin2d_SquareDistance(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        None

        """
        return _gp.gp_Lin2d_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Lin2d":
        r"""
        Transforms a line with the transformation t from class trsf2d.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        gp_Lin2d

        """
        return _gp.gp_Lin2d_Transformed(self, *args)

    def Translate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Vec2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        None

        """
        return _gp.gp_Lin2d_Translate(self, *args)

    def Translated(self, *args) -> "gp_Lin2d":
        r"""
        Translates a line in the direction of the vector v. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        V: gp_Vec2d

        Returns
        -------
        gp_Lin2d
        Translates a line from the point p1 to the point p2.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        gp_Lin2d

        """
        return _gp.gp_Lin2d_Translated(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Lin2d

# Register gp_Lin2d in _gp:
_gp.gp_Lin2d_swigregister(gp_Lin2d)

class gp_Mat(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a matrix with null coefficients.

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        a11: float
        a12: float
        a13: float
        a21: float
        a22: float
        a23: float
        a31: float
        a32: float
        a33: float

        Returns
        -------
        None
        Creates a matrix. col1, col2, col3 are the 3 columns of the matrix.

        Parameters
        ----------
        Col1: gp_XYZ
        Col2: gp_XYZ
        Col3: gp_XYZ

        Returns
        -------
        None

        """
        _gp.gp_Mat_swiginit(self, _gp.new_gp_Mat(*args))

    def Add(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_Mat

        Returns
        -------
        None

        """
        return _gp.gp_Mat_Add(self, *args)

    def Added(self, *args) -> "gp_Mat":
        r"""
        Computes the sum of this matrix and the matrix other for each coefficient of the matrix : <self>.coef(i,j) + <other>.coef(i,j).

        Parameters
        ----------
        Other: gp_Mat

        Returns
        -------
        gp_Mat

        """
        return _gp.gp_Mat_Added(self, *args)

    def GetChangeValue(self, Row: "Standard_Integer const", Col: "Standard_Integer const") -> "Standard_Real":
        r"""GetChangeValue(gp_Mat self, Standard_Integer const Row, Standard_Integer const Col) -> Standard_Real"""
        return _gp.gp_Mat_GetChangeValue(self, Row, Col)

    def SetChangeValue(self, Row: "Standard_Integer const", Col: "Standard_Integer const", value: "Standard_Real") -> "void":
        r"""SetChangeValue(gp_Mat self, Standard_Integer const Row, Standard_Integer const Col, Standard_Real value)"""
        return _gp.gp_Mat_SetChangeValue(self, Row, Col, value)

    def Column(self, *args) -> "gp_XYZ":
        r"""
        Returns the column of col index. raises outofrange if col < 1 or col > 3.

        Parameters
        ----------
        Col: int

        Returns
        -------
        gp_XYZ

        """
        return _gp.gp_Mat_Column(self, *args)

    def Determinant(self, *args) -> "Standard_Real":
        r"""
        Computes the determinant of the matrix.

        Returns
        -------
        float

        """
        return _gp.gp_Mat_Determinant(self, *args)

    def Diagonal(self, *args) -> "gp_XYZ":
        r"""
        Returns the main diagonal of the matrix.

        Returns
        -------
        gp_XYZ

        """
        return _gp.gp_Mat_Diagonal(self, *args)

    def Divide(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        None

        """
        return _gp.gp_Mat_Divide(self, *args)

    def Divided(self, *args) -> "gp_Mat":
        r"""
        Divides all the coefficients of the matrix by scalar.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        gp_Mat

        """
        return _gp.gp_Mat_Divided(self, *args)

    def DumpJsonToString(self, depth: "int"=-1) -> "std::string":
        r"""DumpJsonToString(gp_Mat self, int depth=-1) -> std::string"""
        return _gp.gp_Mat_DumpJsonToString(self, depth)

    def Invert(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _gp.gp_Mat_Invert(self, *args)

    def Inverted(self, *args) -> "gp_Mat":
        r"""
        Inverses the matrix and raises if the matrix is singular. - invert assigns the result to this matrix, while - inverted creates a new one. warning the gauss lu decomposition is used to invert the matrix. consequently, the matrix is considered as singular if the largest pivot found is less than or equal to gp::resolution(). exceptions standard_constructionerror if this matrix is singular, and therefore cannot be inverted.

        Returns
        -------
        gp_Mat

        """
        return _gp.gp_Mat_Inverted(self, *args)

    def IsSingular(self, *args) -> "Standard_Boolean":
        r"""
        The gauss lu decomposition is used to invert the matrix (see math package) so the matrix is considered as singular if the largest pivot found is lower or equal to resolution from gp.

        Returns
        -------
        bool

        """
        return _gp.gp_Mat_IsSingular(self, *args)

    def Multiplied(self, *args) -> "gp_Mat":
        r"""
        Computes the product of two matrices <self> * <other>.

        Parameters
        ----------
        Other: gp_Mat

        Returns
        -------
        gp_Mat
        No available documentation.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        gp_Mat

        """
        return _gp.gp_Mat_Multiplied(self, *args)

    def Multiply(self, *args) -> "void":
        r"""
        Computes the product of two matrices <self> = <other> * <self>.

        Parameters
        ----------
        Other: gp_Mat

        Returns
        -------
        None
        Multiplies all the coefficients of the matrix by scalar.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        None

        """
        return _gp.gp_Mat_Multiply(self, *args)

    def Power(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        N: int

        Returns
        -------
        None

        """
        return _gp.gp_Mat_Power(self, *args)

    def Powered(self, *args) -> "gp_Mat":
        r"""
        Computes <self> = <self> * <self> * .......* <self>, n time. if n = 0 <self> = identity if n < 0 <self> = <self>.invert() *...........* <self>.invert(). if n < 0 an exception will be raised if the matrix is not inversible.

        Parameters
        ----------
        N: int

        Returns
        -------
        gp_Mat

        """
        return _gp.gp_Mat_Powered(self, *args)

    def PreMultiply(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_Mat

        Returns
        -------
        None

        """
        return _gp.gp_Mat_PreMultiply(self, *args)

    def Row(self, *args) -> "gp_XYZ":
        r"""
        Returns the row of row index. raises outofrange if row < 1 or row > 3.

        Parameters
        ----------
        Row: int

        Returns
        -------
        gp_XYZ

        """
        return _gp.gp_Mat_Row(self, *args)

    def SetCol(self, *args) -> "void":
        r"""
        Assigns the three coordinates of value to the column of index col of this matrix. raises outofrange if col < 1 or col > 3.

        Parameters
        ----------
        Col: int
        Value: gp_XYZ

        Returns
        -------
        None

        """
        return _gp.gp_Mat_SetCol(self, *args)

    def SetCols(self, *args) -> "void":
        r"""
        Assigns the number triples col1, col2, col3 to the three columns of this matrix.

        Parameters
        ----------
        Col1: gp_XYZ
        Col2: gp_XYZ
        Col3: gp_XYZ

        Returns
        -------
        None

        """
        return _gp.gp_Mat_SetCols(self, *args)

    def SetCross(self, *args) -> "void":
        r"""
        Modifies the matrix m so that applying it to any number triple (x, y, z) produces the same result as the cross product of ref and the number triple (x, y, z): i.e.: m * {x,y,z}t = ref.cross({x, y ,z}) this matrix is anti symmetric. to apply this matrix to the triplet {xyz} is the same as to do the cross product between the triplet ref and the triplet {xyz}. note: this matrix is anti-symmetric.

        Parameters
        ----------
        Ref: gp_XYZ

        Returns
        -------
        None

        """
        return _gp.gp_Mat_SetCross(self, *args)

    def SetDiagonal(self, *args) -> "void":
        r"""
        Modifies the main diagonal of the matrix. <self>.value (1, 1) = x1 <self>.value (2, 2) = x2 <self>.value (3, 3) = x3 the other coefficients of the matrix are not modified.

        Parameters
        ----------
        X1: float
        X2: float
        X3: float

        Returns
        -------
        None

        """
        return _gp.gp_Mat_SetDiagonal(self, *args)

    def SetDot(self, *args) -> "void":
        r"""
        Modifies this matrix so that applying it to any number triple (x, y, z) produces the same result as the scalar product of ref and the number triple (x, y, z): this * (x,y,z) = ref.(x,y,z) note: this matrix is symmetric.

        Parameters
        ----------
        Ref: gp_XYZ

        Returns
        -------
        None

        """
        return _gp.gp_Mat_SetDot(self, *args)

    def SetIdentity(self, *args) -> "void":
        r"""
        Modifies this matrix so that it represents the identity matrix.

        Returns
        -------
        None

        """
        return _gp.gp_Mat_SetIdentity(self, *args)

    def SetRotation(self, *args) -> "void":
        r"""
        Modifies this matrix so that it represents a rotation. ang is the angular value in radians and the xyz axis gives the direction of the rotation. raises constructionerror if xyz.modulus() <= resolution().

        Parameters
        ----------
        Axis: gp_XYZ
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Mat_SetRotation(self, *args)

    def SetRow(self, *args) -> "void":
        r"""
        Assigns the three coordinates of value to the row of index row of this matrix. raises outofrange if row < 1 or row > 3.

        Parameters
        ----------
        Row: int
        Value: gp_XYZ

        Returns
        -------
        None

        """
        return _gp.gp_Mat_SetRow(self, *args)

    def SetRows(self, *args) -> "void":
        r"""
        Assigns the number triples row1, row2, row3 to the three rows of this matrix.

        Parameters
        ----------
        Row1: gp_XYZ
        Row2: gp_XYZ
        Row3: gp_XYZ

        Returns
        -------
        None

        """
        return _gp.gp_Mat_SetRows(self, *args)

    def SetScale(self, *args) -> "void":
        r"""
        Modifies the the matrix so that it represents a scaling transformation, where s is the scale factor. : | s 0.0 0.0 | <self> = | 0.0 s 0.0 | | 0.0 0.0 s |.

        Parameters
        ----------
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Mat_SetScale(self, *args)

    def SetValue(self, *args) -> "void":
        r"""
        Assigns <value> to the coefficient of row row, column col of this matrix. raises outofrange if row < 1 or row > 3 or col < 1 or col > 3.

        Parameters
        ----------
        Row: int
        Col: int
        Value: float

        Returns
        -------
        None

        """
        return _gp.gp_Mat_SetValue(self, *args)

    def Subtract(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_Mat

        Returns
        -------
        None

        """
        return _gp.gp_Mat_Subtract(self, *args)

    def Subtracted(self, *args) -> "gp_Mat":
        r"""
        Computes for each coefficient of the matrix : <self>.coef(i,j) - <other>.coef(i,j).

        Parameters
        ----------
        Other: gp_Mat

        Returns
        -------
        gp_Mat

        """
        return _gp.gp_Mat_Subtracted(self, *args)

    def Transpose(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _gp.gp_Mat_Transpose(self, *args)

    def Transposed(self, *args) -> "gp_Mat":
        r"""
        Transposes the matrix. a(j, i) -> a (i, j).

        Returns
        -------
        gp_Mat

        """
        return _gp.gp_Mat_Transposed(self, *args)

    def Value(self, *args) -> "Standard_Real const &":
        r"""
        Returns the coefficient of range (row, col) raises outofrange if row < 1 or row > 3 or col < 1 or col > 3.

        Parameters
        ----------
        Row: int
        Col: int

        Returns
        -------
        float

        """
        return _gp.gp_Mat_Value(self, *args)

    def __mul__(self, *args) -> "gp_Mat":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_Mat

        Returns
        -------
        gp_Mat
        No available documentation.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        gp_Mat

        """
        return _gp.gp_Mat___mul__(self, *args)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __imul_wrapper__(self, *args) -> "void":
        r"""
        __imul_wrapper__(gp_Mat self, gp_Mat other)
        __imul_wrapper__(gp_Mat self, Standard_Real const other)
        """
        return _gp.gp_Mat___imul_wrapper__(self, *args)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __add__(self, *args) -> "gp_Mat":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_Mat

        Returns
        -------
        gp_Mat

        """
        return _gp.gp_Mat___add__(self, *args)

    def __iadd_wrapper__(self, other: "gp_Mat") -> "void":
        r"""__iadd_wrapper__(gp_Mat self, gp_Mat other)"""
        return _gp.gp_Mat___iadd_wrapper__(self, other)

    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __sub__(self, *args) -> "gp_Mat":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_Mat

        Returns
        -------
        gp_Mat

        """
        return _gp.gp_Mat___sub__(self, *args)

    def __isub_wrapper__(self, other: "gp_Mat") -> "void":
        r"""__isub_wrapper__(gp_Mat self, gp_Mat other)"""
        return _gp.gp_Mat___isub_wrapper__(self, other)

    def __isub__(self, right):
        self.__isub_wrapper__(right)
        return self


    def __truediv__(self, *args):
        return _gp.gp_Mat___truediv__(self, *args)
    __div__ = __truediv__



    def __itruediv_wrapper__(self, other: "Standard_Real const") -> "void":
        r"""__itruediv_wrapper__(gp_Mat self, Standard_Real const other)"""
        return _gp.gp_Mat___itruediv_wrapper__(self, other)

    def __itruediv__(self, right):
        self.__itruediv_wrapper__(right)
        return self


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Mat

# Register gp_Mat in _gp:
_gp.gp_Mat_swigregister(gp_Mat)

class gp_Mat2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a matrix with null coefficients.

        Returns
        -------
        None
        Col1, col2 are the 2 columns of the matrix.

        Parameters
        ----------
        Col1: gp_XY
        Col2: gp_XY

        Returns
        -------
        None

        """
        _gp.gp_Mat2d_swiginit(self, _gp.new_gp_Mat2d(*args))

    def Add(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_Mat2d

        Returns
        -------
        None

        """
        return _gp.gp_Mat2d_Add(self, *args)

    def Added(self, *args) -> "gp_Mat2d":
        r"""
        Computes the sum of this matrix and the matrix other.for each coefficient of the matrix : <self>.coef(i,j) + <other>.coef(i,j) note: - operator += assigns the result to this matrix, while - operator + creates a new one.

        Parameters
        ----------
        Other: gp_Mat2d

        Returns
        -------
        gp_Mat2d

        """
        return _gp.gp_Mat2d_Added(self, *args)

    def GetChangeValue(self, Row: "Standard_Integer const", Col: "Standard_Integer const") -> "Standard_Real":
        r"""GetChangeValue(gp_Mat2d self, Standard_Integer const Row, Standard_Integer const Col) -> Standard_Real"""
        return _gp.gp_Mat2d_GetChangeValue(self, Row, Col)

    def SetChangeValue(self, Row: "Standard_Integer const", Col: "Standard_Integer const", value: "Standard_Real") -> "void":
        r"""SetChangeValue(gp_Mat2d self, Standard_Integer const Row, Standard_Integer const Col, Standard_Real value)"""
        return _gp.gp_Mat2d_SetChangeValue(self, Row, Col, value)

    def Column(self, *args) -> "gp_XY":
        r"""
        Returns the column of col index. raises outofrange if col < 1 or col > 2.

        Parameters
        ----------
        Col: int

        Returns
        -------
        gp_XY

        """
        return _gp.gp_Mat2d_Column(self, *args)

    def Determinant(self, *args) -> "Standard_Real":
        r"""
        Computes the determinant of the matrix.

        Returns
        -------
        float

        """
        return _gp.gp_Mat2d_Determinant(self, *args)

    def Diagonal(self, *args) -> "gp_XY":
        r"""
        Returns the main diagonal of the matrix.

        Returns
        -------
        gp_XY

        """
        return _gp.gp_Mat2d_Diagonal(self, *args)

    def Divide(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        None

        """
        return _gp.gp_Mat2d_Divide(self, *args)

    def Divided(self, *args) -> "gp_Mat2d":
        r"""
        Divides all the coefficients of the matrix by a scalar.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        gp_Mat2d

        """
        return _gp.gp_Mat2d_Divided(self, *args)

    def Invert(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _gp.gp_Mat2d_Invert(self, *args)

    def Inverted(self, *args) -> "gp_Mat2d":
        r"""
        Inverses the matrix and raises exception if the matrix is singular.

        Returns
        -------
        gp_Mat2d

        """
        return _gp.gp_Mat2d_Inverted(self, *args)

    def IsSingular(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if this matrix is singular (and therefore, cannot be inverted). the gauss lu decomposition is used to invert the matrix so the matrix is considered as singular if the largest pivot found is lower or equal to resolution from gp.

        Returns
        -------
        bool

        """
        return _gp.gp_Mat2d_IsSingular(self, *args)

    def Multiplied(self, *args) -> "gp_Mat2d":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_Mat2d

        Returns
        -------
        gp_Mat2d
        No available documentation.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        gp_Mat2d

        """
        return _gp.gp_Mat2d_Multiplied(self, *args)

    def Multiply(self, *args) -> "void":
        r"""
        Computes the product of two matrices <self> * <other>.

        Parameters
        ----------
        Other: gp_Mat2d

        Returns
        -------
        None
        Multiplies all the coefficients of the matrix by a scalar.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        None

        """
        return _gp.gp_Mat2d_Multiply(self, *args)

    def Power(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        N: int

        Returns
        -------
        None

        """
        return _gp.gp_Mat2d_Power(self, *args)

    def Powered(self, *args) -> "gp_Mat2d":
        r"""
        Computes <self> = <self> * <self> * .......* <self>, n time. if n = 0 <self> = identity if n < 0 <self> = <self>.invert() *...........* <self>.invert(). if n < 0 an exception can be raised if the matrix is not inversible.

        Parameters
        ----------
        N: int

        Returns
        -------
        gp_Mat2d

        """
        return _gp.gp_Mat2d_Powered(self, *args)

    def PreMultiply(self, *args) -> "void":
        r"""
        Modifies this matrix by premultiplying it by the matrix other <self> = other * <self>.

        Parameters
        ----------
        Other: gp_Mat2d

        Returns
        -------
        None

        """
        return _gp.gp_Mat2d_PreMultiply(self, *args)

    def Row(self, *args) -> "gp_XY":
        r"""
        Returns the row of index row. raised if row < 1 or row > 2.

        Parameters
        ----------
        Row: int

        Returns
        -------
        gp_XY

        """
        return _gp.gp_Mat2d_Row(self, *args)

    def SetCol(self, *args) -> "void":
        r"""
        Assigns the two coordinates of value to the column of range col of this matrix raises outofrange if col < 1 or col > 2.

        Parameters
        ----------
        Col: int
        Value: gp_XY

        Returns
        -------
        None

        """
        return _gp.gp_Mat2d_SetCol(self, *args)

    def SetCols(self, *args) -> "void":
        r"""
        Assigns the number pairs col1, col2 to the two columns of this matrix.

        Parameters
        ----------
        Col1: gp_XY
        Col2: gp_XY

        Returns
        -------
        None

        """
        return _gp.gp_Mat2d_SetCols(self, *args)

    def SetDiagonal(self, *args) -> "void":
        r"""
        Modifies the main diagonal of the matrix. <self>.value (1, 1) = x1 <self>.value (2, 2) = x2 the other coefficients of the matrix are not modified.

        Parameters
        ----------
        X1: float
        X2: float

        Returns
        -------
        None

        """
        return _gp.gp_Mat2d_SetDiagonal(self, *args)

    def SetIdentity(self, *args) -> "void":
        r"""
        Modifies this matrix, so that it represents the identity matrix.

        Returns
        -------
        None

        """
        return _gp.gp_Mat2d_SetIdentity(self, *args)

    def SetRotation(self, *args) -> "void":
        r"""
        Modifies this matrix, so that it representso a rotation. ang is the angular value in radian of the rotation.

        Parameters
        ----------
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Mat2d_SetRotation(self, *args)

    def SetRow(self, *args) -> "void":
        r"""
        Assigns the two coordinates of value to the row of index row of this matrix. raises outofrange if row < 1 or row > 2.

        Parameters
        ----------
        Row: int
        Value: gp_XY

        Returns
        -------
        None

        """
        return _gp.gp_Mat2d_SetRow(self, *args)

    def SetRows(self, *args) -> "void":
        r"""
        Assigns the number pairs row1, row2 to the two rows of this matrix.

        Parameters
        ----------
        Row1: gp_XY
        Row2: gp_XY

        Returns
        -------
        None

        """
        return _gp.gp_Mat2d_SetRows(self, *args)

    def SetScale(self, *args) -> "void":
        r"""
        Modifies the matrix such that it represents a scaling transformation, where s is the scale factor : | s 0.0 | <self> = | 0.0 s |.

        Parameters
        ----------
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Mat2d_SetScale(self, *args)

    def SetValue(self, *args) -> "void":
        r"""
        Assigns <value> to the coefficient of row row, column col of this matrix. raises outofrange if row < 1 or row > 2 or col < 1 or col > 2.

        Parameters
        ----------
        Row: int
        Col: int
        Value: float

        Returns
        -------
        None

        """
        return _gp.gp_Mat2d_SetValue(self, *args)

    def Subtract(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_Mat2d

        Returns
        -------
        None

        """
        return _gp.gp_Mat2d_Subtract(self, *args)

    def Subtracted(self, *args) -> "gp_Mat2d":
        r"""
        Computes for each coefficient of the matrix : <self>.coef(i,j) - <other>.coef(i,j).

        Parameters
        ----------
        Other: gp_Mat2d

        Returns
        -------
        gp_Mat2d

        """
        return _gp.gp_Mat2d_Subtracted(self, *args)

    def Transpose(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _gp.gp_Mat2d_Transpose(self, *args)

    def Transposed(self, *args) -> "gp_Mat2d":
        r"""
        Transposes the matrix. a(j, i) -> a (i, j).

        Returns
        -------
        gp_Mat2d

        """
        return _gp.gp_Mat2d_Transposed(self, *args)

    def Value(self, *args) -> "Standard_Real const &":
        r"""
        Returns the coefficient of range (row, col) raises outofrange if row < 1 or row > 2 or col < 1 or col > 2.

        Parameters
        ----------
        Row: int
        Col: int

        Returns
        -------
        float

        """
        return _gp.gp_Mat2d_Value(self, *args)

    def __mul__(self, *args) -> "gp_Mat2d":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_Mat2d

        Returns
        -------
        gp_Mat2d
        No available documentation.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        gp_Mat2d

        """
        return _gp.gp_Mat2d___mul__(self, *args)

    def __imul_wrapper__(self, other: "Standard_Real const") -> "void":
        r"""__imul_wrapper__(gp_Mat2d self, Standard_Real const other)"""
        return _gp.gp_Mat2d___imul_wrapper__(self, other)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __add__(self, *args) -> "gp_Mat2d":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_Mat2d

        Returns
        -------
        gp_Mat2d

        """
        return _gp.gp_Mat2d___add__(self, *args)

    def __iadd_wrapper__(self, other: "gp_Mat2d") -> "void":
        r"""__iadd_wrapper__(gp_Mat2d self, gp_Mat2d other)"""
        return _gp.gp_Mat2d___iadd_wrapper__(self, other)

    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __sub__(self, *args) -> "gp_Mat2d":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_Mat2d

        Returns
        -------
        gp_Mat2d

        """
        return _gp.gp_Mat2d___sub__(self, *args)

    def __isub_wrapper__(self, other: "gp_Mat2d") -> "void":
        r"""__isub_wrapper__(gp_Mat2d self, gp_Mat2d other)"""
        return _gp.gp_Mat2d___isub_wrapper__(self, other)

    def __isub__(self, right):
        self.__isub_wrapper__(right)
        return self


    def __truediv__(self, *args):
        return _gp.gp_Mat2d___truediv__(self, *args)
    __div__ = __truediv__



    def __itruediv_wrapper__(self, other: "Standard_Real const") -> "void":
        r"""__itruediv_wrapper__(gp_Mat2d self, Standard_Real const other)"""
        return _gp.gp_Mat2d___itruediv_wrapper__(self, other)

    def __itruediv__(self, right):
        self.__itruediv_wrapper__(right)
        return self


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Mat2d

# Register gp_Mat2d in _gp:
_gp.gp_Mat2d_swigregister(gp_Mat2d)

class gp_Parab(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an indefinite parabola.

        Returns
        -------
        None
        Creates a parabola with its local coordinate system 'a2' and it's focal length 'focal'. the xdirection of a2 defines the axis of symmetry of the parabola. the ydirection of a2 is parallel to the directrix of the parabola. the location point of a2 is the vertex of the parabola raises constructionerror if focal < 0.0 raised if focal < 0.0.

        Parameters
        ----------
        A2: gp_Ax2
        Focal: float

        Returns
        -------
        None
        D is the directrix of the parabola and f the focus point. the symmetry axis (xaxis) of the parabola is normal to the directrix and pass through the focus point f, but its location point is the vertex of the parabola. the yaxis of the parabola is parallel to d and its location point is the vertex of the parabola. the normal to the plane of the parabola is the cross product between the xaxis and the yaxis.

        Parameters
        ----------
        D: gp_Ax1
        F: gp_Pnt

        Returns
        -------
        None

        """
        _gp.gp_Parab_swiginit(self, _gp.new_gp_Parab(*args))

    def Axis(self, *args) -> "gp_Ax1 const":
        r"""
        Returns the main axis of the parabola. it is the axis normal to the plane of the parabola passing through the vertex of the parabola.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Parab_Axis(self, *args)

    def Directrix(self, *args) -> "gp_Ax1":
        r"""
        Computes the directrix of this parabola. the directrix is: - a line parallel to the 'y direction' of the local coordinate system of this parabola, and - located on the negative side of the axis of symmetry, at a distance from the apex which is equal to the focal length of this parabola. the directrix is returned as an axis (a gp_ax1 object), the origin of which is situated on the 'x axis' of this parabola.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Parab_Directrix(self, *args)

    def Focal(self, *args) -> "Standard_Real":
        r"""
        Returns the distance between the vertex and the focus of the parabola.

        Returns
        -------
        float

        """
        return _gp.gp_Parab_Focal(self, *args)

    def Focus(self, *args) -> "gp_Pnt":
        r"""
        - computes the focus of the parabola.

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Parab_Focus(self, *args)

    def Location(self, *args) -> "gp_Pnt const":
        r"""
        Returns the vertex of the parabola. it is the 'location' point of the coordinate system of the parabola.

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Parab_Location(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        None

        """
        return _gp.gp_Parab_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Parab":
        r"""
        Performs the symmetrical transformation of a parabola with respect to the point p which is the center of the symmetry.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        gp_Parab
        Performs the symmetrical transformation of a parabola with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        gp_Parab
        Performs the symmetrical transformation of a parabola with respect to a plane. the axis placement a2 locates the plane of the symmetry (location, xdirection, ydirection).

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        gp_Parab

        """
        return _gp.gp_Parab_Mirrored(self, *args)

    def Parameter(self, *args) -> "Standard_Real":
        r"""
        Computes the parameter of the parabola. it is the distance between the focus and the directrix of the parabola. this distance is twice the focal length.

        Returns
        -------
        float

        """
        return _gp.gp_Parab_Parameter(self, *args)

    def Position(self, *args) -> "gp_Ax2 const":
        r"""
        Returns the local coordinate system of the parabola.

        Returns
        -------
        gp_Ax2

        """
        return _gp.gp_Parab_Position(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Parab_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Parab":
        r"""
        Rotates a parabola. a1 is the axis of the rotation. ang is the angular value of the rotation in radians.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        gp_Parab

        """
        return _gp.gp_Parab_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Parab_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Parab":
        r"""
        Scales a parabola. s is the scaling value. if s is negative the direction of the symmetry axis xaxis is reversed and the direction of the yaxis too.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        gp_Parab

        """
        return _gp.gp_Parab_Scaled(self, *args)

    def SetAxis(self, *args) -> "void":
        r"""
        Modifies this parabola by redefining its local coordinate system so that - its origin and 'main direction' become those of the axis a1 (the 'x direction' and 'y direction' are then recomputed in the same way as for any gp_ax2) raises constructionerror if the direction of a1 is parallel to the previous xaxis of the parabola.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None

        """
        return _gp.gp_Parab_SetAxis(self, *args)

    def SetFocal(self, *args) -> "void":
        r"""
        Changes the focal distance of the parabola. raises constructionerror if focal < 0.0.

        Parameters
        ----------
        Focal: float

        Returns
        -------
        None

        """
        return _gp.gp_Parab_SetFocal(self, *args)

    def SetLocation(self, *args) -> "void":
        r"""
        Changes the location of the parabola. it is the vertex of the parabola.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Parab_SetLocation(self, *args)

    def SetPosition(self, *args) -> "void":
        r"""
        Changes the local coordinate system of the parabola.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        None

        """
        return _gp.gp_Parab_SetPosition(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        None

        """
        return _gp.gp_Parab_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Parab":
        r"""
        Transforms a parabola with the transformation t from class trsf.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        gp_Parab

        """
        return _gp.gp_Parab_Transformed(self, *args)

    def Translate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Parab_Translate(self, *args)

    def Translated(self, *args) -> "gp_Parab":
        r"""
        Translates a parabola in the direction of the vector v. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        gp_Parab
        Translates a parabola from the point p1 to the point p2.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        gp_Parab

        """
        return _gp.gp_Parab_Translated(self, *args)

    def XAxis(self, *args) -> "gp_Ax1":
        r"""
        Returns the symmetry axis of the parabola. the location point of the axis is the vertex of the parabola.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Parab_XAxis(self, *args)

    def YAxis(self, *args) -> "gp_Ax1":
        r"""
        It is an axis parallel to the directrix of the parabola. the location point of this axis is the vertex of the parabola.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Parab_YAxis(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Parab

# Register gp_Parab in _gp:
_gp.gp_Parab_swigregister(gp_Parab)

class gp_Parab2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an indefinite parabola.

        Returns
        -------
        None
        Creates a parabola with its vertex point, its axis of symmetry ('xaxis') and its focal length. the sense of parametrization is given by thesense. if thesense == true (by default) then right-handed coordinate system is used, otherwise - left-handed. warnings : it is possible to have focallength = 0. in this case, the parabola looks like a line, which is parallel to the symmetry-axis. raises constructionerror if focallength < 0.0.

        Parameters
        ----------
        theMirrorAxis: gp_Ax2d
        theFocalLength: float
        theSense: bool,optional
        	default value is Standard_True

        Returns
        -------
        None
        Creates a parabola with its vertex point, its axis of symmetry ('xaxis'), correspond y-axis and its focal length. warnings : it is possible to have focallength = 0. in this case, the parabola looks like a line, which is parallel to the symmetry-axis. raises constructionerror if focal < 0.0.

        Parameters
        ----------
        theAxes: gp_Ax22d
        theFocalLength: float

        Returns
        -------
        None
        Creates a parabola with the directrix and the focus point. y-axis of the parabola (in user coordinate system - ucs) is the direction of thedirectrix. x-axis always directs from thedirectrix to thefocus point and always comes through thefocus. apex of the parabola is a middle point between the thefocus and the intersection point of thedirectrix and the x-axis. warnings : it is possible to have focallength = 0 (when thefocus lies in thedirectrix). in this case, x-direction of the parabola is defined by thesense parameter. if thesense == true (by default) then right-handed coordinate system is used, otherwise - left-handed. result parabola will look like a line, which is perpendicular to the directrix.

        Parameters
        ----------
        theDirectrix: gp_Ax2d
        theFocus: gp_Pnt2d
        theSense: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        _gp.gp_Parab2d_swiginit(self, _gp.new_gp_Parab2d(*args))

    def Axis(self, *args) -> "gp_Ax22d":
        r"""
        Returns the local coordinate system of the parabola. the 'location' point of this axis is the vertex of the parabola.

        Returns
        -------
        gp_Ax22d

        """
        return _gp.gp_Parab2d_Axis(self, *args)

    def Coefficients(self, *args) -> "void":
        r"""
        Computes the coefficients of the implicit equation of the parabola (in wcs - world coordinate system). a * (x**2) + b * (y**2) + 2*c*(x*y) + 2*d*x + 2*e*y + f = 0.

        Parameters
        ----------

        Returns
        -------
        A: float
        B: float
        C: float
        D: float
        E: float
        F: float

        """
        return _gp.gp_Parab2d_Coefficients(self, *args)

    def Directrix(self, *args) -> "gp_Ax2d":
        r"""
        Computes the directrix of the parabola. the directrix is: - a line parallel to the 'y direction' of the local coordinate system of this parabola, and - located on the negative side of the axis of symmetry, at a distance from the apex which is equal to the focal length of this parabola. the directrix is returned as an axis (a gp_ax2d object), the origin of which is situated on the 'x axis' of this parabola.

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Parab2d_Directrix(self, *args)

    def Focal(self, *args) -> "Standard_Real":
        r"""
        Returns the distance between the vertex and the focus of the parabola.

        Returns
        -------
        float

        """
        return _gp.gp_Parab2d_Focal(self, *args)

    def Focus(self, *args) -> "gp_Pnt2d":
        r"""
        Returns the focus of the parabola.

        Returns
        -------
        gp_Pnt2d

        """
        return _gp.gp_Parab2d_Focus(self, *args)

    def IsDirect(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the local coordinate system is direct and false in the other case.

        Returns
        -------
        bool

        """
        return _gp.gp_Parab2d_IsDirect(self, *args)

    def Location(self, *args) -> "gp_Pnt2d":
        r"""
        Returns the vertex of the parabola.

        Returns
        -------
        gp_Pnt2d

        """
        return _gp.gp_Parab2d_Location(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        None

        """
        return _gp.gp_Parab2d_Mirror(self, *args)

    def MirrorAxis(self, *args) -> "gp_Ax2d":
        r"""
        Returns the symmetry axis of the parabola. the 'location' point of this axis is the vertex of the parabola.

        Returns
        -------
        gp_Ax2d

        """
        return _gp.gp_Parab2d_MirrorAxis(self, *args)

    def Mirrored(self, *args) -> "gp_Parab2d":
        r"""
        Performs the symmetrical transformation of a parabola with respect to the point p which is the center of the symmetry.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        gp_Parab2d
        Performs the symmetrical transformation of a parabola with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        gp_Parab2d

        """
        return _gp.gp_Parab2d_Mirrored(self, *args)

    def Parameter(self, *args) -> "Standard_Real":
        r"""
        Returns the distance between the focus and the directrix of the parabola.

        Returns
        -------
        float

        """
        return _gp.gp_Parab2d_Parameter(self, *args)

    def Reverse(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _gp.gp_Parab2d_Reverse(self, *args)

    def Reversed(self, *args) -> "gp_Parab2d":
        r"""
        Reverses the orientation of the local coordinate system of this parabola (the 'y direction' is reversed). therefore, the implicit orientation of this parabola is reversed. note: - reverse assigns the result to this parabola, while - reversed creates a new one.

        Returns
        -------
        gp_Parab2d

        """
        return _gp.gp_Parab2d_Reversed(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Parab2d_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Parab2d":
        r"""
        Rotates a parabola. p is the center of the rotation. ang is the angular value of the rotation in radians.

        Parameters
        ----------
        P: gp_Pnt2d
        Ang: float

        Returns
        -------
        gp_Parab2d

        """
        return _gp.gp_Parab2d_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Parab2d_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Parab2d":
        r"""
        Scales a parabola. s is the scaling value. if s is negative the direction of the symmetry axis 'xaxis' is reversed and the direction of the 'yaxis' too.

        Parameters
        ----------
        P: gp_Pnt2d
        S: float

        Returns
        -------
        gp_Parab2d

        """
        return _gp.gp_Parab2d_Scaled(self, *args)

    def SetAxis(self, *args) -> "void":
        r"""
        Changes the local coordinate system of the parabola. the 'location' point of a becomes the vertex of the parabola.

        Parameters
        ----------
        A: gp_Ax22d

        Returns
        -------
        None

        """
        return _gp.gp_Parab2d_SetAxis(self, *args)

    def SetFocal(self, *args) -> "void":
        r"""
        Changes the focal distance of the parabola warnings : it is possible to have focal = 0. raises constructionerror if focal < 0.0.

        Parameters
        ----------
        Focal: float

        Returns
        -------
        None

        """
        return _gp.gp_Parab2d_SetFocal(self, *args)

    def SetLocation(self, *args) -> "void":
        r"""
        Changes the 'location' point of the parabola. it is the vertex of the parabola.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        None

        """
        return _gp.gp_Parab2d_SetLocation(self, *args)

    def SetMirrorAxis(self, *args) -> "void":
        r"""
        Modifies this parabola, by redefining its local coordinate system so that its origin and 'x direction' become those of the axis ma. the 'y direction' of the local coordinate system is then recomputed. the orientation of the local coordinate system is not modified.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        None

        """
        return _gp.gp_Parab2d_SetMirrorAxis(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        None

        """
        return _gp.gp_Parab2d_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Parab2d":
        r"""
        Transforms an parabola with the transformation t from class trsf2d.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        gp_Parab2d

        """
        return _gp.gp_Parab2d_Transformed(self, *args)

    def Translate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Vec2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        None

        """
        return _gp.gp_Parab2d_Translate(self, *args)

    def Translated(self, *args) -> "gp_Parab2d":
        r"""
        Translates a parabola in the direction of the vector v. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        V: gp_Vec2d

        Returns
        -------
        gp_Parab2d
        Translates a parabola from the point p1 to the point p2.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        gp_Parab2d

        """
        return _gp.gp_Parab2d_Translated(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Parab2d

# Register gp_Parab2d in _gp:
_gp.gp_Parab2d_swigregister(gp_Parab2d)

class gp_Pln(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a plane coincident with oxy plane of the reference coordinate system.

        Returns
        -------
        None
        The coordinate system of the plane is defined with the axis placement a3. the 'direction' of a3 defines the normal to the plane. the 'location' of a3 defines the location (origin) of the plane. the 'xdirection' and 'ydirection' of a3 define the 'xaxis' and the 'yaxis' of the plane used to parametrize the plane.

        Parameters
        ----------
        A3: gp_Ax3

        Returns
        -------
        None
        Creates a plane with the 'location' point <p> and the normal direction <v>.

        Parameters
        ----------
        P: gp_Pnt
        V: gp_Dir

        Returns
        -------
        None
        Creates a plane from its cartesian equation : a * x + b * y + c * z + d = 0.0 raises constructionerror if sqrt (a*a + b*b + c*c) <= resolution from gp.

        Parameters
        ----------
        A: float
        B: float
        C: float
        D: float

        Returns
        -------
        None

        """
        _gp.gp_Pln_swiginit(self, _gp.new_gp_Pln(*args))

    def Axis(self, *args) -> "gp_Ax1 const":
        r"""
        Returns the plane's normal axis.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Pln_Axis(self, *args)

    def Coefficients(self, *args) -> "void":
        r"""
        Returns the coefficients of the plane's cartesian equation : a * x + b * y + c * z + d = 0.

        Parameters
        ----------

        Returns
        -------
        A: float
        B: float
        C: float
        D: float

        """
        return _gp.gp_Pln_Coefficients(self, *args)

    def Contains(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if this plane contains the point p. this means that - the distance between point p and this plane is less than or equal to lineartolerance, or - line l is normal to the 'main axis' of the local coordinate system of this plane, within the tolerance angulartolerance, and the distance between the origin of line l and this plane is less than or equal to lineartolerance.

        Parameters
        ----------
        P: gp_Pnt
        LinearTolerance: float

        Returns
        -------
        bool
        Returns true if this plane contains the line l. this means that - the distance between point p and this plane is less than or equal to lineartolerance, or - line l is normal to the 'main axis' of the local coordinate system of this plane, within the tolerance angulartolerance, and the distance between the origin of line l and this plane is less than or equal to lineartolerance.

        Parameters
        ----------
        L: gp_Lin
        LinearTolerance: float
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Pln_Contains(self, *args)

    def Direct(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the ax3 is right handed.

        Returns
        -------
        bool

        """
        return _gp.gp_Pln_Direct(self, *args)

    def Distance(self, *args) -> "Standard_Real":
        r"""
        Computes the distance between <self> and the point <p>.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        float
        Computes the distance between <self> and the line <l>.

        Parameters
        ----------
        L: gp_Lin

        Returns
        -------
        float
        Computes the distance between two planes.

        Parameters
        ----------
        Other: gp_Pln

        Returns
        -------
        float

        """
        return _gp.gp_Pln_Distance(self, *args)

    def Location(self, *args) -> "gp_Pnt const":
        r"""
        Returns the plane's location (origin).

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Pln_Location(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        None

        """
        return _gp.gp_Pln_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Pln":
        r"""
        Performs the symmetrical transformation of a plane with respect to the point <p> which is the center of the symmetry warnings : the normal direction to the plane is not changed. the 'xaxis' and the 'yaxis' are reversed.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        gp_Pln
        Performs the symmetrical transformation of a plane with respect to an axis placement which is the axis of the symmetry. the transformation is performed on the 'location' point, on the 'xaxis' and the 'yaxis'. the resulting normal direction is the cross product between the 'xdirection' and the 'ydirection' after transformation if the initial plane was right handed, else it is the opposite.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        gp_Pln
        Performs the symmetrical transformation of a plane with respect to an axis placement. the axis placement <a2> locates the plane of the symmetry. the transformation is performed on the 'location' point, on the 'xaxis' and the 'yaxis'. the resulting normal direction is the cross product between the 'xdirection' and the 'ydirection' after transformation if the initial plane was right handed, else it is the opposite.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        gp_Pln

        """
        return _gp.gp_Pln_Mirrored(self, *args)

    def Position(self, *args) -> "gp_Ax3 const":
        r"""
        Returns the local coordinate system of the plane .

        Returns
        -------
        gp_Ax3

        """
        return _gp.gp_Pln_Position(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Pln_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Pln":
        r"""
        Rotates a plane. a1 is the axis of the rotation. ang is the angular value of the rotation in radians.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        gp_Pln

        """
        return _gp.gp_Pln_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Pln_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Pln":
        r"""
        Scales a plane. s is the scaling value.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        gp_Pln

        """
        return _gp.gp_Pln_Scaled(self, *args)

    def SetAxis(self, *args) -> "void":
        r"""
        Modifies this plane, by redefining its local coordinate system so that - its origin and 'main direction' become those of the axis a1 (the 'x direction' and 'y direction' are then recomputed). raises constructionerror if the a1 is parallel to the 'xaxis' of the plane.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None

        """
        return _gp.gp_Pln_SetAxis(self, *args)

    def SetLocation(self, *args) -> "void":
        r"""
        Changes the origin of the plane.

        Parameters
        ----------
        Loc: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Pln_SetLocation(self, *args)

    def SetPosition(self, *args) -> "void":
        r"""
        Changes the local coordinate system of the plane.

        Parameters
        ----------
        A3: gp_Ax3

        Returns
        -------
        None

        """
        return _gp.gp_Pln_SetPosition(self, *args)

    def SquareDistance(self, *args) -> "Standard_Real":
        r"""
        Computes the square distance between <self> and the point <p>.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        float
        Computes the square distance between <self> and the line <l>.

        Parameters
        ----------
        L: gp_Lin

        Returns
        -------
        float
        Computes the square distance between two planes.

        Parameters
        ----------
        Other: gp_Pln

        Returns
        -------
        float

        """
        return _gp.gp_Pln_SquareDistance(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        None

        """
        return _gp.gp_Pln_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Pln":
        r"""
        Transforms a plane with the transformation t from class trsf. the transformation is performed on the 'location' point, on the 'xaxis' and the 'yaxis'. the resulting normal direction is the cross product between the 'xdirection' and the 'ydirection' after transformation.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        gp_Pln

        """
        return _gp.gp_Pln_Transformed(self, *args)

    def Translate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Pln_Translate(self, *args)

    def Translated(self, *args) -> "gp_Pln":
        r"""
        Translates a plane in the direction of the vector v. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        gp_Pln
        Translates a plane from the point p1 to the point p2.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        gp_Pln

        """
        return _gp.gp_Pln_Translated(self, *args)

    def UReverse(self, *args) -> "void":
        r"""
        Reverses the u parametrization of the plane reversing the xaxis.

        Returns
        -------
        None

        """
        return _gp.gp_Pln_UReverse(self, *args)

    def VReverse(self, *args) -> "void":
        r"""
        Reverses the v parametrization of the plane reversing the yaxis.

        Returns
        -------
        None

        """
        return _gp.gp_Pln_VReverse(self, *args)

    def XAxis(self, *args) -> "gp_Ax1":
        r"""
        Returns the x axis of the plane.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Pln_XAxis(self, *args)

    def YAxis(self, *args) -> "gp_Ax1":
        r"""
        Returns the y axis of the plane.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Pln_YAxis(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Pln

# Register gp_Pln in _gp:
_gp.gp_Pln_swigregister(gp_Pln)

class gp_Pnt(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a point with zero coordinates.

        Returns
        -------
        None
        Creates a point from a xyz object.

        Parameters
        ----------
        Coord: gp_XYZ

        Returns
        -------
        None
        Creates a point with its 3 cartesian's coordinates : xp, yp, zp.

        Parameters
        ----------
        Xp: float
        Yp: float
        Zp: float

        Returns
        -------
        None

        """
        _gp.gp_Pnt_swiginit(self, _gp.new_gp_Pnt(*args))

    def BaryCenter(self, *args) -> "void":
        r"""
        Assigns the result of the following expression to this point (alpha*this + beta*p) / (alpha + beta).

        Parameters
        ----------
        Alpha: float
        P: gp_Pnt
        Beta: float

        Returns
        -------
        None

        """
        return _gp.gp_Pnt_BaryCenter(self, *args)

    def ChangeCoord(self, *args) -> "gp_XYZ":
        r"""
        Returns the coordinates of this point. note: this syntax allows direct modification of the returned value.

        Returns
        -------
        gp_XYZ

        """
        return _gp.gp_Pnt_ChangeCoord(self, *args)

    def Coord(self, *args) -> "gp_XYZ const":
        r"""
        Returns the coordinate of corresponding to the value of index : index = 1 => x is returned index = 2 => y is returned index = 3 => z is returned raises outofrange if index != {1, 2, 3}. raised if index != {1, 2, 3}.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float
        For this point gives its three coordinates xp, yp and zp.

        Parameters
        ----------

        Returns
        -------
        Xp: float
        Yp: float
        Zp: float
        For this point, returns its three coordinates as a xyz object.

        Returns
        -------
        gp_XYZ

        """
        return _gp.gp_Pnt_Coord(self, *args)

    def Distance(self, *args) -> "Standard_Real":
        r"""
        Computes the distance between two points.

        Parameters
        ----------
        Other: gp_Pnt

        Returns
        -------
        float

        """
        return _gp.gp_Pnt_Distance(self, *args)

    def IsEqual(self, *args) -> "Standard_Boolean":
        r"""
        Comparison returns true if the distance between the two points is lower or equal to lineartolerance.

        Parameters
        ----------
        Other: gp_Pnt
        LinearTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Pnt_IsEqual(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        Performs the symmetrical transformation of a point with respect to the point p which is the center of the symmetry.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        None

        """
        return _gp.gp_Pnt_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Pnt":
        r"""
        Performs the symmetrical transformation of a point with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        gp_Pnt
        Performs the symmetrical transformation of a point with respect to a plane. the axis placement a2 locates the plane of the symmetry : (location, xdirection, ydirection).

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        gp_Pnt
        Rotates a point. a1 is the axis of the rotation. ang is the angular value of the rotation in radians.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Pnt_Mirrored(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Pnt_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Pnt":
        r"""
        Scales a point. s is the scaling value.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Pnt_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Pnt_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Pnt":
        r"""
        Transforms a point with the transformation t.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Pnt_Scaled(self, *args)

    def SetCoord(self, *args) -> "void":
        r"""
        Changes the coordinate of range index : index = 1 => x is modified index = 2 => y is modified index = 3 => z is modified raised if index != {1, 2, 3}.

        Parameters
        ----------
        Index: int
        Xi: float

        Returns
        -------
        None
        For this point, assigns the values xp, yp and zp to its three coordinates.

        Parameters
        ----------
        Xp: float
        Yp: float
        Zp: float

        Returns
        -------
        None

        """
        return _gp.gp_Pnt_SetCoord(self, *args)

    def SetX(self, *args) -> "void":
        r"""
        Assigns the given value to the x coordinate of this point.

        Parameters
        ----------
        X: float

        Returns
        -------
        None

        """
        return _gp.gp_Pnt_SetX(self, *args)

    def SetXYZ(self, *args) -> "void":
        r"""
        Assigns the three coordinates of coord to this point.

        Parameters
        ----------
        Coord: gp_XYZ

        Returns
        -------
        None

        """
        return _gp.gp_Pnt_SetXYZ(self, *args)

    def SetY(self, *args) -> "void":
        r"""
        Assigns the given value to the y coordinate of this point.

        Parameters
        ----------
        Y: float

        Returns
        -------
        None

        """
        return _gp.gp_Pnt_SetY(self, *args)

    def SetZ(self, *args) -> "void":
        r"""
        Assigns the given value to the z coordinate of this point.

        Parameters
        ----------
        Z: float

        Returns
        -------
        None

        """
        return _gp.gp_Pnt_SetZ(self, *args)

    def SquareDistance(self, *args) -> "Standard_Real":
        r"""
        Computes the square distance between two points.

        Parameters
        ----------
        Other: gp_Pnt

        Returns
        -------
        float

        """
        return _gp.gp_Pnt_SquareDistance(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        None

        """
        return _gp.gp_Pnt_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Pnt":
        r"""
        Translates a point in the direction of the vector v. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Pnt_Transformed(self, *args)

    def Translate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Pnt_Translate(self, *args)

    def Translated(self, *args) -> "gp_Pnt":
        r"""
        Translates a point from the point p1 to the point p2.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        gp_Pnt
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Pnt_Translated(self, *args)

    def X(self, *args) -> "Standard_Real":
        r"""
        For this point, returns its x coordinate.

        Returns
        -------
        float

        """
        return _gp.gp_Pnt_X(self, *args)

    def XYZ(self, *args) -> "gp_XYZ const":
        r"""
        For this point, returns its three coordinates as a xyz object.

        Returns
        -------
        gp_XYZ

        """
        return _gp.gp_Pnt_XYZ(self, *args)

    def Y(self, *args) -> "Standard_Real":
        r"""
        For this point, returns its y coordinate.

        Returns
        -------
        float

        """
        return _gp.gp_Pnt_Y(self, *args)

    def Z(self, *args) -> "Standard_Real":
        r"""
        For this point, returns its z coordinate.

        Returns
        -------
        float

        """
        return _gp.gp_Pnt_Z(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Pnt

# Register gp_Pnt in _gp:
_gp.gp_Pnt_swigregister(gp_Pnt)

class gp_Pnt2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a point with zero coordinates.

        Returns
        -------
        None
        Creates a point with a doublet of coordinates.

        Parameters
        ----------
        Coord: gp_XY

        Returns
        -------
        None
        Creates a point with its 2 cartesian's coordinates : xp, yp.

        Parameters
        ----------
        Xp: float
        Yp: float

        Returns
        -------
        None

        """
        _gp.gp_Pnt2d_swiginit(self, _gp.new_gp_Pnt2d(*args))

    def ChangeCoord(self, *args) -> "gp_XY":
        r"""
        Returns the coordinates of this point. note: this syntax allows direct modification of the returned value.

        Returns
        -------
        gp_XY

        """
        return _gp.gp_Pnt2d_ChangeCoord(self, *args)

    def Coord(self, *args) -> "gp_XY const":
        r"""
        Returns the coordinate of range index : index = 1 => x is returned index = 2 => y is returned raises outofrange if index != {1, 2}.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float
        For this point returns its two coordinates as a number pair.

        Parameters
        ----------

        Returns
        -------
        Xp: float
        Yp: float
        For this point, returns its two coordinates as a number pair.

        Returns
        -------
        gp_XY

        """
        return _gp.gp_Pnt2d_Coord(self, *args)

    def Distance(self, *args) -> "Standard_Real":
        r"""
        Computes the distance between two points.

        Parameters
        ----------
        Other: gp_Pnt2d

        Returns
        -------
        float

        """
        return _gp.gp_Pnt2d_Distance(self, *args)

    def IsEqual(self, *args) -> "Standard_Boolean":
        r"""
        Comparison returns true if the distance between the two points is lower or equal to lineartolerance.

        Parameters
        ----------
        Other: gp_Pnt2d
        LinearTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Pnt2d_IsEqual(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        Performs the symmetrical transformation of a point with respect to the point p which is the center of the symmetry.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        None

        """
        return _gp.gp_Pnt2d_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Pnt2d":
        r"""
        Performs the symmetrical transformation of a point with respect to an axis placement which is the axis.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        gp_Pnt2d
        Rotates a point. a1 is the axis of the rotation. ang is the angular value of the rotation in radians.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        gp_Pnt2d

        """
        return _gp.gp_Pnt2d_Mirrored(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Pnt2d_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Pnt2d":
        r"""
        Scales a point. s is the scaling value.

        Parameters
        ----------
        P: gp_Pnt2d
        Ang: float

        Returns
        -------
        gp_Pnt2d

        """
        return _gp.gp_Pnt2d_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt2d
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Pnt2d_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Pnt2d":
        r"""
        Transforms a point with the transformation t.

        Parameters
        ----------
        P: gp_Pnt2d
        S: float

        Returns
        -------
        gp_Pnt2d

        """
        return _gp.gp_Pnt2d_Scaled(self, *args)

    def SetCoord(self, *args) -> "void":
        r"""
        Assigns the value xi to the coordinate that corresponds to index: index = 1 => x is modified index = 2 => y is modified raises outofrange if index != {1, 2}.

        Parameters
        ----------
        Index: int
        Xi: float

        Returns
        -------
        None
        For this point, assigns the values xp and yp to its two coordinates.

        Parameters
        ----------
        Xp: float
        Yp: float

        Returns
        -------
        None

        """
        return _gp.gp_Pnt2d_SetCoord(self, *args)

    def SetX(self, *args) -> "void":
        r"""
        Assigns the given value to the x coordinate of this point.

        Parameters
        ----------
        X: float

        Returns
        -------
        None

        """
        return _gp.gp_Pnt2d_SetX(self, *args)

    def SetXY(self, *args) -> "void":
        r"""
        Assigns the two coordinates of coord to this point.

        Parameters
        ----------
        Coord: gp_XY

        Returns
        -------
        None

        """
        return _gp.gp_Pnt2d_SetXY(self, *args)

    def SetY(self, *args) -> "void":
        r"""
        Assigns the given value to the y coordinate of this point.

        Parameters
        ----------
        Y: float

        Returns
        -------
        None

        """
        return _gp.gp_Pnt2d_SetY(self, *args)

    def SquareDistance(self, *args) -> "Standard_Real":
        r"""
        Computes the square distance between two points.

        Parameters
        ----------
        Other: gp_Pnt2d

        Returns
        -------
        float

        """
        return _gp.gp_Pnt2d_SquareDistance(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        None

        """
        return _gp.gp_Pnt2d_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Pnt2d":
        r"""
        Translates a point in the direction of the vector v. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        gp_Pnt2d

        """
        return _gp.gp_Pnt2d_Transformed(self, *args)

    def Translate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Vec2d

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        None

        """
        return _gp.gp_Pnt2d_Translate(self, *args)

    def Translated(self, *args) -> "gp_Pnt2d":
        r"""
        Translates a point from the point p1 to the point p2.

        Parameters
        ----------
        V: gp_Vec2d

        Returns
        -------
        gp_Pnt2d
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        gp_Pnt2d

        """
        return _gp.gp_Pnt2d_Translated(self, *args)

    def X(self, *args) -> "Standard_Real":
        r"""
        For this point, returns its x coordinate.

        Returns
        -------
        float

        """
        return _gp.gp_Pnt2d_X(self, *args)

    def XY(self, *args) -> "gp_XY const":
        r"""
        For this point, returns its two coordinates as a number pair.

        Returns
        -------
        gp_XY

        """
        return _gp.gp_Pnt2d_XY(self, *args)

    def Y(self, *args) -> "Standard_Real":
        r"""
        For this point, returns its y coordinate.

        Returns
        -------
        float

        """
        return _gp.gp_Pnt2d_Y(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Pnt2d

# Register gp_Pnt2d in _gp:
_gp.gp_Pnt2d_swigregister(gp_Pnt2d)

class gp_Quaternion(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an identity quaternion.

        Returns
        -------
        None
        Creates quaternion directly from component values.

        Parameters
        ----------
        x: float
        y: float
        z: float
        w: float

        Returns
        -------
        None
        Creates copy of another quaternion.

        Parameters
        ----------
        theToCopy: gp_Quaternion

        Returns
        -------
        None
        Creates quaternion representing shortest-arc rotation operator producing vector thevecto from vector thevecfrom.

        Parameters
        ----------
        theVecFrom: gp_Vec
        theVecTo: gp_Vec

        Returns
        -------
        None
        Creates quaternion representing shortest-arc rotation operator producing vector thevecto from vector thevecfrom. additional vector thehelpcrossvec defines preferred direction for rotation and is used when thevecto and thevecfrom are directed oppositely.

        Parameters
        ----------
        theVecFrom: gp_Vec
        theVecTo: gp_Vec
        theHelpCrossVec: gp_Vec

        Returns
        -------
        None
        Creates quaternion representing rotation on angle theangle around vector theaxis.

        Parameters
        ----------
        theAxis: gp_Vec
        theAngle: float

        Returns
        -------
        None
        Creates quaternion from rotation matrix 3*3 (which should be orthonormal skew-symmetric matrix).

        Parameters
        ----------
        theMat: gp_Mat

        Returns
        -------
        None

        """
        _gp.gp_Quaternion_swiginit(self, _gp.new_gp_Quaternion(*args))

    def Add(self, *args) -> "void":
        r"""
        Adds componnets of other quaternion; result is 'rotations mix'.

        Parameters
        ----------
        theOther: gp_Quaternion

        Returns
        -------
        None

        """
        return _gp.gp_Quaternion_Add(self, *args)

    def Added(self, *args) -> "gp_Quaternion":
        r"""
        Makes sum of quaternion components; result is 'rotations mix'.

        Parameters
        ----------
        theOther: gp_Quaternion

        Returns
        -------
        gp_Quaternion

        """
        return _gp.gp_Quaternion_Added(self, *args)

    def Dot(self, *args) -> "Standard_Real":
        r"""
        Computes inner product / scalar product / dot.

        Parameters
        ----------
        theOther: gp_Quaternion

        Returns
        -------
        float

        """
        return _gp.gp_Quaternion_Dot(self, *args)

    def GetEulerAngles(self, *args) -> "void":
        r"""
        Returns euler angles describing current rotation.

        Parameters
        ----------
        theOrder: gp_EulerSequence

        Returns
        -------
        theAlpha: float
        theBeta: float
        theGamma: float

        """
        return _gp.gp_Quaternion_GetEulerAngles(self, *args)

    def GetMatrix(self, *args) -> "gp_Mat":
        r"""
        Returns rotation operation as 3*3 matrix.

        Returns
        -------
        gp_Mat

        """
        return _gp.gp_Quaternion_GetMatrix(self, *args)

    def GetRotationAngle(self, *args) -> "Standard_Real":
        r"""
        Return rotation angle from -pi to pi.

        Returns
        -------
        float

        """
        return _gp.gp_Quaternion_GetRotationAngle(self, *args)

    def GetVectorAndAngle(self, *args) -> "void":
        r"""
        Convert a quaternion to axis+angle representation, preserve the axis direction and angle from -pi to +pi.

        Parameters
        ----------
        theAxis: gp_Vec

        Returns
        -------
        theAngle: float

        """
        return _gp.gp_Quaternion_GetVectorAndAngle(self, *args)

    def Invert(self, *args) -> "void":
        r"""
        Inverts quaternion (both rotation direction and norm).

        Returns
        -------
        None

        """
        return _gp.gp_Quaternion_Invert(self, *args)

    def Inverted(self, *args) -> "gp_Quaternion":
        r"""
        Return inversed quaternion q^-1.

        Returns
        -------
        gp_Quaternion

        """
        return _gp.gp_Quaternion_Inverted(self, *args)

    def IsEqual(self, *args) -> "Standard_Boolean":
        r"""
        Simple equal test without precision.

        Parameters
        ----------
        theOther: gp_Quaternion

        Returns
        -------
        bool

        """
        return _gp.gp_Quaternion_IsEqual(self, *args)

    def Multiplied(self, *args) -> "gp_Quaternion":
        r"""
        Multiply function - work the same as matrices multiplying. qq' = (cross(v,v') + wv' + w'v, ww' - dot(v,v')) result is rotation combination: q' than q (here q=this, q'=theq). notices than: qq' != q'q; qq^-1 = q;.

        Parameters
        ----------
        theOther: gp_Quaternion

        Returns
        -------
        gp_Quaternion

        """
        return _gp.gp_Quaternion_Multiplied(self, *args)

    def Multiply(self, *args) -> "gp_Vec":
        r"""
        Adds rotation by multiplication.

        Parameters
        ----------
        theOther: gp_Quaternion

        Returns
        -------
        None
        Rotates vector by quaternion as rotation operator.

        Parameters
        ----------
        theVec: gp_Vec

        Returns
        -------
        gp_Vec

        """
        return _gp.gp_Quaternion_Multiply(self, *args)

    def Negated(self, *args) -> "gp_Quaternion":
        r"""
        Returns quaternion with all components negated. note that this operation does not affect neither rotation operator defined by quaternion nor its norm.

        Returns
        -------
        gp_Quaternion

        """
        return _gp.gp_Quaternion_Negated(self, *args)

    def Norm(self, *args) -> "Standard_Real":
        r"""
        Returns norm of quaternion.

        Returns
        -------
        float

        """
        return _gp.gp_Quaternion_Norm(self, *args)

    def Normalize(self, *args) -> "void":
        r"""
        Scale quaternion that its norm goes to 1. the appearing of 0 magnitude or near is a error, so we can be sure that can divide by magnitude.

        Returns
        -------
        None

        """
        return _gp.gp_Quaternion_Normalize(self, *args)

    def Normalized(self, *args) -> "gp_Quaternion":
        r"""
        Returns quaternion scaled so that its norm goes to 1.

        Returns
        -------
        gp_Quaternion

        """
        return _gp.gp_Quaternion_Normalized(self, *args)

    def Reverse(self, *args) -> "void":
        r"""
        Reverse direction of rotation (conjugate quaternion).

        Returns
        -------
        None

        """
        return _gp.gp_Quaternion_Reverse(self, *args)

    def Reversed(self, *args) -> "gp_Quaternion":
        r"""
        Return rotation with reversed direction (conjugated quaternion).

        Returns
        -------
        gp_Quaternion

        """
        return _gp.gp_Quaternion_Reversed(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        Scale all components by quaternion by thescale; note that rotation is not changed by this operation (except 0-scaling).

        Parameters
        ----------
        theScale: float

        Returns
        -------
        None

        """
        return _gp.gp_Quaternion_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Quaternion":
        r"""
        Returns scaled quaternion.

        Parameters
        ----------
        theScale: float

        Returns
        -------
        gp_Quaternion

        """
        return _gp.gp_Quaternion_Scaled(self, *args)

    def Set(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        x: float
        y: float
        z: float
        w: float

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        theQuaternion: gp_Quaternion

        Returns
        -------
        None

        """
        return _gp.gp_Quaternion_Set(self, *args)

    def SetEulerAngles(self, *args) -> "void":
        r"""
        Create a unit quaternion representing rotation defined by generalized euler angles.

        Parameters
        ----------
        theOrder: gp_EulerSequence
        theAlpha: float
        theBeta: float
        theGamma: float

        Returns
        -------
        None

        """
        return _gp.gp_Quaternion_SetEulerAngles(self, *args)

    def SetIdent(self, *args) -> "void":
        r"""
        Make identity quaternion (zero-rotation).

        Returns
        -------
        None

        """
        return _gp.gp_Quaternion_SetIdent(self, *args)

    def SetMatrix(self, *args) -> "void":
        r"""
        Create a unit quaternion by rotation matrix matrix must contain only rotation (not scale or shear) //! for numerical stability we find first the greatest component of quaternion and than search others from this one.

        Parameters
        ----------
        theMat: gp_Mat

        Returns
        -------
        None

        """
        return _gp.gp_Quaternion_SetMatrix(self, *args)

    def SetRotation(self, *args) -> "void":
        r"""
        Sets quaternion to shortest-arc rotation producing vector thevecto from vector thevecfrom. if vectors thevecfrom and thevecto are opposite then rotation axis is computed as thevecfrom ^ (1,0,0) or thevecfrom ^ (0,0,1).

        Parameters
        ----------
        theVecFrom: gp_Vec
        theVecTo: gp_Vec

        Returns
        -------
        None
        Sets quaternion to shortest-arc rotation producing vector thevecto from vector thevecfrom. if vectors thevecfrom and thevecto are opposite then rotation axis is computed as thevecfrom ^ thehelpcrossvec.

        Parameters
        ----------
        theVecFrom: gp_Vec
        theVecTo: gp_Vec
        theHelpCrossVec: gp_Vec

        Returns
        -------
        None

        """
        return _gp.gp_Quaternion_SetRotation(self, *args)

    def SetVectorAndAngle(self, *args) -> "void":
        r"""
        Create a unit quaternion from axis+angle representation.

        Parameters
        ----------
        theAxis: gp_Vec
        theAngle: float

        Returns
        -------
        None

        """
        return _gp.gp_Quaternion_SetVectorAndAngle(self, *args)

    def SquareNorm(self, *args) -> "Standard_Real":
        r"""
        Returns square norm of quaternion.

        Returns
        -------
        float

        """
        return _gp.gp_Quaternion_SquareNorm(self, *args)

    def StabilizeLength(self, *args) -> "void":
        r"""
        Stabilize quaternion length within 1 - 1/4. this operation is a lot faster than normalization and preserve length goes to 0 or infinity.

        Returns
        -------
        None

        """
        return _gp.gp_Quaternion_StabilizeLength(self, *args)

    def Subtract(self, *args) -> "void":
        r"""
        Subtracts componnets of other quaternion; result is 'rotations mix'.

        Parameters
        ----------
        theOther: gp_Quaternion

        Returns
        -------
        None

        """
        return _gp.gp_Quaternion_Subtract(self, *args)

    def Subtracted(self, *args) -> "gp_Quaternion":
        r"""
        Makes difference of quaternion components; result is 'rotations mix'.

        Parameters
        ----------
        theOther: gp_Quaternion

        Returns
        -------
        gp_Quaternion

        """
        return _gp.gp_Quaternion_Subtracted(self, *args)

    def W(self, *args) -> "Standard_Real":
        r"""
        No available documentation.

        Returns
        -------
        float

        """
        return _gp.gp_Quaternion_W(self, *args)

    def X(self, *args) -> "Standard_Real":
        r"""
        No available documentation.

        Returns
        -------
        float

        """
        return _gp.gp_Quaternion_X(self, *args)

    def Y(self, *args) -> "Standard_Real":
        r"""
        No available documentation.

        Returns
        -------
        float

        """
        return _gp.gp_Quaternion_Y(self, *args)

    def Z(self, *args) -> "Standard_Real":
        r"""
        No available documentation.

        Returns
        -------
        float

        """
        return _gp.gp_Quaternion_Z(self, *args)

    def __mul__(self, *args) -> "gp_Vec":
        r"""
        No available documentation.

        Parameters
        ----------
        theScale: float

        Returns
        -------
        gp_Quaternion
        No available documentation.

        Parameters
        ----------
        theOther: gp_Quaternion

        Returns
        -------
        gp_Quaternion
        No available documentation.

        Parameters
        ----------
        theVec: gp_Vec

        Returns
        -------
        gp_Vec

        """
        return _gp.gp_Quaternion___mul__(self, *args)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __imul_wrapper__(self, *args) -> "void":
        return _gp.gp_Quaternion___imul_wrapper__(self, *args)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __add__(self, *args) -> "gp_Quaternion":
        r"""
        No available documentation.

        Parameters
        ----------
        theOther: gp_Quaternion

        Returns
        -------
        gp_Quaternion

        """
        return _gp.gp_Quaternion___add__(self, *args)

    def __iadd_wrapper__(self, other: "gp_Quaternion") -> "void":
        return _gp.gp_Quaternion___iadd_wrapper__(self, other)

    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __neg__(self, *args) -> "gp_Quaternion":
        r"""
        No available documentation.

        Returns
        -------
        gp_Quaternion

        """
        return _gp.gp_Quaternion___neg__(self, *args)

    def __sub__(self, *args) -> "gp_Quaternion":
        r"""
        No available documentation.

        Parameters
        ----------
        theOther: gp_Quaternion

        Returns
        -------
        gp_Quaternion

        """
        return _gp.gp_Quaternion___sub__(self, *args)

    def __isub_wrapper__(self, other: "gp_Quaternion") -> "void":
        return _gp.gp_Quaternion___isub_wrapper__(self, other)

    def __isub__(self, right):
        self.__isub_wrapper__(right)
        return self


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Quaternion

# Register gp_Quaternion in _gp:
_gp.gp_Quaternion_swigregister(gp_Quaternion)

class gp_QuaternionNLerp(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Empty constructor,.

        Returns
        -------
        None
        Constructor with initialization.

        Parameters
        ----------
        theQStart: gp_Quaternion
        theQEnd: gp_Quaternion

        Returns
        -------
        None

        """
        _gp.gp_QuaternionNLerp_swiginit(self, _gp.new_gp_QuaternionNLerp(*args))

    def Init(self, *args) -> "void":
        r"""
        Initialize the tool with start and end values.

        Parameters
        ----------
        theQStart: gp_Quaternion
        theQEnd: gp_Quaternion

        Returns
        -------
        None

        """
        return _gp.gp_QuaternionNLerp_Init(self, *args)

    def InitFromUnit(self, *args) -> "void":
        r"""
        Initialize the tool with start and end unit quaternions.

        Parameters
        ----------
        theQStart: gp_Quaternion
        theQEnd: gp_Quaternion

        Returns
        -------
        None

        """
        return _gp.gp_QuaternionNLerp_InitFromUnit(self, *args)

    def Interpolate(self, *args) -> "void":
        r"""
        Compute interpolated quaternion between two quaternions. @param thestart first quaternion @param theend second quaternion @param thet normalized interpolation coefficient within 0..1 range, with 0 pointing to thestart and 1 to theend.

        Parameters
        ----------
        theQStart: gp_Quaternion
        theQEnd: gp_Quaternion
        theT: float

        Returns
        -------
        gp_Quaternion
        Set interpolated quaternion for thet position (from 0.0 to 1.0).

        Parameters
        ----------
        theT: float
        theResultQ: gp_Quaternion

        Returns
        -------
        None

        """
        return _gp.gp_QuaternionNLerp_Interpolate(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_QuaternionNLerp

# Register gp_QuaternionNLerp in _gp:
_gp.gp_QuaternionNLerp_swigregister(gp_QuaternionNLerp)

class gp_QuaternionSLerp(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Empty constructor,.

        Returns
        -------
        None
        Constructor with initialization.

        Parameters
        ----------
        theQStart: gp_Quaternion
        theQEnd: gp_Quaternion

        Returns
        -------
        None

        """
        _gp.gp_QuaternionSLerp_swiginit(self, _gp.new_gp_QuaternionSLerp(*args))

    def Init(self, *args) -> "void":
        r"""
        Initialize the tool with start and end values.

        Parameters
        ----------
        theQStart: gp_Quaternion
        theQEnd: gp_Quaternion

        Returns
        -------
        None

        """
        return _gp.gp_QuaternionSLerp_Init(self, *args)

    def InitFromUnit(self, *args) -> "void":
        r"""
        Initialize the tool with start and end unit quaternions.

        Parameters
        ----------
        theQStart: gp_Quaternion
        theQEnd: gp_Quaternion

        Returns
        -------
        None

        """
        return _gp.gp_QuaternionSLerp_InitFromUnit(self, *args)

    def Interpolate(self, *args) -> "void":
        r"""
        Compute interpolated quaternion between two quaternions. @param thestart first quaternion @param theend second quaternion @param thet normalized interpolation coefficient within 0..1 range, with 0 pointing to thestart and 1 to theend.

        Parameters
        ----------
        theQStart: gp_Quaternion
        theQEnd: gp_Quaternion
        theT: float

        Returns
        -------
        gp_Quaternion
        Set interpolated quaternion for thet position (from 0.0 to 1.0).

        Parameters
        ----------
        theT: float
        theResultQ: gp_Quaternion

        Returns
        -------
        None

        """
        return _gp.gp_QuaternionSLerp_Interpolate(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_QuaternionSLerp

# Register gp_QuaternionSLerp in _gp:
_gp.gp_QuaternionSLerp_swigregister(gp_QuaternionSLerp)

class gp_Sphere(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an indefinite sphere.

        Returns
        -------
        None
        Constructs a sphere with radius radius, centered on the origin of a3. a3 is the local coordinate system of the sphere. warnings : it is not forbidden to create a sphere with null radius. raises constructionerror if radius < 0.0.

        Parameters
        ----------
        A3: gp_Ax3
        Radius: float

        Returns
        -------
        None

        """
        _gp.gp_Sphere_swiginit(self, _gp.new_gp_Sphere(*args))

    def Area(self, *args) -> "Standard_Real":
        r"""
        Computes the aera of the sphere.

        Returns
        -------
        float

        """
        return _gp.gp_Sphere_Area(self, *args)

    def Coefficients(self, *args) -> "void":
        r"""
        Computes the coefficients of the implicit equation of the quadric in the absolute cartesian coordinates system : a1.x**2 + a2.y**2 + a3.z**2 + 2.(b1.x.y + b2.x.z + b3.y.z) + 2.(c1.x + c2.y + c3.z) + d = 0.0.

        Parameters
        ----------

        Returns
        -------
        A1: float
        A2: float
        A3: float
        B1: float
        B2: float
        B3: float
        C1: float
        C2: float
        C3: float
        D: float

        """
        return _gp.gp_Sphere_Coefficients(self, *args)

    def Direct(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the local coordinate system of this sphere is right-handed.

        Returns
        -------
        bool

        """
        return _gp.gp_Sphere_Direct(self, *args)

    def Location(self, *args) -> "gp_Pnt const":
        r"""
        --- purpose ; returns the center of the sphere.

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Sphere_Location(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        None

        """
        return _gp.gp_Sphere_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Sphere":
        r"""
        Performs the symmetrical transformation of a sphere with respect to the point p which is the center of the symmetry.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        gp_Sphere
        Performs the symmetrical transformation of a sphere with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        gp_Sphere
        Performs the symmetrical transformation of a sphere with respect to a plane. the axis placement a2 locates the plane of the of the symmetry : (location, xdirection, ydirection).

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        gp_Sphere

        """
        return _gp.gp_Sphere_Mirrored(self, *args)

    def Position(self, *args) -> "gp_Ax3 const":
        r"""
        Returns the local coordinates system of the sphere.

        Returns
        -------
        gp_Ax3

        """
        return _gp.gp_Sphere_Position(self, *args)

    def Radius(self, *args) -> "Standard_Real":
        r"""
        Returns the radius of the sphere.

        Returns
        -------
        float

        """
        return _gp.gp_Sphere_Radius(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Sphere_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Sphere":
        r"""
        Rotates a sphere. a1 is the axis of the rotation. ang is the angular value of the rotation in radians.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        gp_Sphere

        """
        return _gp.gp_Sphere_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Sphere_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Sphere":
        r"""
        Scales a sphere. s is the scaling value. the absolute value of s is used to scale the sphere.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        gp_Sphere

        """
        return _gp.gp_Sphere_Scaled(self, *args)

    def SetLocation(self, *args) -> "void":
        r"""
        Changes the center of the sphere.

        Parameters
        ----------
        Loc: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Sphere_SetLocation(self, *args)

    def SetPosition(self, *args) -> "void":
        r"""
        Changes the local coordinate system of the sphere.

        Parameters
        ----------
        A3: gp_Ax3

        Returns
        -------
        None

        """
        return _gp.gp_Sphere_SetPosition(self, *args)

    def SetRadius(self, *args) -> "void":
        r"""
        Assigns r the radius of the sphere. warnings : it is not forbidden to create a sphere with null radius. raises constructionerror if r < 0.0.

        Parameters
        ----------
        R: float

        Returns
        -------
        None

        """
        return _gp.gp_Sphere_SetRadius(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        None

        """
        return _gp.gp_Sphere_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Sphere":
        r"""
        Transforms a sphere with the transformation t from class trsf.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        gp_Sphere

        """
        return _gp.gp_Sphere_Transformed(self, *args)

    def Translate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Sphere_Translate(self, *args)

    def Translated(self, *args) -> "gp_Sphere":
        r"""
        Translates a sphere in the direction of the vector v. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        gp_Sphere
        Translates a sphere from the point p1 to the point p2.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        gp_Sphere

        """
        return _gp.gp_Sphere_Translated(self, *args)

    def UReverse(self, *args) -> "void":
        r"""
        Reverses the u parametrization of the sphere reversing the yaxis.

        Returns
        -------
        None

        """
        return _gp.gp_Sphere_UReverse(self, *args)

    def VReverse(self, *args) -> "void":
        r"""
        Reverses the v parametrization of the sphere reversing the zaxis.

        Returns
        -------
        None

        """
        return _gp.gp_Sphere_VReverse(self, *args)

    def Volume(self, *args) -> "Standard_Real":
        r"""
        Computes the volume of the sphere.

        Returns
        -------
        float

        """
        return _gp.gp_Sphere_Volume(self, *args)

    def XAxis(self, *args) -> "gp_Ax1":
        r"""
        Returns the axis x of the sphere.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Sphere_XAxis(self, *args)

    def YAxis(self, *args) -> "gp_Ax1":
        r"""
        Returns the axis y of the sphere.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Sphere_YAxis(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Sphere

# Register gp_Sphere in _gp:
_gp.gp_Sphere_swigregister(gp_Sphere)

class gp_Torus(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an indefinite torus.

        Returns
        -------
        None
        A torus centered on the origin of coordinate system a3, with major radius majorradius and minor radius minorradius, and with the reference plane defined by the origin, the 'x direction' and the 'y direction' of a3. warnings : it is not forbidden to create a torus with majorradius = minorradius = 0.0 raises constructionerror if minorradius < 0.0 or if majorradius < 0.0.

        Parameters
        ----------
        A3: gp_Ax3
        MajorRadius: float
        MinorRadius: float

        Returns
        -------
        None

        """
        _gp.gp_Torus_swiginit(self, _gp.new_gp_Torus(*args))

    def Area(self, *args) -> "Standard_Real":
        r"""
        Computes the area of the torus.

        Returns
        -------
        float

        """
        return _gp.gp_Torus_Area(self, *args)

    def Axis(self, *args) -> "gp_Ax1 const":
        r"""
        Returns the symmetry axis of the torus.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Torus_Axis(self, *args)

    def Coefficients(self, *args) -> "void":
        r"""
        Computes the coefficients of the implicit equation of the surface in the absolute cartesian coordinate system: coef(1) * x^4 + coef(2) * y^4 + coef(3) * z^4 + coef(4) * x^3 * y + coef(5) * x^3 * z + coef(6) * y^3 * x + coef(7) * y^3 * z + coef(8) * z^3 * x + coef(9) * z^3 * y + coef(10) * x^2 * y^2 + coef(11) * x^2 * z^2 + coef(12) * y^2 * z^2 + coef(13) * x^2 * y * z + coef(14) * x * y^2 * z + coef(15) * x * y * z^2 + coef(16) * x^3 + coef(17) * y^3 + coef(18) * z^3 + coef(19) * x^2 * y + coef(20) * x^2 * z + coef(21) * y^2 * x + coef(22) * y^2 * z + coef(23) * z^2 * x + coef(24) * z^2 * y + coef(25) * x * y * z + coef(26) * x^2 + coef(27) * y^2 + coef(28) * z^2 + coef(29) * x * y + coef(30) * x * z + coef(31) * y * z + coef(32) * x + coef(33) * y + coef(34) * z + coef(35) = 0.0 raises dimensionerror if the length of coef is lower than 35.

        Parameters
        ----------
        Coef: TColStd_Array1OfReal

        Returns
        -------
        None

        """
        return _gp.gp_Torus_Coefficients(self, *args)

    def Direct(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the ax3, the local coordinate system of this torus, is right handed.

        Returns
        -------
        bool

        """
        return _gp.gp_Torus_Direct(self, *args)

    def Location(self, *args) -> "gp_Pnt const":
        r"""
        Returns the torus's location.

        Returns
        -------
        gp_Pnt

        """
        return _gp.gp_Torus_Location(self, *args)

    def MajorRadius(self, *args) -> "Standard_Real":
        r"""
        Returns the major radius of the torus.

        Returns
        -------
        float

        """
        return _gp.gp_Torus_MajorRadius(self, *args)

    def MinorRadius(self, *args) -> "Standard_Real":
        r"""
        Returns the minor radius of the torus.

        Returns
        -------
        float

        """
        return _gp.gp_Torus_MinorRadius(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        None

        """
        return _gp.gp_Torus_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Torus":
        r"""
        Performs the symmetrical transformation of a torus with respect to the point p which is the center of the symmetry.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        gp_Torus
        Performs the symmetrical transformation of a torus with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        gp_Torus
        Performs the symmetrical transformation of a torus with respect to a plane. the axis placement a2 locates the plane of the of the symmetry : (location, xdirection, ydirection).

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        gp_Torus

        """
        return _gp.gp_Torus_Mirrored(self, *args)

    def Position(self, *args) -> "gp_Ax3 const":
        r"""
        Returns the local coordinates system of the torus.

        Returns
        -------
        gp_Ax3

        """
        return _gp.gp_Torus_Position(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Torus_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Torus":
        r"""
        Rotates a torus. a1 is the axis of the rotation. ang is the angular value of the rotation in radians.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        gp_Torus

        """
        return _gp.gp_Torus_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Torus_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Torus":
        r"""
        Scales a torus. s is the scaling value. the absolute value of s is used to scale the torus.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        gp_Torus

        """
        return _gp.gp_Torus_Scaled(self, *args)

    def SetAxis(self, *args) -> "void":
        r"""
        Modifies this torus, by redefining its local coordinate system so that: - its origin and 'main direction' become those of the axis a1 (the 'x direction' and 'y direction' are then recomputed). raises constructionerror if the direction of a1 is parallel to the 'xdirection' of the coordinate system of the toroidal surface.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None

        """
        return _gp.gp_Torus_SetAxis(self, *args)

    def SetLocation(self, *args) -> "void":
        r"""
        Changes the location of the torus.

        Parameters
        ----------
        Loc: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Torus_SetLocation(self, *args)

    def SetMajorRadius(self, *args) -> "void":
        r"""
        Assigns value to the major radius of this torus. raises constructionerror if majorradius - minorradius <= resolution().

        Parameters
        ----------
        MajorRadius: float

        Returns
        -------
        None

        """
        return _gp.gp_Torus_SetMajorRadius(self, *args)

    def SetMinorRadius(self, *args) -> "void":
        r"""
        Assigns value to the minor radius of this torus. raises constructionerror if minorradius < 0.0 or if majorradius - minorradius <= resolution from gp.

        Parameters
        ----------
        MinorRadius: float

        Returns
        -------
        None

        """
        return _gp.gp_Torus_SetMinorRadius(self, *args)

    def SetPosition(self, *args) -> "void":
        r"""
        Changes the local coordinate system of the surface.

        Parameters
        ----------
        A3: gp_Ax3

        Returns
        -------
        None

        """
        return _gp.gp_Torus_SetPosition(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        None

        """
        return _gp.gp_Torus_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Torus":
        r"""
        Transforms a torus with the transformation t from class trsf.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        gp_Torus

        """
        return _gp.gp_Torus_Transformed(self, *args)

    def Translate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Torus_Translate(self, *args)

    def Translated(self, *args) -> "gp_Torus":
        r"""
        Translates a torus in the direction of the vector v. the magnitude of the translation is the vector's magnitude.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        gp_Torus
        Translates a torus from the point p1 to the point p2.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        gp_Torus

        """
        return _gp.gp_Torus_Translated(self, *args)

    def UReverse(self, *args) -> "void":
        r"""
        Reverses the u parametrization of the torus reversing the yaxis.

        Returns
        -------
        None

        """
        return _gp.gp_Torus_UReverse(self, *args)

    def VReverse(self, *args) -> "void":
        r"""
        Reverses the v parametrization of the torus reversing the zaxis.

        Returns
        -------
        None

        """
        return _gp.gp_Torus_VReverse(self, *args)

    def Volume(self, *args) -> "Standard_Real":
        r"""
        Computes the volume of the torus.

        Returns
        -------
        float

        """
        return _gp.gp_Torus_Volume(self, *args)

    def XAxis(self, *args) -> "gp_Ax1":
        r"""
        Returns the axis x of the torus.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Torus_XAxis(self, *args)

    def YAxis(self, *args) -> "gp_Ax1":
        r"""
        Returns the axis y of the torus.

        Returns
        -------
        gp_Ax1

        """
        return _gp.gp_Torus_YAxis(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Torus

# Register gp_Torus in _gp:
_gp.gp_Torus_swigregister(gp_Torus)

class gp_Trsf(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Returns the identity transformation.

        Returns
        -------
        None
        Creates a 3d transformation from the 2d transformation t. the resulting transformation has a homogeneous vectorial part, v3, and a translation part, t3, built from t: a11 a12 0 a13 v3 = a21 a22 0 t3 = a23 0 0 1. 0 it also has the same scale factor as t. this guarantees (by projection) that the transformation which would be performed by t in a plane (2d space) is performed by the resulting transformation in the xoy plane of the 3d space, (i.e. in the plane defined by the origin (0., 0., 0.) and the vectors dx (1., 0., 0.), and dy (0., 1., 0.)). the scale factor is applied to the entire space.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        None

        """
        _gp.gp_Trsf_swiginit(self, _gp.new_gp_Trsf(*args))

    def DumpJsonToString(self, depth: "int"=-1) -> "std::string":
        r"""DumpJsonToString(gp_Trsf self, int depth=-1) -> std::string"""
        return _gp.gp_Trsf_DumpJsonToString(self, depth)

    def Form(self, *args) -> "gp_TrsfForm":
        r"""
        Returns the nature of the transformation. it can be: an identity transformation, a rotation, a translation, a mirror transformation (relative to a point, an axis or a plane), a scaling transformation, or a compound transformation.

        Returns
        -------
        gp_TrsfForm

        """
        return _gp.gp_Trsf_Form(self, *args)

    def GetRotation(self, *args) -> "gp_Quaternion":
        r"""
        Returns the boolean true if there is non-zero rotation. in the presence of rotation, the output parameters store the axis and the angle of rotation. the method always returns positive value 'theangle', i.e., 0. < theangle <= pi. note that this rotation is defined only by the vectorial part of the transformation; generally you would need to check also the translational part to obtain the axis (gp_ax1) of rotation.

        Parameters
        ----------
        theAxis: gp_XYZ

        Returns
        -------
        theAngle: float
        Returns quaternion representing rotational part of the transformation.

        Returns
        -------
        gp_Quaternion

        """
        return _gp.gp_Trsf_GetRotation(self, *args)

    def HVectorialPart(self, *args) -> "gp_Mat const":
        r"""
        Computes the homogeneous vectorial part of the transformation. it is a 3*3 matrix which doesn't include the scale factor. in other words, the vectorial part of this transformation is equal to its homogeneous vectorial part, multiplied by the scale factor. the coefficients of this matrix must be multiplied by the scale factor to obtain the coefficients of the transformation.

        Returns
        -------
        gp_Mat

        """
        return _gp.gp_Trsf_HVectorialPart(self, *args)

    def Invert(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _gp.gp_Trsf_Invert(self, *args)

    def Inverted(self, *args) -> "gp_Trsf":
        r"""
        Computes the reverse transformation raises an exception if the matrix of the transformation is not inversible, it means that the scale factor is lower or equal to resolution from package gp. computes the transformation composed with t and <self>. in a c++ implementation you can also write tcomposed = <self> * t. example : trsf t1, t2, tcomp; ............... tcomp = t2.multiplied(t1); // or (tcomp = t2 * t1) pnt p1(10.,3.,4.); pnt p2 = p1.transformed(tcomp); //using tcomp pnt p3 = p1.transformed(t1); //using t1 then t2 p3.transform(t2); // p3 = p2 !!!.

        Returns
        -------
        gp_Trsf

        """
        return _gp.gp_Trsf_Inverted(self, *args)

    def IsNegative(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the determinant of the vectorial part of this transformation is negative.

        Returns
        -------
        bool

        """
        return _gp.gp_Trsf_IsNegative(self, *args)

    def Multiplied(self, *args) -> "gp_Trsf":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        gp_Trsf

        """
        return _gp.gp_Trsf_Multiplied(self, *args)

    def Multiply(self, *args) -> "void":
        r"""
        Computes the transformation composed with <self> and t. <self> = <self> * t.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        None

        """
        return _gp.gp_Trsf_Multiply(self, *args)

    def Power(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        N: int

        Returns
        -------
        None

        """
        return _gp.gp_Trsf_Power(self, *args)

    def Powered(self, *args) -> "gp_Trsf":
        r"""
        Computes the following composition of transformations <self> * <self> * .......* <self>, n time. if n = 0 <self> = identity if n < 0 <self> = <self>.inverse() *...........* <self>.inverse(). //! raises if n < 0 and if the matrix of the transformation not inversible.

        Parameters
        ----------
        N: int

        Returns
        -------
        gp_Trsf

        """
        return _gp.gp_Trsf_Powered(self, *args)

    def PreMultiply(self, *args) -> "void":
        r"""
        Computes the transformation composed with <self> and t. <self> = t * <self>.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        None

        """
        return _gp.gp_Trsf_PreMultiply(self, *args)

    def ScaleFactor(self, *args) -> "Standard_Real":
        r"""
        Returns the scale factor.

        Returns
        -------
        float

        """
        return _gp.gp_Trsf_ScaleFactor(self, *args)

    def SetDisplacement(self, *args) -> "void":
        r"""
        Modifies this transformation so that it transforms the coordinate system defined by fromsystem1 into the one defined by tosystem2. after this modification, this transformation transforms: - the origin of fromsystem1 into the origin of tosystem2, - the 'x direction' of fromsystem1 into the 'x direction' of tosystem2, - the 'y direction' of fromsystem1 into the 'y direction' of tosystem2, and - the 'main direction' of fromsystem1 into the 'main direction' of tosystem2. warning when you know the coordinates of a point in one coordinate system and you want to express these coordinates in another one, do not use the transformation resulting from this function. use the transformation that results from settransformation instead. setdisplacement and settransformation create related transformations: the vectorial part of one is the inverse of the vectorial part of the other.

        Parameters
        ----------
        FromSystem1: gp_Ax3
        ToSystem2: gp_Ax3

        Returns
        -------
        None

        """
        return _gp.gp_Trsf_SetDisplacement(self, *args)

    def SetForm(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_TrsfForm

        Returns
        -------
        None

        """
        return _gp.gp_Trsf_SetForm(self, *args)

    def SetMirror(self, *args) -> "void":
        r"""
        Makes the transformation into a symmetrical transformation. p is the center of the symmetry.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None
        Makes the transformation into a symmetrical transformation. a1 is the center of the axial symmetry.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None
        Makes the transformation into a symmetrical transformation. a2 is the center of the planar symmetry and defines the plane of symmetry by its origin, 'x direction' and 'y direction'.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        None

        """
        return _gp.gp_Trsf_SetMirror(self, *args)

    def SetRotation(self, *args) -> "void":
        r"""
        Changes the transformation into a rotation. a1 is the rotation axis and ang is the angular value of the rotation in radians.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        None
        Changes the transformation into a rotation defined by quaternion. note that rotation is performed around origin, i.e. no translation is involved.

        Parameters
        ----------
        R: gp_Quaternion

        Returns
        -------
        None

        """
        return _gp.gp_Trsf_SetRotation(self, *args)

    def SetScale(self, *args) -> "void":
        r"""
        Changes the transformation into a scale. p is the center of the scale and s is the scaling value. raises constructionerror if <s> is null.

        Parameters
        ----------
        P: gp_Pnt
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Trsf_SetScale(self, *args)

    def SetScaleFactor(self, *args) -> "void":
        r"""
        Modifies the scale factor. raises constructionerror if s is null.

        Parameters
        ----------
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Trsf_SetScaleFactor(self, *args)

    def SetTransformation(self, *args) -> "void":
        r"""
        Modifies this transformation so that it transforms the coordinates of any point, (x, y, z), relative to a source coordinate system into the coordinates (x', y', z') which are relative to a target coordinate system, but which represent the same point the transformation is from the coordinate system 'fromsystem1' to the coordinate system 'tosystem2'. example : in a c++ implementation : real x1, y1, z1; // are the coordinates of a point in the // local system fromsystem1 real x2, y2, z2; // are the coordinates of a point in the // local system tosystem2 gp_pnt p1 (x1, y1, z1) trsf t; t.settransformation (fromsystem1, tosystem2); gp_pnt p2 = p1.transformed (t); p2.coord (x2, y2, z2);.

        Parameters
        ----------
        FromSystem1: gp_Ax3
        ToSystem2: gp_Ax3

        Returns
        -------
        None
        Modifies this transformation so that it transforms the coordinates of any point, (x, y, z), relative to a source coordinate system into the coordinates (x', y', z') which are relative to a target coordinate system, but which represent the same point the transformation is from the default coordinate system {p(0.,0.,0.), vx (1.,0.,0.), vy (0.,1.,0.), vz (0., 0. ,1.) } to the local coordinate system defined with the ax3 tosystem. use in the same way as the previous method. fromsystem1 is defaulted to the absolute coordinate system.

        Parameters
        ----------
        ToSystem: gp_Ax3

        Returns
        -------
        None
        Sets transformation by directly specified rotation and translation.

        Parameters
        ----------
        R: gp_Quaternion
        T: gp_Vec

        Returns
        -------
        None

        """
        return _gp.gp_Trsf_SetTransformation(self, *args)

    def SetTranslation(self, *args) -> "void":
        r"""
        Changes the transformation into a translation. v is the vector of the translation.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        None
        Makes the transformation into a translation where the translation vector is the vector (p1, p2) defined from point p1 to point p2.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        return _gp.gp_Trsf_SetTranslation(self, *args)

    def SetTranslationPart(self, *args) -> "void":
        r"""
        Replaces the translation vector with the vector v.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        None

        """
        return _gp.gp_Trsf_SetTranslationPart(self, *args)

    def SetValues(self, *args) -> "void":
        r"""
        Sets the coefficients of the transformation. the transformation of the point x,y,z is the point x',y',z' with : //! x' = a11 x + a12 y + a13 z + a14 y' = a21 x + a22 y + a23 z + a24 z' = a31 x + a32 y + a33 z + a34 //! the method value(i,j) will return aij. raises constructionerror if the determinant of the aij is null. the matrix is orthogonalized before future using.

        Parameters
        ----------
        a11: float
        a12: float
        a13: float
        a14: float
        a21: float
        a22: float
        a23: float
        a24: float
        a31: float
        a32: float
        a33: float
        a34: float

        Returns
        -------
        None

        """
        return _gp.gp_Trsf_SetValues(self, *args)

    def Transforms(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------

        Returns
        -------
        X: float
        Y: float
        Z: float
        Transformation of a triplet xyz with a trsf.

        Parameters
        ----------
        Coord: gp_XYZ

        Returns
        -------
        None

        """
        return _gp.gp_Trsf_Transforms(self, *args)

    def TranslationPart(self, *args) -> "gp_XYZ const":
        r"""
        Returns the translation part of the transformation's matrix.

        Returns
        -------
        gp_XYZ

        """
        return _gp.gp_Trsf_TranslationPart(self, *args)

    def Value(self, *args) -> "Standard_Real":
        r"""
        Returns the coefficients of the transformation's matrix. it is a 3 rows * 4 columns matrix. this coefficient includes the scale factor. raises outofranged if row < 1 or row > 3 or col < 1 or col > 4.

        Parameters
        ----------
        Row: int
        Col: int

        Returns
        -------
        float

        """
        return _gp.gp_Trsf_Value(self, *args)

    def VectorialPart(self, *args) -> "gp_Mat":
        r"""
        Returns the vectorial part of the transformation. it is a 3*3 matrix which includes the scale factor.

        Returns
        -------
        gp_Mat

        """
        return _gp.gp_Trsf_VectorialPart(self, *args)

    def __mul__(self, *args) -> "gp_Trsf":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        gp_Trsf

        """
        return _gp.gp_Trsf___mul__(self, *args)

    def __imul_wrapper__(self, other: "gp_Trsf") -> "void":
        r"""__imul_wrapper__(gp_Trsf self, gp_Trsf other)"""
        return _gp.gp_Trsf___imul_wrapper__(self, other)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Trsf

# Register gp_Trsf in _gp:
_gp.gp_Trsf_swigregister(gp_Trsf)

class gp_Trsf2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Returns identity transformation.

        Returns
        -------
        None
        Creates a 2d transformation in the xy plane from a 3d transformation .

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        None

        """
        _gp.gp_Trsf2d_swiginit(self, _gp.new_gp_Trsf2d(*args))

    def Form(self, *args) -> "gp_TrsfForm":
        r"""
        Returns the nature of the transformation. it can be an identity transformation, a rotation, a translation, a mirror (relative to a point or an axis), a scaling transformation, or a compound transformation.

        Returns
        -------
        gp_TrsfForm

        """
        return _gp.gp_Trsf2d_Form(self, *args)

    def HVectorialPart(self, *args) -> "gp_Mat2d const":
        r"""
        Returns the homogeneous vectorial part of the transformation. it is a 2*2 matrix which doesn't include the scale factor. the coefficients of this matrix must be multiplied by the scale factor to obtain the coefficients of the transformation.

        Returns
        -------
        gp_Mat2d

        """
        return _gp.gp_Trsf2d_HVectorialPart(self, *args)

    def Invert(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _gp.gp_Trsf2d_Invert(self, *args)

    def Inverted(self, *args) -> "gp_Trsf2d":
        r"""
        Computes the reverse transformation. raises an exception if the matrix of the transformation is not inversible, it means that the scale factor is lower or equal to resolution from package gp.

        Returns
        -------
        gp_Trsf2d

        """
        return _gp.gp_Trsf2d_Inverted(self, *args)

    def IsNegative(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the determinant of the vectorial part of this transformation is negative..

        Returns
        -------
        bool

        """
        return _gp.gp_Trsf2d_IsNegative(self, *args)

    def Multiplied(self, *args) -> "gp_Trsf2d":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        gp_Trsf2d

        """
        return _gp.gp_Trsf2d_Multiplied(self, *args)

    def Multiply(self, *args) -> "void":
        r"""
        Computes the transformation composed from <self> and t. <self> = <self> * t.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        None

        """
        return _gp.gp_Trsf2d_Multiply(self, *args)

    def Power(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        N: int

        Returns
        -------
        None

        """
        return _gp.gp_Trsf2d_Power(self, *args)

    def Powered(self, *args) -> "gp_Trsf2d":
        r"""
        Computes the following composition of transformations <self> * <self> * .......* <self>, n time. if n = 0 <self> = identity if n < 0 <self> = <self>.inverse() *...........* <self>.inverse(). //! raises if n < 0 and if the matrix of the transformation not inversible.

        Parameters
        ----------
        N: int

        Returns
        -------
        gp_Trsf2d

        """
        return _gp.gp_Trsf2d_Powered(self, *args)

    def PreMultiply(self, *args) -> "void":
        r"""
        Computes the transformation composed from <self> and t. <self> = t * <self>.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        None

        """
        return _gp.gp_Trsf2d_PreMultiply(self, *args)

    def RotationPart(self, *args) -> "Standard_Real":
        r"""
        Returns the angle corresponding to the rotational component of the transformation matrix (operation opposite to setrotation()).

        Returns
        -------
        float

        """
        return _gp.gp_Trsf2d_RotationPart(self, *args)

    def ScaleFactor(self, *args) -> "Standard_Real":
        r"""
        Returns the scale factor.

        Returns
        -------
        float

        """
        return _gp.gp_Trsf2d_ScaleFactor(self, *args)

    def SetMirror(self, *args) -> "void":
        r"""
        Changes the transformation into a symmetrical transformation. p is the center of the symmetry.

        Parameters
        ----------
        P: gp_Pnt2d

        Returns
        -------
        None
        Changes the transformation into a symmetrical transformation. a is the center of the axial symmetry.

        Parameters
        ----------
        A: gp_Ax2d

        Returns
        -------
        None

        """
        return _gp.gp_Trsf2d_SetMirror(self, *args)

    def SetRotation(self, *args) -> "void":
        r"""
        Changes the transformation into a rotation. p is the rotation's center and ang is the angular value of the rotation in radian.

        Parameters
        ----------
        P: gp_Pnt2d
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Trsf2d_SetRotation(self, *args)

    def SetScale(self, *args) -> "void":
        r"""
        Changes the transformation into a scale. p is the center of the scale and s is the scaling value.

        Parameters
        ----------
        P: gp_Pnt2d
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Trsf2d_SetScale(self, *args)

    def SetScaleFactor(self, *args) -> "void":
        r"""
        Modifies the scale factor.

        Parameters
        ----------
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Trsf2d_SetScaleFactor(self, *args)

    def SetTransformation(self, *args) -> "void":
        r"""
        Changes a transformation allowing passage from the coordinate system 'fromsystem1' to the coordinate system 'tosystem2'.

        Parameters
        ----------
        FromSystem1: gp_Ax2d
        ToSystem2: gp_Ax2d

        Returns
        -------
        None
        Changes the transformation allowing passage from the basic coordinate system {p(0.,0.,0.), vx (1.,0.,0.), vy (0.,1.,0.)} to the local coordinate system defined with the ax2d tosystem.

        Parameters
        ----------
        ToSystem: gp_Ax2d

        Returns
        -------
        None

        """
        return _gp.gp_Trsf2d_SetTransformation(self, *args)

    def SetTranslation(self, *args) -> "void":
        r"""
        Changes the transformation into a translation. v is the vector of the translation.

        Parameters
        ----------
        V: gp_Vec2d

        Returns
        -------
        None
        Makes the transformation into a translation from the point p1 to the point p2.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        None

        """
        return _gp.gp_Trsf2d_SetTranslation(self, *args)

    def SetTranslationPart(self, *args) -> "void":
        r"""
        Replaces the translation vector with v.

        Parameters
        ----------
        V: gp_Vec2d

        Returns
        -------
        None

        """
        return _gp.gp_Trsf2d_SetTranslationPart(self, *args)

    def SetValues(self, *args) -> "void":
        r"""
        Sets the coefficients of the transformation. the transformation of the point x,y is the point x',y' with : //! x' = a11 x + a12 y + a13 y' = a21 x + a22 y + a23 //! the method value(i,j) will return aij. raises constructionerror if the determinant of the aij is null. if the matrix as not a uniform scale it will be orthogonalized before future using.

        Parameters
        ----------
        a11: float
        a12: float
        a13: float
        a21: float
        a22: float
        a23: float

        Returns
        -------
        None

        """
        return _gp.gp_Trsf2d_SetValues(self, *args)

    def Transforms(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------

        Returns
        -------
        X: float
        Y: float
        Transforms a doublet xy with a trsf2d.

        Parameters
        ----------
        Coord: gp_XY

        Returns
        -------
        None

        """
        return _gp.gp_Trsf2d_Transforms(self, *args)

    def TranslationPart(self, *args) -> "gp_XY const":
        r"""
        Returns the translation part of the transformation's matrix.

        Returns
        -------
        gp_XY

        """
        return _gp.gp_Trsf2d_TranslationPart(self, *args)

    def Value(self, *args) -> "Standard_Real":
        r"""
        Returns the coefficients of the transformation's matrix. it is a 2 rows * 3 columns matrix. raises outofrange if row < 1 or row > 2 or col < 1 or col > 3.

        Parameters
        ----------
        Row: int
        Col: int

        Returns
        -------
        float

        """
        return _gp.gp_Trsf2d_Value(self, *args)

    def VectorialPart(self, *args) -> "gp_Mat2d":
        r"""
        Returns the vectorial part of the transformation. it is a 2*2 matrix which includes the scale factor.

        Returns
        -------
        gp_Mat2d

        """
        return _gp.gp_Trsf2d_VectorialPart(self, *args)

    def __mul__(self, *args) -> "gp_Trsf2d":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        gp_Trsf2d

        """
        return _gp.gp_Trsf2d___mul__(self, *args)

    def __imul_wrapper__(self, other: "gp_Trsf2d") -> "void":
        return _gp.gp_Trsf2d___imul_wrapper__(self, other)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Trsf2d

# Register gp_Trsf2d in _gp:
_gp.gp_Trsf2d_swigregister(gp_Trsf2d)

class gp_Vec(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a zero vector.

        Returns
        -------
        None
        Creates a unitary vector from a direction v.

        Parameters
        ----------
        V: gp_Dir

        Returns
        -------
        None
        Creates a vector with a triplet of coordinates.

        Parameters
        ----------
        Coord: gp_XYZ

        Returns
        -------
        None
        Creates a point with its three cartesian coordinates.

        Parameters
        ----------
        Xv: float
        Yv: float
        Zv: float

        Returns
        -------
        None
        Creates a vector from two points. the length of the vector is the distance between p1 and p2.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        _gp.gp_Vec_swiginit(self, _gp.new_gp_Vec(*args))

    def Add(self, *args) -> "void":
        r"""
        Adds two vectors.

        Parameters
        ----------
        Other: gp_Vec

        Returns
        -------
        None

        """
        return _gp.gp_Vec_Add(self, *args)

    def Added(self, *args) -> "gp_Vec":
        r"""
        Adds two vectors.

        Parameters
        ----------
        Other: gp_Vec

        Returns
        -------
        gp_Vec

        """
        return _gp.gp_Vec_Added(self, *args)

    def Angle(self, *args) -> "Standard_Real":
        r"""
        Computes the angular value between <self> and <other> returns the angle value between 0 and pi in radian. raises vectorwithnullmagnitude if <self>.magnitude() <= resolution from gp or other.magnitude() <= resolution because the angular value is indefinite if one of the vectors has a null magnitude.

        Parameters
        ----------
        Other: gp_Vec

        Returns
        -------
        float

        """
        return _gp.gp_Vec_Angle(self, *args)

    def AngleWithRef(self, *args) -> "Standard_Real":
        r"""
        Computes the angle, in radians, between this vector and vector other. the result is a value between -pi and pi. for this, vref defines the positive sense of rotation: the angular value is positive, if the cross product this ^ other has the same orientation as vref relative to the plane defined by the vectors this and other. otherwise, the angular value is negative. exceptions gp_vectorwithnullmagnitude if the magnitude of this vector, the vector other, or the vector vref is less than or equal to gp::resolution(). standard_domainerror if this vector, the vector other, and the vector vref are coplanar, unless this vector and the vector other are parallel.

        Parameters
        ----------
        Other: gp_Vec
        VRef: gp_Vec

        Returns
        -------
        float

        """
        return _gp.gp_Vec_AngleWithRef(self, *args)

    def Coord(self, *args) -> "void":
        r"""
        Returns the coordinate of range index : index = 1 => x is returned index = 2 => y is returned index = 3 => z is returned raised if index != {1, 2, 3}.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float
        For this vector returns its three coordinates xv, yv, and zvinline.

        Parameters
        ----------

        Returns
        -------
        Xv: float
        Yv: float
        Zv: float

        """
        return _gp.gp_Vec_Coord(self, *args)

    def Cross(self, *args) -> "void":
        r"""
        Computes the cross product between two vectors.

        Parameters
        ----------
        Right: gp_Vec

        Returns
        -------
        None

        """
        return _gp.gp_Vec_Cross(self, *args)

    def CrossCross(self, *args) -> "void":
        r"""
        Computes the triple vector product. <self> ^= (v1 ^ v2).

        Parameters
        ----------
        V1: gp_Vec
        V2: gp_Vec

        Returns
        -------
        None

        """
        return _gp.gp_Vec_CrossCross(self, *args)

    def CrossCrossed(self, *args) -> "gp_Vec":
        r"""
        Computes the triple vector product. <self> ^ (v1 ^ v2).

        Parameters
        ----------
        V1: gp_Vec
        V2: gp_Vec

        Returns
        -------
        gp_Vec

        """
        return _gp.gp_Vec_CrossCrossed(self, *args)

    def CrossMagnitude(self, *args) -> "Standard_Real":
        r"""
        Computes the magnitude of the cross product between <self> and right. returns || <self> ^ right ||.

        Parameters
        ----------
        Right: gp_Vec

        Returns
        -------
        float

        """
        return _gp.gp_Vec_CrossMagnitude(self, *args)

    def CrossSquareMagnitude(self, *args) -> "Standard_Real":
        r"""
        Computes the square magnitude of the cross product between <self> and right. returns || <self> ^ right ||**2.

        Parameters
        ----------
        Right: gp_Vec

        Returns
        -------
        float

        """
        return _gp.gp_Vec_CrossSquareMagnitude(self, *args)

    def Crossed(self, *args) -> "gp_Vec":
        r"""
        Computes the cross product between two vectors.

        Parameters
        ----------
        Right: gp_Vec

        Returns
        -------
        gp_Vec

        """
        return _gp.gp_Vec_Crossed(self, *args)

    def Divide(self, *args) -> "void":
        r"""
        Divides a vector by a scalar.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        None

        """
        return _gp.gp_Vec_Divide(self, *args)

    def Divided(self, *args) -> "gp_Vec":
        r"""
        Divides a vector by a scalar.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        gp_Vec

        """
        return _gp.gp_Vec_Divided(self, *args)

    def Dot(self, *args) -> "Standard_Real":
        r"""
        Computes the scalar product.

        Parameters
        ----------
        Other: gp_Vec

        Returns
        -------
        float

        """
        return _gp.gp_Vec_Dot(self, *args)

    def DotCross(self, *args) -> "Standard_Real":
        r"""
        Computes the triple scalar product <self> * (v1 ^ v2).

        Parameters
        ----------
        V1: gp_Vec
        V2: gp_Vec

        Returns
        -------
        float

        """
        return _gp.gp_Vec_DotCross(self, *args)

    def IsEqual(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the two vectors have the same magnitude value and the same direction. the precision values are lineartolerance for the magnitude and angulartolerance for the direction.

        Parameters
        ----------
        Other: gp_Vec
        LinearTolerance: float
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Vec_IsEqual(self, *args)

    def IsNormal(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if abs(<self>.angle(other) - pi/2.) <= angulartolerance raises vectorwithnullmagnitude if <self>.magnitude() <= resolution or other.magnitude() <= resolution from gp.

        Parameters
        ----------
        Other: gp_Vec
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Vec_IsNormal(self, *args)

    def IsOpposite(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if pi - <self>.angle(other) <= angulartolerance raises vectorwithnullmagnitude if <self>.magnitude() <= resolution or other.magnitude() <= resolution from gp.

        Parameters
        ----------
        Other: gp_Vec
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Vec_IsOpposite(self, *args)

    def IsParallel(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if angle(<self>, other) <= angulartolerance or pi - angle(<self>, other) <= angulartolerance this definition means that two parallel vectors cannot define a plane but two vectors with opposite directions are considered as parallel. raises vectorwithnullmagnitude if <self>.magnitude() <= resolution or other.magnitude() <= resolution from gp.

        Parameters
        ----------
        Other: gp_Vec
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Vec_IsParallel(self, *args)

    def Magnitude(self, *args) -> "Standard_Real":
        r"""
        Computes the magnitude of this vector.

        Returns
        -------
        float

        """
        return _gp.gp_Vec_Magnitude(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        None

        """
        return _gp.gp_Vec_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Vec":
        r"""
        Performs the symmetrical transformation of a vector with respect to the vector v which is the center of the symmetry.

        Parameters
        ----------
        V: gp_Vec

        Returns
        -------
        gp_Vec
        Performs the symmetrical transformation of a vector with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        A1: gp_Ax1

        Returns
        -------
        gp_Vec
        Performs the symmetrical transformation of a vector with respect to a plane. the axis placement a2 locates the plane of the symmetry : (location, xdirection, ydirection).

        Parameters
        ----------
        A2: gp_Ax2

        Returns
        -------
        gp_Vec

        """
        return _gp.gp_Vec_Mirrored(self, *args)

    def Multiplied(self, *args) -> "gp_Vec":
        r"""
        Multiplies a vector by a scalar.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        gp_Vec

        """
        return _gp.gp_Vec_Multiplied(self, *args)

    def Multiply(self, *args) -> "void":
        r"""
        Multiplies a vector by a scalar.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        None

        """
        return _gp.gp_Vec_Multiply(self, *args)

    def Normalize(self, *args) -> "void":
        r"""
        Normalizes a vector raises an exception if the magnitude of the vector is lower or equal to resolution from gp.

        Returns
        -------
        None

        """
        return _gp.gp_Vec_Normalize(self, *args)

    def Normalized(self, *args) -> "gp_Vec":
        r"""
        Normalizes a vector raises an exception if the magnitude of the vector is lower or equal to resolution from gp.

        Returns
        -------
        gp_Vec

        """
        return _gp.gp_Vec_Normalized(self, *args)

    def Reverse(self, *args) -> "void":
        r"""
        Reverses the direction of a vector.

        Returns
        -------
        None

        """
        return _gp.gp_Vec_Reverse(self, *args)

    def Reversed(self, *args) -> "gp_Vec":
        r"""
        Reverses the direction of a vector.

        Returns
        -------
        gp_Vec

        """
        return _gp.gp_Vec_Reversed(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Vec_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Vec":
        r"""
        Rotates a vector. a1 is the axis of the rotation. ang is the angular value of the rotation in radians.

        Parameters
        ----------
        A1: gp_Ax1
        Ang: float

        Returns
        -------
        gp_Vec

        """
        return _gp.gp_Vec_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Vec_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Vec":
        r"""
        Scales a vector. s is the scaling value.

        Parameters
        ----------
        S: float

        Returns
        -------
        gp_Vec

        """
        return _gp.gp_Vec_Scaled(self, *args)

    def SetCoord(self, *args) -> "void":
        r"""
        Changes the coordinate of range index index = 1 => x is modified index = 2 => y is modified index = 3 => z is modified raised if index != {1, 2, 3}.

        Parameters
        ----------
        Index: int
        Xi: float

        Returns
        -------
        None
        For this vector, assigns - the values xv, yv and zv to its three coordinates.

        Parameters
        ----------
        Xv: float
        Yv: float
        Zv: float

        Returns
        -------
        None

        """
        return _gp.gp_Vec_SetCoord(self, *args)

    def SetLinearForm(self, *args) -> "void":
        r"""
        <self> is set to the following linear form : a1 * v1 + a2 * v2 + a3 * v3 + v4.

        Parameters
        ----------
        A1: float
        V1: gp_Vec
        A2: float
        V2: gp_Vec
        A3: float
        V3: gp_Vec
        V4: gp_Vec

        Returns
        -------
        None
        <self> is set to the following linear form : a1 * v1 + a2 * v2 + a3 * v3.

        Parameters
        ----------
        A1: float
        V1: gp_Vec
        A2: float
        V2: gp_Vec
        A3: float
        V3: gp_Vec

        Returns
        -------
        None
        <self> is set to the following linear form : a1 * v1 + a2 * v2 + v3.

        Parameters
        ----------
        A1: float
        V1: gp_Vec
        A2: float
        V2: gp_Vec
        V3: gp_Vec

        Returns
        -------
        None
        <self> is set to the following linear form : a1 * v1 + a2 * v2.

        Parameters
        ----------
        A1: float
        V1: gp_Vec
        A2: float
        V2: gp_Vec

        Returns
        -------
        None
        <self> is set to the following linear form : a1 * v1 + v2.

        Parameters
        ----------
        A1: float
        V1: gp_Vec
        V2: gp_Vec

        Returns
        -------
        None
        <self> is set to the following linear form : v1 + v2.

        Parameters
        ----------
        V1: gp_Vec
        V2: gp_Vec

        Returns
        -------
        None

        """
        return _gp.gp_Vec_SetLinearForm(self, *args)

    def SetX(self, *args) -> "void":
        r"""
        Assigns the given value to the x coordinate of this vector.

        Parameters
        ----------
        X: float

        Returns
        -------
        None

        """
        return _gp.gp_Vec_SetX(self, *args)

    def SetXYZ(self, *args) -> "void":
        r"""
        Assigns the three coordinates of coord to this vector.

        Parameters
        ----------
        Coord: gp_XYZ

        Returns
        -------
        None

        """
        return _gp.gp_Vec_SetXYZ(self, *args)

    def SetY(self, *args) -> "void":
        r"""
        Assigns the given value to the x coordinate of this vector.

        Parameters
        ----------
        Y: float

        Returns
        -------
        None

        """
        return _gp.gp_Vec_SetY(self, *args)

    def SetZ(self, *args) -> "void":
        r"""
        Assigns the given value to the x coordinate of this vector.

        Parameters
        ----------
        Z: float

        Returns
        -------
        None

        """
        return _gp.gp_Vec_SetZ(self, *args)

    def SquareMagnitude(self, *args) -> "Standard_Real":
        r"""
        Computes the square magnitude of this vector.

        Returns
        -------
        float

        """
        return _gp.gp_Vec_SquareMagnitude(self, *args)

    def Subtract(self, *args) -> "void":
        r"""
        Subtracts two vectors.

        Parameters
        ----------
        Right: gp_Vec

        Returns
        -------
        None

        """
        return _gp.gp_Vec_Subtract(self, *args)

    def Subtracted(self, *args) -> "gp_Vec":
        r"""
        Subtracts two vectors.

        Parameters
        ----------
        Right: gp_Vec

        Returns
        -------
        gp_Vec

        """
        return _gp.gp_Vec_Subtracted(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        Transforms a vector with the transformation t.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        None

        """
        return _gp.gp_Vec_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Vec":
        r"""
        Transforms a vector with the transformation t.

        Parameters
        ----------
        T: gp_Trsf

        Returns
        -------
        gp_Vec

        """
        return _gp.gp_Vec_Transformed(self, *args)

    def X(self, *args) -> "Standard_Real":
        r"""
        For this vector, returns its x coordinate.

        Returns
        -------
        float

        """
        return _gp.gp_Vec_X(self, *args)

    def XYZ(self, *args) -> "gp_XYZ const":
        r"""
        For this vector, returns - its three coordinates as a number triple.

        Returns
        -------
        gp_XYZ

        """
        return _gp.gp_Vec_XYZ(self, *args)

    def Y(self, *args) -> "Standard_Real":
        r"""
        For this vector, returns its y coordinate.

        Returns
        -------
        float

        """
        return _gp.gp_Vec_Y(self, *args)

    def Z(self, *args) -> "Standard_Real":
        r"""
        For this vector, returns its z coordinate.

        Returns
        -------
        float

        """
        return _gp.gp_Vec_Z(self, *args)

    def __mul__(self, *args) -> "Standard_Real":
        r"""
        No available documentation.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        gp_Vec
        No available documentation.

        Parameters
        ----------
        Other: gp_Vec

        Returns
        -------
        float

        """
        return _gp.gp_Vec___mul__(self, *args)

    def __imul_wrapper__(self, other: "Standard_Real const") -> "void":
        return _gp.gp_Vec___imul_wrapper__(self, other)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __add__(self, *args) -> "gp_Vec":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_Vec

        Returns
        -------
        gp_Vec

        """
        return _gp.gp_Vec___add__(self, *args)

    def __iadd_wrapper__(self, other: "gp_Vec") -> "void":
        return _gp.gp_Vec___iadd_wrapper__(self, other)

    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __sub__(self, *args) -> "gp_Vec":
        r"""
        No available documentation.

        Parameters
        ----------
        Right: gp_Vec

        Returns
        -------
        gp_Vec

        """
        return _gp.gp_Vec___sub__(self, *args)

    def __neg__(self, *args) -> "gp_Vec":
        r"""
        No available documentation.

        Returns
        -------
        gp_Vec

        """
        return _gp.gp_Vec___neg__(self, *args)

    def __isub_wrapper__(self, other: "gp_Vec") -> "void":
        return _gp.gp_Vec___isub_wrapper__(self, other)

    def __isub__(self, right):
        self.__isub_wrapper__(right)
        return self


    def __truediv__(self, *args):
        return _gp.gp_Vec___truediv__(self, *args)
    __div__ = __truediv__



    def __itruediv_wrapper__(self, other: "Standard_Real const") -> "void":
        return _gp.gp_Vec___itruediv_wrapper__(self, other)

    def __itruediv__(self, right):
        self.__itruediv_wrapper__(right)
        return self


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Vec

# Register gp_Vec in _gp:
_gp.gp_Vec_swigregister(gp_Vec)

class gp_Vec2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates a zero vector.

        Returns
        -------
        None
        Creates a unitary vector from a direction v.

        Parameters
        ----------
        V: gp_Dir2d

        Returns
        -------
        None
        Creates a vector with a doublet of coordinates.

        Parameters
        ----------
        Coord: gp_XY

        Returns
        -------
        None
        Creates a point with its two cartesian coordinates.

        Parameters
        ----------
        Xv: float
        Yv: float

        Returns
        -------
        None
        Creates a vector from two points. the length of the vector is the distance between p1 and p2.

        Parameters
        ----------
        P1: gp_Pnt2d
        P2: gp_Pnt2d

        Returns
        -------
        None

        """
        _gp.gp_Vec2d_swiginit(self, _gp.new_gp_Vec2d(*args))

    def Add(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_Vec2d

        Returns
        -------
        None

        """
        return _gp.gp_Vec2d_Add(self, *args)

    def Added(self, *args) -> "gp_Vec2d":
        r"""
        Adds two vectors.

        Parameters
        ----------
        Other: gp_Vec2d

        Returns
        -------
        gp_Vec2d

        """
        return _gp.gp_Vec2d_Added(self, *args)

    def Angle(self, *args) -> "Standard_Real":
        r"""
        Computes the angular value between <self> and <other> returns the angle value between -pi and pi in radian. the orientation is from <self> to other. the positive sense is the trigonometric sense. raises vectorwithnullmagnitude if <self>.magnitude() <= resolution from gp or other.magnitude() <= resolution because the angular value is indefinite if one of the vectors has a null magnitude.

        Parameters
        ----------
        Other: gp_Vec2d

        Returns
        -------
        float

        """
        return _gp.gp_Vec2d_Angle(self, *args)

    def Coord(self, *args) -> "void":
        r"""
        Returns the coordinate of range index : index = 1 => x is returned index = 2 => y is returned raised if index != {1, 2}.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float
        For this vector, returns its two coordinates xv and yv.

        Parameters
        ----------

        Returns
        -------
        Xv: float
        Yv: float

        """
        return _gp.gp_Vec2d_Coord(self, *args)

    def CrossMagnitude(self, *args) -> "Standard_Real":
        r"""
        Computes the magnitude of the cross product between <self> and right. returns || <self> ^ right ||.

        Parameters
        ----------
        Right: gp_Vec2d

        Returns
        -------
        float

        """
        return _gp.gp_Vec2d_CrossMagnitude(self, *args)

    def CrossSquareMagnitude(self, *args) -> "Standard_Real":
        r"""
        Computes the square magnitude of the cross product between <self> and right. returns || <self> ^ right ||**2.

        Parameters
        ----------
        Right: gp_Vec2d

        Returns
        -------
        float

        """
        return _gp.gp_Vec2d_CrossSquareMagnitude(self, *args)

    def Crossed(self, *args) -> "Standard_Real":
        r"""
        Computes the crossing product between two vectors.

        Parameters
        ----------
        Right: gp_Vec2d

        Returns
        -------
        float

        """
        return _gp.gp_Vec2d_Crossed(self, *args)

    def Divide(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        None

        """
        return _gp.gp_Vec2d_Divide(self, *args)

    def Divided(self, *args) -> "gp_Vec2d":
        r"""
        Divides a vector by a scalar.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        gp_Vec2d

        """
        return _gp.gp_Vec2d_Divided(self, *args)

    def Dot(self, *args) -> "Standard_Real":
        r"""
        Computes the scalar product.

        Parameters
        ----------
        Other: gp_Vec2d

        Returns
        -------
        float

        """
        return _gp.gp_Vec2d_Dot(self, *args)

    def GetNormal(self, *args) -> "gp_Vec2d":
        r"""
        No available documentation.

        Returns
        -------
        gp_Vec2d

        """
        return _gp.gp_Vec2d_GetNormal(self, *args)

    def IsEqual(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the two vectors have the same magnitude value and the same direction. the precision values are lineartolerance for the magnitude and angulartolerance for the direction.

        Parameters
        ----------
        Other: gp_Vec2d
        LinearTolerance: float
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Vec2d_IsEqual(self, *args)

    def IsNormal(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if abs(abs(<self>.angle(other)) - pi/2.) <= angulartolerance raises vectorwithnullmagnitude if <self>.magnitude() <= resolution or other.magnitude() <= resolution from gp.

        Parameters
        ----------
        Other: gp_Vec2d
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Vec2d_IsNormal(self, *args)

    def IsOpposite(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if pi - abs(<self>.angle(other)) <= angulartolerance raises vectorwithnullmagnitude if <self>.magnitude() <= resolution or other.magnitude() <= resolution from gp.

        Parameters
        ----------
        Other: gp_Vec2d
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Vec2d_IsOpposite(self, *args)

    def IsParallel(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if abs(angle(<self>, other)) <= angulartolerance or pi - abs(angle(<self>, other)) <= angulartolerance two vectors with opposite directions are considered as parallel. raises vectorwithnullmagnitude if <self>.magnitude() <= resolution or other.magnitude() <= resolution from gp.

        Parameters
        ----------
        Other: gp_Vec2d
        AngularTolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_Vec2d_IsParallel(self, *args)

    def Magnitude(self, *args) -> "Standard_Real":
        r"""
        Computes the magnitude of this vector.

        Returns
        -------
        float

        """
        return _gp.gp_Vec2d_Magnitude(self, *args)

    def Mirror(self, *args) -> "void":
        r"""
        Performs the symmetrical transformation of a vector with respect to the vector v which is the center of the symmetry.

        Parameters
        ----------
        V: gp_Vec2d

        Returns
        -------
        None
        Performs the symmetrical transformation of a vector with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        A1: gp_Ax2d

        Returns
        -------
        None

        """
        return _gp.gp_Vec2d_Mirror(self, *args)

    def Mirrored(self, *args) -> "gp_Vec2d":
        r"""
        Performs the symmetrical transformation of a vector with respect to the vector v which is the center of the symmetry.

        Parameters
        ----------
        V: gp_Vec2d

        Returns
        -------
        gp_Vec2d
        Performs the symmetrical transformation of a vector with respect to an axis placement which is the axis of the symmetry.

        Parameters
        ----------
        A1: gp_Ax2d

        Returns
        -------
        gp_Vec2d

        """
        return _gp.gp_Vec2d_Mirrored(self, *args)

    def Multiplied(self, *args) -> "gp_Vec2d":
        r"""
        Normalizes a vector raises an exception if the magnitude of the vector is lower or equal to resolution from package gp.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        gp_Vec2d

        """
        return _gp.gp_Vec2d_Multiplied(self, *args)

    def Multiply(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        None

        """
        return _gp.gp_Vec2d_Multiply(self, *args)

    def Normalize(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _gp.gp_Vec2d_Normalize(self, *args)

    def Normalized(self, *args) -> "gp_Vec2d":
        r"""
        Normalizes a vector raises an exception if the magnitude of the vector is lower or equal to resolution from package gp. reverses the direction of a vector.

        Returns
        -------
        gp_Vec2d

        """
        return _gp.gp_Vec2d_Normalized(self, *args)

    def Reverse(self, *args) -> "void":
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _gp.gp_Vec2d_Reverse(self, *args)

    def Reversed(self, *args) -> "gp_Vec2d":
        r"""
        Reverses the direction of a vector.

        Returns
        -------
        gp_Vec2d

        """
        return _gp.gp_Vec2d_Reversed(self, *args)

    def Rotate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Ang: float

        Returns
        -------
        None

        """
        return _gp.gp_Vec2d_Rotate(self, *args)

    def Rotated(self, *args) -> "gp_Vec2d":
        r"""
        Rotates a vector. ang is the angular value of the rotation in radians.

        Parameters
        ----------
        Ang: float

        Returns
        -------
        gp_Vec2d

        """
        return _gp.gp_Vec2d_Rotated(self, *args)

    def Scale(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        S: float

        Returns
        -------
        None

        """
        return _gp.gp_Vec2d_Scale(self, *args)

    def Scaled(self, *args) -> "gp_Vec2d":
        r"""
        Scales a vector. s is the scaling value.

        Parameters
        ----------
        S: float

        Returns
        -------
        gp_Vec2d

        """
        return _gp.gp_Vec2d_Scaled(self, *args)

    def SetCoord(self, *args) -> "void":
        r"""
        Changes the coordinate of range index index = 1 => x is modified index = 2 => y is modified raises outofrange if index != {1, 2}.

        Parameters
        ----------
        Index: int
        Xi: float

        Returns
        -------
        None
        For this vector, assigns the values xv and yv to its two coordinates.

        Parameters
        ----------
        Xv: float
        Yv: float

        Returns
        -------
        None

        """
        return _gp.gp_Vec2d_SetCoord(self, *args)

    def SetLinearForm(self, *args) -> "void":
        r"""
        <self> is set to the following linear form : a1 * v1 + a2 * v2 + v3.

        Parameters
        ----------
        A1: float
        V1: gp_Vec2d
        A2: float
        V2: gp_Vec2d
        V3: gp_Vec2d

        Returns
        -------
        None
        <self> is set to the following linear form : a1 * v1 + a2 * v2.

        Parameters
        ----------
        A1: float
        V1: gp_Vec2d
        A2: float
        V2: gp_Vec2d

        Returns
        -------
        None
        <self> is set to the following linear form : a1 * v1 + v2.

        Parameters
        ----------
        A1: float
        V1: gp_Vec2d
        V2: gp_Vec2d

        Returns
        -------
        None
        <self> is set to the following linear form : left + right.

        Parameters
        ----------
        Left: gp_Vec2d
        Right: gp_Vec2d

        Returns
        -------
        None

        """
        return _gp.gp_Vec2d_SetLinearForm(self, *args)

    def SetX(self, *args) -> "void":
        r"""
        Assigns the given value to the x coordinate of this vector.

        Parameters
        ----------
        X: float

        Returns
        -------
        None

        """
        return _gp.gp_Vec2d_SetX(self, *args)

    def SetXY(self, *args) -> "void":
        r"""
        Assigns the two coordinates of coord to this vector.

        Parameters
        ----------
        Coord: gp_XY

        Returns
        -------
        None

        """
        return _gp.gp_Vec2d_SetXY(self, *args)

    def SetY(self, *args) -> "void":
        r"""
        Assigns the given value to the y coordinate of this vector.

        Parameters
        ----------
        Y: float

        Returns
        -------
        None

        """
        return _gp.gp_Vec2d_SetY(self, *args)

    def SquareMagnitude(self, *args) -> "Standard_Real":
        r"""
        Computes the square magnitude of this vector.

        Returns
        -------
        float

        """
        return _gp.gp_Vec2d_SquareMagnitude(self, *args)

    def Subtract(self, *args) -> "void":
        r"""
        Subtracts two vectors.

        Parameters
        ----------
        Right: gp_Vec2d

        Returns
        -------
        None

        """
        return _gp.gp_Vec2d_Subtract(self, *args)

    def Subtracted(self, *args) -> "gp_Vec2d":
        r"""
        Subtracts two vectors.

        Parameters
        ----------
        Right: gp_Vec2d

        Returns
        -------
        gp_Vec2d

        """
        return _gp.gp_Vec2d_Subtracted(self, *args)

    def Transform(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        None

        """
        return _gp.gp_Vec2d_Transform(self, *args)

    def Transformed(self, *args) -> "gp_Vec2d":
        r"""
        Transforms a vector with a trsf from gp.

        Parameters
        ----------
        T: gp_Trsf2d

        Returns
        -------
        gp_Vec2d

        """
        return _gp.gp_Vec2d_Transformed(self, *args)

    def X(self, *args) -> "Standard_Real":
        r"""
        For this vector, returns its x coordinate.

        Returns
        -------
        float

        """
        return _gp.gp_Vec2d_X(self, *args)

    def XY(self, *args) -> "gp_XY const":
        r"""
        For this vector, returns its two coordinates as a number pair.

        Returns
        -------
        gp_XY

        """
        return _gp.gp_Vec2d_XY(self, *args)

    def Y(self, *args) -> "Standard_Real":
        r"""
        For this vector, returns its y coordinate.

        Returns
        -------
        float

        """
        return _gp.gp_Vec2d_Y(self, *args)

    def __mul__(self, *args) -> "gp_Vec2d":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_Vec2d

        Returns
        -------
        float
        No available documentation.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        gp_Vec2d

        """
        return _gp.gp_Vec2d___mul__(self, *args)

    def __imul_wrapper__(self, other: "Standard_Real const") -> "void":
        return _gp.gp_Vec2d___imul_wrapper__(self, other)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __add__(self, *args) -> "gp_Vec2d":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_Vec2d

        Returns
        -------
        gp_Vec2d

        """
        return _gp.gp_Vec2d___add__(self, *args)

    def __iadd_wrapper__(self, other: "gp_Vec2d") -> "void":
        return _gp.gp_Vec2d___iadd_wrapper__(self, other)

    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __neg__(self, *args) -> "gp_Vec2d":
        r"""
        No available documentation.

        Returns
        -------
        gp_Vec2d

        """
        return _gp.gp_Vec2d___neg__(self, *args)

    def __sub__(self, *args) -> "gp_Vec2d":
        r"""
        No available documentation.

        Parameters
        ----------
        Right: gp_Vec2d

        Returns
        -------
        gp_Vec2d

        """
        return _gp.gp_Vec2d___sub__(self, *args)

    def __isub_wrapper__(self, other: "gp_Vec2d") -> "void":
        return _gp.gp_Vec2d___isub_wrapper__(self, other)

    def __isub__(self, right):
        self.__isub_wrapper__(right)
        return self


    def __truediv__(self, *args):
        return _gp.gp_Vec2d___truediv__(self, *args)
    __div__ = __truediv__



    def __itruediv_wrapper__(self, other: "Standard_Real const") -> "void":
        return _gp.gp_Vec2d___itruediv_wrapper__(self, other)

    def __itruediv__(self, right):
        self.__itruediv_wrapper__(right)
        return self


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_Vec2d

# Register gp_Vec2d in _gp:
_gp.gp_Vec2d_swigregister(gp_Vec2d)

class gp_XY(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates xy object with zero coordinates (0,0).

        Returns
        -------
        None
        A number pair defined by the xy coordinates.

        Parameters
        ----------
        X: float
        Y: float

        Returns
        -------
        None

        """
        _gp.gp_XY_swiginit(self, _gp.new_gp_XY(*args))

    def Add(self, *args) -> "void":
        r"""
        Computes the sum of this number pair and number pair other <self>.x() = <self>.x() + other.x() <self>.y() = <self>.y() + other.y().

        Parameters
        ----------
        Other: gp_XY

        Returns
        -------
        None

        """
        return _gp.gp_XY_Add(self, *args)

    def Added(self, *args) -> "gp_XY":
        r"""
        Computes the sum of this number pair and number pair other new.x() = <self>.x() + other.x() new.y() = <self>.y() + other.y().

        Parameters
        ----------
        Other: gp_XY

        Returns
        -------
        gp_XY

        """
        return _gp.gp_XY_Added(self, *args)

    def GetChangeCoord(self, theIndex: "Standard_Integer const") -> "Standard_Real":
        r"""GetChangeCoord(gp_XY self, Standard_Integer const theIndex) -> Standard_Real"""
        return _gp.gp_XY_GetChangeCoord(self, theIndex)

    def SetChangeCoord(self, theIndex: "Standard_Integer const", value: "Standard_Real") -> "void":
        r"""SetChangeCoord(gp_XY self, Standard_Integer const theIndex, Standard_Real value)"""
        return _gp.gp_XY_SetChangeCoord(self, theIndex, value)

    def Coord(self, *args) -> "void":
        r"""
        Returns the coordinate of range index : index = 1 => x is returned index = 2 => y is returned raises outofrange if index != {1, 2}.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float
        For this number pair, returns its coordinates x and y.

        Parameters
        ----------

        Returns
        -------
        X: float
        Y: float

        """
        return _gp.gp_XY_Coord(self, *args)

    def CrossMagnitude(self, *args) -> "Standard_Real":
        r"""
        Computes the magnitude of the cross product between <self> and right. returns || <self> ^ right ||.

        Parameters
        ----------
        Right: gp_XY

        Returns
        -------
        float

        """
        return _gp.gp_XY_CrossMagnitude(self, *args)

    def CrossSquareMagnitude(self, *args) -> "Standard_Real":
        r"""
        Computes the square magnitude of the cross product between <self> and right. returns || <self> ^ right ||**2.

        Parameters
        ----------
        Right: gp_XY

        Returns
        -------
        float

        """
        return _gp.gp_XY_CrossSquareMagnitude(self, *args)

    def Crossed(self, *args) -> "Standard_Real":
        r"""
        Real d = <self>.x() * other.y() - <self>.y() * other.x().

        Parameters
        ----------
        Right: gp_XY

        Returns
        -------
        float

        """
        return _gp.gp_XY_Crossed(self, *args)

    def Divide(self, *args) -> "void":
        r"""
        Divides <self> by a real.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        None

        """
        return _gp.gp_XY_Divide(self, *args)

    def Divided(self, *args) -> "gp_XY":
        r"""
        Divides <self> by a real.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        gp_XY

        """
        return _gp.gp_XY_Divided(self, *args)

    def Dot(self, *args) -> "Standard_Real":
        r"""
        Computes the scalar product between <self> and other.

        Parameters
        ----------
        Other: gp_XY

        Returns
        -------
        float

        """
        return _gp.gp_XY_Dot(self, *args)

    def IsEqual(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the coordinates of this number pair are equal to the respective coordinates of the number pair other, within the specified tolerance tolerance. i.e.: abs(<self>.x() - other.x()) <= tolerance and abs(<self>.y() - other.y()) <= tolerance and computations.

        Parameters
        ----------
        Other: gp_XY
        Tolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_XY_IsEqual(self, *args)

    def Modulus(self, *args) -> "Standard_Real":
        r"""
        Computes sqrt (x*x + y*y) where x and y are the two coordinates of this number pair.

        Returns
        -------
        float

        """
        return _gp.gp_XY_Modulus(self, *args)

    def Multiplied(self, *args) -> "gp_XY":
        r"""
        New.x() = <self>.x() * scalar; new.y() = <self>.y() * scalar;.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        gp_XY
        New.x() = <self>.x() * other.x(); new.y() = <self>.y() * other.y();.

        Parameters
        ----------
        Other: gp_XY

        Returns
        -------
        gp_XY
        New = matrix * <self>.

        Parameters
        ----------
        Matrix: gp_Mat2d

        Returns
        -------
        gp_XY

        """
        return _gp.gp_XY_Multiplied(self, *args)

    def Multiply(self, *args) -> "void":
        r"""
        <self>.x() = <self>.x() * scalar; <self>.y() = <self>.y() * scalar;.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        None
        <self>.x() = <self>.x() * other.x(); <self>.y() = <self>.y() * other.y();.

        Parameters
        ----------
        Other: gp_XY

        Returns
        -------
        None
        <self> = matrix * <self>.

        Parameters
        ----------
        Matrix: gp_Mat2d

        Returns
        -------
        None

        """
        return _gp.gp_XY_Multiply(self, *args)

    def Normalize(self, *args) -> "void":
        r"""
        <self>.x() = <self>.x()/ <self>.modulus() <self>.y() = <self>.y()/ <self>.modulus() raises constructionerror if <self>.modulus() <= resolution from gp.

        Returns
        -------
        None

        """
        return _gp.gp_XY_Normalize(self, *args)

    def Normalized(self, *args) -> "gp_XY":
        r"""
        New.x() = <self>.x()/ <self>.modulus() new.y() = <self>.y()/ <self>.modulus() raises constructionerror if <self>.modulus() <= resolution from gp.

        Returns
        -------
        gp_XY

        """
        return _gp.gp_XY_Normalized(self, *args)

    def Reverse(self, *args) -> "void":
        r"""
        <self>.x() = -<self>.x() <self>.y() = -<self>.y().

        Returns
        -------
        None

        """
        return _gp.gp_XY_Reverse(self, *args)

    def Reversed(self, *args) -> "gp_XY":
        r"""
        New.x() = -<self>.x() new.y() = -<self>.y().

        Returns
        -------
        gp_XY

        """
        return _gp.gp_XY_Reversed(self, *args)

    def SetCoord(self, *args) -> "void":
        r"""
        Modifies the coordinate of range index index = 1 => x is modified index = 2 => y is modified raises outofrange if index != {1, 2}.

        Parameters
        ----------
        Index: int
        Xi: float

        Returns
        -------
        None
        For this number pair, assigns the values x and y to its coordinates.

        Parameters
        ----------
        X: float
        Y: float

        Returns
        -------
        None

        """
        return _gp.gp_XY_SetCoord(self, *args)

    def SetLinearForm(self, *args) -> "void":
        r"""
        Computes the following linear combination and assigns the result to this number pair: a1 * xy1 + a2 * xy2.

        Parameters
        ----------
        A1: float
        XY1: gp_XY
        A2: float
        XY2: gp_XY

        Returns
        -------
        None
        -- computes the following linear combination and assigns the result to this number pair: a1 * xy1 + a2 * xy2 + xy3.

        Parameters
        ----------
        A1: float
        XY1: gp_XY
        A2: float
        XY2: gp_XY
        XY3: gp_XY

        Returns
        -------
        None
        Computes the following linear combination and assigns the result to this number pair: a1 * xy1 + xy2.

        Parameters
        ----------
        A1: float
        XY1: gp_XY
        XY2: gp_XY

        Returns
        -------
        None
        Computes the following linear combination and assigns the result to this number pair: xy1 + xy2.

        Parameters
        ----------
        XY1: gp_XY
        XY2: gp_XY

        Returns
        -------
        None

        """
        return _gp.gp_XY_SetLinearForm(self, *args)

    def SetX(self, *args) -> "void":
        r"""
        Assigns the given value to the x coordinate of this number pair.

        Parameters
        ----------
        X: float

        Returns
        -------
        None

        """
        return _gp.gp_XY_SetX(self, *args)

    def SetY(self, *args) -> "void":
        r"""
        Assigns the given value to the y coordinate of this number pair.

        Parameters
        ----------
        Y: float

        Returns
        -------
        None

        """
        return _gp.gp_XY_SetY(self, *args)

    def SquareModulus(self, *args) -> "Standard_Real":
        r"""
        Computes x*x + y*y where x and y are the two coordinates of this number pair.

        Returns
        -------
        float

        """
        return _gp.gp_XY_SquareModulus(self, *args)

    def Subtract(self, *args) -> "void":
        r"""
        <self>.x() = <self>.x() - other.x() <self>.y() = <self>.y() - other.y().

        Parameters
        ----------
        Right: gp_XY

        Returns
        -------
        None

        """
        return _gp.gp_XY_Subtract(self, *args)

    def Subtracted(self, *args) -> "gp_XY":
        r"""
        New.x() = <self>.x() - other.x() new.y() = <self>.y() - other.y().

        Parameters
        ----------
        Right: gp_XY

        Returns
        -------
        gp_XY

        """
        return _gp.gp_XY_Subtracted(self, *args)

    def X(self, *args) -> "Standard_Real":
        r"""
        Returns the x coordinate of this number pair.

        Returns
        -------
        float

        """
        return _gp.gp_XY_X(self, *args)

    def Y(self, *args) -> "Standard_Real":
        r"""
        Returns the y coordinate of this number pair.

        Returns
        -------
        float

        """
        return _gp.gp_XY_Y(self, *args)

    def __mul__(self, *args) -> "gp_XY":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_XY

        Returns
        -------
        float
        No available documentation.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        gp_XY
        No available documentation.

        Parameters
        ----------
        Matrix: gp_Mat2d

        Returns
        -------
        gp_XY

        """
        return _gp.gp_XY___mul__(self, *args)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __imul_wrapper__(self, *args) -> "void":
        r"""
        __imul_wrapper__(gp_XY self, Standard_Real const other)
        __imul_wrapper__(gp_XY self, gp_XY other)
        __imul_wrapper__(gp_XY self, gp_Mat2d other)
        """
        return _gp.gp_XY___imul_wrapper__(self, *args)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __add__(self, *args) -> "gp_XY":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_XY

        Returns
        -------
        gp_XY

        """
        return _gp.gp_XY___add__(self, *args)

    def __iadd_wrapper__(self, other: "gp_XY") -> "void":
        r"""__iadd_wrapper__(gp_XY self, gp_XY other)"""
        return _gp.gp_XY___iadd_wrapper__(self, other)

    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __neg__(self, *args) -> "gp_XY":
        r"""
        No available documentation.

        Returns
        -------
        gp_XY

        """
        return _gp.gp_XY___neg__(self, *args)

    def __sub__(self, *args) -> "gp_XY":
        r"""
        No available documentation.

        Parameters
        ----------
        Right: gp_XY

        Returns
        -------
        gp_XY

        """
        return _gp.gp_XY___sub__(self, *args)

    def __isub_wrapper__(self, other: "gp_XY") -> "void":
        r"""__isub_wrapper__(gp_XY self, gp_XY other)"""
        return _gp.gp_XY___isub_wrapper__(self, other)

    def __isub__(self, right):
        self.__isub_wrapper__(right)
        return self


    def __truediv__(self, *args):
        return _gp.gp_XY___truediv__(self, *args)
    __div__ = __truediv__



    def __itruediv_wrapper__(self, other: "Standard_Real const") -> "void":
        r"""__itruediv_wrapper__(gp_XY self, Standard_Real const other)"""
        return _gp.gp_XY___itruediv_wrapper__(self, other)

    def __itruediv__(self, right):
        self.__itruediv_wrapper__(right)
        return self


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_XY

# Register gp_XY in _gp:
_gp.gp_XY_swigregister(gp_XY)

class gp_XYZ(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an xyz object with zero co-ordinates (0,0,0).

        Returns
        -------
        None
        Creates an xyz with given coordinates.

        Parameters
        ----------
        X: float
        Y: float
        Z: float

        Returns
        -------
        None

        """
        _gp.gp_XYZ_swiginit(self, _gp.new_gp_XYZ(*args))

    def Add(self, *args) -> "void":
        r"""
        <self>.x() = <self>.x() + other.x() <self>.y() = <self>.y() + other.y() <self>.z() = <self>.z() + other.z().

        Parameters
        ----------
        Other: gp_XYZ

        Returns
        -------
        None

        """
        return _gp.gp_XYZ_Add(self, *args)

    def Added(self, *args) -> "gp_XYZ":
        r"""
        New.x() = <self>.x() + other.x() new.y() = <self>.y() + other.y() new.z() = <self>.z() + other.z().

        Parameters
        ----------
        Other: gp_XYZ

        Returns
        -------
        gp_XYZ

        """
        return _gp.gp_XYZ_Added(self, *args)

    def GetChangeCoord(self, theIndex: "Standard_Integer const") -> "Standard_Real":
        r"""GetChangeCoord(gp_XYZ self, Standard_Integer const theIndex) -> Standard_Real"""
        return _gp.gp_XYZ_GetChangeCoord(self, theIndex)

    def SetChangeCoord(self, theIndex: "Standard_Integer const", value: "Standard_Real") -> "void":
        r"""SetChangeCoord(gp_XYZ self, Standard_Integer const theIndex, Standard_Real value)"""
        return _gp.gp_XYZ_SetChangeCoord(self, theIndex, value)

    def ChangeData(self, *args) -> "Standard_Real *":
        r"""
        Returns a ptr to coordinates location. is useful for algorithms, but does not perform any checks!.

        Returns
        -------
        float *

        """
        return _gp.gp_XYZ_ChangeData(self, *args)

    def Coord(self, *args) -> "void":
        r"""
        Returns the coordinate of range index : index = 1 => x is returned index = 2 => y is returned index = 3 => z is returned //! raises outofrange if index != {1, 2, 3}.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float
        No available documentation.

        Parameters
        ----------

        Returns
        -------
        X: float
        Y: float
        Z: float

        """
        return _gp.gp_XYZ_Coord(self, *args)

    def Cross(self, *args) -> "void":
        r"""
        <self>.x() = <self>.y() * other.z() - <self>.z() * other.y() <self>.y() = <self>.z() * other.x() - <self>.x() * other.z() <self>.z() = <self>.x() * other.y() - <self>.y() * other.x().

        Parameters
        ----------
        Right: gp_XYZ

        Returns
        -------
        None

        """
        return _gp.gp_XYZ_Cross(self, *args)

    def CrossCross(self, *args) -> "void":
        r"""
        Triple vector product computes <self> = <self>.cross(coord1.cross(coord2)).

        Parameters
        ----------
        Coord1: gp_XYZ
        Coord2: gp_XYZ

        Returns
        -------
        None

        """
        return _gp.gp_XYZ_CrossCross(self, *args)

    def CrossCrossed(self, *args) -> "gp_XYZ":
        r"""
        Triple vector product computes new = <self>.cross(coord1.cross(coord2)).

        Parameters
        ----------
        Coord1: gp_XYZ
        Coord2: gp_XYZ

        Returns
        -------
        gp_XYZ

        """
        return _gp.gp_XYZ_CrossCrossed(self, *args)

    def CrossMagnitude(self, *args) -> "Standard_Real":
        r"""
        Computes the magnitude of the cross product between <self> and right. returns || <self> ^ right ||.

        Parameters
        ----------
        Right: gp_XYZ

        Returns
        -------
        float

        """
        return _gp.gp_XYZ_CrossMagnitude(self, *args)

    def CrossSquareMagnitude(self, *args) -> "Standard_Real":
        r"""
        Computes the square magnitude of the cross product between <self> and right. returns || <self> ^ right ||**2.

        Parameters
        ----------
        Right: gp_XYZ

        Returns
        -------
        float

        """
        return _gp.gp_XYZ_CrossSquareMagnitude(self, *args)

    def Crossed(self, *args) -> "gp_XYZ":
        r"""
        New.x() = <self>.y() * other.z() - <self>.z() * other.y() new.y() = <self>.z() * other.x() - <self>.x() * other.z() new.z() = <self>.x() * other.y() - <self>.y() * other.x().

        Parameters
        ----------
        Right: gp_XYZ

        Returns
        -------
        gp_XYZ

        """
        return _gp.gp_XYZ_Crossed(self, *args)

    def Divide(self, *args) -> "void":
        r"""
        Divides <self> by a real.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        None

        """
        return _gp.gp_XYZ_Divide(self, *args)

    def Divided(self, *args) -> "gp_XYZ":
        r"""
        Divides <self> by a real.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        gp_XYZ

        """
        return _gp.gp_XYZ_Divided(self, *args)

    def Dot(self, *args) -> "Standard_Real":
        r"""
        Computes the scalar product between <self> and other.

        Parameters
        ----------
        Other: gp_XYZ

        Returns
        -------
        float

        """
        return _gp.gp_XYZ_Dot(self, *args)

    def DotCross(self, *args) -> "Standard_Real":
        r"""
        Computes the triple scalar product.

        Parameters
        ----------
        Coord1: gp_XYZ
        Coord2: gp_XYZ

        Returns
        -------
        float

        """
        return _gp.gp_XYZ_DotCross(self, *args)

    def DumpJsonToString(self, depth: "int"=-1) -> "std::string":
        r"""DumpJsonToString(gp_XYZ self, int depth=-1) -> std::string"""
        return _gp.gp_XYZ_DumpJsonToString(self, depth)

    def GetData(self, *args) -> "Standard_Real const *":
        r"""
        Returns a const ptr to coordinates location. is useful for algorithms, but does not perform any checks!.

        Returns
        -------
        float *

        """
        return _gp.gp_XYZ_GetData(self, *args)

    def IsEqual(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if he coordinates of this xyz object are equal to the respective coordinates other, within the specified tolerance tolerance. i.e.: abs(<self>.x() - other.x()) <= tolerance and abs(<self>.y() - other.y()) <= tolerance and abs(<self>.z() - other.z()) <= tolerance.

        Parameters
        ----------
        Other: gp_XYZ
        Tolerance: float

        Returns
        -------
        bool

        """
        return _gp.gp_XYZ_IsEqual(self, *args)

    def Modulus(self, *args) -> "Standard_Real":
        r"""
        Computes sqrt (x*x + y*y + z*z) where x, y and z are the three coordinates of this xyz object.

        Returns
        -------
        float

        """
        return _gp.gp_XYZ_Modulus(self, *args)

    def Multiplied(self, *args) -> "gp_XYZ":
        r"""
        New.x() = <self>.x() * scalar; new.y() = <self>.y() * scalar; new.z() = <self>.z() * scalar;.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        gp_XYZ
        New.x() = <self>.x() * other.x(); new.y() = <self>.y() * other.y(); new.z() = <self>.z() * other.z();.

        Parameters
        ----------
        Other: gp_XYZ

        Returns
        -------
        gp_XYZ
        New = matrix * <self>.

        Parameters
        ----------
        Matrix: gp_Mat

        Returns
        -------
        gp_XYZ

        """
        return _gp.gp_XYZ_Multiplied(self, *args)

    def Multiply(self, *args) -> "void":
        r"""
        <self>.x() = <self>.x() * scalar; <self>.y() = <self>.y() * scalar; <self>.z() = <self>.z() * scalar;.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        None
        <self>.x() = <self>.x() * other.x(); <self>.y() = <self>.y() * other.y(); <self>.z() = <self>.z() * other.z();.

        Parameters
        ----------
        Other: gp_XYZ

        Returns
        -------
        None
        <self> = matrix * <self>.

        Parameters
        ----------
        Matrix: gp_Mat

        Returns
        -------
        None

        """
        return _gp.gp_XYZ_Multiply(self, *args)

    def Normalize(self, *args) -> "void":
        r"""
        <self>.x() = <self>.x()/ <self>.modulus() <self>.y() = <self>.y()/ <self>.modulus() <self>.z() = <self>.z()/ <self>.modulus() raised if <self>.modulus() <= resolution from gp.

        Returns
        -------
        None

        """
        return _gp.gp_XYZ_Normalize(self, *args)

    def Normalized(self, *args) -> "gp_XYZ":
        r"""
        New.x() = <self>.x()/ <self>.modulus() new.y() = <self>.y()/ <self>.modulus() new.z() = <self>.z()/ <self>.modulus() raised if <self>.modulus() <= resolution from gp.

        Returns
        -------
        gp_XYZ

        """
        return _gp.gp_XYZ_Normalized(self, *args)

    def Reverse(self, *args) -> "void":
        r"""
        <self>.x() = -<self>.x() <self>.y() = -<self>.y() <self>.z() = -<self>.z().

        Returns
        -------
        None

        """
        return _gp.gp_XYZ_Reverse(self, *args)

    def Reversed(self, *args) -> "gp_XYZ":
        r"""
        New.x() = -<self>.x() new.y() = -<self>.y() new.z() = -<self>.z().

        Returns
        -------
        gp_XYZ

        """
        return _gp.gp_XYZ_Reversed(self, *args)

    def SetCoord(self, *args) -> "void":
        r"""
        For this xyz object, assigns the values x, y and z to its three coordinates.

        Parameters
        ----------
        X: float
        Y: float
        Z: float

        Returns
        -------
        None
        Modifies the coordinate of range index index = 1 => x is modified index = 2 => y is modified index = 3 => z is modified raises outofrange if index != {1, 2, 3}.

        Parameters
        ----------
        Index: int
        Xi: float

        Returns
        -------
        None

        """
        return _gp.gp_XYZ_SetCoord(self, *args)

    def SetLinearForm(self, *args) -> "void":
        r"""
        <self> is set to the following linear form : a1 * xyz1 + a2 * xyz2 + a3 * xyz3 + xyz4.

        Parameters
        ----------
        A1: float
        XYZ1: gp_XYZ
        A2: float
        XYZ2: gp_XYZ
        A3: float
        XYZ3: gp_XYZ
        XYZ4: gp_XYZ

        Returns
        -------
        None
        <self> is set to the following linear form : a1 * xyz1 + a2 * xyz2 + a3 * xyz3.

        Parameters
        ----------
        A1: float
        XYZ1: gp_XYZ
        A2: float
        XYZ2: gp_XYZ
        A3: float
        XYZ3: gp_XYZ

        Returns
        -------
        None
        <self> is set to the following linear form : a1 * xyz1 + a2 * xyz2 + xyz3.

        Parameters
        ----------
        A1: float
        XYZ1: gp_XYZ
        A2: float
        XYZ2: gp_XYZ
        XYZ3: gp_XYZ

        Returns
        -------
        None
        <self> is set to the following linear form : a1 * xyz1 + a2 * xyz2.

        Parameters
        ----------
        A1: float
        XYZ1: gp_XYZ
        A2: float
        XYZ2: gp_XYZ

        Returns
        -------
        None
        <self> is set to the following linear form : a1 * xyz1 + xyz2.

        Parameters
        ----------
        A1: float
        XYZ1: gp_XYZ
        XYZ2: gp_XYZ

        Returns
        -------
        None
        <self> is set to the following linear form : xyz1 + xyz2.

        Parameters
        ----------
        XYZ1: gp_XYZ
        XYZ2: gp_XYZ

        Returns
        -------
        None

        """
        return _gp.gp_XYZ_SetLinearForm(self, *args)

    def SetX(self, *args) -> "void":
        r"""
        Assigns the given value to the x coordinate.

        Parameters
        ----------
        X: float

        Returns
        -------
        None

        """
        return _gp.gp_XYZ_SetX(self, *args)

    def SetY(self, *args) -> "void":
        r"""
        Assigns the given value to the y coordinate.

        Parameters
        ----------
        Y: float

        Returns
        -------
        None

        """
        return _gp.gp_XYZ_SetY(self, *args)

    def SetZ(self, *args) -> "void":
        r"""
        Assigns the given value to the z coordinate.

        Parameters
        ----------
        Z: float

        Returns
        -------
        None

        """
        return _gp.gp_XYZ_SetZ(self, *args)

    def SquareModulus(self, *args) -> "Standard_Real":
        r"""
        Computes x*x + y*y + z*z where x, y and z are the three coordinates of this xyz object.

        Returns
        -------
        float

        """
        return _gp.gp_XYZ_SquareModulus(self, *args)

    def Subtract(self, *args) -> "void":
        r"""
        <self>.x() = <self>.x() - other.x() <self>.y() = <self>.y() - other.y() <self>.z() = <self>.z() - other.z().

        Parameters
        ----------
        Right: gp_XYZ

        Returns
        -------
        None

        """
        return _gp.gp_XYZ_Subtract(self, *args)

    def Subtracted(self, *args) -> "gp_XYZ":
        r"""
        New.x() = <self>.x() - other.x() new.y() = <self>.y() - other.y() new.z() = <self>.z() - other.z().

        Parameters
        ----------
        Right: gp_XYZ

        Returns
        -------
        gp_XYZ

        """
        return _gp.gp_XYZ_Subtracted(self, *args)

    def X(self, *args) -> "Standard_Real":
        r"""
        Returns the x coordinate.

        Returns
        -------
        float

        """
        return _gp.gp_XYZ_X(self, *args)

    def Y(self, *args) -> "Standard_Real":
        r"""
        Returns the y coordinate.

        Returns
        -------
        float

        """
        return _gp.gp_XYZ_Y(self, *args)

    def Z(self, *args) -> "Standard_Real":
        r"""
        Returns the z coordinate.

        Returns
        -------
        float

        """
        return _gp.gp_XYZ_Z(self, *args)

    def __mul__(self, *args) -> "gp_XYZ":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_XYZ

        Returns
        -------
        float
        No available documentation.

        Parameters
        ----------
        Scalar: float

        Returns
        -------
        gp_XYZ
        No available documentation.

        Parameters
        ----------
        Matrix: gp_Mat

        Returns
        -------
        gp_XYZ

        """
        return _gp.gp_XYZ___mul__(self, *args)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __imul_wrapper__(self, *args) -> "void":
        r"""
        __imul_wrapper__(gp_XYZ self, Standard_Real const other)
        __imul_wrapper__(gp_XYZ self, gp_XYZ other)
        __imul_wrapper__(gp_XYZ self, gp_Mat other)
        """
        return _gp.gp_XYZ___imul_wrapper__(self, *args)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __add__(self, *args) -> "gp_XYZ":
        r"""
        No available documentation.

        Parameters
        ----------
        Other: gp_XYZ

        Returns
        -------
        gp_XYZ

        """
        return _gp.gp_XYZ___add__(self, *args)

    def __iadd_wrapper__(self, other: "gp_XYZ") -> "void":
        r"""__iadd_wrapper__(gp_XYZ self, gp_XYZ other)"""
        return _gp.gp_XYZ___iadd_wrapper__(self, other)

    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __sub__(self, *args) -> "gp_XYZ":
        r"""
        No available documentation.

        Parameters
        ----------
        Right: gp_XYZ

        Returns
        -------
        gp_XYZ

        """
        return _gp.gp_XYZ___sub__(self, *args)

    def __isub_wrapper__(self, other: "gp_XYZ") -> "void":
        r"""__isub_wrapper__(gp_XYZ self, gp_XYZ other)"""
        return _gp.gp_XYZ___isub_wrapper__(self, other)

    def __isub__(self, right):
        self.__isub_wrapper__(right)
        return self


    def __truediv__(self, *args):
        return _gp.gp_XYZ___truediv__(self, *args)
    __div__ = __truediv__



    def __itruediv_wrapper__(self, other: "Standard_Real const") -> "void":
        r"""__itruediv_wrapper__(gp_XYZ self, Standard_Real const other)"""
        return _gp.gp_XYZ___itruediv_wrapper__(self, other)

    def __itruediv__(self, right):
        self.__itruediv_wrapper__(right)
        return self


    __repr__ = _dumps_object

    __swig_destroy__ = _gp.delete_gp_XYZ

# Register gp_XYZ in _gp:
_gp.gp_XYZ_swigregister(gp_XYZ)





