from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TCollection import *


class Resource_FormatType(IntEnum):
	Resource_FormatType_SJIS: int = ...
	Resource_FormatType_EUC: int = ...
	Resource_FormatType_ANSI: int = ...
	Resource_FormatType_GB: int = ...
	Resource_FormatType_UTF8: int = ...
	Resource_FormatType_SystemLocale: int = ...
	Resource_SJIS: int = ...
	Resource_EUC: int = ...
	Resource_ANSI: int = ...
	Resource_GB: int = ...
Resource_FormatType_SJIS = Resource_FormatType.Resource_FormatType_SJIS
Resource_FormatType_EUC = Resource_FormatType.Resource_FormatType_EUC
Resource_FormatType_ANSI = Resource_FormatType.Resource_FormatType_ANSI
Resource_FormatType_GB = Resource_FormatType.Resource_FormatType_GB
Resource_FormatType_UTF8 = Resource_FormatType.Resource_FormatType_UTF8
Resource_FormatType_SystemLocale = Resource_FormatType.Resource_FormatType_SystemLocale
Resource_SJIS = Resource_FormatType.Resource_SJIS
Resource_EUC = Resource_FormatType.Resource_EUC
Resource_ANSI = Resource_FormatType.Resource_ANSI
Resource_GB = Resource_FormatType.Resource_GB

class Resource_LexicalCompare:
	def __init__(self) -> None: ...
	def IsLower(self, Left: TCollection_AsciiString, Right: TCollection_AsciiString) -> bool: ...

class Resource_Manager(Standard_Transient):
	@overload
	def __init__(self, aName: str, Verbose: Optional[bool] = False) -> None: ...
	@overload
	def __init__(self, aName: str, aDefaultsDirectory: TCollection_AsciiString, anUserDefaultsDirectory: TCollection_AsciiString, Verbose: Optional[bool] = False) -> None: ...
	def ExtValue(self, aResourceName: str) -> Standard_ExtString: ...
	def Find(self, aResource: str) -> bool: ...
	@staticmethod
	def GetResourcePath(aPath: TCollection_AsciiString, aName: str, isUserDefaults: bool) -> None: ...
	def Integer(self, aResourceName: str) -> int: ...
	def Real(self, aResourceName: str) -> float: ...
	def Save(self) -> bool: ...
	@overload
	def SetResource(self, aResourceName: str, aValue: int) -> None: ...
	@overload
	def SetResource(self, aResourceName: str, aValue: float) -> None: ...
	@overload
	def SetResource(self, aResourceName: str, aValue: str) -> None: ...
	@overload
	def SetResource(self, aResourceName: str, aValue: Standard_ExtString) -> None: ...
	def Value(self, aResourceName: str) -> str: ...

class Resource_Unicode:
	@staticmethod
	def ConvertANSIToUnicode(fromstr: str, tostr: TCollection_ExtendedString) -> None: ...
	@staticmethod
	def ConvertBig5ToUnicode(fromstr: str, tostr: TCollection_ExtendedString) -> bool: ...
	@staticmethod
	def ConvertEUCToUnicode(fromstr: str, tostr: TCollection_ExtendedString) -> None: ...
	@overload
	@staticmethod
	def ConvertFormatToUnicode(theFromStr: str, theToStr: TCollection_ExtendedString) -> None: ...
	@overload
	@staticmethod
	def ConvertFormatToUnicode(theFormat: Resource_FormatType, theFromStr: str, theToStr: TCollection_ExtendedString) -> None: ...
	@staticmethod
	def ConvertGBKToUnicode(fromstr: str, tostr: TCollection_ExtendedString) -> bool: ...
	@staticmethod
	def ConvertGBToUnicode(fromstr: str, tostr: TCollection_ExtendedString) -> None: ...
	@staticmethod
	def ConvertSJISToUnicode(fromstr: str, tostr: TCollection_ExtendedString) -> None: ...
	@staticmethod
	def ConvertUnicodeToANSI(fromstr: TCollection_ExtendedString, tostr: Standard_PCharacter, maxsize: int) -> bool: ...
	@staticmethod
	def ConvertUnicodeToEUC(fromstr: TCollection_ExtendedString, tostr: Standard_PCharacter, maxsize: int) -> bool: ...
	@overload
	@staticmethod
	def ConvertUnicodeToFormat(theFormat: Resource_FormatType, theFromStr: TCollection_ExtendedString, theToStr: Standard_PCharacter, theMaxSize: int) -> bool: ...
	@overload
	@staticmethod
	def ConvertUnicodeToFormat(theFromStr: TCollection_ExtendedString, theToStr: Standard_PCharacter, theMaxSize: int) -> bool: ...
	@staticmethod
	def ConvertUnicodeToGB(fromstr: TCollection_ExtendedString, tostr: Standard_PCharacter, maxsize: int) -> bool: ...
	@staticmethod
	def ConvertUnicodeToSJIS(fromstr: TCollection_ExtendedString, tostr: Standard_PCharacter, maxsize: int) -> bool: ...
	@staticmethod
	def GetFormat() -> Resource_FormatType: ...
	@staticmethod
	def ReadFormat() -> None: ...
	@staticmethod
	def SetFormat(typecode: Resource_FormatType) -> None: ...

# harray1 classes
# harray2 classes
# hsequence classes

Resource_Manager_GetResourcePath = Resource_Manager.GetResourcePath
Resource_Unicode_ConvertANSIToUnicode = Resource_Unicode.ConvertANSIToUnicode
Resource_Unicode_ConvertBig5ToUnicode = Resource_Unicode.ConvertBig5ToUnicode
Resource_Unicode_ConvertEUCToUnicode = Resource_Unicode.ConvertEUCToUnicode
Resource_Unicode_ConvertFormatToUnicode = Resource_Unicode.ConvertFormatToUnicode
Resource_Unicode_ConvertFormatToUnicode = Resource_Unicode.ConvertFormatToUnicode
Resource_Unicode_ConvertGBKToUnicode = Resource_Unicode.ConvertGBKToUnicode
Resource_Unicode_ConvertGBToUnicode = Resource_Unicode.ConvertGBToUnicode
Resource_Unicode_ConvertSJISToUnicode = Resource_Unicode.ConvertSJISToUnicode
Resource_Unicode_ConvertUnicodeToANSI = Resource_Unicode.ConvertUnicodeToANSI
Resource_Unicode_ConvertUnicodeToEUC = Resource_Unicode.ConvertUnicodeToEUC
Resource_Unicode_ConvertUnicodeToFormat = Resource_Unicode.ConvertUnicodeToFormat
Resource_Unicode_ConvertUnicodeToFormat = Resource_Unicode.ConvertUnicodeToFormat
Resource_Unicode_ConvertUnicodeToGB = Resource_Unicode.ConvertUnicodeToGB
Resource_Unicode_ConvertUnicodeToSJIS = Resource_Unicode.ConvertUnicodeToSJIS
Resource_Unicode_GetFormat = Resource_Unicode.GetFormat
Resource_Unicode_ReadFormat = Resource_Unicode.ReadFormat
Resource_Unicode_SetFormat = Resource_Unicode.SetFormat
