# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
Poly module, see official documentation at
https://www.opencascade.com/doc/occt-7.4.0/refman/html/package_poly.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _Poly
else:
    import _Poly

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Poly.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _Poly.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _Poly.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _Poly.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _Poly.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _Poly.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _Poly.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _Poly.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _Poly.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _Poly.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _Poly.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _Poly.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _Poly.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _Poly.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _Poly.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _Poly.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _Poly.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _Poly:
_Poly.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _Poly.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.TColgp
import OCC.Core.TShort

from enum import IntEnum
from OCC.Core.Exception import *




def Handle_Poly_Polygon2D_Create() -> "opencascade::handle< Poly_Polygon2D >":
    return _Poly.Handle_Poly_Polygon2D_Create()

def Handle_Poly_Polygon2D_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Poly_Polygon2D >":
    return _Poly.Handle_Poly_Polygon2D_DownCast(t)

def Handle_Poly_Polygon2D_IsNull(t: "opencascade::handle< Poly_Polygon2D > const &") -> "bool":
    return _Poly.Handle_Poly_Polygon2D_IsNull(t)

def Handle_Poly_Polygon3D_Create() -> "opencascade::handle< Poly_Polygon3D >":
    return _Poly.Handle_Poly_Polygon3D_Create()

def Handle_Poly_Polygon3D_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Poly_Polygon3D >":
    return _Poly.Handle_Poly_Polygon3D_DownCast(t)

def Handle_Poly_Polygon3D_IsNull(t: "opencascade::handle< Poly_Polygon3D > const &") -> "bool":
    return _Poly.Handle_Poly_Polygon3D_IsNull(t)

def Handle_Poly_PolygonOnTriangulation_Create() -> "opencascade::handle< Poly_PolygonOnTriangulation >":
    return _Poly.Handle_Poly_PolygonOnTriangulation_Create()

def Handle_Poly_PolygonOnTriangulation_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Poly_PolygonOnTriangulation >":
    return _Poly.Handle_Poly_PolygonOnTriangulation_DownCast(t)

def Handle_Poly_PolygonOnTriangulation_IsNull(t: "opencascade::handle< Poly_PolygonOnTriangulation > const &") -> "bool":
    return _Poly.Handle_Poly_PolygonOnTriangulation_IsNull(t)

def Handle_Poly_Triangulation_Create() -> "opencascade::handle< Poly_Triangulation >":
    return _Poly.Handle_Poly_Triangulation_Create()

def Handle_Poly_Triangulation_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Poly_Triangulation >":
    return _Poly.Handle_Poly_Triangulation_DownCast(t)

def Handle_Poly_Triangulation_IsNull(t: "opencascade::handle< Poly_Triangulation > const &") -> "bool":
    return _Poly.Handle_Poly_Triangulation_IsNull(t)

def Handle_Poly_HArray1OfTriangle_Create() -> "opencascade::handle< Poly_HArray1OfTriangle >":
    return _Poly.Handle_Poly_HArray1OfTriangle_Create()

def Handle_Poly_HArray1OfTriangle_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< Poly_HArray1OfTriangle >":
    return _Poly.Handle_Poly_HArray1OfTriangle_DownCast(t)

def Handle_Poly_HArray1OfTriangle_IsNull(t: "opencascade::handle< Poly_HArray1OfTriangle > const &") -> "bool":
    return _Poly.Handle_Poly_HArray1OfTriangle_IsNull(t)
class Poly_Array1OfTriangle(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self) -> "NCollection_Array1< Poly_Triangle >::iterator":
        return _Poly.Poly_Array1OfTriangle_begin(self)

    def end(self) -> "NCollection_Array1< Poly_Triangle >::iterator":
        return _Poly.Poly_Array1OfTriangle_end(self)

    def cbegin(self) -> "NCollection_Array1< Poly_Triangle >::const_iterator":
        return _Poly.Poly_Array1OfTriangle_cbegin(self)

    def cend(self) -> "NCollection_Array1< Poly_Triangle >::const_iterator":
        return _Poly.Poly_Array1OfTriangle_cend(self)

    def __init__(self, *args):
        _Poly.Poly_Array1OfTriangle_swiginit(self, _Poly.new_Poly_Array1OfTriangle(*args))

    def Init(self, theValue: "Poly_Triangle") -> "void":
        return _Poly.Poly_Array1OfTriangle_Init(self, theValue)

    def Size(self) -> "Standard_Integer":
        return _Poly.Poly_Array1OfTriangle_Size(self)

    def Length(self) -> "Standard_Integer":
        return _Poly.Poly_Array1OfTriangle_Length(self)

    def IsEmpty(self) -> "Standard_Boolean":
        return _Poly.Poly_Array1OfTriangle_IsEmpty(self)

    def Lower(self) -> "Standard_Integer":
        return _Poly.Poly_Array1OfTriangle_Lower(self)

    def Upper(self) -> "Standard_Integer":
        return _Poly.Poly_Array1OfTriangle_Upper(self)

    def IsDeletable(self) -> "Standard_Boolean":
        return _Poly.Poly_Array1OfTriangle_IsDeletable(self)

    def IsAllocated(self) -> "Standard_Boolean":
        return _Poly.Poly_Array1OfTriangle_IsAllocated(self)

    def Assign(self, theOther: "Poly_Array1OfTriangle") -> "NCollection_Array1< Poly_Triangle > &":
        return _Poly.Poly_Array1OfTriangle_Assign(self, theOther)

    def Move(self, theOther: "Poly_Array1OfTriangle") -> "NCollection_Array1< Poly_Triangle > &":
        return _Poly.Poly_Array1OfTriangle_Move(self, theOther)

    def Set(self, *args) -> "NCollection_Array1< Poly_Triangle > &":
        return _Poly.Poly_Array1OfTriangle_Set(self, *args)

    def First(self) -> "Poly_Triangle const &":
        return _Poly.Poly_Array1OfTriangle_First(self)

    def ChangeFirst(self) -> "Poly_Triangle &":
        return _Poly.Poly_Array1OfTriangle_ChangeFirst(self)

    def Last(self) -> "Poly_Triangle const &":
        return _Poly.Poly_Array1OfTriangle_Last(self)

    def ChangeLast(self) -> "Poly_Triangle &":
        return _Poly.Poly_Array1OfTriangle_ChangeLast(self)

    def Value(self, theIndex: "Standard_Integer const") -> "Poly_Triangle const &":
        return _Poly.Poly_Array1OfTriangle_Value(self, theIndex)

    def ChangeValue(self, theIndex: "Standard_Integer const") -> "Poly_Triangle &":
        return _Poly.Poly_Array1OfTriangle_ChangeValue(self, theIndex)

    def __call__(self, *args) -> "Poly_Triangle &":
        return _Poly.Poly_Array1OfTriangle___call__(self, *args)

    def SetValue(self, theIndex: "Standard_Integer const", theItem: "Poly_Triangle") -> "void":
        return _Poly.Poly_Array1OfTriangle_SetValue(self, theIndex, theItem)

    def Resize(self, theLower: "Standard_Integer const", theUpper: "Standard_Integer const", theToCopyData: "Standard_Boolean const") -> "void":
        return _Poly.Poly_Array1OfTriangle_Resize(self, theLower, theUpper, theToCopyData)
    __swig_destroy__ = _Poly.delete_Poly_Array1OfTriangle

    def __getitem__(self, index):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            return self.Value(index + self.Lower())

    def __setitem__(self, index, value):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            self.SetValue(index + self.Lower(), value)

    def __len__(self):
        return self.Length()

    def __iter__(self):
        self.low = self.Lower()
        self.up = self.Upper()
        self.current = self.Lower() - 1
        return self

    def next(self):
        if self.current >= self.Upper():
            raise StopIteration
        else:
            self.current += 1
        return self.Value(self.current)

    __next__ = next


# Register Poly_Array1OfTriangle in _Poly:
_Poly.Poly_Array1OfTriangle_swigregister(Poly_Array1OfTriangle)

class Poly_ListOfTriangulation(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self) -> "NCollection_List< opencascade::handle< Poly_Triangulation > >::iterator":
        return _Poly.Poly_ListOfTriangulation_begin(self)

    def end(self) -> "NCollection_List< opencascade::handle< Poly_Triangulation > >::iterator":
        return _Poly.Poly_ListOfTriangulation_end(self)

    def cbegin(self) -> "NCollection_List< opencascade::handle< Poly_Triangulation > >::const_iterator":
        return _Poly.Poly_ListOfTriangulation_cbegin(self)

    def cend(self) -> "NCollection_List< opencascade::handle< Poly_Triangulation > >::const_iterator":
        return _Poly.Poly_ListOfTriangulation_cend(self)

    def __init__(self, *args):
        _Poly.Poly_ListOfTriangulation_swiginit(self, _Poly.new_Poly_ListOfTriangulation(*args))

    def Size(self) -> "Standard_Integer":
        return _Poly.Poly_ListOfTriangulation_Size(self)

    def Assign(self, theOther: "Poly_ListOfTriangulation") -> "NCollection_List< opencascade::handle< Poly_Triangulation > > &":
        return _Poly.Poly_ListOfTriangulation_Assign(self, theOther)

    def Set(self, theOther: "Poly_ListOfTriangulation") -> "NCollection_List< opencascade::handle< Poly_Triangulation > > &":
        return _Poly.Poly_ListOfTriangulation_Set(self, theOther)

    def Clear(self, theAllocator: "opencascade::handle< NCollection_BaseAllocator > const &"=0) -> "void":
        return _Poly.Poly_ListOfTriangulation_Clear(self, theAllocator)

    def First(self) -> "opencascade::handle< Poly_Triangulation > const &":
        return _Poly.Poly_ListOfTriangulation_First(self)

    def Last(self) -> "opencascade::handle< Poly_Triangulation > const &":
        return _Poly.Poly_ListOfTriangulation_Last(self)

    def Append(self, *args) -> "void":
        return _Poly.Poly_ListOfTriangulation_Append(self, *args)

    def Prepend(self, *args) -> "void":
        return _Poly.Poly_ListOfTriangulation_Prepend(self, *args)

    def RemoveFirst(self) -> "void":
        return _Poly.Poly_ListOfTriangulation_RemoveFirst(self)

    def Remove(self, theIter: "NCollection_List< opencascade::handle< Poly_Triangulation > >::Iterator &") -> "void":
        return _Poly.Poly_ListOfTriangulation_Remove(self, theIter)

    def InsertBefore(self, *args) -> "void":
        return _Poly.Poly_ListOfTriangulation_InsertBefore(self, *args)

    def InsertAfter(self, *args) -> "void":
        return _Poly.Poly_ListOfTriangulation_InsertAfter(self, *args)

    def Reverse(self) -> "void":
        return _Poly.Poly_ListOfTriangulation_Reverse(self)
    __swig_destroy__ = _Poly.delete_Poly_ListOfTriangulation

    def __len__(self):
        return self.Size()


# Register Poly_ListOfTriangulation in _Poly:
_Poly.Poly_ListOfTriangulation_swigregister(Poly_ListOfTriangulation)

class poly(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Catenate(*args) -> "opencascade::handle< Poly_Triangulation >":
        r"""
        Computes and stores the link from nodes to triangles and from triangles to neighbouring triangles. this tool is obsolete, replaced by poly_coherenttriangulation algorithm to make minimal loops in a graph join several triangulations to one new triangulation object. the new triangulation is just a mechanical sum of input triangulations, without node sharing. uv coordinates are dropped in the result.

        Parameters
        ----------
        lstTri: Poly_ListOfTriangulation

        Returns
        -------
        opencascade::handle<Poly_Triangulation>

        """
        return _Poly.poly_Catenate(*args)

    @staticmethod
    def ComputeNormals(*args) -> "void":
        r"""
        Compute node normals for face triangulation as mean normal of surrounding triangles.

        Parameters
        ----------
        Tri: Poly_Triangulation

        Returns
        -------
        None

        """
        return _Poly.poly_ComputeNormals(*args)

    @staticmethod
    def PointOnTriangle(*args) -> "Standard_Real":
        r"""
        Computes parameters of the point p on triangle defined by points p1, p2, and p3, in 2d. the parameters u and v are defined so that p = p1 + u * (p2 - p1) + v * (p3 - p1), with u >= 0, v >= 0, u + v <= 1. if p is located outside of triangle, or triangle is degenerated, the returned parameters correspond to closest point, and returned value is square of the distance from original point to triangle (0 if point is inside).

        Parameters
        ----------
        P1: gp_XY
        P2: gp_XY
        P3: gp_XY
        P: gp_XY
        UV: gp_XY

        Returns
        -------
        float

        """
        return _Poly.poly_PointOnTriangle(*args)

    def ReadPolygon2DFromString(self, src: "std::string") -> "void":
        r"""ReadPolygon2DFromString(poly self, std::string src)"""
        return _Poly.poly_ReadPolygon2DFromString(self, src)

    def ReadPolygon3DFromString(self, src: "std::string") -> "void":
        r"""ReadPolygon3DFromString(poly self, std::string src)"""
        return _Poly.poly_ReadPolygon3DFromString(self, src)

    def ReadTriangulationFromString(self, src: "std::string") -> "void":
        r"""ReadTriangulationFromString(poly self, std::string src)"""
        return _Poly.poly_ReadTriangulationFromString(self, src)

    __repr__ = _dumps_object

    @methodnotwrapped
    def PolygonProperties(self):
    	pass


    def __init__(self):
        r"""__init__(poly self) -> poly"""
        _Poly.poly_swiginit(self, _Poly.new_poly())
    __swig_destroy__ = _Poly.delete_poly

# Register poly in _Poly:
_Poly.poly_swigregister(poly)

def poly_Catenate(*args) -> "opencascade::handle< Poly_Triangulation >":
    r"""
    Computes and stores the link from nodes to triangles and from triangles to neighbouring triangles. this tool is obsolete, replaced by poly_coherenttriangulation algorithm to make minimal loops in a graph join several triangulations to one new triangulation object. the new triangulation is just a mechanical sum of input triangulations, without node sharing. uv coordinates are dropped in the result.

    Parameters
    ----------
    lstTri: Poly_ListOfTriangulation

    Returns
    -------
    opencascade::handle<Poly_Triangulation>

    """
    return _Poly.poly_Catenate(*args)

def poly_ComputeNormals(*args) -> "void":
    r"""
    Compute node normals for face triangulation as mean normal of surrounding triangles.

    Parameters
    ----------
    Tri: Poly_Triangulation

    Returns
    -------
    None

    """
    return _Poly.poly_ComputeNormals(*args)

def poly_PointOnTriangle(*args) -> "Standard_Real":
    r"""
    Computes parameters of the point p on triangle defined by points p1, p2, and p3, in 2d. the parameters u and v are defined so that p = p1 + u * (p2 - p1) + v * (p3 - p1), with u >= 0, v >= 0, u + v <= 1. if p is located outside of triangle, or triangle is degenerated, the returned parameters correspond to closest point, and returned value is square of the distance from original point to triangle (0 if point is inside).

    Parameters
    ----------
    P1: gp_XY
    P2: gp_XY
    P3: gp_XY
    P: gp_XY
    UV: gp_XY

    Returns
    -------
    float

    """
    return _Poly.poly_PointOnTriangle(*args)

class Poly_CoherentLink(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        /** * empty constructor. */.

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        iNode0: int
        iNode1: int

        Returns
        -------
        None
        /** * constructor, takes a triangle and a side. a link is created always such * that mynode[0] < mynode[1]. unlike the previous constructor, this one * assigns the 'opposite node' fields. this constructor is used when a * link is inserted into a poly_coherenttriangulation structure. * @param thetri * triangle containing the link that is created * @param iside * can be 0, 1 or 2. index of the node */.

        Parameters
        ----------
        theTri: Poly_CoherentTriangle
        iSide: int

        Returns
        -------
        None

        """
        _Poly.Poly_CoherentLink_swiginit(self, _Poly.new_Poly_CoherentLink(*args))

    def GetAttribute(self, *args) -> "Standard_Address":
        r"""
        /** * query the attribute of the link. */.

        Returns
        -------
        Standard_Address

        """
        return _Poly.Poly_CoherentLink_GetAttribute(self, *args)

    def IsEmpty(self, *args) -> "Standard_Boolean":
        r"""
        /** * query the status of the link - if it is an invalid one. * an invalid link has node members equal to -1. */.

        Returns
        -------
        bool

        """
        return _Poly.Poly_CoherentLink_IsEmpty(self, *args)

    def Node(self, *args) -> "Standard_Integer":
        r"""
        /** * return the node index in the current triangulation. * @param ind * 0 or 1 making distinction of the two nodes that constitute the link. * node(0) always returns a smaller number than node(1). */.

        Parameters
        ----------
        ind: int

        Returns
        -------
        int

        """
        return _Poly.Poly_CoherentLink_Node(self, *args)

    def Nullify(self, *args) -> "void":
        r"""
        /** * invalidate this link. */.

        Returns
        -------
        None

        """
        return _Poly.Poly_CoherentLink_Nullify(self, *args)

    def OppositeNode(self, *args) -> "Standard_Integer":
        r"""
        /** * return the opposite node (belonging to the left or right incident triangle) * index in the current triangulation. * @param ind * 0 or 1 making distinction of the two involved triangles: 0 on the left, * 1 on the right side of the link. */.

        Parameters
        ----------
        ind: int

        Returns
        -------
        int

        """
        return _Poly.Poly_CoherentLink_OppositeNode(self, *args)

    def SetAttribute(self, *args) -> "void":
        r"""
        /** * set the attribute of the link. */.

        Parameters
        ----------
        theAtt: Standard_Address

        Returns
        -------
        None

        """
        return _Poly.Poly_CoherentLink_SetAttribute(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_CoherentLink

# Register Poly_CoherentLink in _Poly:
_Poly.Poly_CoherentLink_swigregister(Poly_CoherentLink)

class Poly_CoherentNode(OCC.Core.gp.gp_XYZ):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        /** * empty constructor. */.

        Returns
        -------
        None
        /** * constructor. */.

        Parameters
        ----------
        thePnt: gp_XYZ

        Returns
        -------
        None

        """
        _Poly.Poly_CoherentNode_swiginit(self, _Poly.new_Poly_CoherentNode(*args))

    def AddTriangle(self, *args) -> "void":
        r"""
        /** * connect a triangle to this node. */.

        Parameters
        ----------
        theTri: Poly_CoherentTriangle
        theA: NCollection_BaseAllocator

        Returns
        -------
        None

        """
        return _Poly.Poly_CoherentNode_AddTriangle(self, *args)

    def Clear(self, *args) -> "void":
        r"""
        /** * reset the node to void. */.

        Parameters
        ----------
        &: NCollection_BaseAllocator

        Returns
        -------
        None

        """
        return _Poly.Poly_CoherentNode_Clear(self, *args)

    def DumpToString(self) -> "std::string":
        r"""DumpToString(Poly_CoherentNode self) -> std::string"""
        return _Poly.Poly_CoherentNode_DumpToString(self)

    def GetIndex(self, *args) -> "Standard_Integer":
        r"""
        /** * get the value of node index. */.

        Returns
        -------
        int

        """
        return _Poly.Poly_CoherentNode_GetIndex(self, *args)

    def GetNormal(self, *args) -> "gp_XYZ":
        r"""
        /** * get the stored normal in the node. */.

        Returns
        -------
        gp_XYZ

        """
        return _Poly.Poly_CoherentNode_GetNormal(self, *args)

    def GetU(self, *args) -> "Standard_Real":
        r"""
        /** * get u coordinate of the node. */.

        Returns
        -------
        float

        """
        return _Poly.Poly_CoherentNode_GetU(self, *args)

    def GetV(self, *args) -> "Standard_Real":
        r"""
        /** * get v coordinate of the node. */.

        Returns
        -------
        float

        """
        return _Poly.Poly_CoherentNode_GetV(self, *args)

    def HasNormal(self, *args) -> "Standard_Boolean":
        r"""
        /** * query if the node contains a normal vector. */.

        Returns
        -------
        bool

        """
        return _Poly.Poly_CoherentNode_HasNormal(self, *args)

    def IsFreeNode(self, *args) -> "Standard_Boolean":
        r"""
        /** * check if this is a free node, i.e., a node without a single * incident triangle. */.

        Returns
        -------
        bool

        """
        return _Poly.Poly_CoherentNode_IsFreeNode(self, *args)

    def RemoveTriangle(self, *args) -> "Standard_Boolean":
        r"""
        /** * disconnect a triangle from this node. */.

        Parameters
        ----------
        theTri: Poly_CoherentTriangle
        theA: NCollection_BaseAllocator

        Returns
        -------
        bool

        """
        return _Poly.Poly_CoherentNode_RemoveTriangle(self, *args)

    def SetIndex(self, *args) -> "void":
        r"""
        /** * set the value of node index. */.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        None

        """
        return _Poly.Poly_CoherentNode_SetIndex(self, *args)

    def SetNormal(self, *args) -> "void":
        r"""
        /** * define the normal vector in the node. */.

        Parameters
        ----------
        theVector: gp_XYZ

        Returns
        -------
        None

        """
        return _Poly.Poly_CoherentNode_SetNormal(self, *args)

    def SetUV(self, *args) -> "void":
        r"""
        /** * set the uv coordinates of the node. */.

        Parameters
        ----------
        theU: float
        theV: float

        Returns
        -------
        None

        """
        return _Poly.Poly_CoherentNode_SetUV(self, *args)

    def TriangleIterator(self, *args) -> "Poly_CoherentTriPtr::Iterator":
        r"""
        /** * create an iterator of incident triangles. */.

        Returns
        -------
        Poly_CoherentTriPtr::Iterator

        """
        return _Poly.Poly_CoherentNode_TriangleIterator(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_CoherentNode

# Register Poly_CoherentNode in _Poly:
_Poly.Poly_CoherentNode_swigregister(Poly_CoherentNode)

class Poly_CoherentTriangle(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        /** * empty constructor. */.

        Returns
        -------
        None
        /** * constructor. */.

        Parameters
        ----------
        iNode0: int
        iNode1: int
        iNode2: int

        Returns
        -------
        None

        """
        _Poly.Poly_CoherentTriangle_swiginit(self, _Poly.new_Poly_CoherentTriangle(*args))

    def FindConnection(self, *args) -> "Standard_Integer":
        r"""
        /** * retuns the index of the connection with the given triangle, or -1 if not * found. */.

        Parameters
        ----------
        &: Poly_CoherentTriangle

        Returns
        -------
        int

        """
        return _Poly.Poly_CoherentTriangle_FindConnection(self, *args)

    def GetConnectedNode(self, *args) -> "Standard_Integer":
        r"""
        /** * query the connected node on the given side. * returns -1 if there is no connection on the specified side. */.

        Parameters
        ----------
        iConn: int

        Returns
        -------
        int

        """
        return _Poly.Poly_CoherentTriangle_GetConnectedNode(self, *args)

    def GetConnectedTri(self, *args) -> "Poly_CoherentTriangle const *":
        r"""
        /** * query the connected triangle on the given side. * returns null if there is no connection on the specified side. */.

        Parameters
        ----------
        iConn: int

        Returns
        -------
        Poly_CoherentTriangle *

        """
        return _Poly.Poly_CoherentTriangle_GetConnectedTri(self, *args)

    def GetLink(self, *args) -> "Poly_CoherentLink const *":
        r"""
        /** * query the link associate with the given side of the triangle. * may return null if there are no links in the triangulation. */.

        Parameters
        ----------
        iLink: int

        Returns
        -------
        Poly_CoherentLink *

        """
        return _Poly.Poly_CoherentTriangle_GetLink(self, *args)

    def IsEmpty(self, *args) -> "Standard_Boolean":
        r"""
        /** * query if this is a valid triangle. */.

        Returns
        -------
        bool

        """
        return _Poly.Poly_CoherentTriangle_IsEmpty(self, *args)

    def NConnections(self, *args) -> "Standard_Integer":
        r"""
        /** * query the number of connected triangles. */.

        Returns
        -------
        int

        """
        return _Poly.Poly_CoherentTriangle_NConnections(self, *args)

    def Node(self, *args) -> "Standard_Integer":
        r"""
        /** * query the node index in the position given by the parameter 'ind' */.

        Parameters
        ----------
        ind: int

        Returns
        -------
        int

        """
        return _Poly.Poly_CoherentTriangle_Node(self, *args)

    def RemoveConnection(self, *args) -> "Standard_Boolean":
        r"""
        /** * remove the connection with the given index. * @param iconn * can be 0, 1 or 2 - index of the node that is opposite to the connection * (shared link). */.

        Parameters
        ----------
        iConn: int

        Returns
        -------
        None
        /** * remove the connection with the given triangle. * returns * true if successfuol or false if the connection has not been found. */.

        Parameters
        ----------
        theTri: Poly_CoherentTriangle

        Returns
        -------
        bool

        """
        return _Poly.Poly_CoherentTriangle_RemoveConnection(self, *args)

    def SetConnection(self, *args) -> "Standard_Boolean":
        r"""
        /** * create connection with another triangle thetri. * this method creates both connections: in this triangle and in thetri. you * do not need to call the same method on triangle thetr. * @param iconn * can be 0, 1 or 2 - index of the node that is opposite to the connection * (shared link). * @param thetr * triangle that is connected on the given link. * returns * true if successful, false if the connection is rejected * due to improper topology. */.

        Parameters
        ----------
        iConn: int
        theTr: Poly_CoherentTriangle

        Returns
        -------
        bool
        /** * create connection with another triangle thetri. * this method creates both connections: in this triangle and in thetri. * this method is slower than the previous one, because it makes analysis * what sides of both triangles are connected. * @param thetri * triangle that is connected. * returns * true if successful, false if the connection is rejected * due to improper topology. */.

        Parameters
        ----------
        theTri: Poly_CoherentTriangle

        Returns
        -------
        bool

        """
        return _Poly.Poly_CoherentTriangle_SetConnection(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_CoherentTriangle

# Register Poly_CoherentTriangle in _Poly:
_Poly.Poly_CoherentTriangle_swigregister(Poly_CoherentTriangle)

class Poly_Connect(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs an uninitialized algorithm.

        Returns
        -------
        None
        Constructs an algorithm to explore the adjacency data of nodes or triangles for the triangulation t.

        Parameters
        ----------
        theTriangulation: Poly_Triangulation

        Returns
        -------
        None

        """
        _Poly.Poly_Connect_swiginit(self, _Poly.new_Poly_Connect(*args))

    def Initialize(self, *args) -> "void":
        r"""
        Initializes an iterator to search for all the triangles containing the node referenced at index n in the nodes table, for the triangulation analyzed by this tool. the iterator is managed by the following functions: - more, which checks if there are still elements in the iterator - next, which positions the iterator on the next element - value, which returns the current element. the use of such an iterator provides direct access to the triangles around a particular node, i.e. it avoids iterating on all the component triangles of a triangulation. example poly_connect c(tr); for (c.initialize(n1);c.more();c.next()) { t = c.value(); }.

        Parameters
        ----------
        N: int

        Returns
        -------
        None

        """
        return _Poly.Poly_Connect_Initialize(self, *args)

    def Load(self, *args) -> "void":
        r"""
        Initialize the algorithm to explore the adjacency data of nodes or triangles for the triangulation thetriangulation.

        Parameters
        ----------
        theTriangulation: Poly_Triangulation

        Returns
        -------
        None

        """
        return _Poly.Poly_Connect_Load(self, *args)

    def More(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if there is another element in the iterator defined with the function initialize (i.e. if there is another triangle containing the given node).

        Returns
        -------
        bool

        """
        return _Poly.Poly_Connect_More(self, *args)

    def Next(self, *args) -> "void":
        r"""
        Advances the iterator defined with the function initialize to access the next triangle. note: there is no action if the iterator is empty (i.e. if the function more returns false).-.

        Returns
        -------
        None

        """
        return _Poly.Poly_Connect_Next(self, *args)

    def Nodes(self, *args) -> "void":
        r"""
        Returns, in n1, n2 and n3, the indices of the 3 nodes adjacent to the triangle referenced at index t in the triangles table specific to the triangulation analyzed by this tool. warning null indices are returned when there are fewer than 3 adjacent nodes.

        Parameters
        ----------
        T: int

        Returns
        -------
        n1: int
        n2: int
        n3: int

        """
        return _Poly.Poly_Connect_Nodes(self, *args)

    def Triangle(self, *args) -> "Standard_Integer":
        r"""
        Returns the index of a triangle containing the node at index n in the nodes table specific to the triangulation analyzed by this tool.

        Parameters
        ----------
        N: int

        Returns
        -------
        int

        """
        return _Poly.Poly_Connect_Triangle(self, *args)

    def Triangles(self, *args) -> "void":
        r"""
        Returns in t1, t2 and t3, the indices of the 3 triangles adjacent to the triangle at index t in the triangles table specific to the triangulation analyzed by this tool. warning null indices are returned when there are fewer than 3 adjacent triangles.

        Parameters
        ----------
        T: int

        Returns
        -------
        t1: int
        t2: int
        t3: int

        """
        return _Poly.Poly_Connect_Triangles(self, *args)

    def Triangulation(self, *args) -> "opencascade::handle< Poly_Triangulation > const &":
        r"""
        Returns the triangulation analyzed by this tool.

        Returns
        -------
        opencascade::handle<Poly_Triangulation>

        """
        return _Poly.Poly_Connect_Triangulation(self, *args)

    def Value(self, *args) -> "Standard_Integer":
        r"""
        Returns the index of the current triangle to which the iterator, defined with the function initialize, points. this is an index in the triangles table specific to the triangulation analyzed by this tool.

        Returns
        -------
        int

        """
        return _Poly.Poly_Connect_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_Connect

# Register Poly_Connect in _Poly:
_Poly.Poly_Connect_swigregister(Poly_Connect)

class Poly_Polygon2D(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs a 2d polygon defined by the table of points, <nodes>.

        Parameters
        ----------
        Nodes: TColgp_Array1OfPnt2d

        Returns
        -------
        None

        """
        _Poly.Poly_Polygon2D_swiginit(self, _Poly.new_Poly_Polygon2D(*args))

    def Deflection(self, *args) -> "void":
        r"""
        Returns the deflection of this polygon. deflection is used in cases where the polygon is an approximate representation of a curve. deflection represents the maximum distance permitted between any point on the curve and the corresponding point on the polygon. by default the deflection value is equal to 0. an algorithm using this 2d polygon with a deflection value equal to 0 considers that it is working with a true polygon and not with an approximate representation of a curve. the deflection function is used to modify the deflection value of this polygon. the deflection value can be used by any algorithm working with 2d polygons. for example: - an algorithm may use a unique deflection value for all its polygons. in this case it is not necessary to use the deflection function. - or an algorithm may want to attach a different deflection to each polygon. in this case, the deflection function is used to set a value on each polygon, and later to fetch the value.

        Returns
        -------
        float
        Sets the deflection of this polygon to d.

        Parameters
        ----------
        D: float

        Returns
        -------
        None

        """
        return _Poly.Poly_Polygon2D_Deflection(self, *args)

    def NbNodes(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of nodes in this polygon. note: if the polygon is closed, the point of closure is repeated at the end of its table of nodes. thus, on a closed triangle, the function nbnodes returns 4.

        Returns
        -------
        int

        """
        return _Poly.Poly_Polygon2D_NbNodes(self, *args)

    def Nodes(self, *args) -> "TColgp_Array1OfPnt2d const &":
        r"""
        Returns the table of nodes for this polygon.

        Returns
        -------
        TColgp_Array1OfPnt2d

        """
        return _Poly.Poly_Polygon2D_Nodes(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Poly_Polygon2D_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_Polygon2D

# Register Poly_Polygon2D in _Poly:
_Poly.Poly_Polygon2D_swigregister(Poly_Polygon2D)

class Poly_Polygon3D(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Onstructs a 3d polygon defined by the table of points, nodes.

        Parameters
        ----------
        Nodes: TColgp_Array1OfPnt

        Returns
        -------
        None
        Constructs a 3d polygon defined by the table of points, nodes, and the parallel table of parameters, parameters, where each value of the table parameters is the parameter of the corresponding point on the curve approximated by the constructed polygon. warning both the nodes and parameters tables must have the same bounds. this property is not checked at construction time.

        Parameters
        ----------
        Nodes: TColgp_Array1OfPnt
        Parameters: TColStd_Array1OfReal

        Returns
        -------
        None

        """
        _Poly.Poly_Polygon3D_swiginit(self, _Poly.new_Poly_Polygon3D(*args))

    def ChangeParameters(self, *args) -> "TColStd_Array1OfReal &":
        r"""
        Returns the table of the parameters associated with each node in this polygon. changeparameters function returnes the array as shared. therefore if the table is selected by reference you can, by simply modifying it, directly modify the data structure of this polygon.

        Returns
        -------
        TColStd_Array1OfReal

        """
        return _Poly.Poly_Polygon3D_ChangeParameters(self, *args)

    def Copy(self, *args) -> "opencascade::handle< Poly_Polygon3D >":
        r"""
        Creates a copy of current polygon.

        Returns
        -------
        opencascade::handle<Poly_Polygon3D>

        """
        return _Poly.Poly_Polygon3D_Copy(self, *args)

    def Deflection(self, *args) -> "void":
        r"""
        Returns the deflection of this polygon.

        Returns
        -------
        float
        Sets the deflection of this polygon to d. see more on deflection in poly_polygon2d.

        Parameters
        ----------
        D: float

        Returns
        -------
        None

        """
        return _Poly.Poly_Polygon3D_Deflection(self, *args)

    def HasParameters(self, *args) -> "Standard_Boolean":
        r"""
        Returns the table of the parameters associated with each node in this polygon. hasparameters function checks if parameters are associated with the nodes of this polygon.

        Returns
        -------
        bool

        """
        return _Poly.Poly_Polygon3D_HasParameters(self, *args)

    def NbNodes(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of nodes in this polygon. note: if the polygon is closed, the point of closure is repeated at the end of its table of nodes. thus, on a closed triangle the function nbnodes returns 4.

        Returns
        -------
        int

        """
        return _Poly.Poly_Polygon3D_NbNodes(self, *args)

    def Nodes(self, *args) -> "TColgp_Array1OfPnt const &":
        r"""
        Returns the table of nodes for this polygon.

        Returns
        -------
        TColgp_Array1OfPnt

        """
        return _Poly.Poly_Polygon3D_Nodes(self, *args)

    def Parameters(self, *args) -> "TColStd_Array1OfReal const &":
        r"""
        Returns true if parameters are associated with the nodes in this polygon.

        Returns
        -------
        TColStd_Array1OfReal

        """
        return _Poly.Poly_Polygon3D_Parameters(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Poly_Polygon3D_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_Polygon3D

# Register Poly_Polygon3D in _Poly:
_Poly.Poly_Polygon3D_swigregister(Poly_Polygon3D)

class Poly_PolygonOnTriangulation(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs a 3d polygon on the triangulation of a shape, defined by the table of nodes, <nodes>.

        Parameters
        ----------
        Nodes: TColStd_Array1OfInteger

        Returns
        -------
        None
        Constructs a 3d polygon on the triangulation of a shape, defined by: - the table of nodes, nodes, and the table of parameters, <parameters>. where: - a node value is an index in the table of nodes specific to an existing triangulation of a shape - and a parameter value is the value of the parameter of the corresponding point on the curve approximated by the constructed polygon. warning the tables nodes and parameters must be the same size. this property is not checked at construction time.

        Parameters
        ----------
        Nodes: TColStd_Array1OfInteger
        Parameters: TColStd_Array1OfReal

        Returns
        -------
        None

        """
        _Poly.Poly_PolygonOnTriangulation_swiginit(self, _Poly.new_Poly_PolygonOnTriangulation(*args))

    def Copy(self, *args) -> "opencascade::handle< Poly_PolygonOnTriangulation >":
        r"""
        Creates a copy of current polygon.

        Returns
        -------
        opencascade::handle<Poly_PolygonOnTriangulation>

        """
        return _Poly.Poly_PolygonOnTriangulation_Copy(self, *args)

    def Deflection(self, *args) -> "void":
        r"""
        Returns the deflection of this polygon.

        Returns
        -------
        float
        Sets the deflection of this polygon to d. see more on deflection in poly_polygones2d.

        Parameters
        ----------
        D: float

        Returns
        -------
        None

        """
        return _Poly.Poly_PolygonOnTriangulation_Deflection(self, *args)

    def HasParameters(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if parameters are associated with the nodes in this polygon.

        Returns
        -------
        bool

        """
        return _Poly.Poly_PolygonOnTriangulation_HasParameters(self, *args)

    def NbNodes(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of nodes for this polygon. note: if the polygon is closed, the point of closure is repeated at the end of its table of nodes. thus, on a closed triangle, the function nbnodes returns 4.

        Returns
        -------
        int

        """
        return _Poly.Poly_PolygonOnTriangulation_NbNodes(self, *args)

    def Nodes(self, *args) -> "TColStd_Array1OfInteger const &":
        r"""
        Returns the table of nodes for this polygon. a node value is an index in the table of nodes specific to an existing triangulation of a shape.

        Returns
        -------
        TColStd_Array1OfInteger

        """
        return _Poly.Poly_PolygonOnTriangulation_Nodes(self, *args)

    def Parameters(self, *args) -> "opencascade::handle< TColStd_HArray1OfReal >":
        r"""
        Returns the table of the parameters associated with each node in this polygon. warning use the function hasparameters to check if parameters are associated with the nodes in this polygon.

        Returns
        -------
        opencascade::handle<TColStd_HArray1OfReal>

        """
        return _Poly.Poly_PolygonOnTriangulation_Parameters(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Poly_PolygonOnTriangulation_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_PolygonOnTriangulation

# Register Poly_PolygonOnTriangulation in _Poly:
_Poly.Poly_PolygonOnTriangulation_swigregister(Poly_PolygonOnTriangulation)

class Poly_Triangle(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs a triangle and sets all indices to zero.

        Returns
        -------
        None
        Constructs a triangle and sets its three indices to n1, n2 and n3 respectively, where these node values are indices in the table of nodes specific to an existing triangulation of a shape.

        Parameters
        ----------
        N1: int
        N2: int
        N3: int

        Returns
        -------
        None

        """
        _Poly.Poly_Triangle_swiginit(self, _Poly.new_Poly_Triangle(*args))

    def GetChangeValue(self, Index: "Standard_Integer const") -> "Standard_Integer":
        r"""GetChangeValue(Poly_Triangle self, Standard_Integer const Index) -> Standard_Integer"""
        return _Poly.Poly_Triangle_GetChangeValue(self, Index)

    def SetChangeValue(self, Index: "Standard_Integer const", value: "Standard_Integer") -> "void":
        r"""SetChangeValue(Poly_Triangle self, Standard_Integer const Index, Standard_Integer value)"""
        return _Poly.Poly_Triangle_SetChangeValue(self, Index, value)

    def Get(self, *args) -> "void":
        r"""
        Returns the node indices of this triangle in n1, n2 and n3.

        Parameters
        ----------

        Returns
        -------
        N1: int
        N2: int
        N3: int

        """
        return _Poly.Poly_Triangle_Get(self, *args)

    def Set(self, *args) -> "void":
        r"""
        Sets the value of the three nodes of this triangle to n1, n2 and n3 respectively.

        Parameters
        ----------
        N1: int
        N2: int
        N3: int

        Returns
        -------
        None
        Sets the value of the indexth node of this triangle to node. raises outofrange if index is not in 1,2,3.

        Parameters
        ----------
        Index: int
        Node: int

        Returns
        -------
        None

        """
        return _Poly.Poly_Triangle_Set(self, *args)

    def Value(self, *args) -> "Standard_Integer":
        r"""
        Get the node of given index. raises outofrange from standard if index is not in 1,2,3.

        Parameters
        ----------
        Index: int

        Returns
        -------
        int

        """
        return _Poly.Poly_Triangle_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_Triangle

# Register Poly_Triangle in _Poly:
_Poly.Poly_Triangle_swigregister(Poly_Triangle)

class Poly_Triangulation(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs a triangulation from a set of triangles. the triangulation is initialized without a triangle or a node, but capable of containing nbnodes nodes, and nbtriangles triangles. here the uvnodes flag indicates whether 2d nodes will be associated with 3d ones, (i.e. to enable a 2d representation).

        Parameters
        ----------
        nbNodes: int
        nbTriangles: int
        UVNodes: bool

        Returns
        -------
        None
        Constructs a triangulation from a set of triangles. the triangulation is initialized with 3d points from nodes and triangles from triangles.

        Parameters
        ----------
        Nodes: TColgp_Array1OfPnt
        Triangles: Poly_Array1OfTriangle

        Returns
        -------
        None
        Constructs a triangulation from a set of triangles. the triangulation is initialized with 3d points from nodes, 2d points from uvnodes and triangles from triangles, where coordinates of a 2d point from uvnodes are the (u, v) parameters of the corresponding 3d point from nodes on the surface approximated by the constructed triangulation.

        Parameters
        ----------
        Nodes: TColgp_Array1OfPnt
        UVNodes: TColgp_Array1OfPnt2d
        Triangles: Poly_Array1OfTriangle

        Returns
        -------
        None
        Copy constructor for triangulation.

        Parameters
        ----------
        theTriangulation: Poly_Triangulation

        Returns
        -------
        None

        """
        _Poly.Poly_Triangulation_swiginit(self, _Poly.new_Poly_Triangulation(*args))

    def ChangeNode(self, *args) -> "gp_Pnt":
        r"""
        Give access to the node at the given index. raises standard_outofrange exception if theindex is less than 1 or greater than nbnodes.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        gp_Pnt

        """
        return _Poly.Poly_Triangulation_ChangeNode(self, *args)

    def ChangeNodes(self, *args) -> "TColgp_Array1OfPnt &":
        r"""
        Returns the table of 3d nodes (3d points) for this triangulation. the returned array is shared. therefore if the table is selected by reference, you can, by simply modifying it, directly modify the data structure of this triangulation.

        Returns
        -------
        TColgp_Array1OfPnt

        """
        return _Poly.Poly_Triangulation_ChangeNodes(self, *args)

    def ChangeNormals(self, *args) -> "TShort_Array1OfShortReal &":
        r"""
        Gives access to the table of node normals.

        Returns
        -------
        TShort_Array1OfShortReal

        """
        return _Poly.Poly_Triangulation_ChangeNormals(self, *args)

    def ChangeTriangle(self, *args) -> "Poly_Triangle &":
        r"""
        Give access to the triangle at the given index. raises standard_outofrange exception if theindex is less than 1 or greater than nbtriangles.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        Poly_Triangle

        """
        return _Poly.Poly_Triangulation_ChangeTriangle(self, *args)

    def ChangeTriangles(self, *args) -> "Poly_Array1OfTriangle &":
        r"""
        Returns the table of triangles for this triangulation. function changeuvnodes shares the returned array. therefore if the table is selected by reference, you can, by simply modifying it, directly modify the data structure of this triangulation.

        Returns
        -------
        Poly_Array1OfTriangle

        """
        return _Poly.Poly_Triangulation_ChangeTriangles(self, *args)

    def ChangeUVNode(self, *args) -> "gp_Pnt2d":
        r"""
        Give access to the uvnode at the given index. raises standard_outofrange exception if theindex is less than 1 or greater than nbnodes.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        gp_Pnt2d

        """
        return _Poly.Poly_Triangulation_ChangeUVNode(self, *args)

    def ChangeUVNodes(self, *args) -> "TColgp_Array1OfPnt2d &":
        r"""
        Returns the table of 2d nodes (2d points) associated with each 3d node of this triangulation. function changeuvnodes shares the returned array. therefore if the table is selected by reference, you can, by simply modifying it, directly modify the data structure of this triangulation.

        Returns
        -------
        TColgp_Array1OfPnt2d

        """
        return _Poly.Poly_Triangulation_ChangeUVNodes(self, *args)

    def Copy(self, *args) -> "opencascade::handle< Poly_Triangulation >":
        r"""
        Creates full copy of current triangulation.

        Returns
        -------
        opencascade::handle<Poly_Triangulation>

        """
        return _Poly.Poly_Triangulation_Copy(self, *args)

    def Deflection(self, *args) -> "void":
        r"""
        Returns the deflection of this triangulation.

        Returns
        -------
        float
        Sets the deflection of this triangulation to thedeflection. see more on deflection in polygon2d.

        Parameters
        ----------
        theDeflection: float

        Returns
        -------
        None

        """
        return _Poly.Poly_Triangulation_Deflection(self, *args)

    def HasNormals(self, *args) -> "Standard_Boolean":
        r"""
        Returns standard_true if nodal normals are defined.

        Returns
        -------
        bool

        """
        return _Poly.Poly_Triangulation_HasNormals(self, *args)

    def HasUVNodes(self, *args) -> "Standard_Boolean":
        r"""
        Returns standard_true if 2d nodes are associated with 3d nodes for this triangulation.

        Returns
        -------
        bool

        """
        return _Poly.Poly_Triangulation_HasUVNodes(self, *args)

    def NbNodes(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of nodes for this triangulation.

        Returns
        -------
        int

        """
        return _Poly.Poly_Triangulation_NbNodes(self, *args)

    def NbTriangles(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of triangles for this triangulation.

        Returns
        -------
        int

        """
        return _Poly.Poly_Triangulation_NbTriangles(self, *args)

    def Node(self, *args) -> "gp_Pnt const":
        r"""
        Returns node at the given index. raises standard_outofrange exception if theindex is less than 1 or greater than nbnodes.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        gp_Pnt

        """
        return _Poly.Poly_Triangulation_Node(self, *args)

    def Nodes(self, *args) -> "TColgp_Array1OfPnt const &":
        r"""
        Returns the table of 3d nodes (3d points) for this triangulation.

        Returns
        -------
        TColgp_Array1OfPnt

        """
        return _Poly.Poly_Triangulation_Nodes(self, *args)

    def Normal(self, *args) -> "gp_Dir":
        r"""
        Returns normal at the given index. raises standard_outofrange exception.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        gp_Dir

        """
        return _Poly.Poly_Triangulation_Normal(self, *args)

    def Normals(self, *args) -> "TShort_Array1OfShortReal const &":
        r"""
        Returns the table of node normals.

        Returns
        -------
        TShort_Array1OfShortReal

        """
        return _Poly.Poly_Triangulation_Normals(self, *args)

    def RemoveUVNodes(self, *args) -> "void":
        r"""
        Deallocates the uv nodes.

        Returns
        -------
        None

        """
        return _Poly.Poly_Triangulation_RemoveUVNodes(self, *args)

    def SetNormal(self, *args) -> "void":
        r"""
        Changes normal at the given index. raises standard_outofrange exception.

        Parameters
        ----------
        theIndex: int
        theNormal: gp_Dir

        Returns
        -------
        None

        """
        return _Poly.Poly_Triangulation_SetNormal(self, *args)

    def SetNormals(self, *args) -> "void":
        r"""
        Sets the table of node normals. raises exception if length of thenormals != 3*nbnodes.

        Parameters
        ----------
        theNormals: TShort_HArray1OfShortReal

        Returns
        -------
        None

        """
        return _Poly.Poly_Triangulation_SetNormals(self, *args)

    def Triangle(self, *args) -> "Poly_Triangle const &":
        r"""
        Returns triangle at the given index. raises standard_outofrange exception if theindex is less than 1 or greater than nbtriangles.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        Poly_Triangle

        """
        return _Poly.Poly_Triangulation_Triangle(self, *args)

    def Triangles(self, *args) -> "Poly_Array1OfTriangle const &":
        r"""
        Returns the table of triangles for this triangulation.

        Returns
        -------
        Poly_Array1OfTriangle

        """
        return _Poly.Poly_Triangulation_Triangles(self, *args)

    def UVNode(self, *args) -> "gp_Pnt2d const":
        r"""
        Returns uvnode at the given index. raises standard_outofrange exception if theindex is less than 1 or greater than nbnodes.

        Parameters
        ----------
        theIndex: int

        Returns
        -------
        gp_Pnt2d

        """
        return _Poly.Poly_Triangulation_UVNode(self, *args)

    def UVNodes(self, *args) -> "TColgp_Array1OfPnt2d const &":
        r"""
        Returns the table of 2d nodes (2d points) associated with each 3d node of this triangulation. the function hasuvnodes checks if 2d nodes are associated with the 3d nodes of this triangulation. const reference on the 2d nodes values.

        Returns
        -------
        TColgp_Array1OfPnt2d

        """
        return _Poly.Poly_Triangulation_UVNodes(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Poly_Triangulation_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_Triangulation

# Register Poly_Triangulation in _Poly:
_Poly.Poly_Triangulation_swigregister(Poly_Triangulation)


@classnotwrapped
class Poly_CoherentTriPtr:
	pass

@classnotwrapped
class Poly_CoherentTriangulation:
	pass

@classnotwrapped
class Poly_MakeLoops:
	pass

@classnotwrapped
class Poly_MakeLoops3D:
	pass

@classnotwrapped
class Poly_MakeLoops2D:
	pass


class Poly_HArray1OfTriangle(Poly_Array1OfTriangle, OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _Poly.Poly_HArray1OfTriangle_swiginit(self, _Poly.new_Poly_HArray1OfTriangle(*args))

    def Array1(self) -> "Poly_Array1OfTriangle const &":
        return _Poly.Poly_HArray1OfTriangle_Array1(self)

    def ChangeArray1(self) -> "Poly_Array1OfTriangle &":
        return _Poly.Poly_HArray1OfTriangle_ChangeArray1(self)


    @staticmethod
    def DownCast(t):
      return Handle_Poly_HArray1OfTriangle_DownCast(t)

    __swig_destroy__ = _Poly.delete_Poly_HArray1OfTriangle

# Register Poly_HArray1OfTriangle in _Poly:
_Poly.Poly_HArray1OfTriangle_swigregister(Poly_HArray1OfTriangle)





