from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TCollection import *
from OCC.Core.TColStd import *
from OCC.Core.Message import *
from OCC.Core.MoniTool import *

#the following typedef cannot be wrapped as is
Interface_IndexedMapOfAsciiString = NewType('Interface_IndexedMapOfAsciiString', Any)
#the following typedef cannot be wrapped as is
Interface_VectorOfFileParameter = NewType('Interface_VectorOfFileParameter', Any)

class Interface_Array1OfFileParameter:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> Interface_FileParameter: ...
    def __setitem__(self, index: int, value: Interface_FileParameter) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[Interface_FileParameter]: ...
    def next(self) -> Interface_FileParameter: ...
    __next__ = next
    def Init(self, theValue: Interface_FileParameter) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> Interface_FileParameter: ...
    def Last(self) -> Interface_FileParameter: ...
    def Value(self, theIndex: int) -> Interface_FileParameter: ...
    def SetValue(self, theIndex: int, theValue: Interface_FileParameter) -> None: ...

class Interface_Array1OfHAsciiString:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> False: ...
    def __setitem__(self, index: int, value: False) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[False]: ...
    def next(self) -> False: ...
    __next__ = next
    def Init(self, theValue: False) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class Interface_SequenceOfCheck:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Length(self) -> int: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class Interface_ParamType(IntEnum):
	Interface_ParamMisc: int = ...
	Interface_ParamInteger: int = ...
	Interface_ParamReal: int = ...
	Interface_ParamIdent: int = ...
	Interface_ParamVoid: int = ...
	Interface_ParamText: int = ...
	Interface_ParamEnum: int = ...
	Interface_ParamLogical: int = ...
	Interface_ParamSub: int = ...
	Interface_ParamHexa: int = ...
	Interface_ParamBinary: int = ...
Interface_ParamMisc = Interface_ParamType.Interface_ParamMisc
Interface_ParamInteger = Interface_ParamType.Interface_ParamInteger
Interface_ParamReal = Interface_ParamType.Interface_ParamReal
Interface_ParamIdent = Interface_ParamType.Interface_ParamIdent
Interface_ParamVoid = Interface_ParamType.Interface_ParamVoid
Interface_ParamText = Interface_ParamType.Interface_ParamText
Interface_ParamEnum = Interface_ParamType.Interface_ParamEnum
Interface_ParamLogical = Interface_ParamType.Interface_ParamLogical
Interface_ParamSub = Interface_ParamType.Interface_ParamSub
Interface_ParamHexa = Interface_ParamType.Interface_ParamHexa
Interface_ParamBinary = Interface_ParamType.Interface_ParamBinary

class Interface_DataState(IntEnum):
	Interface_StateOK: int = ...
	Interface_LoadWarning: int = ...
	Interface_LoadFail: int = ...
	Interface_DataWarning: int = ...
	Interface_DataFail: int = ...
	Interface_StateUnloaded: int = ...
	Interface_StateUnknown: int = ...
Interface_StateOK = Interface_DataState.Interface_StateOK
Interface_LoadWarning = Interface_DataState.Interface_LoadWarning
Interface_LoadFail = Interface_DataState.Interface_LoadFail
Interface_DataWarning = Interface_DataState.Interface_DataWarning
Interface_DataFail = Interface_DataState.Interface_DataFail
Interface_StateUnloaded = Interface_DataState.Interface_StateUnloaded
Interface_StateUnknown = Interface_DataState.Interface_StateUnknown

class Interface_CheckStatus(IntEnum):
	Interface_CheckOK: int = ...
	Interface_CheckWarning: int = ...
	Interface_CheckFail: int = ...
	Interface_CheckAny: int = ...
	Interface_CheckMessage: int = ...
	Interface_CheckNoFail: int = ...
Interface_CheckOK = Interface_CheckStatus.Interface_CheckOK
Interface_CheckWarning = Interface_CheckStatus.Interface_CheckWarning
Interface_CheckFail = Interface_CheckStatus.Interface_CheckFail
Interface_CheckAny = Interface_CheckStatus.Interface_CheckAny
Interface_CheckMessage = Interface_CheckStatus.Interface_CheckMessage
Interface_CheckNoFail = Interface_CheckStatus.Interface_CheckNoFail

class Interface_BitMap:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, nbitems: int, resflags: Optional[int] = 0) -> None: ...
	@overload
	def __init__(self, other: Interface_BitMap, copied: Optional[bool] = False) -> None: ...
	def AddFlag(self, name: Optional[str] = "") -> int: ...
	def AddSomeFlags(self, more: int) -> int: ...
	def CFalse(self, item: int, flag: Optional[int] = 0) -> bool: ...
	def CTrue(self, item: int, flag: Optional[int] = 0) -> bool: ...
	def Clear(self) -> None: ...
	def FlagName(self, num: int) -> str: ...
	def FlagNumber(self, name: str) -> int: ...
	def Init(self, val: bool, flag: Optional[int] = 0) -> None: ...
	@overload
	def Initialize(self, nbitems: int, resflags: Optional[int] = 0) -> None: ...
	@overload
	def Initialize(self, other: Interface_BitMap, copied: Optional[bool] = False) -> None: ...
	def Internals(self, flags: TColStd_HArray1OfInteger, names: TColStd_HSequenceOfAsciiString) -> Tuple[int, int, int]: ...
	def Length(self) -> int: ...
	def NbFlags(self) -> int: ...
	def RemoveFlag(self, num: int) -> bool: ...
	def Reservate(self, moreflags: int) -> None: ...
	def SetFalse(self, item: int, flag: Optional[int] = 0) -> None: ...
	def SetFlagName(self, num: int, name: str) -> bool: ...
	def SetLength(self, nbitems: int) -> None: ...
	def SetTrue(self, item: int, flag: Optional[int] = 0) -> None: ...
	def SetValue(self, item: int, val: bool, flag: Optional[int] = 0) -> None: ...
	def Value(self, item: int, flag: Optional[int] = 0) -> bool: ...

class Interface_Category:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, theProtocol: Interface_Protocol) -> None: ...
	@overload
	def __init__(self, theGTool: Interface_GTool) -> None: ...
	@staticmethod
	def AddCategory(theName: str) -> int: ...
	def CatNum(self, theEnt: Standard_Transient, theShares: Interface_ShareTool) -> int: ...
	def ClearNums(self) -> None: ...
	def Compute(self, theModel: Interface_InterfaceModel, theShares: Interface_ShareTool) -> None: ...
	@staticmethod
	def Init() -> None: ...
	@staticmethod
	def Name(theNum: int) -> str: ...
	@staticmethod
	def NbCategories() -> int: ...
	def Num(self, theNumEnt: int) -> int: ...
	@staticmethod
	def Number(theName: str) -> int: ...
	def SetProtocol(self, theProtocol: Interface_Protocol) -> None: ...

class Interface_Check(Standard_Transient):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, anentity: Standard_Transient) -> None: ...
	@overload
	def AddFail(self, amess: TCollection_HAsciiString) -> None: ...
	@overload
	def AddFail(self, amess: TCollection_HAsciiString, orig: TCollection_HAsciiString) -> None: ...
	@overload
	def AddFail(self, amess: str, orig: Optional[str] = "") -> None: ...
	@overload
	def AddFail(self, amsg: Message_Msg) -> None: ...
	@overload
	def AddWarning(self, amess: TCollection_HAsciiString) -> None: ...
	@overload
	def AddWarning(self, amess: TCollection_HAsciiString, orig: TCollection_HAsciiString) -> None: ...
	@overload
	def AddWarning(self, amess: str, orig: Optional[str] = "") -> None: ...
	@overload
	def AddWarning(self, amsg: Message_Msg) -> None: ...
	def CFail(self, num: int, final: Optional[bool] = True) -> str: ...
	def CInfoMsg(self, num: int, final: Optional[bool] = True) -> str: ...
	def CWarning(self, num: int, final: Optional[bool] = True) -> str: ...
	def Clear(self) -> None: ...
	def ClearFails(self) -> None: ...
	def ClearInfoMsgs(self) -> None: ...
	def ClearWarnings(self) -> None: ...
	@overload
	def Complies(self, status: Interface_CheckStatus) -> bool: ...
	@overload
	def Complies(self, mess: TCollection_HAsciiString, incl: int, status: Interface_CheckStatus) -> bool: ...
	def Entity(self) -> Standard_Transient: ...
	def Fail(self, num: int, final: Optional[bool] = True) -> TCollection_HAsciiString: ...
	def Fails(self, final: Optional[bool] = True) -> TColStd_HSequenceOfHAsciiString: ...
	def GetAsWarning(self, other: Interface_Check, failsonly: bool) -> None: ...
	def GetEntity(self, anentity: Standard_Transient) -> None: ...
	def GetMessages(self, other: Interface_Check) -> None: ...
	def HasEntity(self) -> bool: ...
	def HasFailed(self) -> bool: ...
	def HasWarnings(self) -> bool: ...
	def InfoMsg(self, num: int, final: Optional[bool] = True) -> TCollection_HAsciiString: ...
	def InfoMsgs(self, final: Optional[bool] = True) -> TColStd_HSequenceOfHAsciiString: ...
	def Mend(self, pref: str, num: Optional[int] = 0) -> bool: ...
	def NbFails(self) -> int: ...
	def NbInfoMsgs(self) -> int: ...
	def NbWarnings(self) -> int: ...
	def Print(self, S: Message_Messenger, level: int, final: Optional[int] = 1) -> None: ...
	def Remove(self, mess: TCollection_HAsciiString, incl: int, status: Interface_CheckStatus) -> bool: ...
	def SendFail(self, amsg: Message_Msg) -> None: ...
	def SendMsg(self, amsg: Message_Msg) -> None: ...
	def SendWarning(self, amsg: Message_Msg) -> None: ...
	def SetEntity(self, anentity: Standard_Transient) -> None: ...
	def Status(self) -> Interface_CheckStatus: ...
	def Trace(self, level: Optional[int] = -1, final: Optional[int] = 1) -> None: ...
	def Warning(self, num: int, final: Optional[bool] = True) -> TCollection_HAsciiString: ...
	def Warnings(self, final: Optional[bool] = True) -> TColStd_HSequenceOfHAsciiString: ...

class Interface_CheckIterator:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, name: str) -> None: ...
	def Add(self, ach: Interface_Check, num: Optional[int] = 0) -> None: ...
	@overload
	def CCheck(self, num: int) -> Interface_Check: ...
	@overload
	def CCheck(self, ent: Standard_Transient) -> Interface_Check: ...
	@overload
	def Check(self, num: int) -> Interface_Check: ...
	@overload
	def Check(self, ent: Standard_Transient) -> Interface_Check: ...
	def Checkeds(self, failsonly: bool, global_: bool) -> TColStd_HSequenceOfTransient: ...
	def Clear(self) -> None: ...
	def Complies(self, status: Interface_CheckStatus) -> bool: ...
	def Destroy(self) -> None: ...
	@overload
	def Extract(self, status: Interface_CheckStatus) -> Interface_CheckIterator: ...
	@overload
	def Extract(self, mess: str, incl: int, status: Interface_CheckStatus) -> Interface_CheckIterator: ...
	def IsEmpty(self, failsonly: bool) -> bool: ...
	def Merge(self, other: Interface_CheckIterator) -> None: ...
	def Model(self) -> Interface_InterfaceModel: ...
	def More(self) -> bool: ...
	def Name(self) -> str: ...
	def Next(self) -> None: ...
	def Number(self) -> int: ...
	@overload
	def Print(self, S: Message_Messenger, failsonly: bool, final: Optional[int] = 0) -> None: ...
	@overload
	def Print(self, S: Message_Messenger, model: Interface_InterfaceModel, failsonly: bool, final: Optional[int] = 0) -> None: ...
	def Remove(self, mess: str, incl: int, status: Interface_CheckStatus) -> bool: ...
	def SetModel(self, model: Interface_InterfaceModel) -> None: ...
	def SetName(self, name: str) -> None: ...
	def Start(self) -> None: ...
	def Status(self) -> Interface_CheckStatus: ...
	def Value(self) -> Interface_Check: ...

class Interface_CheckTool:
	@overload
	def __init__(self, model: Interface_InterfaceModel, protocol: Interface_Protocol) -> None: ...
	@overload
	def __init__(self, model: Interface_InterfaceModel) -> None: ...
	@overload
	def __init__(self, graph: Interface_Graph) -> None: ...
	@overload
	def __init__(self, hgraph: Interface_HGraph) -> None: ...
	def AnalyseCheckList(self) -> Interface_CheckIterator: ...
	def Check(self, num: int) -> Interface_Check: ...
	def CheckList(self) -> Interface_CheckIterator: ...
	def CheckSuccess(self, reset: Optional[bool] = False) -> None: ...
	def CompleteCheckList(self) -> Interface_CheckIterator: ...
	def FillCheck(self, ent: Standard_Transient, sh: Interface_ShareTool, ach: Interface_Check) -> None: ...
	@overload
	def Print(self, ach: Interface_Check, S: Message_Messenger) -> None: ...
	@overload
	def Print(self, list: Interface_CheckIterator, S: Message_Messenger) -> None: ...
	def UnknownEntities(self) -> Interface_EntityIterator: ...
	def VerifyCheckList(self) -> Interface_CheckIterator: ...
	def WarningCheckList(self) -> Interface_CheckIterator: ...

class Interface_CopyControl(Standard_Transient):
	def Bind(self, ent: Standard_Transient, res: Standard_Transient) -> None: ...
	def Clear(self) -> None: ...
	def Search(self, ent: Standard_Transient, res: Standard_Transient) -> bool: ...

class Interface_CopyTool:
	@overload
	def __init__(self, amodel: Interface_InterfaceModel, lib: Interface_GeneralLib) -> None: ...
	@overload
	def __init__(self, amodel: Interface_InterfaceModel, protocol: Interface_Protocol) -> None: ...
	@overload
	def __init__(self, amodel: Interface_InterfaceModel) -> None: ...
	def Bind(self, ent: Standard_Transient, res: Standard_Transient) -> None: ...
	def Clear(self) -> None: ...
	def ClearLastFlags(self) -> None: ...
	def CompleteResult(self, withreports: Optional[bool] = False) -> Interface_EntityIterator: ...
	def Control(self) -> Interface_CopyControl: ...
	def Copy(self, entfrom: Standard_Transient, entto: Standard_Transient, mapped: bool, errstat: bool) -> bool: ...
	def FillModel(self, bmodel: Interface_InterfaceModel) -> None: ...
	def LastCopiedAfter(self, numfrom: int, ent: Standard_Transient, res: Standard_Transient) -> int: ...
	def Model(self) -> Interface_InterfaceModel: ...
	def RenewImpliedRefs(self) -> None: ...
	def RootResult(self, withreports: Optional[bool] = False) -> Interface_EntityIterator: ...
	def Search(self, ent: Standard_Transient, res: Standard_Transient) -> bool: ...
	def SetControl(self, othermap: Interface_CopyControl) -> None: ...
	def TransferEntity(self, ent: Standard_Transient) -> None: ...
	def Transferred(self, ent: Standard_Transient) -> Standard_Transient: ...

class Interface_EntityCluster(Standard_Transient):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, ent: Standard_Transient) -> None: ...
	@overload
	def __init__(self, ec: Interface_EntityCluster) -> None: ...
	@overload
	def __init__(self, ant: Standard_Transient, ec: Interface_EntityCluster) -> None: ...
	def Append(self, ent: Standard_Transient) -> None: ...
	def FillIterator(self, iter: Interface_EntityIterator) -> None: ...
	def NbEntities(self) -> int: ...
	@overload
	def Remove(self, ent: Standard_Transient) -> bool: ...
	@overload
	def Remove(self, num: int) -> bool: ...
	def SetValue(self, num: int, ent: Standard_Transient) -> None: ...
	def Value(self, num: int) -> Standard_Transient: ...

class Interface_EntityIterator:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, list: TColStd_HSequenceOfTransient) -> None: ...
	def AddItem(self, anentity: Standard_Transient) -> None: ...
	def AddList(self, list: TColStd_HSequenceOfTransient) -> None: ...
	def Content(self) -> TColStd_HSequenceOfTransient: ...
	def Destroy(self) -> None: ...
	def GetOneItem(self, anentity: Standard_Transient) -> None: ...
	def More(self) -> bool: ...
	def NbEntities(self) -> int: ...
	def NbTyped(self, type: Standard_Type) -> int: ...
	def Next(self) -> None: ...
	def SelectType(self, atype: Standard_Type, keep: bool) -> None: ...
	def Start(self) -> None: ...
	def Typed(self, type: Standard_Type) -> Interface_EntityIterator: ...
	def Value(self) -> Standard_Transient: ...

class Interface_EntityList:
	def __init__(self) -> None: ...
	def Add(self, ent: Standard_Transient) -> None: ...
	def Append(self, ent: Standard_Transient) -> None: ...
	def Clear(self) -> None: ...
	def FillIterator(self, iter: Interface_EntityIterator) -> None: ...
	def IsEmpty(self) -> bool: ...
	def NbEntities(self) -> int: ...
	def NbTypedEntities(self, atype: Standard_Type) -> int: ...
	@overload
	def Remove(self, ent: Standard_Transient) -> None: ...
	@overload
	def Remove(self, num: int) -> None: ...
	def SetValue(self, num: int, ent: Standard_Transient) -> None: ...
	def TypedEntity(self, atype: Standard_Type, num: Optional[int] = 0) -> Standard_Transient: ...
	def Value(self, num: int) -> Standard_Transient: ...

class Interface_FileParameter:
	def __init__(self) -> None: ...
	def CValue(self) -> str: ...
	def Clear(self) -> None: ...
	def Destroy(self) -> None: ...
	def EntityNumber(self) -> int: ...
	@overload
	def Init(self, val: TCollection_AsciiString, typ: Interface_ParamType) -> None: ...
	@overload
	def Init(self, val: str, typ: Interface_ParamType) -> None: ...
	def ParamType(self) -> Interface_ParamType: ...
	def SetEntityNumber(self, num: int) -> None: ...

class Interface_FileReaderData(Standard_Transient):
	@overload
	def AddParam(self, num: int, aval: str, atype: Interface_ParamType, nument: Optional[int] = 0) -> None: ...
	@overload
	def AddParam(self, num: int, aval: TCollection_AsciiString, atype: Interface_ParamType, nument: Optional[int] = 0) -> None: ...
	@overload
	def AddParam(self, num: int, FP: Interface_FileParameter) -> None: ...
	def BindEntity(self, num: int, ent: Standard_Transient) -> None: ...
	def BoundEntity(self, num: int) -> Standard_Transient: ...
	def ChangeParam(self, num: int, nump: int) -> Interface_FileParameter: ...
	def Destroy(self) -> None: ...
	@staticmethod
	def Fastof(str: str) -> float: ...
	def FindNextRecord(self, num: int) -> int: ...
	def InitParams(self, num: int) -> None: ...
	def IsErrorLoad(self) -> bool: ...
	def IsParamDefined(self, num: int, nump: int) -> bool: ...
	def NbEntities(self) -> int: ...
	def NbParams(self, num: int) -> int: ...
	def NbRecords(self) -> int: ...
	def Param(self, num: int, nump: int) -> Interface_FileParameter: ...
	def ParamCValue(self, num: int, nump: int) -> str: ...
	def ParamEntity(self, num: int, nump: int) -> Standard_Transient: ...
	def ParamFirstRank(self, num: int) -> int: ...
	def ParamNumber(self, num: int, nump: int) -> int: ...
	def ParamType(self, num: int, nump: int) -> Interface_ParamType: ...
	def Params(self, num: int) -> Interface_ParamList: ...
	def ResetErrorLoad(self) -> bool: ...
	def SetErrorLoad(self, val: bool) -> None: ...
	def SetParam(self, num: int, nump: int, FP: Interface_FileParameter) -> None: ...

class Interface_FileReaderTool:
	def AnalyseRecord(self, num: int, anent: Standard_Transient, acheck: Interface_Check) -> bool: ...
	def BeginRead(self, amodel: Interface_InterfaceModel) -> None: ...
	def Clear(self) -> None: ...
	def Data(self) -> Interface_FileReaderData: ...
	def EndRead(self, amodel: Interface_InterfaceModel) -> None: ...
	def ErrorHandle(self) -> bool: ...
	def LoadModel(self, amodel: Interface_InterfaceModel) -> None: ...
	def LoadedEntity(self, num: int) -> Standard_Transient: ...
	def Messenger(self) -> Message_Messenger: ...
	def Model(self) -> Interface_InterfaceModel: ...
	def NewModel(self) -> Interface_InterfaceModel: ...
	def Protocol(self) -> Interface_Protocol: ...
	def Recognize(self, num: int, ach: Interface_Check, ent: Standard_Transient) -> bool: ...
	def RecognizeByLib(self, num: int, glib: Interface_GeneralLib, rlib: Interface_ReaderLib, ach: Interface_Check, ent: Standard_Transient) -> bool: ...
	def SetData(self, reader: Interface_FileReaderData, protocol: Interface_Protocol) -> None: ...
	def SetEntities(self) -> None: ...
	def SetErrorHandle(self, err: bool) -> None: ...
	def SetMessenger(self, messenger: Message_Messenger) -> None: ...
	def SetModel(self, amodel: Interface_InterfaceModel) -> None: ...
	def SetTraceLevel(self, tracelev: int) -> None: ...
	def TraceLevel(self) -> int: ...
	def UnknownEntity(self) -> Standard_Transient: ...

class Interface_FloatWriter:
	def __init__(self, chars: Optional[int] = 0) -> None: ...
	@staticmethod
	def Convert(val: float, text: str, zerosup: bool, Range1: float, Range2: float, mainform: str, rangeform: str) -> int: ...
	def FormatForRange(self) -> str: ...
	def MainFormat(self) -> str: ...
	def Options(self) -> Tuple[bool, bool, float, float]: ...
	def SetDefaults(self, chars: Optional[int] = 0) -> None: ...
	def SetFormat(self, form: str, reset: Optional[bool] = True) -> None: ...
	def SetFormatForRange(self, form: str, R1: float, R2: float) -> None: ...
	def SetZeroSuppress(self, mode: bool) -> None: ...
	def Write(self, val: float, text: str) -> int: ...

class Interface_GTool(Standard_Transient):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, proto: Interface_Protocol, nbent: Optional[int] = 0) -> None: ...
	def ClearEntities(self) -> None: ...
	def Lib(self) -> Interface_GeneralLib: ...
	def Protocol(self) -> Interface_Protocol: ...
	def Reservate(self, nb: int, enforce: Optional[bool] = False) -> None: ...
	def Select(self, ent: Standard_Transient, gmod: Interface_GeneralModule, enforce: Optional[bool] = False) -> Tuple[bool, int]: ...
	def SetProtocol(self, proto: Interface_Protocol, enforce: Optional[bool] = False) -> None: ...
	def SetSignType(self, sign: Interface_SignType) -> None: ...
	def SignName(self) -> str: ...
	def SignType(self) -> Interface_SignType: ...
	def SignValue(self, ent: Standard_Transient, model: Interface_InterfaceModel) -> str: ...

class Interface_GeneralLib:
	@overload
	def __init__(self, aprotocol: Interface_Protocol) -> None: ...
	@overload
	def __init__(self) -> None: ...
	def AddProtocol(self, aprotocol: Standard_Transient) -> None: ...
	def Clear(self) -> None: ...
	def Module(self) -> Interface_GeneralModule: ...
	def More(self) -> bool: ...
	def Next(self) -> None: ...
	def Protocol(self) -> Interface_Protocol: ...
	def Select(self, obj: Standard_Transient, module: Interface_GeneralModule) -> Tuple[bool, int]: ...
	def SetComplete(self) -> None: ...
	@staticmethod
	def SetGlobal(amodule: Interface_GeneralModule, aprotocol: Interface_Protocol) -> None: ...
	def Start(self) -> None: ...

class Interface_GeneralModule(Standard_Transient):
	def CanCopy(self, CN: int, ent: Standard_Transient) -> bool: ...
	def CategoryNumber(self, CN: int, ent: Standard_Transient, shares: Interface_ShareTool) -> int: ...
	def CheckCase(self, CN: int, ent: Standard_Transient, shares: Interface_ShareTool, ach: Interface_Check) -> None: ...
	def CopyCase(self, CN: int, entfrom: Standard_Transient, entto: Standard_Transient, TC: Interface_CopyTool) -> None: ...
	def Dispatch(self, CN: int, entfrom: Standard_Transient, entto: Standard_Transient, TC: Interface_CopyTool) -> bool: ...
	def FillShared(self, model: Interface_InterfaceModel, CN: int, ent: Standard_Transient, iter: Interface_EntityIterator) -> None: ...
	def FillSharedCase(self, CN: int, ent: Standard_Transient, iter: Interface_EntityIterator) -> None: ...
	def ListImplied(self, model: Interface_InterfaceModel, CN: int, ent: Standard_Transient, iter: Interface_EntityIterator) -> None: ...
	def ListImpliedCase(self, CN: int, ent: Standard_Transient, iter: Interface_EntityIterator) -> None: ...
	def Name(self, CN: int, ent: Standard_Transient, shares: Interface_ShareTool) -> TCollection_HAsciiString: ...
	def NewCopiedCase(self, CN: int, entfrom: Standard_Transient, entto: Standard_Transient, TC: Interface_CopyTool) -> bool: ...
	def NewVoid(self, CN: int, entto: Standard_Transient) -> bool: ...
	def RenewImpliedCase(self, CN: int, entfrom: Standard_Transient, entto: Standard_Transient, TC: Interface_CopyTool) -> None: ...
	def Share(self, iter: Interface_EntityIterator, shared: Standard_Transient) -> None: ...
	def WhenDeleteCase(self, CN: int, ent: Standard_Transient, dispatched: bool) -> None: ...

class Interface_GlobalNodeOfGeneralLib(Standard_Transient):
	def __init__(self) -> None: ...
	def Add(self, amodule: Interface_GeneralModule, aprotocol: Interface_Protocol) -> None: ...
	def Module(self) -> Interface_GeneralModule: ...
	def Next(self) -> Interface_GlobalNodeOfGeneralLib: ...
	def Protocol(self) -> Interface_Protocol: ...

class Interface_GlobalNodeOfReaderLib(Standard_Transient):
	def __init__(self) -> None: ...
	def Add(self, amodule: Interface_ReaderModule, aprotocol: Interface_Protocol) -> None: ...
	def Module(self) -> Interface_ReaderModule: ...
	def Next(self) -> Interface_GlobalNodeOfReaderLib: ...
	def Protocol(self) -> Interface_Protocol: ...

class Interface_Graph:
	@overload
	def __init__(self, amodel: Interface_InterfaceModel, lib: Interface_GeneralLib, theModeStats: Optional[bool] = True) -> None: ...
	@overload
	def __init__(self, amodel: Interface_InterfaceModel, protocol: Interface_Protocol, theModeStats: Optional[bool] = True) -> None: ...
	@overload
	def __init__(self, amodel: Interface_InterfaceModel, gtool: Interface_GTool, theModeStats: Optional[bool] = True) -> None: ...
	@overload
	def __init__(self, amodel: Interface_InterfaceModel, theModeStats: Optional[bool] = True) -> None: ...
	@overload
	def __init__(self, agraph: Interface_Graph, copied: Optional[bool] = False) -> None: ...
	def BitMap(self) -> Interface_BitMap: ...
	def CBitMap(self) -> Interface_BitMap: ...
	def ChangeStatus(self, oldstat: int, newstat: int) -> None: ...
	def Entity(self, num: int) -> Standard_Transient: ...
	def EntityNumber(self, ent: Standard_Transient) -> int: ...
	@overload
	def GetFromEntity(self, ent: Standard_Transient, shared: bool, newstat: Optional[int] = 0) -> None: ...
	@overload
	def GetFromEntity(self, ent: Standard_Transient, shared: bool, newstat: int, overlapstat: int, cumul: bool) -> None: ...
	@overload
	def GetFromGraph(self, agraph: Interface_Graph) -> None: ...
	@overload
	def GetFromGraph(self, agraph: Interface_Graph, stat: int) -> None: ...
	@overload
	def GetFromIter(self, iter: Interface_EntityIterator, newstat: int) -> None: ...
	@overload
	def GetFromIter(self, iter: Interface_EntityIterator, newstat: int, overlapstat: int, cumul: bool) -> None: ...
	def GetFromModel(self) -> None: ...
	def GetShareds(self, ent: Standard_Transient) -> TColStd_HSequenceOfTransient: ...
	def GetSharings(self, ent: Standard_Transient) -> TColStd_HSequenceOfTransient: ...
	def HasShareErrors(self, ent: Standard_Transient) -> bool: ...
	@overload
	def IsPresent(self, num: int) -> bool: ...
	@overload
	def IsPresent(self, ent: Standard_Transient) -> bool: ...
	def ModeStat(self) -> bool: ...
	def Model(self) -> Interface_InterfaceModel: ...
	def Name(self, ent: Standard_Transient) -> TCollection_HAsciiString: ...
	def NbStatuses(self) -> int: ...
	def RemoveItem(self, num: int) -> None: ...
	def RemoveStatus(self, stat: int) -> None: ...
	def Reset(self) -> None: ...
	def ResetStatus(self) -> None: ...
	def RootEntities(self) -> Interface_EntityIterator: ...
	def SetStatus(self, num: int, stat: int) -> None: ...
	def Shareds(self, ent: Standard_Transient) -> Interface_EntityIterator: ...
	def SharingTable(self) -> TColStd_HArray1OfListOfInteger: ...
	def Sharings(self, ent: Standard_Transient) -> Interface_EntityIterator: ...
	def Size(self) -> int: ...
	def Status(self, num: int) -> int: ...
	def TypedSharings(self, ent: Standard_Transient, type: Standard_Type) -> Interface_EntityIterator: ...

class Interface_HGraph(Standard_Transient):
	@overload
	def __init__(self, agraph: Interface_Graph) -> None: ...
	@overload
	def __init__(self, amodel: Interface_InterfaceModel, lib: Interface_GeneralLib, theModeStats: Optional[bool] = True) -> None: ...
	@overload
	def __init__(self, amodel: Interface_InterfaceModel, protocol: Interface_Protocol, theModeStats: Optional[bool] = True) -> None: ...
	@overload
	def __init__(self, amodel: Interface_InterfaceModel, gtool: Interface_GTool, theModeStats: Optional[bool] = True) -> None: ...
	@overload
	def __init__(self, amodel: Interface_InterfaceModel, theModeStats: Optional[bool] = True) -> None: ...
	def CGraph(self) -> Interface_Graph: ...
	def Graph(self) -> Interface_Graph: ...

class Interface_IntList:
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, nbe: int) -> None: ...
	@overload
	def __init__(self, other: Interface_IntList, copied: bool) -> None: ...
	def Add(self, ref: int) -> None: ...
	def AdjustSize(self, margin: Optional[int] = 0) -> None: ...
	def Clear(self) -> None: ...
	def Initialize(self, nbe: int) -> None: ...
	def Internals(self, ents: TColStd_HArray1OfInteger, refs: TColStd_HArray1OfInteger) -> int: ...
	def IsRedefined(self, num: Optional[int] = 0) -> bool: ...
	def Length(self) -> int: ...
	def List(self, number: int, copied: Optional[bool] = False) -> Interface_IntList: ...
	def NbEntities(self) -> int: ...
	def Number(self) -> int: ...
	def Remove(self, num: int) -> bool: ...
	def Reservate(self, count: int) -> None: ...
	def SetNbEntities(self, nbe: int) -> None: ...
	def SetNumber(self, number: int) -> None: ...
	def SetRedefined(self, mode: bool) -> None: ...
	def Value(self, num: int) -> int: ...

class Interface_IntVal(Standard_Transient):
	def __init__(self) -> None: ...
	def GetCValue(self) -> int: ...
	def SetCValue(self, value: int) -> None: ...
	def Value(self) -> int: ...

class Interface_InterfaceModel(Standard_Transient):
	def AddEntity(self, anentity: Standard_Transient) -> None: ...
	def AddReportEntity(self, rep: Interface_ReportEntity, semantic: Optional[bool] = False) -> bool: ...
	@overload
	def AddWithRefs(self, anent: Standard_Transient, proto: Interface_Protocol, level: Optional[int] = 0, listall: Optional[bool] = False) -> None: ...
	@overload
	def AddWithRefs(self, anent: Standard_Transient, level: Optional[int] = 0, listall: Optional[bool] = False) -> None: ...
	@overload
	def AddWithRefs(self, anent: Standard_Transient, lib: Interface_GeneralLib, level: Optional[int] = 0, listall: Optional[bool] = False) -> None: ...
	def CategoryNumber(self, num: int) -> int: ...
	def ChangeOrder(self, oldnum: int, newnum: int, count: Optional[int] = 1) -> None: ...
	def Check(self, num: int, syntactic: bool) -> Interface_Check: ...
	@staticmethod
	def ClassName(typnam: str) -> str: ...
	def Clear(self) -> None: ...
	def ClearEntities(self) -> None: ...
	def ClearHeader(self) -> None: ...
	def ClearLabels(self) -> None: ...
	def ClearReportEntity(self, num: int) -> bool: ...
	def Contains(self, anentity: Standard_Transient) -> bool: ...
	def Destroy(self) -> None: ...
	def GetDispatchStatus(self) -> bool: ...
	def SetDispatchStatus(self, value: bool) -> None: ...
	def DumpHeader(self, S: Message_Messenger, level: Optional[int] = 0) -> None: ...
	def Entities(self) -> Interface_EntityIterator: ...
	def EntityState(self, num: int) -> Interface_DataState: ...
	def FillIterator(self, iter: Interface_EntityIterator) -> None: ...
	def FillSemanticChecks(self, checks: Interface_CheckIterator, clear: Optional[bool] = True) -> None: ...
	def GTool(self) -> Interface_GTool: ...
	def GetFromAnother(self, other: Interface_InterfaceModel) -> None: ...
	def GetFromTransfer(self, aniter: Interface_EntityIterator) -> None: ...
	def GlobalCheck(self, syntactic: Optional[bool] = True) -> Interface_Check: ...
	def HasSemanticChecks(self) -> bool: ...
	@staticmethod
	def HasTemplate(name: str) -> bool: ...
	def IsErrorEntity(self, num: int) -> bool: ...
	def IsRedefinedContent(self, num: int) -> bool: ...
	def IsReportEntity(self, num: int, semantic: Optional[bool] = False) -> bool: ...
	def IsUnknownEntity(self, num: int) -> bool: ...
	@staticmethod
	def ListTemplates() -> TColStd_HSequenceOfHAsciiString: ...
	def NbEntities(self) -> int: ...
	def NbTypes(self, ent: Standard_Transient) -> int: ...
	def NewEmptyModel(self) -> Interface_InterfaceModel: ...
	def NextNumberForLabel(self, label: str, lastnum: Optional[int] = 0, exact: Optional[bool] = True) -> int: ...
	def Number(self, anentity: Standard_Transient) -> int: ...
	def Print(self, ent: Standard_Transient, s: Message_Messenger, mode: Optional[int] = 0) -> None: ...
	def PrintLabel(self, ent: Standard_Transient, S: Message_Messenger) -> None: ...
	def PrintToLog(self, ent: Standard_Transient, S: Message_Messenger) -> None: ...
	def Protocol(self) -> Interface_Protocol: ...
	def Redefineds(self) -> Interface_EntityIterator: ...
	def ReplaceEntity(self, nument: int, anent: Standard_Transient) -> None: ...
	def ReportEntity(self, num: int, semantic: Optional[bool] = False) -> Interface_ReportEntity: ...
	def Reports(self, semantic: Optional[bool] = False) -> Interface_EntityIterator: ...
	def Reservate(self, nbent: int) -> None: ...
	def ReverseOrders(self, after: Optional[int] = 0) -> None: ...
	def SetCategoryNumber(self, num: int, val: int) -> bool: ...
	def SetGTool(self, gtool: Interface_GTool) -> None: ...
	def SetGlobalCheck(self, ach: Interface_Check) -> None: ...
	def SetProtocol(self, proto: Interface_Protocol) -> None: ...
	def SetReportEntity(self, num: int, rep: Interface_ReportEntity) -> bool: ...
	@staticmethod
	def SetTemplate(name: str, model: Interface_InterfaceModel) -> bool: ...
	def StringLabel(self, ent: Standard_Transient) -> TCollection_HAsciiString: ...
	@staticmethod
	def Template(name: str) -> Interface_InterfaceModel: ...
	def Type(self, ent: Standard_Transient, num: Optional[int] = 1) -> Standard_Type: ...
	def TypeName(self, ent: Standard_Transient, complete: Optional[bool] = True) -> str: ...
	def Value(self, num: int) -> Standard_Transient: ...
	def VerifyCheck(self, ach: Interface_Check) -> None: ...

class Interface_LineBuffer:
	def __init__(self, size: Optional[int] = 10) -> None: ...
	@overload
	def Add(self, text: str) -> None: ...
	@overload
	def Add(self, text: str, lntext: int) -> None: ...
	@overload
	def Add(self, text: TCollection_AsciiString) -> None: ...
	@overload
	def Add(self, text: str) -> None: ...
	def CanGet(self, more: int) -> bool: ...
	def Clear(self) -> None: ...
	def Content(self) -> str: ...
	def FreezeInitial(self) -> None: ...
	def Length(self) -> int: ...
	@overload
	def Move(self, str: TCollection_AsciiString) -> None: ...
	@overload
	def Move(self, str: TCollection_HAsciiString) -> None: ...
	def Moved(self) -> TCollection_HAsciiString: ...
	def SetInitial(self, initial: int) -> None: ...
	def SetKeep(self) -> None: ...
	def SetMax(self, max: int) -> None: ...

class Interface_MSG:
	@overload
	def __init__(self, key: str) -> None: ...
	@overload
	def __init__(self, key: str, i1: int) -> None: ...
	@overload
	def __init__(self, key: str, i1: int, i2: int) -> None: ...
	@overload
	def __init__(self, key: str, r1: float, intervals: Optional[int] = -1) -> None: ...
	@overload
	def __init__(self, key: str, str: str) -> None: ...
	@overload
	def __init__(self, key: str, ival: int, str: str) -> None: ...
	@overload
	@staticmethod
	def Blanks(val: int, max: int) -> str: ...
	@overload
	@staticmethod
	def Blanks(val: str, max: int) -> str: ...
	@overload
	@staticmethod
	def Blanks(count: int) -> str: ...
	@staticmethod
	def CDate(text1: str, text2: str) -> int: ...
	def Destroy(self) -> None: ...
	@staticmethod
	def Intervalled(val: float, order: Optional[int] = 3, upper: Optional[bool] = False) -> float: ...
	@staticmethod
	def IsKey(mess: str) -> bool: ...
	@staticmethod
	def NDate(text: str) -> Tuple[bool, int, int, int, int, int, int]: ...
	@overload
	@staticmethod
	def Read(file: str) -> int: ...
	@staticmethod
	def Record(key: str, item: str) -> None: ...
	@staticmethod
	def SetMode(running: bool, raising: bool) -> None: ...
	@staticmethod
	def SetTrace(toprint: bool, torecord: bool) -> None: ...
	@staticmethod
	def TDate(text: str, yy: int, mm: int, dd: int, hh: int, mn: int, ss: int, format: Optional[str] = "") -> None: ...
	@staticmethod
	def Translated(key: str) -> str: ...
	def Value(self) -> str: ...

class Interface_MapAsciiStringHasher:
	@staticmethod
	def HashCode(theAsciiString: TCollection_AsciiString, theUpperBound: int) -> int: ...
	@staticmethod
	def IsEqual(K1: TCollection_AsciiString, K2: TCollection_AsciiString) -> bool: ...

class Interface_NodeOfGeneralLib(Standard_Transient):
	def __init__(self) -> None: ...
	def AddNode(self, anode: Interface_GlobalNodeOfGeneralLib) -> None: ...
	def Module(self) -> Interface_GeneralModule: ...
	def Next(self) -> Interface_NodeOfGeneralLib: ...
	def Protocol(self) -> Interface_Protocol: ...

class Interface_NodeOfReaderLib(Standard_Transient):
	def __init__(self) -> None: ...
	def AddNode(self, anode: Interface_GlobalNodeOfReaderLib) -> None: ...
	def Module(self) -> Interface_ReaderModule: ...
	def Next(self) -> Interface_NodeOfReaderLib: ...
	def Protocol(self) -> Interface_Protocol: ...

class Interface_ParamList(Standard_Transient):
	def __init__(self, theIncrement: Optional[int] = 256) -> None: ...
	def ChangeValue(self, Index: int) -> Interface_FileParameter: ...
	def Clear(self) -> None: ...
	def Length(self) -> int: ...
	def Lower(self) -> int: ...
	def SetValue(self, Index: int, Value: Interface_FileParameter) -> None: ...
	def Upper(self) -> int: ...
	def Value(self, Index: int) -> Interface_FileParameter: ...

class Interface_ParamSet(Standard_Transient):
	def __init__(self, nres: int, nst: Optional[int] = 1) -> None: ...
	@overload
	def Append(self, val: str, lnval: int, typ: Interface_ParamType, nument: int) -> int: ...
	@overload
	def Append(self, FP: Interface_FileParameter) -> int: ...
	def ChangeParam(self, num: int) -> Interface_FileParameter: ...
	def Destroy(self) -> None: ...
	def NbParams(self) -> int: ...
	def Param(self, num: int) -> Interface_FileParameter: ...
	def Params(self, num: int, nb: int) -> Interface_ParamList: ...
	def SetParam(self, num: int, FP: Interface_FileParameter) -> None: ...

class Interface_Protocol(Standard_Transient):
	@staticmethod
	def Active() -> Interface_Protocol: ...
	def CaseNumber(self, obj: Standard_Transient) -> int: ...
	@staticmethod
	def ClearActive() -> None: ...
	def GlobalCheck(self, G: Interface_Graph, ach: Interface_Check) -> bool: ...
	def IsDynamicType(self, obj: Standard_Transient) -> bool: ...
	def IsSuitableModel(self, model: Interface_InterfaceModel) -> bool: ...
	def IsUnknownEntity(self, ent: Standard_Transient) -> bool: ...
	def NbResources(self) -> int: ...
	def NbTypes(self, obj: Standard_Transient) -> int: ...
	def NewModel(self) -> Interface_InterfaceModel: ...
	def Resource(self, num: int) -> Interface_Protocol: ...
	@staticmethod
	def SetActive(aprotocol: Interface_Protocol) -> None: ...
	def Type(self, obj: Standard_Transient, nt: Optional[int] = 1) -> Standard_Type: ...
	def TypeNumber(self, atype: Standard_Type) -> int: ...
	def UnknownEntity(self) -> Standard_Transient: ...

class Interface_ReaderLib:
	@overload
	def __init__(self, aprotocol: Interface_Protocol) -> None: ...
	@overload
	def __init__(self) -> None: ...
	def AddProtocol(self, aprotocol: Standard_Transient) -> None: ...
	def Clear(self) -> None: ...
	def Module(self) -> Interface_ReaderModule: ...
	def More(self) -> bool: ...
	def Next(self) -> None: ...
	def Protocol(self) -> Interface_Protocol: ...
	def Select(self, obj: Standard_Transient, module: Interface_ReaderModule) -> Tuple[bool, int]: ...
	def SetComplete(self) -> None: ...
	@staticmethod
	def SetGlobal(amodule: Interface_ReaderModule, aprotocol: Interface_Protocol) -> None: ...
	def Start(self) -> None: ...

class Interface_ReaderModule(Standard_Transient):
	def CaseNum(self, data: Interface_FileReaderData, num: int) -> int: ...
	def NewRead(self, casenum: int, data: Interface_FileReaderData, num: int, ach: Interface_Check, ent: Standard_Transient) -> bool: ...
	def Read(self, casenum: int, data: Interface_FileReaderData, num: int, ach: Interface_Check, ent: Standard_Transient) -> None: ...

class Interface_ReportEntity(Standard_Transient):
	@overload
	def __init__(self, unknown: Standard_Transient) -> None: ...
	@overload
	def __init__(self, acheck: Interface_Check, concerned: Standard_Transient) -> None: ...
	def CCheck(self) -> Interface_Check: ...
	def Check(self) -> Interface_Check: ...
	def Concerned(self) -> Standard_Transient: ...
	def Content(self) -> Standard_Transient: ...
	def HasContent(self) -> bool: ...
	def HasNewContent(self) -> bool: ...
	def IsError(self) -> bool: ...
	def IsUnknown(self) -> bool: ...
	def SetContent(self, content: Standard_Transient) -> None: ...

class Interface_STAT:
	@overload
	def __init__(self, title: Optional[str] = "") -> None: ...
	@overload
	def __init__(self, other: Interface_STAT) -> None: ...
	def AddPhase(self, weight: float, name: Optional[str] = "") -> None: ...
	def AddStep(self, weight: Optional[float] = 1) -> None: ...
	def Description(self, title: str) -> Tuple[int, float]: ...
	@staticmethod
	def End() -> None: ...
	def Internals(self, tit: TCollection_HAsciiString, phn: TColStd_HSequenceOfAsciiString, phw: TColStd_HSequenceOfReal, phdeb: TColStd_HSequenceOfInteger, phfin: TColStd_HSequenceOfInteger, stw: TColStd_HSequenceOfReal) -> float: ...
	@staticmethod
	def NextCycle(items: int) -> None: ...
	@staticmethod
	def NextItem(nbitems: Optional[int] = 1) -> None: ...
	@staticmethod
	def NextPhase(items: int, cycles: Optional[int] = 1) -> None: ...
	@staticmethod
	def NextStep() -> None: ...
	@staticmethod
	def Percent(phase: Optional[bool] = False) -> int: ...
	def Phase(self, num: int, name: str) -> Tuple[int, int, float]: ...
	@staticmethod
	def SetPhase(items: int, cycles: Optional[int] = 1) -> None: ...
	def Start(self, items: int, cycles: Optional[int] = 1) -> None: ...
	@staticmethod
	def StartCount(items: int, title: Optional[str] = "") -> None: ...
	def Step(self, num: int) -> float: ...
	@staticmethod
	def Where(phase: Optional[bool] = True) -> str: ...

class Interface_ShareFlags:
	@overload
	def __init__(self, amodel: Interface_InterfaceModel, lib: Interface_GeneralLib) -> None: ...
	@overload
	def __init__(self, amodel: Interface_InterfaceModel, gtool: Interface_GTool) -> None: ...
	@overload
	def __init__(self, amodel: Interface_InterfaceModel, protocol: Interface_Protocol) -> None: ...
	@overload
	def __init__(self, amodel: Interface_InterfaceModel) -> None: ...
	@overload
	def __init__(self, agraph: Interface_Graph) -> None: ...
	def IsShared(self, ent: Standard_Transient) -> bool: ...
	def Model(self) -> Interface_InterfaceModel: ...
	def NbRoots(self) -> int: ...
	def Root(self, num: Optional[int] = 1) -> Standard_Transient: ...
	def RootEntities(self) -> Interface_EntityIterator: ...

class Interface_ShareTool:
	@overload
	def __init__(self, amodel: Interface_InterfaceModel, lib: Interface_GeneralLib) -> None: ...
	@overload
	def __init__(self, amodel: Interface_InterfaceModel, gtool: Interface_GTool) -> None: ...
	@overload
	def __init__(self, amodel: Interface_InterfaceModel, protocol: Interface_Protocol) -> None: ...
	@overload
	def __init__(self, amodel: Interface_InterfaceModel) -> None: ...
	@overload
	def __init__(self, agraph: Interface_Graph) -> None: ...
	@overload
	def __init__(self, ahgraph: Interface_HGraph) -> None: ...
	def All(self, ent: Standard_Transient, rootlast: Optional[bool] = True) -> Interface_EntityIterator: ...
	def Graph(self) -> Interface_Graph: ...
	def IsShared(self, ent: Standard_Transient) -> bool: ...
	def Model(self) -> Interface_InterfaceModel: ...
	def NbTypedSharings(self, ent: Standard_Transient, atype: Standard_Type) -> int: ...
	def Print(self, iter: Interface_EntityIterator, S: Message_Messenger) -> None: ...
	def RootEntities(self) -> Interface_EntityIterator: ...
	def Shareds(self, ent: Standard_Transient) -> Interface_EntityIterator: ...
	def Sharings(self, ent: Standard_Transient) -> Interface_EntityIterator: ...
	def TypedSharing(self, ent: Standard_Transient, atype: Standard_Type) -> Standard_Transient: ...

class Interface_SignLabel(MoniTool_SignText):
	def __init__(self) -> None: ...
	def Name(self) -> str: ...
	def Text(self, ent: Standard_Transient, context: Standard_Transient) -> TCollection_AsciiString: ...

class Interface_SignType(MoniTool_SignText):
	@staticmethod
	def ClassName(typnam: str) -> str: ...
	def Text(self, ent: Standard_Transient, context: Standard_Transient) -> TCollection_AsciiString: ...
	def Value(self, ent: Standard_Transient, model: Interface_InterfaceModel) -> str: ...

class Interface_TypedValue(MoniTool_TypedValue):
	def __init__(self, name: str, type: Optional[Interface_ParamType] = Interface_ParamText, init: Optional[str] = "") -> None: ...
	@staticmethod
	def ParamTypeToValueType(typ: Interface_ParamType) -> MoniTool_ValueType: ...
	def Type(self) -> Interface_ParamType: ...
	@staticmethod
	def ValueTypeToParamType(typ: MoniTool_ValueType) -> Interface_ParamType: ...

class Interface_UndefinedContent(Standard_Transient):
	def __init__(self) -> None: ...
	def AddEntity(self, ptype: Interface_ParamType, ent: Standard_Transient) -> None: ...
	def AddLiteral(self, ptype: Interface_ParamType, val: TCollection_HAsciiString) -> None: ...
	def EntityList(self) -> Interface_EntityList: ...
	def GetFromAnother(self, other: Interface_UndefinedContent, TC: Interface_CopyTool) -> None: ...
	def IsParamEntity(self, num: int) -> bool: ...
	def NbLiterals(self) -> int: ...
	def NbParams(self) -> int: ...
	def ParamData(self, num: int, ptype: Interface_ParamType, ent: Standard_Transient, val: TCollection_HAsciiString) -> bool: ...
	def ParamEntity(self, num: int) -> Standard_Transient: ...
	def ParamType(self, num: int) -> Interface_ParamType: ...
	def ParamValue(self, num: int) -> TCollection_HAsciiString: ...
	def RemoveParam(self, num: int) -> None: ...
	def Reservate(self, nb: int, nblit: int) -> None: ...
	@overload
	def SetEntity(self, num: int, ptype: Interface_ParamType, ent: Standard_Transient) -> None: ...
	@overload
	def SetEntity(self, num: int, ent: Standard_Transient) -> None: ...
	def SetLiteral(self, num: int, ptype: Interface_ParamType, val: TCollection_HAsciiString) -> None: ...

class Interface_CopyMap(Interface_CopyControl):
	def __init__(self, amodel: Interface_InterfaceModel) -> None: ...
	def Bind(self, ent: Standard_Transient, res: Standard_Transient) -> None: ...
	def Clear(self) -> None: ...
	def Model(self) -> Interface_InterfaceModel: ...
	def Search(self, ent: Standard_Transient, res: Standard_Transient) -> bool: ...

class Interface_GraphContent(Interface_EntityIterator):
	@overload
	def __init__(self) -> None: ...
	@overload
	def __init__(self, agraph: Interface_Graph) -> None: ...
	@overload
	def __init__(self, agraph: Interface_Graph, stat: int) -> None: ...
	@overload
	def __init__(self, agraph: Interface_Graph, ent: Standard_Transient) -> None: ...
	def Begin(self) -> None: ...
	def Evaluate(self) -> None: ...
	@overload
	def GetFromGraph(self, agraph: Interface_Graph) -> None: ...
	@overload
	def GetFromGraph(self, agraph: Interface_Graph, stat: int) -> None: ...
	def Result(self) -> Interface_EntityIterator: ...

class Interface_Static(Interface_TypedValue):
	@overload
	def __init__(self, family: str, name: str, type: Optional[Interface_ParamType] = Interface_ParamText, init: Optional[str] = "") -> None: ...
	@overload
	def __init__(self, family: str, name: str, other: Interface_Static) -> None: ...
	@staticmethod
	def CDef(name: str, part: str) -> str: ...
	@staticmethod
	def CVal(name: str) -> str: ...
	def Family(self) -> str: ...
	@staticmethod
	def IDef(name: str, part: str) -> int: ...
	@staticmethod
	def IVal(name: str) -> int: ...
	@overload
	@staticmethod
	def Init(family: str, name: str, type: Interface_ParamType, init: Optional[str] = "") -> bool: ...
	@overload
	@staticmethod
	def Init(family: str, name: str, type: str, init: Optional[str] = "") -> bool: ...
	@staticmethod
	def IsPresent(name: str) -> bool: ...
	@staticmethod
	def IsSet(name: str, proper: Optional[bool] = True) -> bool: ...
	@staticmethod
	def IsUpdated(name: str) -> bool: ...
	@staticmethod
	def Items(mode: Optional[int] = 0, criter: Optional[str] = "") -> TColStd_HSequenceOfHAsciiString: ...
	def PrintStatic(self, S: Message_Messenger) -> None: ...
	@staticmethod
	def RVal(name: str) -> float: ...
	@staticmethod
	def SetCVal(name: str, val: str) -> bool: ...
	@staticmethod
	def SetIVal(name: str, val: int) -> bool: ...
	@staticmethod
	def SetRVal(name: str, val: float) -> bool: ...
	def SetUptodate(self) -> None: ...
	def SetWild(self, wildcard: Interface_Static) -> None: ...
	@staticmethod
	def Standards() -> None: ...
	@staticmethod
	def Static(name: str) -> Interface_Static: ...
	@staticmethod
	def Update(name: str) -> bool: ...
	def UpdatedStatus(self) -> bool: ...
	def Wild(self) -> Interface_Static: ...

# harray1 classes

class Interface_HArray1OfHAsciiString(Interface_Array1OfHAsciiString, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> Interface_Array1OfHAsciiString: ...

# harray2 classes
# hsequence classes

class Interface_HSequenceOfCheck(Interface_SequenceOfCheck, Standard_Transient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: Interface_SequenceOfCheck) -> None: ...
    def Sequence(self) -> Interface_SequenceOfCheck: ...
    def Append(self, theSequence: Interface_SequenceOfCheck) -> None: ...


Interface_Category_AddCategory = Interface_Category.AddCategory
Interface_Category_Init = Interface_Category.Init
Interface_Category_Name = Interface_Category.Name
Interface_Category_NbCategories = Interface_Category.NbCategories
Interface_Category_Number = Interface_Category.Number
Interface_FileReaderData_Fastof = Interface_FileReaderData.Fastof
Interface_FloatWriter_Convert = Interface_FloatWriter.Convert
Interface_GeneralLib_SetGlobal = Interface_GeneralLib.SetGlobal
Interface_InterfaceModel_ClassName = Interface_InterfaceModel.ClassName
Interface_InterfaceModel_HasTemplate = Interface_InterfaceModel.HasTemplate
Interface_InterfaceModel_ListTemplates = Interface_InterfaceModel.ListTemplates
Interface_InterfaceModel_SetTemplate = Interface_InterfaceModel.SetTemplate
Interface_InterfaceModel_Template = Interface_InterfaceModel.Template
Interface_MSG_Blanks = Interface_MSG.Blanks
Interface_MSG_Blanks = Interface_MSG.Blanks
Interface_MSG_Blanks = Interface_MSG.Blanks
Interface_MSG_CDate = Interface_MSG.CDate
Interface_MSG_Intervalled = Interface_MSG.Intervalled
Interface_MSG_IsKey = Interface_MSG.IsKey
Interface_MSG_NDate = Interface_MSG.NDate
Interface_MSG_Print = Interface_MSG.Print
Interface_MSG_Read = Interface_MSG.Read
Interface_MSG_Record = Interface_MSG.Record
Interface_MSG_SetMode = Interface_MSG.SetMode
Interface_MSG_SetTrace = Interface_MSG.SetTrace
Interface_MSG_TDate = Interface_MSG.TDate
Interface_MSG_Translated = Interface_MSG.Translated
Interface_MSG_Write = Interface_MSG.Write
Interface_MapAsciiStringHasher_HashCode = Interface_MapAsciiStringHasher.HashCode
Interface_MapAsciiStringHasher_IsEqual = Interface_MapAsciiStringHasher.IsEqual
Interface_Protocol_Active = Interface_Protocol.Active
Interface_Protocol_ClearActive = Interface_Protocol.ClearActive
Interface_Protocol_SetActive = Interface_Protocol.SetActive
Interface_ReaderLib_SetGlobal = Interface_ReaderLib.SetGlobal
Interface_STAT_End = Interface_STAT.End
Interface_STAT_NextCycle = Interface_STAT.NextCycle
Interface_STAT_NextItem = Interface_STAT.NextItem
Interface_STAT_NextPhase = Interface_STAT.NextPhase
Interface_STAT_NextStep = Interface_STAT.NextStep
Interface_STAT_Percent = Interface_STAT.Percent
Interface_STAT_SetPhase = Interface_STAT.SetPhase
Interface_STAT_StartCount = Interface_STAT.StartCount
Interface_STAT_Where = Interface_STAT.Where
Interface_SignType_ClassName = Interface_SignType.ClassName
Interface_TypedValue_ParamTypeToValueType = Interface_TypedValue.ParamTypeToValueType
Interface_TypedValue_ValueTypeToParamType = Interface_TypedValue.ValueTypeToParamType
Interface_Static_CDef = Interface_Static.CDef
Interface_Static_CVal = Interface_Static.CVal
Interface_Static_IDef = Interface_Static.IDef
Interface_Static_IVal = Interface_Static.IVal
Interface_Static_Init = Interface_Static.Init
Interface_Static_Init = Interface_Static.Init
Interface_Static_IsPresent = Interface_Static.IsPresent
Interface_Static_IsSet = Interface_Static.IsSet
Interface_Static_IsUpdated = Interface_Static.IsUpdated
Interface_Static_Items = Interface_Static.Items
Interface_Static_RVal = Interface_Static.RVal
Interface_Static_SetCVal = Interface_Static.SetCVal
Interface_Static_SetIVal = Interface_Static.SetIVal
Interface_Static_SetRVal = Interface_Static.SetRVal
Interface_Static_Standards = Interface_Static.Standards
Interface_Static_Static = Interface_Static.Static
Interface_Static_Update = Interface_Static.Update
