# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
GeomAPI module, see official documentation at
https://www.opencascade.com/doc/occt-7.4.0/refman/html/package_geomapi.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _GeomAPI
else:
    import _GeomAPI

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _GeomAPI.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _GeomAPI.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _GeomAPI.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _GeomAPI.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _GeomAPI.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _GeomAPI.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _GeomAPI.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _GeomAPI.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _GeomAPI.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _GeomAPI.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _GeomAPI.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _GeomAPI.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _GeomAPI.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _GeomAPI.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _GeomAPI.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _GeomAPI.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _GeomAPI.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _GeomAPI:
_GeomAPI.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _GeomAPI.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.Geom
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.Geom2d
import OCC.Core.Extrema
import OCC.Core.math
import OCC.Core.Message
import OCC.Core.Adaptor3d
import OCC.Core.TopAbs
import OCC.Core.Adaptor2d
import OCC.Core.GeomAdaptor
import OCC.Core.Approx
import OCC.Core.AppCont
import OCC.Core.AppParCurves

from enum import IntEnum
from OCC.Core.Exception import *



class geomapi(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def To2d(*args) -> "opencascade::handle< Geom2d_Curve >":
        r"""
        This function builds (in the parametric space of the plane p) a 2d curve equivalent to the 3d curve c. the 3d curve c is considered to be located in the plane p. warning the 3d curve c must be of one of the following types: - a line - a circle - an ellipse - a hyperbola - a parabola - a bezier curve - a bspline curve exceptions standard_nosuchobject if c is not a defined type curve.

        Parameters
        ----------
        C: Geom_Curve
        P: gp_Pln

        Returns
        -------
        opencascade::handle<Geom2d_Curve>

        """
        return _GeomAPI.geomapi_To2d(*args)

    @staticmethod
    def To3d(*args) -> "opencascade::handle< Geom_Curve >":
        r"""
        Builds a 3d curve equivalent to the 2d curve c described in the parametric space defined by the local coordinate system of plane p. the resulting 3d curve is of the same nature as that of the curve c.

        Parameters
        ----------
        C: Geom2d_Curve
        P: gp_Pln

        Returns
        -------
        opencascade::handle<Geom_Curve>

        """
        return _GeomAPI.geomapi_To3d(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _GeomAPI.geomapi_swiginit(self, _GeomAPI.new_geomapi())
    __swig_destroy__ = _GeomAPI.delete_geomapi

# Register geomapi in _GeomAPI:
_GeomAPI.geomapi_swigregister(geomapi)

def geomapi_To2d(*args) -> "opencascade::handle< Geom2d_Curve >":
    r"""
    This function builds (in the parametric space of the plane p) a 2d curve equivalent to the 3d curve c. the 3d curve c is considered to be located in the plane p. warning the 3d curve c must be of one of the following types: - a line - a circle - an ellipse - a hyperbola - a parabola - a bezier curve - a bspline curve exceptions standard_nosuchobject if c is not a defined type curve.

    Parameters
    ----------
    C: Geom_Curve
    P: gp_Pln

    Returns
    -------
    opencascade::handle<Geom2d_Curve>

    """
    return _GeomAPI.geomapi_To2d(*args)

def geomapi_To3d(*args) -> "opencascade::handle< Geom_Curve >":
    r"""
    Builds a 3d curve equivalent to the 2d curve c described in the parametric space defined by the local coordinate system of plane p. the resulting 3d curve is of the same nature as that of the curve c.

    Parameters
    ----------
    C: Geom2d_Curve
    P: gp_Pln

    Returns
    -------
    opencascade::handle<Geom_Curve>

    """
    return _GeomAPI.geomapi_To3d(*args)

class GeomAPI_ExtremaCurveCurve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs an empty algorithm for computing extrema between two curves. use an init function to define the curves on which it is going to work.

        Returns
        -------
        None
        Computes the extrema between the curves c1 and c2.

        Parameters
        ----------
        C1: Geom_Curve
        C2: Geom_Curve

        Returns
        -------
        None
        Computes the portion of the curve c1 limited by the two points of parameter (u1min,u1max), and - the portion of the curve c2 limited by the two points of parameter (u2min,u2max). warning use the function nbextrema to obtain the number of solutions. if this algorithm fails, nbextrema returns 0.

        Parameters
        ----------
        C1: Geom_Curve
        C2: Geom_Curve
        U1min: float
        U1max: float
        U2min: float
        U2max: float

        Returns
        -------
        None

        """
        _GeomAPI.GeomAPI_ExtremaCurveCurve_swiginit(self, _GeomAPI.new_GeomAPI_ExtremaCurveCurve(*args))

    def Distance(self, *args) -> "Standard_Real":
        r"""
        Computes the distance between the end points of the extremum of index index computed by this algorithm. exceptions standard_outofrange if index is not in the range [ 1,nbextrema ], where nbextrema is the number of extrema computed by this algorithm.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float

        """
        return _GeomAPI.GeomAPI_ExtremaCurveCurve_Distance(self, *args)

    def Extrema(self, *args) -> "Extrema_ExtCC const &":
        r"""
        Return the algorithmic object from extrema.

        Returns
        -------
        Extrema_ExtCC

        """
        return _GeomAPI.GeomAPI_ExtremaCurveCurve_Extrema(self, *args)

    def Init(self, *args) -> "void":
        r"""
        Initializes this algorithm with the given arguments and computes the extrema between the curves c1 and c2.

        Parameters
        ----------
        C1: Geom_Curve
        C2: Geom_Curve

        Returns
        -------
        None
        Initializes this algorithm with the given arguments and computes the extrema between : - the portion of the curve c1 limited by the two points of parameter (u1min,u1max), and - the portion of the curve c2 limited by the two points of parameter (u2min,u2max). warning use the function nbextrema to obtain the number of solutions. if this algorithm fails, nbextrema returns 0.

        Parameters
        ----------
        C1: Geom_Curve
        C2: Geom_Curve
        U1min: float
        U1max: float
        U2min: float
        U2max: float

        Returns
        -------
        None

        """
        return _GeomAPI.GeomAPI_ExtremaCurveCurve_Init(self, *args)

    def LowerDistance(self, *args) -> "Standard_Real":
        r"""
        Computes the distance between the end points of the shortest extremum computed by this algorithm. exceptions stdfail_notdone if this algorithm fails.

        Returns
        -------
        float

        """
        return _GeomAPI.GeomAPI_ExtremaCurveCurve_LowerDistance(self, *args)

    def LowerDistanceParameters(self, *args) -> "void":
        r"""
        Returns the parameters u1 of the point on the first curve and u2 of the point on the second curve, which are the ends of the shortest extremum computed by this algorithm. exceptions stdfail_notdone if this algorithm fails.

        Parameters
        ----------

        Returns
        -------
        U1: float
        U2: float

        """
        return _GeomAPI.GeomAPI_ExtremaCurveCurve_LowerDistanceParameters(self, *args)

    def NbExtrema(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of extrema computed by this algorithm. note: if this algorithm fails, nbextrema returns 0.

        Returns
        -------
        int

        """
        return _GeomAPI.GeomAPI_ExtremaCurveCurve_NbExtrema(self, *args)

    def NearestPoints(self, *args) -> "void":
        r"""
        Returns the points p1 on the first curve and p2 on the second curve, which are the ends of the shortest extremum computed by this algorithm. exceptions stdfail_notdone if this algorithm fails.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        return _GeomAPI.GeomAPI_ExtremaCurveCurve_NearestPoints(self, *args)

    def Parameters(self, *args) -> "void":
        r"""
        Returns the parameters u1 of the point on the first curve and u2 of the point on the second curve, which are the ends of the extremum of index index computed by this algorithm. exceptions standard_outofrange if index is not in the range [ 1,nbextrema ], where nbextrema is the number of extrema computed by this algorithm.

        Parameters
        ----------
        Index: int

        Returns
        -------
        U1: float
        U2: float

        """
        return _GeomAPI.GeomAPI_ExtremaCurveCurve_Parameters(self, *args)

    def Points(self, *args) -> "void":
        r"""
        Returns the points p1 on the first curve and p2 on the second curve, which are the ends of the extremum of index index computed by this algorithm. exceptions standard_outofrange if index is not in the range [ 1,nbextrema ], where nbextrema is the number of extrema computed by this algorithm.

        Parameters
        ----------
        Index: int
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        return _GeomAPI.GeomAPI_ExtremaCurveCurve_Points(self, *args)

    def TotalLowerDistance(self, *args) -> "Standard_Real":
        r"""
        Return the distance of the total nearest couple solution point. if <myextcc> is not done.

        Returns
        -------
        float

        """
        return _GeomAPI.GeomAPI_ExtremaCurveCurve_TotalLowerDistance(self, *args)

    def TotalLowerDistanceParameters(self, *args) -> "Standard_Boolean":
        r"""
        Set in <u1> and <u2> the parameters of the couple solution points which represents the total nearest solution.

        Parameters
        ----------

        Returns
        -------
        U1: float
        U2: float

        """
        return _GeomAPI.GeomAPI_ExtremaCurveCurve_TotalLowerDistanceParameters(self, *args)

    def TotalNearestPoints(self, *args) -> "Standard_Boolean":
        r"""
        Set in <p1> and <p2> the couple solution points such a the distance [p1,p2] is the minimum. taking in account extremity points of curves.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        bool

        """
        return _GeomAPI.GeomAPI_ExtremaCurveCurve_TotalNearestPoints(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomAPI.delete_GeomAPI_ExtremaCurveCurve

# Register GeomAPI_ExtremaCurveCurve in _GeomAPI:
_GeomAPI.GeomAPI_ExtremaCurveCurve_swigregister(GeomAPI_ExtremaCurveCurve)

class GeomAPI_ExtremaCurveSurface(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs an empty algorithm for computing extrema between a curve and a surface. use an init function to define the curve and the surface on which it is going to work.

        Returns
        -------
        None
        Computes the extrema distances between the curve <c> and the surface <s>.

        Parameters
        ----------
        Curve: Geom_Curve
        Surface: Geom_Surface

        Returns
        -------
        None
        Computes the extrema distances between the curve <c> and the surface <s>. the solution point are computed in the domain [wmin,wmax] of the curve and in the domain [umin,umax] [vmin,vmax] of the surface. warning use the function nbextrema to obtain the number of solutions. if this algorithm fails, nbextrema returns 0.

        Parameters
        ----------
        Curve: Geom_Curve
        Surface: Geom_Surface
        Wmin: float
        Wmax: float
        Umin: float
        Umax: float
        Vmin: float
        Vmax: float

        Returns
        -------
        None

        """
        _GeomAPI.GeomAPI_ExtremaCurveSurface_swiginit(self, _GeomAPI.new_GeomAPI_ExtremaCurveSurface(*args))

    def Distance(self, *args) -> "Standard_Real":
        r"""
        Computes the distance between the end points of the extremum of index index computed by this algorithm. exceptions standard_outofrange if index is not in the range [ 1,nbextrema ], where nbextrema is the number of extrema computed by this algorithm.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float

        """
        return _GeomAPI.GeomAPI_ExtremaCurveSurface_Distance(self, *args)

    def Extrema(self, *args) -> "Extrema_ExtCS const &":
        r"""
        Returns the algorithmic object from extrema.

        Returns
        -------
        Extrema_ExtCS

        """
        return _GeomAPI.GeomAPI_ExtremaCurveSurface_Extrema(self, *args)

    def Init(self, *args) -> "void":
        r"""
        Computes the extrema distances between the curve <c> and the surface <s>.

        Parameters
        ----------
        Curve: Geom_Curve
        Surface: Geom_Surface

        Returns
        -------
        None
        Computes the extrema distances between the curve <c> and the surface <s>. the solution point are computed in the domain [wmin,wmax] of the curve and in the domain [umin,umax] [vmin,vmax] of the surface. warning use the function nbextrema to obtain the number of solutions. if this algorithm fails, nbextrema returns 0.

        Parameters
        ----------
        Curve: Geom_Curve
        Surface: Geom_Surface
        Wmin: float
        Wmax: float
        Umin: float
        Umax: float
        Vmin: float
        Vmax: float

        Returns
        -------
        None

        """
        return _GeomAPI.GeomAPI_ExtremaCurveSurface_Init(self, *args)

    def LowerDistance(self, *args) -> "Standard_Real":
        r"""
        Computes the distance between the end points of the shortest extremum computed by this algorithm. exceptions - stdfail_notdone if this algorithm fails.

        Returns
        -------
        float

        """
        return _GeomAPI.GeomAPI_ExtremaCurveSurface_LowerDistance(self, *args)

    def LowerDistanceParameters(self, *args) -> "void":
        r"""
        Returns the parameters w of the point on the curve and (u,v) of the point on the surface, which are the ends of the shortest extremum computed by this algorithm. exceptions - stdfail_notdone if this algorithm fails.

        Parameters
        ----------

        Returns
        -------
        W: float
        U: float
        V: float

        """
        return _GeomAPI.GeomAPI_ExtremaCurveSurface_LowerDistanceParameters(self, *args)

    def NbExtrema(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of extrema computed by this algorithm. note: if this algorithm fails, nbextrema returns 0.

        Returns
        -------
        int

        """
        return _GeomAPI.GeomAPI_ExtremaCurveSurface_NbExtrema(self, *args)

    def NearestPoints(self, *args) -> "void":
        r"""
        Returns the points pc on the curve and ps on the surface, which are the ends of the shortest extremum computed by this algorithm. exceptions - stdfail_notdone if this algorithm fails.

        Parameters
        ----------
        PC: gp_Pnt
        PS: gp_Pnt

        Returns
        -------
        None

        """
        return _GeomAPI.GeomAPI_ExtremaCurveSurface_NearestPoints(self, *args)

    def Parameters(self, *args) -> "void":
        r"""
        Returns the parameters w of the point on the curve, and (u,v) of the point on the surface, which are the ends of the extremum of index index computed by this algorithm. exceptions standard_outofrange if index is not in the range [ 1,nbextrema ], where nbextrema is the number of extrema computed by this algorithm.

        Parameters
        ----------
        Index: int

        Returns
        -------
        W: float
        U: float
        V: float

        """
        return _GeomAPI.GeomAPI_ExtremaCurveSurface_Parameters(self, *args)

    def Points(self, *args) -> "void":
        r"""
        Returns the points p1 on the curve and p2 on the surface, which are the ends of the extremum of index index computed by this algorithm. exceptions standard_outofrange if index is not in the range [ 1,nbextrema ], where nbextrema is the number of extrema computed by this algorithm.

        Parameters
        ----------
        Index: int
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        return _GeomAPI.GeomAPI_ExtremaCurveSurface_Points(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomAPI.delete_GeomAPI_ExtremaCurveSurface

# Register GeomAPI_ExtremaCurveSurface in _GeomAPI:
_GeomAPI.GeomAPI_ExtremaCurveSurface_swigregister(GeomAPI_ExtremaCurveSurface)

class GeomAPI_ExtremaSurfaceSurface(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs an empty algorithm for computing extrema between two surfaces. use an init function to define the surfaces on which it is going to work.

        Returns
        -------
        None
        Computes the extrema distances between the surfaces <s1> and <s2>.

        Parameters
        ----------
        S1: Geom_Surface
        S2: Geom_Surface

        Returns
        -------
        None
        Computes the extrema distances between the portion of the surface s1 limited by the two values of parameter (u1min,u1max) in the u parametric direction, and by the two values of parameter (v1min,v1max) in the v parametric direction, and - the portion of the surface s2 limited by the two values of parameter (u2min,u2max) in the u parametric direction, and by the two values of parameter (v2min,v2max) in the v parametric direction.

        Parameters
        ----------
        S1: Geom_Surface
        S2: Geom_Surface
        U1min: float
        U1max: float
        V1min: float
        V1max: float
        U2min: float
        U2max: float
        V2min: float
        V2max: float

        Returns
        -------
        None

        """
        _GeomAPI.GeomAPI_ExtremaSurfaceSurface_swiginit(self, _GeomAPI.new_GeomAPI_ExtremaSurfaceSurface(*args))

    def Distance(self, *args) -> "Standard_Real":
        r"""
        Computes the distance between the end points of the extremum of index index computed by this algorithm. exceptions standard_outofrange if index is not in the range [ 1,nbextrema ], where nbextrema is the number of extrema computed by this algorithm.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float

        """
        return _GeomAPI.GeomAPI_ExtremaSurfaceSurface_Distance(self, *args)

    def Extrema(self, *args) -> "Extrema_ExtSS const &":
        r"""
        Return the algorithmic object from extrema.

        Returns
        -------
        Extrema_ExtSS

        """
        return _GeomAPI.GeomAPI_ExtremaSurfaceSurface_Extrema(self, *args)

    def Init(self, *args) -> "void":
        r"""
        Initializes this algorithm with the given arguments and computes the extrema distances between the surfaces <s1> and <s2>.

        Parameters
        ----------
        S1: Geom_Surface
        S2: Geom_Surface

        Returns
        -------
        None
        Initializes this algorithm with the given arguments and computes the extrema distances between - the portion of the surface s1 limited by the two values of parameter (u1min,u1max) in the u parametric direction, and by the two values of parameter (v1min,v1max) in the v parametric direction, and - the portion of the surface s2 limited by the two values of parameter (u2min,u2max) in the u parametric direction, and by the two values of parameter (v2min,v2max) in the v parametric direction.

        Parameters
        ----------
        S1: Geom_Surface
        S2: Geom_Surface
        U1min: float
        U1max: float
        V1min: float
        V1max: float
        U2min: float
        U2max: float
        V2min: float
        V2max: float

        Returns
        -------
        None

        """
        return _GeomAPI.GeomAPI_ExtremaSurfaceSurface_Init(self, *args)

    def LowerDistance(self, *args) -> "Standard_Real":
        r"""
        Computes the distance between the end points of the shortest extremum computed by this algorithm. exceptions stdfail_notdone if this algorithm fails.

        Returns
        -------
        float

        """
        return _GeomAPI.GeomAPI_ExtremaSurfaceSurface_LowerDistance(self, *args)

    def LowerDistanceParameters(self, *args) -> "void":
        r"""
        Returns the parameters (u1,v1) of the point on the first surface and (u2,v2) of the point on the second surface, which are the ends of the shortest extremum computed by this algorithm. exceptions - stdfail_notdone if this algorithm fails.

        Parameters
        ----------

        Returns
        -------
        U1: float
        V1: float
        U2: float
        V2: float

        """
        return _GeomAPI.GeomAPI_ExtremaSurfaceSurface_LowerDistanceParameters(self, *args)

    def NbExtrema(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of extrema computed by this algorithm. note: if this algorithm fails, nbextrema returns 0.

        Returns
        -------
        int

        """
        return _GeomAPI.GeomAPI_ExtremaSurfaceSurface_NbExtrema(self, *args)

    def NearestPoints(self, *args) -> "void":
        r"""
        Returns the points p1 on the first surface and p2 on the second surface, which are the ends of the shortest extremum computed by this algorithm. exceptions stdfail_notdone if this algorithm fails.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        return _GeomAPI.GeomAPI_ExtremaSurfaceSurface_NearestPoints(self, *args)

    def Parameters(self, *args) -> "void":
        r"""
        Returns the parameters (u1,v1) of the point on the first surface, and (u2,v2) of the point on the second surface, which are the ends of the extremum of index index computed by this algorithm. exceptions standard_outofrange if index is not in the range [ 1,nbextrema ], where nbextrema is the number of extrema computed by this algorithm.

        Parameters
        ----------
        Index: int

        Returns
        -------
        U1: float
        V1: float
        U2: float
        V2: float

        """
        return _GeomAPI.GeomAPI_ExtremaSurfaceSurface_Parameters(self, *args)

    def Points(self, *args) -> "void":
        r"""
        Returns the points p1 on the first surface and p2 on the second surface, which are the ends of the extremum of index index computed by this algorithm. exceptions standard_outofrange if index is not in the range [ 1,nbextrema ], where nbextrema is the number of extrema computed by this algorithm.

        Parameters
        ----------
        Index: int
        P1: gp_Pnt
        P2: gp_Pnt

        Returns
        -------
        None

        """
        return _GeomAPI.GeomAPI_ExtremaSurfaceSurface_Points(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomAPI.delete_GeomAPI_ExtremaSurfaceSurface

# Register GeomAPI_ExtremaSurfaceSurface in _GeomAPI:
_GeomAPI.GeomAPI_ExtremaSurfaceSurface_swigregister(GeomAPI_ExtremaSurfaceSurface)

class GeomAPI_IntCS(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty object. use the function perform for further initialization of the algorithm by the curve and the surface.

        Returns
        -------
        None
        Computes the intersections between the curve c and the surface s. warning use function isdone to verify that the intersections are computed successfully.

        Parameters
        ----------
        C: Geom_Curve
        S: Geom_Surface

        Returns
        -------
        None

        """
        _GeomAPI.GeomAPI_IntCS_swiginit(self, _GeomAPI.new_GeomAPI_IntCS(*args))

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the intersections are successfully computed.

        Returns
        -------
        bool

        """
        return _GeomAPI.GeomAPI_IntCS_IsDone(self, *args)

    def NbPoints(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of intersection points if isdone returns true. else notdone is raised.

        Returns
        -------
        int

        """
        return _GeomAPI.GeomAPI_IntCS_NbPoints(self, *args)

    def NbSegments(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of computed intersection segments in case of tangential intersection. exceptions stdfail_notdone if the intersection algorithm fails or is not initialized.

        Returns
        -------
        int

        """
        return _GeomAPI.GeomAPI_IntCS_NbSegments(self, *args)

    def Parameters(self, *args) -> "void":
        r"""
        Returns parameter w on the curve and (parameters u,v) on the surface of the computed intersection point of index index in case of cross intersection. exceptions stdfail_notdone if intersection algorithm fails or is not initialized. standard_outofrange if index is not in the range [ 1,nbpoints ], where nbpoints is the number of computed intersection points.

        Parameters
        ----------
        Index: int

        Returns
        -------
        U: float
        V: float
        W: float
        Returns the parameters of the first (u1,v1) and the last (u2,v2) points of curve's segment on the surface in case of tangential intersection. index is the number of computed intersection segments. exceptions stdfail_notdone if intersection algorithm fails or is not initialized. standard_outofrange if index is not in the range [ 1,nbsegments ], where nbsegments is the number of computed intersection segments.

        Parameters
        ----------
        Index: int

        Returns
        -------
        U1: float
        V1: float
        U2: float
        V2: float

        """
        return _GeomAPI.GeomAPI_IntCS_Parameters(self, *args)

    def Perform(self, *args) -> "void":
        r"""
        This function initializes an algorithm with the curve c and the surface s and computes the intersections between c and s. warning use function isdone to verify that the intersections are computed successfully.

        Parameters
        ----------
        C: Geom_Curve
        S: Geom_Surface

        Returns
        -------
        None

        """
        return _GeomAPI.GeomAPI_IntCS_Perform(self, *args)

    def Point(self, *args) -> "gp_Pnt const":
        r"""
        Returns the intersection point of range <index>in case of cross intersection. raises notdone if the computation has failed or if the computation has not been done raises outofrange if index is not in the range <1..nbpoints>.

        Parameters
        ----------
        Index: int

        Returns
        -------
        gp_Pnt

        """
        return _GeomAPI.GeomAPI_IntCS_Point(self, *args)

    def Segment(self, *args) -> "opencascade::handle< Geom_Curve >":
        r"""
        Returns the computed intersection segment of index index in case of tangential intersection. intersection segment is a portion of the initial curve tangent to surface. exceptions stdfail_notdone if intersection algorithm fails or is not initialized. standard_outofrange if index is not in the range [ 1,nbsegments ], where nbsegments is the number of computed intersection segments.

        Parameters
        ----------
        Index: int

        Returns
        -------
        opencascade::handle<Geom_Curve>

        """
        return _GeomAPI.GeomAPI_IntCS_Segment(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomAPI.delete_GeomAPI_IntCS

# Register GeomAPI_IntCS in _GeomAPI:
_GeomAPI.GeomAPI_IntCS_swigregister(GeomAPI_IntCS)

class GeomAPI_IntSS(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs an empty object. use the function perform for further initialization algorithm by two surfaces.

        Returns
        -------
        None
        Computes the intersection curves between the two surfaces s1 and s2. parameter tol defines the precision of curves computation. for most cases the value 1.0e-7 is recommended to use. warning use the function isdone to verify that the intersections are successfully computed.i.

        Parameters
        ----------
        S1: Geom_Surface
        S2: Geom_Surface
        Tol: float

        Returns
        -------
        None

        """
        _GeomAPI.GeomAPI_IntSS_swiginit(self, _GeomAPI.new_GeomAPI_IntSS(*args))

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the intersection was successful.

        Returns
        -------
        bool

        """
        return _GeomAPI.GeomAPI_IntSS_IsDone(self, *args)

    def Line(self, *args) -> "opencascade::handle< Geom_Curve > const &":
        r"""
        Returns the computed intersection curve of index index. exceptions stdfail_notdone if the computation fails. standard_outofrange if index is out of range [1, nblines] where nblines is the number of computed intersection curves.

        Parameters
        ----------
        Index: int

        Returns
        -------
        opencascade::handle<Geom_Curve>

        """
        return _GeomAPI.GeomAPI_IntSS_Line(self, *args)

    def NbLines(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of computed intersection curves. exceptions stdfail_notdone if the computation fails.

        Returns
        -------
        int

        """
        return _GeomAPI.GeomAPI_IntSS_NbLines(self, *args)

    def Perform(self, *args) -> "void":
        r"""
        Initializes an algorithm with the given arguments and computes the intersection curves between the two surfaces s1 and s2. parameter tol defines the precision of curves computation. for most cases the value 1.0e-7 is recommended to use. warning use function isdone to verify that the intersections are successfully computed.

        Parameters
        ----------
        S1: Geom_Surface
        S2: Geom_Surface
        Tol: float

        Returns
        -------
        None

        """
        return _GeomAPI.GeomAPI_IntSS_Perform(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomAPI.delete_GeomAPI_IntSS

# Register GeomAPI_IntSS in _GeomAPI:
_GeomAPI.GeomAPI_IntSS_swigregister(GeomAPI_IntSS)

class GeomAPI_Interpolate(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Initializes an algorithm for constructing a constrained bspline curve passing through the points of the table points. tangential vectors can then be assigned, using the function load. if periodicflag is true, the constrained bspline curve will be periodic and closed. in this case, the junction point is the first point of the table points. the tolerance value tolerance is used to check that: - points are not too close to each other, or - tangential vectors (defined using the function load) are not too small. the resulting bspline curve will be 'c2' continuous, except where a tangency constraint is defined on a point through which the curve passes (by using the load function). in this case, it will be only 'c1' continuous. once all the constraints are defined, use the function perform to compute the curve. warning - there must be at least 2 points in the table points. - if periodicflag is false, there must be as many parameters in the array parameters as there are points in the array points. - if periodicflag is true, there must be one more parameter in the table parameters: this is used to give the parameter on the resulting bspline curve of the junction point of the curve (which is also the first point of the table points). exceptions - standard_constructionerror if the distance between two consecutive points in the table points is less than or equal to tolerance. - standard_outofrange if: - there are less than two points in the table points, or - conditions relating to the respective number of elements in the parallel tables points and parameters are not respected.

        Parameters
        ----------
        Points: TColgp_HArray1OfPnt
        PeriodicFlag: bool
        Tolerance: float

        Returns
        -------
        None
        Initializes an algorithm for constructing a constrained bspline curve passing through the points of the table points, where the parameters of each of its points are given by the parallel table parameters. tangential vectors can then be assigned, using the function load. if periodicflag is true, the constrained bspline curve will be periodic and closed. in this case, the junction point is the first point of the table points. the tolerance value tolerance is used to check that: - points are not too close to each other, or - tangential vectors (defined using the function load) are not too small. the resulting bspline curve will be 'c2' continuous, except where a tangency constraint is defined on a point through which the curve passes (by using the load function). in this case, it will be only 'c1' continuous. once all the constraints are defined, use the function perform to compute the curve. warning - there must be at least 2 points in the table points. - if periodicflag is false, there must be as many parameters in the array parameters as there are points in the array points. - if periodicflag is true, there must be one more parameter in the table parameters: this is used to give the parameter on the resulting bspline curve of the junction point of the curve (which is also the first point of the table points). exceptions - standard_constructionerror if the distance between two consecutive points in the table points is less than or equal to tolerance. - standard_outofrange if: - there are less than two points in the table points, or - conditions relating to the respective number of elements in the parallel tables points and parameters are not respected.

        Parameters
        ----------
        Points: TColgp_HArray1OfPnt
        Parameters: TColStd_HArray1OfReal
        PeriodicFlag: bool
        Tolerance: float

        Returns
        -------
        None

        """
        _GeomAPI.GeomAPI_Interpolate_swiginit(self, _GeomAPI.new_GeomAPI_Interpolate(*args))

    def Curve(self, *args) -> "opencascade::handle< Geom_BSplineCurve > const &":
        r"""
        Returns the computed bspline curve. raises stdfail_notdone if the interpolation fails.

        Returns
        -------
        opencascade::handle<Geom_BSplineCurve>

        """
        return _GeomAPI.GeomAPI_Interpolate_Curve(self, *args)

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the constrained bspline curve is successfully constructed. note: in this case, the result is given by the function curve.

        Returns
        -------
        bool

        """
        return _GeomAPI.GeomAPI_Interpolate_IsDone(self, *args)

    def Load(self, *args) -> "void":
        r"""
        Assigns this constrained bspline curve to be tangential to vectors initialtangent and finaltangent at its first and last points respectively (i.e. the first and last points of the table of points through which the curve passes, as defined at the time of initialization).

        Parameters
        ----------
        InitialTangent: gp_Vec
        FinalTangent: gp_Vec
        Scale: bool,optional
        	default value is Standard_True

        Returns
        -------
        None
        Assigns this constrained bspline curve to be tangential to vectors defined in the table tangents, which is parallel to the table of points through which the curve passes, as defined at the time of initialization. vectors in the table tangents are defined only if the flag given in the parallel table tangentflags is true: only these vectors are set as tangency constraints.

        Parameters
        ----------
        Tangents: TColgp_Array1OfVec
        TangentFlags: TColStd_HArray1OfBoolean
        Scale: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        return _GeomAPI.GeomAPI_Interpolate_Load(self, *args)

    def Perform(self, *args) -> "void":
        r"""
        Computes the constrained bspline curve. use the function isdone to verify that the computation is successful, and then the function curve to obtain the result.

        Returns
        -------
        None

        """
        return _GeomAPI.GeomAPI_Interpolate_Perform(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def ClearTangents(self):
    	pass

    __swig_destroy__ = _GeomAPI.delete_GeomAPI_Interpolate

# Register GeomAPI_Interpolate in _GeomAPI:
_GeomAPI.GeomAPI_Interpolate_swigregister(GeomAPI_Interpolate)

class GeomAPI_PointsToBSpline(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs an empty approximation algorithm. use an init function to define and build the bspline curve.

        Returns
        -------
        None
        Approximate a bspline curve passing through an array of point. the resulting bspline will have the following properties: 1- his degree will be in the range [degmin,degmax] 2- his continuity will be at least <continuity> 3- the distance from the point <points> to the bspline will be lower to tol3d.

        Parameters
        ----------
        Points: TColgp_Array1OfPnt
        DegMin: int,optional
        	default value is 3
        DegMax: int,optional
        	default value is 8
        Continuity: GeomAbs_Shape,optional
        	default value is GeomAbs_C2
        Tol3D: float,optional
        	default value is 1.0e-3

        Returns
        -------
        None
        Approximate a bspline curve passing through an array of point. the resulting bspline will have the following properties: 1- his degree will be in the range [degmin,degmax] 2- his continuity will be at least <continuity> 3- the distance from the point <points> to the bspline will be lower to tol3d.

        Parameters
        ----------
        Points: TColgp_Array1OfPnt
        ParType: Approx_ParametrizationType
        DegMin: int,optional
        	default value is 3
        DegMax: int,optional
        	default value is 8
        Continuity: GeomAbs_Shape,optional
        	default value is GeomAbs_C2
        Tol3D: float,optional
        	default value is 1.0e-3

        Returns
        -------
        None
        Approximate a bspline curve passing through an array of point, which parameters are given by the array <parameters>. the resulting bspline will have the following properties: 1- his degree will be in the range [degmin,degmax] 2- his continuity will be at least <continuity> 3- the distance from the point <points> to the bspline will be lower to tol3d.

        Parameters
        ----------
        Points: TColgp_Array1OfPnt
        Parameters: TColStd_Array1OfReal
        DegMin: int,optional
        	default value is 3
        DegMax: int,optional
        	default value is 8
        Continuity: GeomAbs_Shape,optional
        	default value is GeomAbs_C2
        Tol3D: float,optional
        	default value is 1.0e-3

        Returns
        -------
        None
        Approximate a bspline curve passing through an array of point using variational smoothing algorithm, which tries to minimize additional criterium: weight1*curvelength + weight2*curvature + weight3*torsion.

        Parameters
        ----------
        Points: TColgp_Array1OfPnt
        Weight1: float
        Weight2: float
        Weight3: float
        DegMax: int,optional
        	default value is 8
        Continuity: GeomAbs_Shape,optional
        	default value is GeomAbs_C2
        Tol3D: float,optional
        	default value is 1.0e-3

        Returns
        -------
        None

        """
        _GeomAPI.GeomAPI_PointsToBSpline_swiginit(self, _GeomAPI.new_GeomAPI_PointsToBSpline(*args))

    def Curve(self, *args) -> "opencascade::handle< Geom_BSplineCurve > const &":
        r"""
        Returns the computed bspline curve. raises stdfail_notdone if the curve is not built.

        Returns
        -------
        opencascade::handle<Geom_BSplineCurve>

        """
        return _GeomAPI.GeomAPI_PointsToBSpline_Curve(self, *args)

    def Init(self, *args) -> "void":
        r"""
        Approximate a bspline curve passing through an array of point. the resulting bspline will have the following properties: 1- his degree will be in the range [degmin,degmax] 2- his continuity will be at least <continuity> 3- the distance from the point <points> to the bspline will be lower to tol3d.

        Parameters
        ----------
        Points: TColgp_Array1OfPnt
        DegMin: int,optional
        	default value is 3
        DegMax: int,optional
        	default value is 8
        Continuity: GeomAbs_Shape,optional
        	default value is GeomAbs_C2
        Tol3D: float,optional
        	default value is 1.0e-3

        Returns
        -------
        None
        Approximate a bspline curve passing through an array of point. the resulting bspline will have the following properties: 1- his degree will be in the range [degmin,degmax] 2- his continuity will be at least <continuity> 3- the distance from the point <points> to the bspline will be lower to tol3d.

        Parameters
        ----------
        Points: TColgp_Array1OfPnt
        ParType: Approx_ParametrizationType
        DegMin: int,optional
        	default value is 3
        DegMax: int,optional
        	default value is 8
        Continuity: GeomAbs_Shape,optional
        	default value is GeomAbs_C2
        Tol3D: float,optional
        	default value is 1.0e-3

        Returns
        -------
        None
        Approximate a bspline curve passing through an array of point, which parameters are given by the array <parameters>. the resulting bspline will have the following properties: 1- his degree will be in the range [degmin,degmax] 2- his continuity will be at least <continuity> 3- the distance from the point <points> to the bspline will be lower to tol3d.

        Parameters
        ----------
        Points: TColgp_Array1OfPnt
        Parameters: TColStd_Array1OfReal
        DegMin: int,optional
        	default value is 3
        DegMax: int,optional
        	default value is 8
        Continuity: GeomAbs_Shape,optional
        	default value is GeomAbs_C2
        Tol3D: float,optional
        	default value is 1.0e-3

        Returns
        -------
        None
        Approximate a bspline curve passing through an array of point using variational smoothing algorithm, which tries to minimize additional criterium: weight1*curvelength + weight2*curvature + weight3*torsion.

        Parameters
        ----------
        Points: TColgp_Array1OfPnt
        Weight1: float
        Weight2: float
        Weight3: float
        DegMax: int,optional
        	default value is 8
        Continuity: GeomAbs_Shape,optional
        	default value is GeomAbs_C2
        Tol3D: float,optional
        	default value is 1.0e-3

        Returns
        -------
        None

        """
        return _GeomAPI.GeomAPI_PointsToBSpline_Init(self, *args)

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _GeomAPI.GeomAPI_PointsToBSpline_IsDone(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomAPI.delete_GeomAPI_PointsToBSpline

# Register GeomAPI_PointsToBSpline in _GeomAPI:
_GeomAPI.GeomAPI_PointsToBSpline_swigregister(GeomAPI_PointsToBSpline)

class GeomAPI_PointsToBSplineSurface(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs an empty algorithm for approximation or interpolation of a surface. use: - an init function to define and build the bspline surface by approximation, or - an interpolate function to define and build the bspline surface by interpolation.

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        Points: TColgp_Array2OfPnt
        DegMin: int,optional
        	default value is 3
        DegMax: int,optional
        	default value is 8
        Continuity: GeomAbs_Shape,optional
        	default value is GeomAbs_C2
        Tol3D: float,optional
        	default value is 1.0e-3

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        Points: TColgp_Array2OfPnt
        ParType: Approx_ParametrizationType
        DegMin: int,optional
        	default value is 3
        DegMax: int,optional
        	default value is 8
        Continuity: GeomAbs_Shape,optional
        	default value is GeomAbs_C2
        Tol3D: float,optional
        	default value is 1.0e-3

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        Points: TColgp_Array2OfPnt
        Weight1: float
        Weight2: float
        Weight3: float
        DegMax: int,optional
        	default value is 8
        Continuity: GeomAbs_Shape,optional
        	default value is GeomAbs_C2
        Tol3D: float,optional
        	default value is 1.0e-3

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        ZPoints: TColStd_Array2OfReal
        X0: float
        dX: float
        Y0: float
        dY: float
        DegMin: int,optional
        	default value is 3
        DegMax: int,optional
        	default value is 8
        Continuity: GeomAbs_Shape,optional
        	default value is GeomAbs_C2
        Tol3D: float,optional
        	default value is 1.0e-3

        Returns
        -------
        None

        """
        _GeomAPI.GeomAPI_PointsToBSplineSurface_swiginit(self, _GeomAPI.new_GeomAPI_PointsToBSplineSurface(*args))

    def Init(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Points: TColgp_Array2OfPnt
        DegMin: int,optional
        	default value is 3
        DegMax: int,optional
        	default value is 8
        Continuity: GeomAbs_Shape,optional
        	default value is GeomAbs_C2
        Tol3D: float,optional
        	default value is 1.0e-3

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        ZPoints: TColStd_Array2OfReal
        X0: float
        dX: float
        Y0: float
        dY: float
        DegMin: int,optional
        	default value is 3
        DegMax: int,optional
        	default value is 8
        Continuity: GeomAbs_Shape,optional
        	default value is GeomAbs_C2
        Tol3D: float,optional
        	default value is 1.0e-3

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        Points: TColgp_Array2OfPnt
        ParType: Approx_ParametrizationType
        DegMin: int,optional
        	default value is 3
        DegMax: int,optional
        	default value is 8
        Continuity: GeomAbs_Shape,optional
        	default value is GeomAbs_C2
        Tol3D: float,optional
        	default value is 1.0e-3
        thePeriodic: bool,optional
        	default value is Standard_False

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        Points: TColgp_Array2OfPnt
        Weight1: float
        Weight2: float
        Weight3: float
        DegMax: int,optional
        	default value is 8
        Continuity: GeomAbs_Shape,optional
        	default value is GeomAbs_C2
        Tol3D: float,optional
        	default value is 1.0e-3

        Returns
        -------
        None

        """
        return _GeomAPI.GeomAPI_PointsToBSplineSurface_Init(self, *args)

    def Interpolate(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        Points: TColgp_Array2OfPnt
        thePeriodic: bool,optional
        	default value is Standard_False

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        Points: TColgp_Array2OfPnt
        ParType: Approx_ParametrizationType
        thePeriodic: bool,optional
        	default value is Standard_False

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        ZPoints: TColStd_Array2OfReal
        X0: float
        dX: float
        Y0: float
        dY: float

        Returns
        -------
        None

        """
        return _GeomAPI.GeomAPI_PointsToBSplineSurface_Interpolate(self, *args)

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _GeomAPI.GeomAPI_PointsToBSplineSurface_IsDone(self, *args)

    def Surface(self, *args) -> "opencascade::handle< Geom_BSplineSurface > const &":
        r"""
        Returns the approximate bspline surface.

        Returns
        -------
        opencascade::handle<Geom_BSplineSurface>

        """
        return _GeomAPI.GeomAPI_PointsToBSplineSurface_Surface(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomAPI.delete_GeomAPI_PointsToBSplineSurface

# Register GeomAPI_PointsToBSplineSurface in _GeomAPI:
_GeomAPI.GeomAPI_PointsToBSplineSurface_swigregister(GeomAPI_PointsToBSplineSurface)

class GeomAPI_ProjectPointOnCurve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty object. use an init function for further initialization.

        Returns
        -------
        None
        Create the projection of a point <p> on a curve <curve>.

        Parameters
        ----------
        P: gp_Pnt
        Curve: Geom_Curve

        Returns
        -------
        None
        Create the projection of a point <p> on a curve <curve> limited by the two points of parameter umin and usup.

        Parameters
        ----------
        P: gp_Pnt
        Curve: Geom_Curve
        Umin: float
        Usup: float

        Returns
        -------
        None

        """
        _GeomAPI.GeomAPI_ProjectPointOnCurve_swiginit(self, _GeomAPI.new_GeomAPI_ProjectPointOnCurve(*args))

    def Distance(self, *args) -> "Standard_Real":
        r"""
        Computes the distance between the point and its orthogonal projection on the curve. index is a number of a computed point. exceptions standard_outofrange if index is not in the range [ 1,nbpoints ], where nbpoints is the number of solution points.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float

        """
        return _GeomAPI.GeomAPI_ProjectPointOnCurve_Distance(self, *args)

    def Extrema(self, *args) -> "Extrema_ExtPC const &":
        r"""
        Return the algorithmic object from extrema.

        Returns
        -------
        Extrema_ExtPC

        """
        return _GeomAPI.GeomAPI_ProjectPointOnCurve_Extrema(self, *args)

    def Init(self, *args) -> "void":
        r"""
        Init the projection of a point <p> on a curve <curve>.

        Parameters
        ----------
        P: gp_Pnt
        Curve: Geom_Curve

        Returns
        -------
        None
        Init the projection of a point <p> on a curve <curve> limited by the two points of parameter umin and usup.

        Parameters
        ----------
        P: gp_Pnt
        Curve: Geom_Curve
        Umin: float
        Usup: float

        Returns
        -------
        None
        Init the projection of a point <p> on a curve <curve> limited by the two points of parameter umin and usup.

        Parameters
        ----------
        Curve: Geom_Curve
        Umin: float
        Usup: float

        Returns
        -------
        None

        """
        return _GeomAPI.GeomAPI_ProjectPointOnCurve_Init(self, *args)

    def LowerDistance(self, *args) -> "Standard_Real":
        r"""
        Computes the distance between the point and its nearest orthogonal projection on the curve. exceptions: stdfail_notdone if this algorithm fails.

        Returns
        -------
        float

        """
        return _GeomAPI.GeomAPI_ProjectPointOnCurve_LowerDistance(self, *args)

    def LowerDistanceParameter(self, *args) -> "Standard_Real":
        r"""
        Returns the parameter on the curve of the nearest orthogonal projection of the point. exceptions: stdfail_notdone if this algorithm fails.

        Returns
        -------
        float

        """
        return _GeomAPI.GeomAPI_ProjectPointOnCurve_LowerDistanceParameter(self, *args)

    def NbPoints(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of computed orthogonal projection points. note: if this algorithm fails, nbpoints returns 0.

        Returns
        -------
        int

        """
        return _GeomAPI.GeomAPI_ProjectPointOnCurve_NbPoints(self, *args)

    def NearestPoint(self, *args) -> "gp_Pnt":
        r"""
        Returns the nearest orthogonal projection of the point on the curve. exceptions: stdfail_notdone if this algorithm fails.

        Returns
        -------
        gp_Pnt

        """
        return _GeomAPI.GeomAPI_ProjectPointOnCurve_NearestPoint(self, *args)

    def Parameter(self, *args) -> "void":
        r"""
        Returns the parameter on the curve of the point, which is the orthogonal projection. index is a number of a computed point. exceptions standard_outofrange if index is not in the range [ 1,nbpoints ], where nbpoints is the number of solution points.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float
        Returns the parameter on the curve of the point, which is the orthogonal projection. index is a number of a computed point. exceptions standard_outofrange if index is not in the range [ 1,nbpoints ], where nbpoints is the number of solution points.-.

        Parameters
        ----------
        Index: int

        Returns
        -------
        U: float

        """
        return _GeomAPI.GeomAPI_ProjectPointOnCurve_Parameter(self, *args)

    def Perform(self, *args) -> "void":
        r"""
        Performs the projection of a point on the current curve.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None

        """
        return _GeomAPI.GeomAPI_ProjectPointOnCurve_Perform(self, *args)

    def Point(self, *args) -> "gp_Pnt":
        r"""
        Returns the orthogonal projection on the curve. index is a number of a computed point. exceptions standard_outofrange if index is not in the range [ 1,nbpoints ], where nbpoints is the number of solution points.

        Parameters
        ----------
        Index: int

        Returns
        -------
        gp_Pnt

        """
        return _GeomAPI.GeomAPI_ProjectPointOnCurve_Point(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomAPI.delete_GeomAPI_ProjectPointOnCurve

# Register GeomAPI_ProjectPointOnCurve in _GeomAPI:
_GeomAPI.GeomAPI_ProjectPointOnCurve_swigregister(GeomAPI_ProjectPointOnCurve)

class GeomAPI_ProjectPointOnSurf(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates an empty object. use the init function for further initialization.

        Returns
        -------
        None
        Create the projection of a point <p> on a surface <surface>.

        Parameters
        ----------
        P: gp_Pnt
        Surface: Geom_Surface
        Algo: Extrema_ExtAlgo,optional
        	default value is Extrema_ExtAlgo_Grad

        Returns
        -------
        None
        Create the projection of a point <p> on a surface <surface> create the projection of a point <p> on a surface <surface>. the solution are computed in the domain [umin,usup] [vmin,vsup] of the surface.

        Parameters
        ----------
        P: gp_Pnt
        Surface: Geom_Surface
        Tolerance: float
        Algo: Extrema_ExtAlgo,optional
        	default value is Extrema_ExtAlgo_Grad

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt
        Surface: Geom_Surface
        Umin: float
        Usup: float
        Vmin: float
        Vsup: float
        Tolerance: float
        Algo: Extrema_ExtAlgo,optional
        	default value is Extrema_ExtAlgo_Grad

        Returns
        -------
        None
        Init the projection of a point <p> on a surface <surface>.

        Parameters
        ----------
        P: gp_Pnt
        Surface: Geom_Surface
        Umin: float
        Usup: float
        Vmin: float
        Vsup: float
        Algo: Extrema_ExtAlgo,optional
        	default value is Extrema_ExtAlgo_Grad

        Returns
        -------
        None

        """
        _GeomAPI.GeomAPI_ProjectPointOnSurf_swiginit(self, _GeomAPI.new_GeomAPI_ProjectPointOnSurf(*args))

    def Distance(self, *args) -> "Standard_Real":
        r"""
        Computes the distance between the point and its orthogonal projection on the surface. index is a number of a computed point. exceptions standard_outofrange if index is not in the range [ 1,nbpoints ], where nbpoints is the number of solution points.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float

        """
        return _GeomAPI.GeomAPI_ProjectPointOnSurf_Distance(self, *args)

    def Extrema(self, *args) -> "Extrema_ExtPS const &":
        r"""
        Return the algorithmic object from extrema.

        Returns
        -------
        Extrema_ExtPS

        """
        return _GeomAPI.GeomAPI_ProjectPointOnSurf_Extrema(self, *args)

    def Init(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt
        Surface: Geom_Surface
        Tolerance: float
        Algo: Extrema_ExtAlgo,optional
        	default value is Extrema_ExtAlgo_Grad

        Returns
        -------
        None
        Init the projection of a point <p> on a surface <surface>. the solution are computed in the domain [umin,usup] [vmin,vsup] of the surface.

        Parameters
        ----------
        P: gp_Pnt
        Surface: Geom_Surface
        Algo: Extrema_ExtAlgo,optional
        	default value is Extrema_ExtAlgo_Grad

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        P: gp_Pnt
        Surface: Geom_Surface
        Umin: float
        Usup: float
        Vmin: float
        Vsup: float
        Tolerance: float
        Algo: Extrema_ExtAlgo,optional
        	default value is Extrema_ExtAlgo_Grad

        Returns
        -------
        None
        Init the projection for many points on a surface <surface>. the solutions will be computed in the domain [umin,usup] [vmin,vsup] of the surface.

        Parameters
        ----------
        P: gp_Pnt
        Surface: Geom_Surface
        Umin: float
        Usup: float
        Vmin: float
        Vsup: float
        Algo: Extrema_ExtAlgo,optional
        	default value is Extrema_ExtAlgo_Grad

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        Surface: Geom_Surface
        Umin: float
        Usup: float
        Vmin: float
        Vsup: float
        Tolerance: float
        Algo: Extrema_ExtAlgo,optional
        	default value is Extrema_ExtAlgo_Grad

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        Surface: Geom_Surface
        Umin: float
        Usup: float
        Vmin: float
        Vsup: float
        Algo: Extrema_ExtAlgo,optional
        	default value is Extrema_ExtAlgo_Grad

        Returns
        -------
        None

        """
        return _GeomAPI.GeomAPI_ProjectPointOnSurf_Init(self, *args)

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _GeomAPI.GeomAPI_ProjectPointOnSurf_IsDone(self, *args)

    def LowerDistance(self, *args) -> "Standard_Real":
        r"""
        Computes the distance between the point and its nearest orthogonal projection on the surface. exceptions stdfail_notdone if projection fails.

        Returns
        -------
        float

        """
        return _GeomAPI.GeomAPI_ProjectPointOnSurf_LowerDistance(self, *args)

    def LowerDistanceParameters(self, *args) -> "void":
        r"""
        Returns the parameters (u,v) on the surface of the nearest computed orthogonal projection of the point. exceptions stdfail_notdone if projection fails.

        Parameters
        ----------

        Returns
        -------
        U: float
        V: float

        """
        return _GeomAPI.GeomAPI_ProjectPointOnSurf_LowerDistanceParameters(self, *args)

    def NbPoints(self, *args) -> "Standard_Integer":
        r"""
        Returns the number of computed orthogonal projection points. note: if projection fails, nbpoints returns 0.

        Returns
        -------
        int

        """
        return _GeomAPI.GeomAPI_ProjectPointOnSurf_NbPoints(self, *args)

    def NearestPoint(self, *args) -> "gp_Pnt":
        r"""
        Returns the nearest orthogonal projection of the point on the surface. exceptions stdfail_notdone if projection fails.

        Returns
        -------
        gp_Pnt

        """
        return _GeomAPI.GeomAPI_ProjectPointOnSurf_NearestPoint(self, *args)

    def Parameters(self, *args) -> "void":
        r"""
        Returns the parameters (u,v) on the surface of the orthogonal projection. index is a number of a computed point. exceptions standard_outofrange if index is not in the range [ 1,nbpoints ], where nbpoints is the number of solution points.

        Parameters
        ----------
        Index: int

        Returns
        -------
        U: float
        V: float

        """
        return _GeomAPI.GeomAPI_ProjectPointOnSurf_Parameters(self, *args)

    def Perform(self, *args) -> "void":
        r"""
        Performs the projection of a point on the current surface.

        Parameters
        ----------
        P: gp_Pnt

        Returns
        -------
        None

        """
        return _GeomAPI.GeomAPI_ProjectPointOnSurf_Perform(self, *args)

    def Point(self, *args) -> "gp_Pnt":
        r"""
        Returns the orthogonal projection on the surface. index is a number of a computed point. exceptions standard_outofrange if index is not in the range [ 1,nbpoints ], where nbpoints is the number of solution points.

        Parameters
        ----------
        Index: int

        Returns
        -------
        gp_Pnt

        """
        return _GeomAPI.GeomAPI_ProjectPointOnSurf_Point(self, *args)

    def SetExtremaAlgo(self, *args) -> "void":
        r"""
        Sets the extrema search algorithm - grad or tree. by default the extrema is initialized with grad algorithm.

        Parameters
        ----------
        theAlgo: Extrema_ExtAlgo

        Returns
        -------
        None

        """
        return _GeomAPI.GeomAPI_ProjectPointOnSurf_SetExtremaAlgo(self, *args)

    def SetExtremaFlag(self, *args) -> "void":
        r"""
        Sets the extrema search flag - min or max or minmax. by default the extrema is set to search the minmax solutions.

        Parameters
        ----------
        theExtFlag: Extrema_ExtFlag

        Returns
        -------
        None

        """
        return _GeomAPI.GeomAPI_ProjectPointOnSurf_SetExtremaFlag(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomAPI.delete_GeomAPI_ProjectPointOnSurf

# Register GeomAPI_ProjectPointOnSurf in _GeomAPI:
_GeomAPI.GeomAPI_ProjectPointOnSurf_swigregister(GeomAPI_ProjectPointOnSurf)





